CLS

PI# = 3.141592654#

DIM R(18), Z(18), DF(9), D(9), FX(4), FaixasAlt(4), SN(3), MR(3)
V = 1
DIM X(V + 2), S(V + 2), T(V + 2), A(V + 2, V + 2)

' Carga de referencia para a conversao das deflexoes do FWD
LOAD = 4100

PRINT
PRINT "  PARAMETROS GERADOS DA ANALISE ESTRUTURAL DAS BACIAS DO FWD   "
PRINT

' Subdiretorios onde se encontram o programa SGP e a base de dados:
OPEN "DIRETOR.DAT" FOR INPUT AS #1
INPUT #1, ANOBASE
INPUT #1, NPeriodos
INPUT #1, PROGRAMA$
INPUT #1, DADOS$
INPUT #1, CALC$
INPUT #1, DADOSANOBASE$
CLOSE #1

' Codigos de identificacao das rodovias que compoem a rede:
ARQUIVO$ = DADOSANOBASE$ + "RODOVIAS.DAT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NRODOV
DIM Rodovia$(NRODOV), NSTHRODOV(NRODOV)
FOR I = 1 TO NRODOV
    INPUT #1, Rodovia$(I)
NEXT I
CLOSE #1

' Numero de Subtrechos Homogeneos por rodovia:
ARQUIVO$ = CALC$ + "NSTHROD.OUT"
OPEN ARQUIVO$ FOR INPUT AS #1
INPUT #1, NSTHMAX
FOR I = 1 TO NRODOV
    INPUT #1, NSTHRODOV(I)
NEXT I
CLOSE #1

ARQ$ = CALC$ + "REF.DAT"
OPEN ARQ$ FOR INPUT AS #1
INPUT #1, TRECHO$
INPUT #1, Faixa
INPUT #1, PP
INPUT #1, NC
INPUT #1, TAXA
INPUT #1, PSIt
INPUT #1, GrTraf$
INPUT #1, RestrGreide$
CLOSE #1

' Parametros para o Fator de Seguranca no Guia da AASHTO

' Overall standard deviation
GrTraf$ = UCASE$(GrTraf$)
SELECT CASE GrTraf$
    CASE "A": S0 = .5
    CASE "M": S0 = .4
    CASE "B": S0 = .3
    CASE ELSE: S0 = .4
END SELECT

' Nivel de Confiabilidade
R(1) = 50: Z(1) = 0
R(2) = 60: Z(2) = -.253
R(3) = 70: Z(3) = -.524
R(4) = 75: Z(4) = -.674
R(5) = 80: Z(5) = -.841
R(6) = 85: Z(6) = -1.037
R(7) = 90: Z(7) = -1.282
R(8) = 91: Z(8) = -1.34
R(9) = 92: Z(9) = -1.405
R(10) = 93: Z(10) = -1.476
R(11) = 94: Z(11) = -1.555
R(12) = 95: Z(12) = -1.645
R(13) = 96: Z(13) = -1.751
R(14) = 97: Z(14) = -1.881
R(15) = 98: Z(15) = -2.054
R(16) = 99: Z(16) = -2.327
R(17) = 99.9: Z(17) = -3.09
R(18) = 99.99: Z(18) = -3.75
IF NC <= 50 THEN
    ZR = 0
ELSE
    IF NC <= R(2) THEN
        I1 = 1: I2 = 2
    ELSE
        IF NC <= R(3) THEN
            I1 = 2: I2 = 3
        ELSE
            IF NC <= R(4) THEN
                I1 = 3: I2 = 4
            ELSE
                IF NC <= R(5) THEN
                    I1 = 4: I2 = 5
                ELSE
                    IF NC <= R(6) THEN
                        I1 = 5: I2 = 6
                    ELSE
                        IF NC <= R(7) THEN
                            I1 = 6: I2 = 7
                        ELSE
                            IF NC <= R(8) THEN
                                I1 = 7: I2 = 8
                            ELSE
                                IF NC <= R(9) THEN
                                    I1 = 8: I2 = 9
                                ELSE
                                    IF NC <= R(10) THEN
                                        I1 = 9: I2 = 10
                                    ELSE
                                        IF NC <= R(11) THEN
                                            I1 = 10: I2 = 11
                                        ELSE
                                            IF NC <= R(12) THEN
                                                I1 = 11: I2 = 12
                                            ELSE
                                                IF NC <= R(13) THEN
                                                    I1 = 12: I2 = 13
                                                ELSE
                                                    IF NC <= R(14) THEN
                                                        I1 = 13: I2 = 14
                                                    ELSE
                                                        IF NC <= R(15) THEN
                                                            I1 = 14: I2 = 15
                                                        ELSE
                                                            IF NC <= R(16) THEN
                                                                I1 = 15: I2 = 16
                                                            ELSE
                                                                IF NC <= R(17) THEN
                                                                    I1 = 16: I2 = 17
                                                                ELSE
                                                                    I1 = 17: I2 = 18
                                                                END IF
                                                            END IF
                                                        END IF
                                                    END IF
                                                END IF
                                            END IF
                                        END IF
                                    END IF
                                END IF
                            END IF
                        END IF
                    END IF
                END IF
            END IF
        END IF
    END IF
    ' Interpolacao Linear
    X = NC
    X1 = R(I1)
    X2 = R(I2)
    Y1 = Z(I1)
    Y2 = Z(I2)
    ZR = ((X2 * Y1 - X1 * Y2) + X * (Y2 - Y1)) / (X2 - X1)
END IF

OPEN "Parametros.csv" FOR OUTPUT AS #15
WRITE #15, "Trecho", "Inicio", "Final", "VRmedia", "Np", "HRestrut", "HRfunc"
WRITE #15, "", "(km)", "(km)", "(anos)", "(AASHTO)", "(cm)", "(cm)"

OPEN "Trechos.csv" FOR INPUT AS #12
LINE INPUT #12, LINHA$
WHILE NOT EOF(12)

    INPUT #12, TRECHO$, TipoAmpliac$, kmiTrecho, kmfTrecho, AnoAmpliac, NFaixasMax

    IF TipoAmpliac$ = "Duplica" THEN
        NCasos = NFaixasMax
        FOR I = 1 TO NCasos
            FaixasAlt(I) = I
        NEXT I
    ELSE
        IF TipoAmpliac$ = "Faixa3LD" THEN
            IF NFaixasMax = 2 THEN
                NCasos = 1
                FaixasAlt(1) = 2
            ELSE
                NCasos = 2
                FaixasAlt(1) = 2
                FaixasAlt(2) = 3
            END IF
        ELSE
            IF NFaixasMax = 2 THEN
                NCasos = 1
                FaixasAlt(1) = 1
            ELSE
                NCasos = 2
                FaixasAlt(1) = 1
                FaixasAlt(2) = 3
            END IF
        END IF
    END IF

    HRestrutMed = 0
    HRfuncMed = 0
    JCONT = 0
    VRmed = 0
    ICONT = 0
    ICONT1 = 0
    FOR ICASO = 1 TO NCasos

        Faixa = FaixasAlt(ICASO)

        SELECT CASE Faixa
            CASE 1: Faixa$ = "1"
            CASE 2: Faixa$ = "2"
            CASE 3: Faixa$ = "3"
            CASE 4: Faixa$ = "4"
            CASE ELSE
                PRINT "ERRO"
        END SELECT

        ' Dados do pavimento dentro dos subtrechos homogeneos

        ARQUIVO$ = CALC$ + "HR" + TRECHO$ + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #1
        LINE INPUT #1, LINHA$

        ARQUIVO$ = CALC$ + "D" + TRECHO$ + Faixa$ + ".CSV"
        OPEN ARQUIVO$ FOR INPUT AS #2
        LINE INPUT #2, LINHA$

        WHILE NOT EOF(1)

            INPUT #2, Subtrecho, km, Dvbk, NanoUSACE, VR$, Rc, Dadm11, HRpro11, MedPRO11$, TipoSL$, HEF, DADM, HRpro269, AgePav

            INPUT #1, Subtrecho, km, DF(1), HRestr, CamCrit$, HRfunc, Medida$, hc, HR, h2, Acost$, hcac, HRac, h2ac, SNtotal, Hrev, Hbase, Hsub, Href, E1ref, E1, E2, Ebase, E3, MRsl, JDR, Eccp, Kef

            PRINT "km "; km

            IF (kmiTrecho <= km AND km <= kmfTrecho) THEN

                HRestrutMed = HRestrutMed + HRestr
                HRfuncMed = HRfuncMed + HRfunc
                JCONT = JCONT + 1

                ' Resgata os parametros gerados pelo SGP
                VRfaixa = -1
                NanoAASHTO = -1
                QI = -1
                CamBase$ = ""
                Achou$ = "N"
                ARQUIVO$ = CALC$ + "CADAS" + TRECHO$ + ".CSV"
                OPEN ARQUIVO$ FOR INPUT AS #4
                LINE INPUT #4, LINHA$
                WHILE (NOT EOF(4) AND Achou$ = "N")
                    INPUT #4, STH$, Rodov$, INI$, FIM$, KMI, KMF, PISTA$
                    INPUT #4, NFaixas, PLUV, ALTM, PLATAF, LARGPISTA, ACOSTLE, ACOSTLD
                    INPUT #4, GEOVERT$, GEOHORIZ$, SECTIPO$, FX(1), FX(2), FX(3), FX(4), DECTRA, RESTR, ExtPontes, OBS$
                    IF KMF > KMI THEN
                        IF (km >= KMI AND km <= KMF) THEN Achou$ = "S"
                    ELSE
                        IF (km <= KMI AND km >= KMF) THEN Achou$ = "S"
                    END IF
                    IF Achou$ = "S" THEN
                        GOSUB 300
                        IF VRfaixa >= 0 THEN
                            VRmed = VRmed + VRfaixa
                            ICONT = ICONT + 1
                            ' Calcula a capacidade de trafego do pavimento pelo Guia da AASHTO
                            a1 = 0.1667 * LOG(E1ref / 0.0703) - 1.733
                            SN(1) = a1 * (Hrev / 2.54)
                            MR(1) = Ebase
                            SELECT CASE CamBase$
                                CASE "BG", "MS", "MH", "SE"
                                    a2 = 0.249 * (LOG(Ebase / 0.0703) / LOG(10)) - 0.977
                                CASE "SOLO-CIMENTO", "SOLO-CAL", "BGTC", "SC", "CCR", "CCP"
                                    a2 = 0.25
                                CASE "MB", "PMQ", "SOLO-BETUME", "PMF", "CBUQ", "BINDER"
                                    a2 = 0.155 * LOG(Ebase / 0.0703) - 1.6586
                                CASE ELSE
                                    a2 = .14
                            END SELECT
                            SN(2) = SN(1) + a2 * (Hbase / 2.54)
                            MR(2) = E3
                            a3 = 0.227 * (LOG(E2 / 0.0703) / LOG(10)) - 0.839
                            SN(3) = SN(2) + a3 * (Hsub / 2.54)
                            MR(3) = MRsl
                            IF QI >= 0 THEN PSI0 = 5 * EXP(-QI / 71.5) ELSE PSI0 = 4.2
                            DELTAPSI = PSI0 - PSIt
                            IF DELTAPSI < .5 THEN DELTAPSI = .5
                            W18p = 1.0E10
                            FOR I = 1 TO 3
                                BETA = .4 + (1094 / ((SN(I) + 1) ^ 5.19))
                                W18 = (10 ^ (ZR * S0)) * (((SN(I) + 1) / 1.05) ^ 9.36) * (((DELTAPSI) / 2.7) ^ (1 / BETA)) * (((MR(I) / .0703) / 3000) ^ 2.32)
                                IF W18 < W18p THEN W18p = W18
                            NEXT I
                            IF W18P < 1.0E10 THEN
                               ICONT1 = ICONT1 + 1
                               W18med = W18med + W18p
                            END IF
                        END IF
                    END IF
                WEND
                CLOSE #4

            END IF

        WEND
        CLOSE #1, #2

    NEXT ICASO

    IF ICONT > 0 THEN VRmed = VRmed / ICONT
    IF ICONT1 > 0 THEN W18med = W18med / ICONT1
    IF JCONT > 0 THEN
        HRestrutMed = HRestrutMed / JCONT
        HRfuncMed = HRfuncMed / JCONT
    END IF

    WRITE #15, TRECHO$, kmiTrecho, kmfTrecho, VRmed, W18med, HRestrutMed, HRfuncMed

WEND
CLOSE #12, #15

SYSTEM


300 '
' - - - - - - - - - - - - - - - - - - -
' -  Leitura da Base de Dados do SGP  -
' - - - - - - - - - - - - - - - - - - -
Trincado$ = "N"
ARQUIVO$ = CALC$ + "ESTSTHS0.DAT"
OPEN ARQUIVO$ FOR INPUT AS #5
ISTH = 0
QIa = -1
AgePav = -1
FOR IRodov = 1 TO NRODOV
    FOR ISUB = 1 TO NSTHRODOV(IRodov)
        ISTH = ISTH + 1
        INPUT #5, Subtr, NFX, KM1, KM2, FatorVDM, FatorTraf
        FOR IFaixa = 1 TO NFX
            INPUT #5, IFX, h1, HrecExist, Idade, SN, QImed, Nano, IRI0, Nacum, REVEST$, ALFAIGG
            INPUT #5, PSIat, Aream2, VidaRes, VDMUni, PSInovo, Heff, IRec, ICalib, D0, MRfound
            INPUT #5, ALPHA0, ALPHA, ALPHA2, AreaAcost, PSIacost, DegrauAcost, T0, TR23, CBRsl, MatBase$, VDMc, ATRmed
            IF (Subtr = VAL(STH$) AND IFX = Faixa) THEN
                QI = QImed
                VRfaixa = VidaRes
                NanoAASHTO = Nano
                CamBase$ = UCASE$(MatBase$)
            END IF
        NEXT IFaixa
    NEXT ISUB
NEXT IRodov
INPUT #5, PSImed(0), Npsi(0), VRmed(0)
INPUT #5, AreaTotal, NUnidAnalise
CLOSE #5
RETURN
