CLS

  PRINT
  PRINT "   NECESSIDADE DE REFORCO ESTRUTURAL PELO GUIA DA AASHTO  "
  PRINT

  INPUT "- Periodo de projeto (anos) = "; PP
  PRINT
  INPUT "- PSI terminal = "; PSIt
  PRINT
  INPUT "- Nivel de confiabilidade (%) = "; Nconf
  PRINT

  PSI0 = 4.5
  S0 = .4

  NFaixas = 3
  ARQ$(1) = "Faixa1.csv"
  ARQ$(2) = "Faixa2.csv"
  ARQ$(3) = "Faixa3.csv"

  ' Funcao densidade de probabilidade para Fc
    DIM Nc(4), NQI(4), NS(4), NTR(4)
    Nc(1) = 50: NS(1) = 0: NQI(1) = 0: NTR(1) = 0
    Nc(2) = 85: NS(2) = 1.04: NQI(2) = 1.08: NTR(2) = 1.013
    Nc(3) = 90: NS(3) = 1.29: NQI(3) = 1.6038: NTR(3) = 1.14
    Nc(4) = 95: NS(4) = 1.65: NQI(4) = 2.35: NTR(4) = 1.348
    IF Nconf <= Nc(2) THEN
       I1 = 1: I2 = 2
    ELSE
       IF Nconf <= Nc(3) THEN
          I1 = 2: I2 = 3
       ELSE
          I1 = 3: I2 = 4
       END IF
    END IF
    Ngauss = ((Nc(I2) * NS(I1) - Nc(I1) * NS(I2)) + Nconf * (NS(I2) - NS(I1))) / (Nc(I2) - Nc(I1))

  FOR IFX = 1 TO NFaixas
    OPEN ARQ$(IFX) FOR INPUT AS #1
    LINE INPUT #1, LINHA$
    SELECT CASE IFX
           CASE 1: Faixa$ = "1"
           CASE 2: Faixa$ = "2"
           CASE 3: Faixa$ = "3"
           CASE ELSE
                   PRINT "ERRO": STOP
    END SELECT
    ARQOUT$ = "HR" + Faixa$ + ".csv"
    OPEN ARQOUT$ FOR OUTPUT AS #3
    WRITE #3, "km", "HR_cm"
    NP = 0
    WHILE NOT EOF(1)
      INPUT #1, km, D0, SN, Esl
      OPEN "Trafego.csv" FOR INPUT AS #2
      LINE INPUT #2, LINHA$
      WHILE NOT EOF(2)
        INPUT #2, kmi, kmf, Faixa, NanoAASHTO, NanoUSACE
        IF Faixa = IFX THEN
           IF (km >= kmi AND km <= kmf) THEN NP = PP * NanoAASHTO
        END IF
      WEND
      CLOSE #2
      MR = Esl / .0703
      DPSI = PSI0 - PSIt
      W18 = 0
      SNP = .5
      WHILE W18 < NP
         SNP = SNP + .01
         BETA = .4 + (1094 / ((SNP + 1) ^ 5.19))
         W18 = (((SNP + 1) / 1.05) ^ 9.36) * ((DPSI / 2.7) ^ (1 / BETA))
         W18 = W18 * ((MR / 3000) ^ 2.32) * 10 ^ (-Ngauss * S0)
      WEND
      HR = ((SNP - SN) / .44) / 2.54
      IF HR < 0 THEN HR = 0
      WRITE #3, km, HR
    WEND
    CLOSE #1, #3
  NEXT IFX


END

