/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.spring.security;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.web.filter.GenericFilterBean;

public class CorsFilter
extends GenericFilterBean
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (!resp.containsHeader("Access-Control-Allow-Origin")) {
            resp.addHeader("Access-Control-Allow-Origin", "*");
        }
        if (!resp.containsHeader("Access-Control-Allow-Methods")) {
            resp.addHeader("Access-Control-Allow-Methods", "GET, OPTIONS, HEAD, PUT, POST, DELETE");
        }
        if (!resp.containsHeader("Access-Control-Allow-Headers")) {
            resp.addHeader("Access-Control-Allow-Headers", "Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
        }
        if (req.getMethod().equals("OPTIONS")) {
            resp.setStatus(202);
            return;
        }
        chain.doFilter(request, response);
    }
}

