/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.server.helpers;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.core.mail.Email;
import br.com.oti.gesconsys.beans.core.mail.EmailDestinatario;
import br.com.oti.gesconsys.beans.core.mail.TipoDestinatario;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.obrigacao.ObrigacaoLancamento;
import br.com.oti.gesconsys.beans.obrigacao.ObrigacaoMobileVO;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.dao.seguranca.UsuarioEmpresaDAO;
import br.com.oti.gesconsys.business.services.ObrigacaoService;
import br.com.oti.gesconsys.dao.geral.EmpresaDAO;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.helper.EncodeDecodeURL;
import jakarta.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailObrigacaoHelper {
    private Logger logger = LoggerFactory.getLogger(EmailObrigacaoHelper.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private ObrigacaoService obrigacaoService;
    @Autowired
    private EmpresaDAO empresaDAO;
    @Autowired
    private UsuarioEmpresaDAO usuarioEmpresaDAO;
    private Integer countEmails;

    @PostConstruct
    private void init() {
        this.countEmails = 0;
    }

    public Boolean execute() {
        String webAppCtx = (String)this.coreService.getRefValueByName(null, TipoRefCode.URL_WEBAPP_CONTEXT);
        if (webAppCtx == null || webAppCtx.isEmpty()) {
            throw new BusinessException("Application Context URL n\u00e3o informada.");
        }
        HashMap resumoCriticos = new HashMap();
        ArrayList usuariosCache = new ArrayList();
        ArrayList<UsuarioEmpresa> usersEmpresa = new ArrayList<UsuarioEmpresa>();
        List dataObrigacoes = null;
        LocalDate datIni = LocalDate.now().withDayOfMonth(1);
        LocalDate datFim = YearMonth.from(datIni).atEndOfMonth();
        HashMap<String, List> tplData = new HashMap<String, List>();
        SimpleDateFormat sdfDatas = new SimpleDateFormat("dd/MM");
        String data = sdfDatas.format(new Date(System.currentTimeMillis()));
        List empresas = this.empresaDAO.findAll("", null);
        ArrayList<String> usersValidate = new ArrayList<String>();
        ArrayList<Integer> empsId = new ArrayList<Integer>();
        for (Empresa empresa : empresas) {
            usuariosCache.clear();
            usersEmpresa.clear();
            empsId.clear();
            empsId.add(empresa.getId());
            for (UsuarioEmpresa usrEmp : this.usuarioEmpresaDAO.findUsuariosByEmpresasAndGrupos(empsId, null, null, null, Boolean.valueOf(false), null, null)) {
                usersEmpresa.add(usrEmp);
                String keyUser = String.format("%d::%d", usrEmp.getId().getIdEmpresa(), usrEmp.getId().getIdUsuario());
                if (usersValidate.contains(keyUser)) continue;
                usersValidate.add(keyUser);
            }
            dataObrigacoes = this.obrigacaoService.findObrigacoesByIntervalo(empresa.getId(), datIni, datFim);
            if (dataObrigacoes != null && !dataObrigacoes.isEmpty()) {
                for (ObrigacaoLancamento lcto : dataObrigacoes) {
                    Integer idUsuario = lcto.getObrigacao().getIdResponsavelArea();
                    if (idUsuario == null) {
                        idUsuario = lcto.getObrigacao().getIdUsuarioIns();
                    }
                    this.processUsuario(idUsuario, lcto, resumoCriticos, usuariosCache, usersValidate, webAppCtx);
                }
                this.logger.debug("obrigacoes.count={}", (Object)dataObrigacoes.size());
            }
            this.logger.debug("Processando usu\u00e1rios, empresa '{}'", (Object)empresa.getSigla());
            for (Integer idUsuario : usuariosCache) {
                UsuarioEmpresa usuarioEmp = null;
                for (UsuarioEmpresa usrEmpresa : usersEmpresa) {
                    if (!usrEmpresa.getId().getIdUsuario().equals(idUsuario)) continue;
                    usuarioEmp = usrEmpresa;
                    break;
                }
                if (usuarioEmp == null) {
                    this.logger.debug("Usu\u00e1rio '{}' inativo, ignorado no email mensal.", (Object)idUsuario);
                    continue;
                }
                tplData.clear();
                List criticasLst = (List)resumoCriticos.get(idUsuario);
                if (criticasLst != null && criticasLst.size() > 0) {
                    tplData.put("lancamentos", criticasLst);
                }
                String emailContent = this.coreService.processTemplate(empresa.getId(), "resumoMensalObrigacoes.tpl", tplData);
                Integer countCrit = 0;
                Integer countImpo = 0;
                Integer countApro = 0;
                Integer idEmpresa = null;
                if (criticasLst != null && !criticasLst.isEmpty()) {
                    idEmpresa = ((ObrigacaoMobileVO)criticasLst.get(0)).getIdEmpresa();
                    countCrit = criticasLst.size();
                }
                if (idEmpresa == null || countCrit <= 0 && countImpo <= 0 && countApro <= 0) continue;
                Email email = new Email();
                email.getId().setIdEmpresa(idEmpresa);
                email.setAssunto(String.format("Resumo Mensal Obriga\u00e7\u00f5es %s - %s", usuarioEmp.getEmpresa().getSigla(), data));
                email.setOrigem(TipoModulo.OBRIGACOES.getSigla());
                email.setStatus(Integer.valueOf(0));
                EmailDestinatario destinatario = new EmailDestinatario(idEmpresa, idUsuario, TipoDestinatario.EMAIL_TO);
                email.setDestinatarios(new ArrayList());
                email.getDestinatarios().add(destinatario);
                email = this.coreService.saveEmail(email, emailContent);
                Integer n = this.countEmails;
                this.countEmails = this.countEmails + 1;
            }
        }
        return true;
    }

    private void processUsuario(Integer idUsuario, ObrigacaoLancamento lancamento, Map<Integer, List<ObrigacaoMobileVO>> resumo, List<Integer> usuarios, List<String> usersValidate, String contextPath) {
        String keyUser;
        if (idUsuario == null || lancamento == null) {
            return;
        }
        if (usersValidate != null && !usersValidate.contains(keyUser = String.format("%d::%d", lancamento.getId().getIdEmpresa(), idUsuario))) {
            return;
        }
        List<ObrigacaoMobileVO> dadosUsuarios = resumo.get(idUsuario);
        if (dadosUsuarios == null) {
            dadosUsuarios = new ArrayList<ObrigacaoMobileVO>();
            resumo.put(idUsuario, dadosUsuarios);
        }
        ObrigacaoMobileVO obrigaMail = ObrigacaoMobileVO.fromLancamento((ObrigacaoLancamento)lancamento);
        boolean foundObriga = false;
        for (ObrigacaoMobileVO itemMail : dadosUsuarios) {
            if (!itemMail.getIdEmpresa().equals(obrigaMail.getIdEmpresa()) || !itemMail.getIdObrigacao().equals(obrigaMail.getIdObrigacao()) || !itemMail.getSeqLancamento().equals(obrigaMail.getSeqLancamento())) continue;
            foundObriga = true;
            break;
        }
        if (!foundObriga) {
            dadosUsuarios.add(obrigaMail);
            StringBuilder outLink = new StringBuilder();
            outLink.append("/pages/obrigacao/obrigacaoLancamentoEdit.faces");
            outLink.append("?idEmpresa=").append(obrigaMail.getIdEmpresa());
            outLink.append("&idObrigacao=").append(obrigaMail.getIdObrigacao());
            outLink.append("&seqLancamento=").append(obrigaMail.getSeqLancamento());
            String encodedURL = new EncodeDecodeURL().encode(outLink.toString());
            outLink = new StringBuilder();
            outLink.append(contextPath);
            outLink.append("/forwardUrl?fwId=").append(encodedURL);
            obrigaMail.setExternalUrl(outLink.toString());
        }
        if (!usuarios.contains(idUsuario)) {
            usuarios.add(idUsuario);
        }
    }
}

