/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.server.helpers;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.core.mail.Email;
import br.com.oti.gesconsys.beans.core.mail.EmailDestinatario;
import br.com.oti.gesconsys.beans.core.mail.TipoDestinatario;
import br.com.oti.gesconsys.beans.core.mail.UsuarioEmailEmpresa;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.obrigacao.ObrigacaoLancamento;
import br.com.oti.gesconsys.beans.obrigacao.TipoStatusLancamentoObrigacao;
import br.com.oti.gesconsys.beans.seguranca.UsuarioArea;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.shared.EmailDiarioVO;
import br.com.oti.gesconsys.beans.shared.ObrigacaoResponsavel;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.dao.seguranca.UsuarioAreaDAO;
import br.com.oti.gesconsys.business.dao.seguranca.UsuarioEmpresaDAO;
import br.com.oti.gesconsys.business.services.ObrigacaoService;
import br.com.oti.gesconsys.dao.geral.EmpresaDAO;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.helper.EncodeDecodeURL;
import jakarta.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailDiarioObrigacaoHelper {
    private Logger logger = LoggerFactory.getLogger(EmailDiarioObrigacaoHelper.class);
    @Autowired
    private CoreService coreService;
    @Autowired
    private ObrigacaoService obrigacaoService;
    @Autowired
    private EmpresaDAO empresaDAO;
    @Autowired
    private UsuarioEmpresaDAO usuarioEmpresaDAO;
    @Autowired
    private UsuarioAreaDAO usuarioAreaDAO;
    private Integer countEmails;
    private Map<Integer, List<EmailDiarioVO>> resumoAreas;
    private static final int PRAZO_IMPORTANTE = 15;
    private static final int PRAZO_CRITICO = 7;

    @PostConstruct
    private void init() {
        this.countEmails = 0;
    }

    public Boolean execute() {
        String webAppCtx = (String)this.coreService.getRefValueByName(null, TipoRefCode.URL_WEBAPP_CONTEXT);
        if (webAppCtx == null || webAppCtx.isEmpty()) {
            throw new BusinessException("Application Context URL n\u00e3o informada.");
        }
        String apiUrl = (String)this.coreService.getRefValueByName(null, TipoRefCode.URL_API_CONTEXT);
        if (apiUrl == null || apiUrl.isEmpty()) {
            throw new BusinessException("API Context URL n\u00e3o informada.");
        }
        String userApi = (String)this.coreService.getRefValueByName(null, TipoRefCode.SCHEDULER_USUARIO_API);
        if (userApi == null || userApi.isEmpty()) {
            throw new BusinessException("Usu\u00e1rio API [Scheduler] n\u00e3o foi informado.");
        }
        HashMap resumoCriticos = new HashMap();
        HashMap resumoImportantes = new HashMap();
        ArrayList<String> usuariosCache = new ArrayList<String>();
        HashMap<String, UsuarioEmpresa> usersEmpresa = new HashMap<String, UsuarioEmpresa>();
        this.resumoAreas = new HashMap();
        List empresas = this.empresaDAO.findAll("", null);
        HashMap<String, List> tplData = new HashMap<String, List>();
        SimpleDateFormat sdfDatas = new SimpleDateFormat("dd/MM");
        String data = sdfDatas.format(new Date(System.currentTimeMillis()));
        ArrayList<String> usersValidate = new ArrayList<String>();
        LocalDate datInicio = LocalDate.now().withDayOfYear(1);
        LocalDate datFinal = LocalDate.now().plusDays(15L);
        ArrayList<Integer> empsId = new ArrayList<Integer>();
        for (Empresa empresa : empresas) {
            Object usrEmp2;
            usuariosCache.clear();
            usersEmpresa.clear();
            empsId.clear();
            empsId.add(empresa.getId());
            for (Object usrEmp2 : this.usuarioEmpresaDAO.findUsuariosByEmpresasAndGrupos(empsId, null, null, null, Boolean.valueOf(false), null, null)) {
                usersEmpresa.put(usrEmp2.getUsuario().getLogin(), (UsuarioEmpresa)usrEmp2);
                String keyUser = String.format("%d::%s", usrEmp2.getId().getIdEmpresa(), usrEmp2.getUsuario().getLogin());
                if (usersValidate.contains(keyUser)) continue;
                usersValidate.add(keyUser);
            }
            List usuariosAreas = this.usuarioAreaDAO.findUsuariosAreaByEmpresa(empresa.getId(), null, null, Boolean.valueOf(false));
            usrEmp2 = usuariosAreas.iterator();
            while (usrEmp2.hasNext()) {
                UsuarioArea usuarioArea = (UsuarioArea)usrEmp2.next();
                if (usuarioArea.getModulos() == null || !usuarioArea.getModulos().contains(TipoModulo.OBRIGACOES.getSigla())) continue;
                usuariosCache.add(usuarioArea.getUsuario().getLogin());
            }
            List usrMailsEmp = this.empresaDAO.findUsuariosEmailByEmpresa(empresa.getId(), "O");
            StringBuilder url = new StringBuilder();
            url.append(apiUrl);
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(empresa.getId());
            List obrigacoesDB = this.obrigacaoService.findLancamentosByFiltro(empresasInt, null, null, null, TipoStatusLancamentoObrigacao.PENDENTE.getCode(), null, null, datInicio, datFinal, null, null, null, Boolean.valueOf(true));
            if (obrigacoesDB != null) {
                Object obrigacao;
                for (ObrigacaoLancamento lcto : obrigacoesDB) {
                    if (lcto.getPrazo() == null || (obrigacao = lcto.getObrigacao()) == null || obrigacao.getIdArea() == null) continue;
                    ArrayList<EmailDiarioVO> dataAreas = (ArrayList<EmailDiarioVO>)this.resumoAreas.get(obrigacao.getIdArea());
                    if (dataAreas == null) {
                        dataAreas = new ArrayList<EmailDiarioVO>();
                    }
                    if (lcto.getPrazo().compareTo(7) > 0 && lcto.getPrazo().compareTo(15) > 0) continue;
                    dataAreas.add(this.generateObrigacaoMail(lcto, webAppCtx));
                    this.resumoAreas.put(obrigacao.getIdArea(), dataAreas);
                }
                for (ObrigacaoLancamento lcto : obrigacoesDB) {
                    UsuarioEmailEmpresa usrMail;
                    ObrigacaoResponsavel responsavel;
                    if (lcto.getPrazo() == null) continue;
                    if (lcto.getPrazo().compareTo(7) <= 0) {
                        if (lcto.getObrigacao().getResponsavelArea() != null) {
                            this.processUsuario(lcto.getObrigacao().getResponsavelArea().getLogin(), lcto, resumoCriticos, usuariosCache, usersValidate, webAppCtx);
                        }
                        if (lcto.getResponsavelEntrega() != null && lcto.getResponsavelEntrega().getLogin() != null) {
                            this.processUsuario(lcto.getResponsavelEntrega().getLogin(), lcto, resumoCriticos, usuariosCache, usersValidate, webAppCtx);
                        }
                        obrigacao = lcto.getObrigacao().getResponsaveis().iterator();
                        while (obrigacao.hasNext()) {
                            responsavel = (ObrigacaoResponsavel)obrigacao.next();
                            this.processUsuario(responsavel.getResponsavel().getLogin(), lcto, resumoCriticos, usuariosCache, usersValidate, webAppCtx);
                        }
                        if (usrMailsEmp == null) continue;
                        obrigacao = usrMailsEmp.iterator();
                        while (obrigacao.hasNext()) {
                            usrMail = (UsuarioEmailEmpresa)obrigacao.next();
                            this.processUsuario(usrMail.getUsuario().getLogin(), lcto, resumoCriticos, usuariosCache, usersValidate, webAppCtx);
                        }
                        continue;
                    }
                    if (lcto.getPrazo().compareTo(15) > 0) continue;
                    if (lcto.getObrigacao().getResponsavelArea() != null) {
                        this.processUsuario(lcto.getObrigacao().getResponsavelArea().getLogin(), lcto, resumoImportantes, usuariosCache, usersValidate, webAppCtx);
                    }
                    if (lcto.getResponsavelEntrega() != null && lcto.getResponsavelEntrega().getLogin() != null) {
                        this.processUsuario(lcto.getResponsavelEntrega().getLogin(), lcto, resumoImportantes, usuariosCache, usersValidate, webAppCtx);
                    }
                    obrigacao = lcto.getObrigacao().getResponsaveis().iterator();
                    while (obrigacao.hasNext()) {
                        responsavel = (ObrigacaoResponsavel)obrigacao.next();
                        this.processUsuario(responsavel.getResponsavel().getLogin(), lcto, resumoImportantes, usuariosCache, usersValidate, webAppCtx);
                    }
                    if (usrMailsEmp == null) continue;
                    obrigacao = usrMailsEmp.iterator();
                    while (obrigacao.hasNext()) {
                        usrMail = (UsuarioEmailEmpresa)obrigacao.next();
                        this.processUsuario(usrMail.getUsuario().getLogin(), lcto, resumoImportantes, usuariosCache, usersValidate, webAppCtx);
                    }
                }
            }
            UsuarioEmpresa usuarioEmp = null;
            this.logger.debug("Processando usu\u00e1rios, empresa '{}'", (Object)empresa.getSigla());
            for (String userName : usuariosCache) {
                List importantesLst;
                usuarioEmp = (UsuarioEmpresa)usersEmpresa.get(userName);
                if (usuarioEmp == null) {
                    this.logger.debug("Usu\u00e1rio '{}' inativo, ignorado no email di\u00e1rio.", (Object)userName);
                    continue;
                }
                tplData.clear();
                List criticasLst = (List)resumoCriticos.get(userName);
                if (criticasLst != null && criticasLst.size() > 0) {
                    tplData.put("criticas", criticasLst);
                }
                if ((importantesLst = (List)resumoImportantes.get(userName)) != null && importantesLst.size() > 0) {
                    tplData.put("importantes", importantesLst);
                }
                ArrayList areasLst = new ArrayList();
                for (UsuarioArea usuarioArea : usuariosAreas) {
                    List dataAreas;
                    if (!usuarioArea.getUsuario().getLogin().equals(userName) || (dataAreas = (List)this.resumoAreas.get(usuarioArea.getId().getIdArea())) == null || dataAreas.isEmpty()) continue;
                    areasLst.addAll(dataAreas);
                }
                if (areasLst.size() > 0) {
                    tplData.put("pendenciasAreas", areasLst);
                }
                String emailContent = this.coreService.processTemplate(empresa.getId(), "resumoDiarioObrigacoes.tpl", tplData);
                Integer countCrit = 0;
                Integer countImpo = 0;
                Integer idEmpresa = null;
                if (criticasLst != null && !criticasLst.isEmpty()) {
                    idEmpresa = ((ObrigacaoLancamento)criticasLst.get(0)).getId().getIdEmpresa();
                    countCrit = criticasLst.size();
                } else if (importantesLst != null && !importantesLst.isEmpty()) {
                    idEmpresa = ((ObrigacaoLancamento)importantesLst.get(0)).getId().getIdEmpresa();
                    countImpo = importantesLst.size();
                }
                if (idEmpresa == null || countCrit <= 0 && countImpo <= 0) continue;
                Email email = new Email();
                email.getId().setIdEmpresa(idEmpresa);
                email.setAssunto(String.format("Resumo di\u00e1rio obriga\u00e7\u00f5es %s - %s", usuarioEmp.getEmpresa().getSigla(), data));
                email.setOrigem(TipoModulo.OBRIGACOES.getSigla());
                email.setStatus(Integer.valueOf(0));
                EmailDestinatario destinatario = new EmailDestinatario(idEmpresa, usuarioEmp.getId().getIdUsuario(), TipoDestinatario.EMAIL_TO);
                email.setDestinatarios(new ArrayList());
                email.getDestinatarios().add(destinatario);
                email = this.coreService.saveEmail(email, emailContent);
                Integer n = this.countEmails;
                this.countEmails = this.countEmails + 1;
            }
        }
        return true;
    }

    private void processUsuario(String nomeUsuario, ObrigacaoLancamento obrigacao, Map<String, List<ObrigacaoLancamento>> resumo, List<String> usuarios, List<String> usersValidate, String contextPath) {
        String keyUser;
        if (nomeUsuario == null || obrigacao == null) {
            return;
        }
        if (usersValidate != null && !usersValidate.contains(keyUser = String.format("%d::%s", obrigacao.getId().getIdEmpresa(), nomeUsuario))) {
            return;
        }
        List<ObrigacaoLancamento> dadosUsuarios = resumo.get(nomeUsuario);
        if (dadosUsuarios == null) {
            dadosUsuarios = new ArrayList<ObrigacaoLancamento>();
            resumo.put(nomeUsuario, dadosUsuarios);
        }
        Boolean found = false;
        for (ObrigacaoLancamento itemMail : dadosUsuarios) {
            if (!itemMail.getId().getIdEmpresa().equals(obrigacao.getId().getIdEmpresa()) || !itemMail.getId().getIdObrigacao().equals(obrigacao.getId().getIdObrigacao()) || !itemMail.getId().getSequencia().equals(obrigacao.getId().getSequencia())) continue;
            found = true;
            break;
        }
        if (!found.booleanValue()) {
            dadosUsuarios.add(obrigacao);
            StringBuilder outLink = new StringBuilder();
            outLink.append("/pages/obrigacao/obrigacaoLancamentoEdit.faces");
            outLink.append("?idEmpresa=").append(obrigacao.getId().getIdEmpresa());
            outLink.append("&idObrigacao=").append(obrigacao.getId().getIdObrigacao());
            outLink.append("&seqLancamento=").append(obrigacao.getId().getSequencia());
            String encodedURL = new EncodeDecodeURL().encode(outLink.toString());
            outLink = new StringBuilder();
            outLink.append(contextPath);
            outLink.append("/forwardUrl?fwId=").append(encodedURL);
            obrigacao.setExternalUrl(outLink.toString());
        }
        if (!usuarios.contains(nomeUsuario)) {
            usuarios.add(nomeUsuario);
        }
    }

    private EmailDiarioVO generateObrigacaoMail(ObrigacaoLancamento lcto, String contextPath) {
        String classificacao = "";
        if (lcto.getObrigacao().getClassificacao() != null) {
            classificacao = lcto.getObrigacao().getClassificacao().getDescricao();
        }
        EmailDiarioVO lctoMail = new EmailDiarioVO(lcto.getId().getIdEmpresa(), lcto.getId().getIdObrigacao(), lcto.getId().getSequencia(), lcto.getObrigacao().getNome(), lcto.getObrigacao().getDescricao(), lcto.getDatObrigacao(), classificacao, lcto.getEmpresa(), lcto.getObrigacao().getArea(), lcto.getObrigacao().getResponsavelArea(), lcto.getObrigacao().getEntidade());
        StringBuilder outLink = new StringBuilder();
        outLink.append("/pages/obrigacao/obrigacaoLancamentoEdit.faces");
        outLink.append("?idEmpresa=").append(lctoMail.getIdEmpresa());
        outLink.append("&idObrigacao=").append(lctoMail.getIdObrigacao());
        outLink.append("&seqLancamento=").append(lctoMail.getSequencia());
        String encodedURL = new EncodeDecodeURL().encode(outLink.toString());
        outLink = new StringBuilder();
        outLink.append(contextPath);
        outLink.append("/forwardUrl?fwId=").append(encodedURL);
        lctoMail.setExternalUrl(outLink.toString());
        return lctoMail;
    }
}

