/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.sigaco;

import br.com.oti.gesconsys.beans.ativos.TipoAtivo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.sigaco.cad.ImportacaoMonitoracao;
import br.com.oti.gesconsys.beans.sigaco.monit.DashboardSigacoVO;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoAnexo;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoDrenagem;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoEdificacao;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoFaixaDominio;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoHistorico;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoImagem;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoOae;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoSigaco;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoSinalizacao;
import br.com.oti.gesconsys.beans.sigaco.monit.MonitoracaoTerrapleno;
import br.com.oti.gesconsys.beans.sigaco.pav.MonitoracaoPavimento;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.business.services.SigacoService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.sigaco.ExportMonitoracaoExcel;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Tag(description="REST Services para Monitora\u00e7\u00f5es do Sigaco", name="sigaco")
@RequestMapping(value={"/api/monitoracoes/sigaco"})
public class MonitoracoesSigacoRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(MonitoracoesSigacoRestServices.class);
    private static Locale ptBR = new Locale.Builder().setLanguage("pt").setRegion("BR").build();
    private static final NumberFormat fmtPtBr = DecimalFormat.getNumberInstance(ptBR);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SigacoService sigacoService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}/{tipoAtivo}/all"})
    public ResponseEntity<List<MonitoracaoSigaco>> findMonitoracoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usr = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Double[] kmMetros;
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findMonitoracoes({}, {})", (Object)empresa, (Object)tipoAtivo);
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            TipoAtivo tipoAtv = TipoAtivo.fromCode((String)tipoAtivo);
            Integer idTipoElemento = null;
            Integer idFase = null;
            String situacao = null;
            String param = null;
            Integer idRodovia = null;
            Double kmInicial = null;
            Double kmFinal = null;
            Integer faixa = null;
            String sentido = null;
            if (tipoAtv == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ativo [%s]n\u00e3o encontrado.", tipoAtivo));
            }
            String[] params = request.getParameterValues("faseMonitoracao");
            if (params != null && params.length > 0 && params[0] != null && !params[0].isEmpty()) {
                idFase = Integer.valueOf(params[0]);
            }
            if ((param = request.getParameter("rodovia")) != null) {
                idRodovia = Integer.valueOf(param);
            }
            if ((param = request.getParameter("categoria")) != null) {
                idTipoElemento = Integer.valueOf(param);
            }
            if ((kmMetros = MonitoracoesSigacoRestServices.stringToKm((String)request.getParameter("kmInicial"))) != null && kmMetros.length > 0) {
                kmInicial = kmMetros[0] + kmMetros[1];
            }
            if ((kmMetros = MonitoracoesSigacoRestServices.stringToKm((String)request.getParameter("kmFinal"))) != null && kmMetros.length > 0) {
                kmFinal = kmMetros[0] + kmMetros[1];
            }
            if ((param = request.getParameter("faixa")) != null) {
                faixa = Integer.valueOf(param);
            }
            sentido = request.getParameter("sentido");
            situacao = request.getParameter("situacao");
            String classeSinalizacao = request.getParameter("classeSinalizacao");
            String variavel = null;
            String varIni = null;
            String varFim = null;
            Integer seqImportacao = null;
            param = request.getParameter("importacao");
            if (param != null) {
                seqImportacao = Integer.valueOf(param);
            }
            Integer statusImportacao = null;
            param = request.getParameter("statusImportacao");
            if (param != null) {
                statusImportacao = Integer.valueOf(param);
            }
            if (usr.getIdPoderConcedente() != null && empresaDB.getIdPoderConcedente() != null && usr.isExterno().booleanValue() && usr.getIdPoderConcedente().equals(empresaDB.getIdPoderConcedente())) {
                statusImportacao = 2;
            }
            List rows = this.sigacoService.findMonitoracoes(empresa, tipoAtv, idTipoElemento, idFase, idRodovia, kmInicial, kmFinal, faixa, sentido, situacao, classeSinalizacao, variavel, varIni, varFim, seqImportacao, statusImportacao);
            for (MonitoracaoSigaco row : rows) {
                if (row.getElemento() == null) continue;
                row.getElemento().setTipoElemento(null);
                row.getElemento().setRodovia(null);
                row.setAnexos(null);
                row.setImportacao(null);
                if (row.getRodovia() == null) continue;
                row.getRodovia().setEmpresa(null);
            }
            return ResponseEntity.ok().body((Object)rows);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findMonitoracoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{tipoAtivo}/{idMonitoracao}"})
    public ResponseEntity<MonitoracaoSigaco> getMonitoracaoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_VISUALIZAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_VISUALIZAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getMonitoracaoById({}, {})", (Object)empresa, (Object)idMonitoracao);
            TipoAtivo tipoAtv = TipoAtivo.fromCode((String)tipoAtivo);
            return ResponseEntity.ok().body((Object)this.sigacoService.getMonitoracaoById(empresa, idMonitoracao, tipoAtv));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getMonitoracaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/drenagens"})
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoDrenagem monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_FASE_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_FASE_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            MonitoracaoSigaco monitoracaoDB = this.sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[DRE]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/sinalizacoes"})
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoSinalizacao monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_FASE_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_FASE_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            MonitoracaoSigaco monitoracaoDB = this.sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[SNH]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/pavimentos"})
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoPavimento monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_FASE_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_FASE_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            MonitoracaoSigaco monitoracaoDB = this.sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[SNV]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/terraplenos"})
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoTerrapleno monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_FASE_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_FASE_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            MonitoracaoSigaco monitoracaoDB = this.sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[SNV]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/faixasDominio"})
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoFaixaDominio monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_FASE_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_FASE_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            MonitoracaoSigaco monitoracaoDB = this.sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[Faixa de dom\u00ednio]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/obrasArteEspeciais"})
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoOae monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_FASE_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_FASE_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            MonitoracaoSigaco monitoracaoDB = this.sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[Obra de Arte Especial]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/edificacoes"})
    public ResponseEntity<MonitoracaoSigaco> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoEdificacao monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_FASE_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_FASE_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            MonitoracaoSigaco monitoracaoDB = this.sigacoService.saveMonitoracao(empresa, (MonitoracaoSigaco)monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[Edifica\u00e7\u00f5es]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{empresa}"})
    public ResponseEntity<MonitoracaoSigaco> updateMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoSigaco monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_ALTERAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_ALTERAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            MonitoracaoSigaco monitoracaoDB = this.sigacoService.saveMonitoracao(empresa, monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateMonitoracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{tipoAtivo}/{idMonitoracao}"})
    public ResponseEntity<Boolean> deleteMonitoracao(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXCLUIR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_EXCLUIR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            TipoAtivo tipoAtv = TipoAtivo.fromCode((String)tipoAtivo);
            return new ResponseEntity((Object)this.sigacoService.deleteMonitoracao(empresa, idMonitoracao, tipoAtv), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteMonitoracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/imagens"})
    public ResponseEntity<List<MonitoracaoImagem>> findImagens(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findImagens({})", (Object)empresa);
            return ResponseEntity.ok().body((Object)this.sigacoService.findImagensMonitoracao(empresa, idMonitoracao, null, null, null, null, null));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findImagens", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/imagens/{sequencia}"})
    public ResponseEntity<MonitoracaoImagem> getImagemById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_VISUALIZAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_VISUALIZAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getImagemById({}, {})", (Object)empresa, (Object)idMonitoracao);
            return ResponseEntity.ok().body((Object)this.sigacoService.getImagemMonitoracaoById(empresa, idMonitoracao, sequencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getImagemById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{idMonitoracao}/imagens"})
    @ResponseBody
    public ResponseEntity<MonitoracaoImagem> saveImagem(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @RequestParam(name="file", required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando saveImagem(emp={},idMonitoracao={})...", (Object)empresa, (Object)idMonitoracao);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_IMAGEM_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_IMAGEM_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            String tipoMovto = null;
            String tipoImagem = null;
            if (formData.containsKey("tipoAtivo")) {
                tipoAtivo = ((String[])formData.get("tipoAtivo"))[0];
            }
            if (formData.containsKey("tipoMovimento")) {
                tipoMovto = ((String[])formData.get("tipoMovimento"))[0];
            }
            if (formData.containsKey("tipoImagem")) {
                tipoImagem = ((String[])formData.get("tipoImagem"))[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            MonitoracaoImagem imagemDB = this.sigacoService.saveImagemMonitoracao(empresa, idMonitoracao, tipoAtivo, tipoImagem, tipoMovto, fileInfo, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)imagemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveImagem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("BizExc.saveImagem", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idMonitoramento}/imagens/{seqAnexo}"})
    @Operation(summary="Exclui a imagem da monitora\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteImagemMonitoracao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoramento") Integer idMonitoramento, @PathVariable(name="seqAnexo") Integer seqAnexo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteImagemMonitoracaoSigaco({},{},{})", new Object[]{empresa, idMonitoramento, seqAnexo});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXCLUIR_IMAGEM_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_EXCLUIR_IMAGEM_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.sigacoService.deleteImagemMonitoracao(empresa, idMonitoramento, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteImagemMonitoracaoSigaco", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/anexos"})
    public ResponseEntity<List<MonitoracaoAnexo>> findAnexos(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findImagens({})", (Object)empresa);
            return ResponseEntity.ok().body((Object)this.sigacoService.findAnexosMonitoracao(empresa, idMonitoracao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findImagens", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/anexos/{sequencia}"})
    public ResponseEntity<MonitoracaoAnexo> getAnexoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getAnexoById({}, {})", (Object)empresa, (Object)idMonitoracao);
            return ResponseEntity.ok().body((Object)this.sigacoService.getAnexoMonitoracaoById(empresa, idMonitoracao, sequencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAnexoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{idMonitoracao}/anexos"})
    @ResponseBody
    public ResponseEntity<MonitoracaoAnexo> saveAnexo(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @RequestParam(name="file", required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando saveAnexo(emp={},idMonitoracao={})...", (Object)empresa, (Object)idMonitoracao);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_FASE_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_FASE_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            String tipoAnexo = null;
            if (formData.containsKey("tipoAtivo")) {
                tipoAtivo = ((String[])formData.get("tipoAtivo"))[0];
            }
            if (formData.containsKey("tipoAnexo")) {
                tipoAnexo = ((String[])formData.get("tipoAnexo"))[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            MonitoracaoAnexo imagemDB = this.sigacoService.saveAnexoMonitoracao(empresa, idMonitoracao, tipoAtivo, tipoAnexo, fileInfo, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)imagemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("BizExc.saveAnexo", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idMonitoramento}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da Monitora\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoMonitoracao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoramento") Integer idMonitoramento, @PathVariable(name="seqAnexo") Integer seqAnexo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteAnexoMonitoracao({},{},{})", new Object[]{empresa, idMonitoramento, seqAnexo});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXCLUIR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_EXCLUIR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.sigacoService.deleteAnexoMonitoracao(empresa, idMonitoramento, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{tipoAtivo}/ciclos/{idElemento}"})
    public ResponseEntity<List<MonitoracaoSigaco>> findCiclosAnteriores(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, @PathVariable(name="idElemento") Integer idElemento, @RequestParam(name="fase") Integer faseMonitoracao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findCiclosAnteriores({}, {}, {})", new Object[]{empresa, tipoAtivo, idElemento});
            TipoAtivo tipoAtv = TipoAtivo.fromCode((String)tipoAtivo);
            if (tipoAtv == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ativo [%s] n\u00e3o encontrado.", tipoAtivo));
            }
            return ResponseEntity.ok().body((Object)this.sigacoService.findCiclosAnteriores(empresa, tipoAtv, idElemento, faseMonitoracao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCiclosAnteriores", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/historicos"})
    public ResponseEntity<List<MonitoracaoHistorico>> findHistoricos(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findHistoricos({}, {}, {})", (Object)empresa, (Object)idMonitoracao);
            return ResponseEntity.ok().body((Object)this.sigacoService.findHistoricos(empresa, idMonitoracao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findMonitoracoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{tipoAtivo}/exportacao"})
    @Operation(summary="Efetua o download das monitora\u00e7\u00f5es em formato de planilha")
    public ResponseEntity<byte[]> exportExcel(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Exportando excel, monitora\u00e7\u00f5es (emp={}, {})...", (Object)empresa, (Object)tipoAtivo);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        try {
            Integer statusImportacao;
            Integer seqImportacao;
            String varFim;
            String varIni;
            String variavel;
            String classeSinalizacao;
            List monitoracoes;
            byte[] bytes;
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXPORTAR_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_EXPORTAR_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            TipoAtivo tipoAtivoEnum = TipoAtivo.fromCode((String)tipoAtivo);
            if (tipoAtivoEnum == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ativo [%s]n\u00e3o encontrado.", tipoAtivo));
            }
            Integer idTipoElemento = null;
            Integer idRodovia = null;
            Double kmIni = null;
            Double kmFim = null;
            Integer faixa = null;
            String sentido = null;
            Integer idFase = null;
            String situacao = null;
            String param = null;
            String[] params = request.getParameterValues("faseMonitoracao");
            if (params != null && params.length > 0 && params[0] != null && !params[0].isEmpty()) {
                idFase = Integer.valueOf(params[0]);
            }
            if ((param = request.getParameter("rodovia")) != null) {
                idRodovia = Integer.valueOf(param);
            }
            if ((param = request.getParameter("faixa")) != null) {
                faixa = Integer.valueOf(param);
            }
            if ((bytes = new ExportMonitoracaoExcel().executeXLS(monitoracoes = this.sigacoService.findMonitoracoes(empresa, tipoAtivoEnum, idTipoElemento, idFase, idRodovia, kmIni, kmFim, faixa, sentido = request.getParameter("sentido"), situacao = request.getParameter("situacao"), classeSinalizacao = request.getParameter("classeSinalizacao"), variavel = null, varIni = null, varFim = null, seqImportacao = null, statusImportacao = null))) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"monitoracoes.xlsx\"");
            headers.add("Content-Type", "application/octet-stream");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    public static Double[] stringToKm(String cellValue) {
        if (cellValue == null || cellValue.isEmpty()) {
            return null;
        }
        try {
            if (cellValue.indexOf(" ") != -1) {
                cellValue = cellValue.replaceAll(" ", "+");
            }
            if (cellValue.indexOf(".") != -1) {
                String[] kmMetros = cellValue.split("\\.");
                if (kmMetros != null && kmMetros.length > 0) {
                    return new Double[]{Double.valueOf(kmMetros[0]), Double.valueOf(kmMetros[1])};
                }
                return null;
            }
            if (cellValue.indexOf(",") != -1) {
                Double kilometro = fmtPtBr.parse(cellValue).doubleValue();
                String[] kmMetros = kilometro.toString().split("\\.");
                if (kmMetros != null && kmMetros.length > 0) {
                    return new Double[]{Double.valueOf(kmMetros[0]), Double.valueOf(kmMetros[1])};
                }
                return null;
            }
            if (cellValue.indexOf("+") != -1) {
                String[] kmMetros = cellValue.split("\\+");
                if (kmMetros != null && kmMetros.length > 0) {
                    return new Double[]{Double.valueOf(kmMetros[0]), Double.valueOf(kmMetros[1]) / 1000.0};
                }
                return null;
            }
            return new Double[]{Double.valueOf(cellValue), 0.0};
        }
        catch (NumberFormatException nmfExc) {
            return null;
        }
        catch (ParseException psExc) {
            return null;
        }
    }

    @GetMapping(value={"/importacoes/{empresa}"})
    public ResponseEntity<List<ImportacaoMonitoracao>> findImportacoes(@PathVariable(name="empresa") String empresa, @RequestParam(name="idFase", required=false) Integer idFase, @RequestParam(name="subsistema", required=false) String subsistema, @RequestParam(name="status", required=false) Integer status, @RequestParam(name="responsavel", required=false) String responsavel, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_IMPORTACOES_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_IMPORTACOES_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findImportacoes({}, {}, {}, {})", new Object[]{empresa, idFase, subsistema, responsavel});
            List importacoes = this.sigacoService.findImportacoes(empresa, idFase, subsistema, status, responsavel);
            return ResponseEntity.ok().body((Object)importacoes);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/importacoes/{empresa}/{idFase}/{seqImportacao}"})
    public ResponseEntity<ImportacaoMonitoracao> getImportacaoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFase") Integer idFase, @PathVariable(name="seqImportacao") Integer seqImportacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_VISUALIZAR_IMPORTACAO_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_VISUALIZAR_IMPORTACAO_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getImportacaoById({}, {}, {})", new Object[]{empresa, idFase, seqImportacao});
            ImportacaoMonitoracao importacao = this.sigacoService.getImportacaoById(idFase, seqImportacao);
            return ResponseEntity.ok().body((Object)importacao);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getImportacaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/aprovar"})
    public ResponseEntity<Boolean> aprovarImportacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="fase") Integer fase, @PathVariable(name="importacao") Integer importacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - aprovarImportacoes({}, {})", new Object[]{usuario.getLogin(), empresa, importacao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_APROVAR_REPROVAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"GAC_APROVAR_REPROVAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.sigacoService.aprovarImportacoes(empresa, fase, importacao, usuario.getLogin()));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.aprovarImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/reprovarImportacao"})
    public ResponseEntity<Boolean> reprovarImportacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="fase") Integer fase, @PathVariable(name="importacao") Integer importacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - reprovarImportacoes({}, {}, {})", new Object[]{usuario.getLogin(), empresa, fase, importacao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_APROVAR_REPROVAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"GAC_APROVAR_REPROVAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.sigacoService.reprovarImportacoes(empresa, fase, importacao, usuario.getLogin()));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.reprovarImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/publicar"})
    public ResponseEntity<Boolean> publicarImportacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="fase") Integer fase, @PathVariable(name="importacao") Integer importacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("publicarImportacoes({}, {}, {})", new Object[]{empresa, fase, importacao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_APROVAR_REPROVAR_PUBLICACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"GAC_APROVAR_REPROVAR_PUBLICACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.sigacoService.aprovarPublicacoes(empresa, fase, importacao, usuario.getLogin()));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.publicarImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/reprovarPublicacao"})
    public ResponseEntity<Boolean> reprovarPublicacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="fase") Integer fase, @PathVariable(name="importacao") Integer importacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_APROVAR_REPROVAR_PUBLICACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"GAC_APROVAR_REPROVAR_PUBLICACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - reprovarPublicacoes({}, {}, {})", new Object[]{usuario.getLogin(), empresa, fase, importacao});
            return ResponseEntity.ok().body((Object)this.sigacoService.reprovarPublicacoes(empresa, fase, importacao, usuario.getLogin()));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.reprovarPublicacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/excluir"})
    public ResponseEntity<Boolean> deleteImportacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="fase") Integer fase, @PathVariable(name="importacao") Integer importacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("excluirImportacoes({}, {}, {})", new Object[]{empresa, fase, importacao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXCLUIR_IMPORTACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"GAC_EXCLUIR_IMPORTACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.sigacoService.deleteImportacoes(empresa, fase, importacao, usuario.getLogin()));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.excluirImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/dashboards/{tipoAtivo}"})
    public ResponseEntity<Map<String, List<DashboardSigacoVO>>> findDashboards(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usr = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Double[] kmMetros;
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_DASHBOARDS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_DASHBOARDS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - findDashboards({}, {})", new Object[]{usuario.getLogin(), empresa, tipoAtivo});
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            TipoAtivo tipoAtv = TipoAtivo.fromCode((String)tipoAtivo);
            Integer idFase = null;
            Integer idRodovia = null;
            Double kmInicial = null;
            Double kmFinal = null;
            Integer faixa = null;
            String sentido = null;
            Integer statusImportacao = null;
            String param = null;
            if (tipoAtv == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ativo [%s]n\u00e3o encontrado.", tipoAtivo));
            }
            String[] params = request.getParameterValues("faseMonitoracao");
            if (params != null && params.length > 0 && params[0] != null && !params[0].isEmpty()) {
                idFase = Integer.valueOf(params[0]);
            }
            if ((param = request.getParameter("rodovia")) != null) {
                idRodovia = Integer.valueOf(param);
            }
            if ((kmMetros = MonitoracoesSigacoRestServices.stringToKm((String)request.getParameter("kmInicial"))) != null && kmMetros.length > 0) {
                kmInicial = kmMetros[0] + kmMetros[1];
            }
            if ((kmMetros = MonitoracoesSigacoRestServices.stringToKm((String)request.getParameter("kmFinal"))) != null && kmMetros.length > 0) {
                kmFinal = kmMetros[0] + kmMetros[1];
            }
            if ((param = request.getParameter("faixa")) != null) {
                faixa = Integer.valueOf(param);
            }
            sentido = request.getParameter("sentido");
            String subTipo = request.getParameter("subTipo");
            HashMap dashboards = this.sigacoService.findDashboards(empresa, tipoAtv, subTipo, idFase, idRodovia, kmInicial, kmFinal, faixa, sentido, statusImportacao, usuario.getLogin());
            return ResponseEntity.ok().body((Object)dashboards);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findDashboards", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/dashboards/{tipoAtivo}/itens"})
    public ResponseEntity<List<DashboardSigacoVO>> findDashboardsItems(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usr = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            String param;
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_DASHBOARDS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_DASHBOARDS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - findDashboardsItems({}, {})", new Object[]{usuario.getLogin(), empresa, tipoAtivo});
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            TipoAtivo tipoAtv = TipoAtivo.fromCode((String)tipoAtivo);
            if (tipoAtv == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ativo [%s] n\u00e3o encontrado.", tipoAtivo));
            }
            Integer idRodovia = null;
            Integer idFase = null;
            String subTipo = null;
            Integer faixa = null;
            String sentido = null;
            String[] params = request.getParameterValues("faseMonitoracao");
            if (params != null && params.length > 0 && params[0] != null && !params[0].isEmpty()) {
                idFase = Integer.valueOf(params[0]);
            }
            if ((param = request.getParameter("rodovia")) != null) {
                idRodovia = Integer.valueOf(param);
            }
            Double kilometro = null;
            param = request.getParameter("kilometro");
            if (param != null) {
                kilometro = Double.valueOf(param);
            }
            Integer ano = null;
            param = request.getParameter("ano");
            if (param != null) {
                ano = Integer.valueOf(param);
            }
            String tipoGrafico = "kms";
            param = request.getParameter("tipoGrafico");
            if (param != null) {
                tipoGrafico = param;
            }
            subTipo = request.getParameter("subTipo");
            param = request.getParameter("faixa");
            if (param != null) {
                faixa = Integer.valueOf(param);
            }
            sentido = request.getParameter("sentido");
            String situacao = null;
            String serieName = request.getParameter("serieName");
            String itemName = request.getParameter("itemName");
            if (tipoGrafico.equals("geral")) {
                String aux = itemName;
                itemName = serieName;
                serieName = aux;
            }
            if (tipoGrafico.equals("kms")) {
                try {
                    kilometro = Double.valueOf(itemName.trim());
                }
                catch (NumberFormatException nmfExc) {
                    kilometro = null;
                }
            }
            if (tipoAtv.equals((Object)TipoAtivo.OBRA_ARTE_CORRENTE)) {
                if (serieName.equalsIgnoreCase("Bom")) {
                    situacao = "B";
                } else if (serieName.equalsIgnoreCase("Regular")) {
                    situacao = "R";
                } else if (serieName.equalsIgnoreCase("Prec\u00e1rio")) {
                    situacao = "P";
                }
            } else if (tipoAtv.equals((Object)TipoAtivo.SINALIZACAO)) {
                if (subTipo == null) {
                    subTipo = "";
                }
                if (subTipo.equals("H")) {
                    if (serieName.equalsIgnoreCase("Aprovado")) {
                        situacao = "A";
                    } else if (serieName.equalsIgnoreCase("Reprovado")) {
                        situacao = "R";
                    }
                } else if (subTipo.equals("V")) {
                    if (serieName.equalsIgnoreCase("???")) {
                        situacao = "A";
                    } else if (serieName.equalsIgnoreCase("XYZ")) {
                        situacao = "R";
                    }
                } else if (subTipo.equals("E")) {
                    if (serieName.equalsIgnoreCase("Bom")) {
                        situacao = "B";
                    } else if (serieName.equalsIgnoreCase("Regular")) {
                        situacao = "R";
                    } else if (serieName.equalsIgnoreCase("Prec\u00e1rio")) {
                        situacao = "P";
                    }
                }
            } else if (tipoAtv.equals((Object)TipoAtivo.FAIXA_DOMINIO)) {
                if (serieName.equalsIgnoreCase("Regular")) {
                    situacao = "R";
                } else if (serieName.equalsIgnoreCase("Irregular")) {
                    situacao = "I";
                }
            } else if (tipoAtv.equals((Object)TipoAtivo.TERRAPLENOS)) {
                if (serieName.equalsIgnoreCase("N\u00edvel 0")) {
                    situacao = "0";
                } else if (serieName.equalsIgnoreCase("N\u00edvel 1")) {
                    situacao = "1";
                } else if (serieName.equalsIgnoreCase("N\u00edvel 2")) {
                    situacao = "2";
                } else if (serieName.equalsIgnoreCase("N\u00edvel 3")) {
                    situacao = "3";
                }
            } else if (tipoAtv.equals((Object)TipoAtivo.EDIFICACOES)) {
                if (serieName.equalsIgnoreCase("Bom")) {
                    situacao = "B";
                } else if (serieName.equalsIgnoreCase("Regular")) {
                    situacao = "R";
                } else if (serieName.equalsIgnoreCase("Ruim")) {
                    situacao = "U";
                }
            }
            List itensDash = this.sigacoService.findDashboardItens(empresa, tipoAtv, subTipo, idFase, idRodovia, kilometro, faixa, sentido, ano, situacao, usuario.getLogin());
            return ResponseEntity.ok().body((Object)itensDash);
        }
        catch (BusinessException bizExc) {
            logger.error("findDashboardsItems", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/dashboards/{tipoAtivo}/ciclos/{idItem}"})
    public ResponseEntity<List<DashboardSigacoVO>> findDashboardsCiclos(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, @PathVariable(name="idItem") Integer idItem, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usr = this.segurancaService.getUsuarioByLoginOrMail(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_DASHBOARDS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_DASHBOARDS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - findDashboardsCiclos({}, {}, {})", new Object[]{usuario.getLogin(), empresa, tipoAtivo, idItem});
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            TipoAtivo tipoAtv = TipoAtivo.fromCode((String)tipoAtivo);
            if (tipoAtv == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ativo [%s] n\u00e3o encontrado.", tipoAtivo));
            }
            String subTipo = request.getParameter("subTipo");
            List itensDash = this.sigacoService.findDashboardCiclos(empresa, tipoAtv, subTipo, idItem);
            return ResponseEntity.ok().body((Object)itensDash);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findDashboardsCiclos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

