/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.sigaco;

import br.com.oti.gesconsys.beans.ativos.TipoAtivo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.sigaco.cad.ElementoDrenagem;
import br.com.oti.gesconsys.beans.sigaco.cad.ElementoSigaco;
import br.com.oti.gesconsys.beans.sigaco.cad.ElementoSinalizacao;
import br.com.oti.gesconsys.beans.sigaco.cad.FaseMonitoracao;
import br.com.oti.gesconsys.beans.sigaco.cad.FaseMonitoracaoAnexo;
import br.com.oti.gesconsys.beans.sigaco.cad.TipoElemento;
import br.com.oti.gesconsys.beans.sigaco.cad.TipoStatusElemento;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.business.services.SigacoService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import com.itextpdf.io.source.ByteArrayOutputStream;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@Tag(description="REST Services para Cadastros do Sigaco", name="sigaco")
@RequestMapping(value={"/api/cadastros/sigaco"})
public class CadastrosSigacoRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CadastrosSigacoRestServices.class);
    private static Locale ptBR = new Locale.Builder().setLanguage("pt").setRegion("BR").build();
    private static final NumberFormat fmtPtBr = DecimalFormat.getNumberInstance(ptBR);
    @Autowired
    private SigacoService sigacoService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private GedService gedService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/tiposElementos"})
    @Operation(summary="Busca os tipos de elementos.")
    public ResponseEntity<List<TipoElemento>> findTiposElementos(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_TIPOS_ELEMENTOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_TIPOS_ELEMENTOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findTiposElementos()");
            String search = null;
            TipoAtivo subsistema = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (request.getParameter("subsistema") != null) {
                subsistema = TipoAtivo.fromCode((String)request.getParameter("subsistema"));
            }
            List tipos = this.sigacoService.findTiposElementos(search, subsistema);
            return ResponseEntity.ok().body((Object)tipos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposElementos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tiposElementos/{idCategoria}"})
    @Operation(summary="Busca a categoria conforme seu identificador.")
    public ResponseEntity<TipoElemento> getCategoriaById(@PathVariable(name="idCategoria") Integer idCategoria, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_VISUALIZAR_CATEGORIA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_VISUALIZAR_CATEGORIA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getCategoriaById({})", (Object)idCategoria);
            return ResponseEntity.ok().body((Object)this.sigacoService.getTipoElementoById(idCategoria));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCategoriaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/tiposElementos"})
    @Operation(summary="Salva a categoria de ativo.")
    public ResponseEntity<TipoElemento> saveCategoria(@RequestBody TipoElemento categoria, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_CATEGORIA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_CATEGORIA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PublicUser userDB = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            TipoElemento categoriaDB = this.sigacoService.saveTipoElemento(categoria, userDB.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)categoriaDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCategoria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/tiposElementos/{idCategoria}"})
    @Operation(summary="Deleta a categoria de ativo de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteCategoria(@PathVariable(name="idCategoria") Integer idCategoria, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXCLUIR_CATEGORIA");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_EXCLUIR_CATEGORIA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("deleteCategoria({})", (Object)idCategoria);
            return new ResponseEntity((Object)this.sigacoService.deleteTipoElemento(idCategoria), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCategoria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/elementos/{tipoAtivo}/all"})
    @Operation(summary="Busca os itens de ativo.")
    public ResponseEntity<List<ElementoSigaco>> findElementos(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Integer idTipoElemento = null;
        Integer idRodovia = null;
        Double kmInicial = null;
        Double kmFinal = null;
        try {
            Double[] kmMetros;
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_ELEMENTOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_ELEMENTOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findItens({}, {})", (Object)empresa, (Object)tipoAtivo);
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (request.getParameter("tipoElemento") != null) {
                idTipoElemento = Integer.valueOf(request.getParameter("tipoElemento"));
            }
            if (request.getParameter("rodovia") != null) {
                idRodovia = Integer.valueOf(request.getParameter("rodovia"));
            }
            if ((kmMetros = CadastrosSigacoRestServices.stringToKm((String)request.getParameter("kmInicial"))) != null && kmMetros.length > 0) {
                kmInicial = kmMetros[0] + kmMetros[1];
            }
            if ((kmMetros = CadastrosSigacoRestServices.stringToKm((String)request.getParameter("kmFinal"))) != null && kmMetros.length > 0) {
                kmFinal = kmMetros[0] + kmMetros[1];
            }
            TipoStatusElemento status = TipoStatusElemento.ATIVO;
            if (request.getParameter("status") != null) {
                status = TipoStatusElemento.fromCode((String)request.getParameter("status"));
            }
            TipoAtivo tipoAtivoBase = TipoAtivo.fromCode((String)tipoAtivo);
            List itens = this.sigacoService.findElementos(empresa, search, tipoAtivoBase, idTipoElemento, idRodovia, kmInicial, kmFinal, status);
            return ResponseEntity.ok().body((Object)itens);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findItens", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/elementos/{tipoAtivo}/{idElemento}"})
    @Operation(summary="Busca o elemento por seu identificador e empresa.")
    public ResponseEntity<ElementoSigaco> getElementoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, @PathVariable(name="idElemento") Integer idElemento, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_VISUALIZAR_ELEMENTO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_VISUALIZAR_ELEMENTO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getElementoById({})", (Object)idElemento);
            return ResponseEntity.ok().body((Object)this.sigacoService.getElementoById(empresa, idElemento, tipoAtivo));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getElementoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/elementosDrenagem"})
    @Operation(summary="Salva o Elemento de ativo drenagem.")
    public ResponseEntity<ElementoSigaco> saveElemento(@PathVariable(name="empresa") String empresa, @RequestBody ElementoDrenagem elemento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_ELEMENTO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_ELEMENTO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ElementoSigaco elementoDB = this.sigacoService.saveElemento(empresa, (ElementoSigaco)elemento, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)elementoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveElemento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/elementosSinalizacao"})
    @Operation(summary="Salva o Elemento de sinaliza\u00e7\u00e3o [Vert./Horiz./EPS]")
    public ResponseEntity<ElementoSigaco> saveElemento(@PathVariable(name="empresa") String empresa, @RequestBody ElementoSinalizacao elemento, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_ELEMENTO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_ELEMENTO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ElementoSigaco elementoDB = this.sigacoService.saveElemento(empresa, (ElementoSigaco)elemento, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)elementoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveElemento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/elementos/{tipoAtivo}/{idElemento}"})
    @Operation(summary="Deleta o elemento de ativo de acordo com seu identificador e empresa.")
    public ResponseEntity<Boolean> deleteElemento(@PathVariable(name="empresa") String empresa, @PathVariable(name="idElemento") Integer idElemento, @PathVariable(name="tipoAtivo") String tipoAtivo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXCLUIR_ELEMENTO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_EXCLUIR_ELEMENTO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("deleteElemento({})", (Object)idElemento);
            return new ResponseEntity((Object)this.sigacoService.deleteElemento(empresa, idElemento, tipoAtivo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteElemento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fasesMonitoracao"})
    @Operation(summary="Busca as fases de monitora\u00e7\u00e3o de ativos.")
    public ResponseEntity<List<FaseMonitoracao>> findFases(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CONSULTAR_FASES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CONSULTAR_FASES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findFases()");
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            List fases = this.sigacoService.findFasesMonitoracoes(empresa, search);
            return ResponseEntity.ok().body((Object)fases);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFases", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fasesMonitoracao/{idFase}"})
    @Operation(summary="Busca a fase de monitora\u00e7\u00e3o conforme seu identificador.")
    public ResponseEntity<FaseMonitoracao> getFaseById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFase") Integer idFase, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_VISUALIZAR_FASE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_VISUALIZAR_FASE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getFaseById({}, {})", (Object)empresa, (Object)idFase);
            FaseMonitoracao fase = this.sigacoService.getFaseMonitoracaoById(idFase);
            if (fase != null) {
                fase.setResponsaveis(this.sigacoService.findResponsaveisFase(idFase));
            }
            return ResponseEntity.ok().body((Object)fase);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFaseById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/fasesMonitoracao"})
    @Operation(summary="Salva a fase de monitora\u00e7\u00e3o.")
    public ResponseEntity<FaseMonitoracao> saveFase(@PathVariable(name="empresa") String empresa, @RequestBody FaseMonitoracao fase, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_FASE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_FASE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            fase.setIdEmpresa(emp.getId());
            FaseMonitoracao faseDB = this.sigacoService.saveFaseMonitoracao(fase, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)faseDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFase", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/fasesMonitoracao/{idFase}"})
    @Operation(summary="Deleta a fase de monitora\u00e7\u00e3o de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteFase(@PathVariable(name="idFase") Integer idFase, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXCLUIR_FASE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_EXCLUIR_FASE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("deleteFase({})", (Object)idFase);
            return new ResponseEntity((Object)this.sigacoService.deleteFaseMonitoracao(idFase), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFase", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fasesMonitoracao/{idFase}/anexos"})
    public ResponseEntity<List<FaseMonitoracaoAnexo>> findAnexosFase(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFase") Integer idFase, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_VISUALIZAR_FASE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_VISUALIZAR_FASE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findAnexosFase({})", (Object)empresa);
            return ResponseEntity.ok().body((Object)this.sigacoService.findAnexosFase(empresa, idFase));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosFase", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fasesMonitoracao/{idFase}/anexos/{idAnexo}"})
    public ResponseEntity<FaseMonitoracaoAnexo> getAnexoFaseById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFase") Integer idFase, @PathVariable(name="idAnexoFase") Integer idAnexoFase, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_VISUALIZAR_FASE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_VISUALIZAR_FASE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getAnexoFaseById({}, {}, {})", new Object[]{empresa, idFase, idAnexoFase});
            return ResponseEntity.ok().body((Object)this.sigacoService.getAnexoFaseById(empresa, idAnexoFase));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAnexoFaseById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/fasesMonitoracao/{idFase}/anexos"})
    @ResponseBody
    public ResponseEntity<FaseMonitoracaoAnexo> saveAnexoFase(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idFase") Integer idFase, @RequestParam(name="file", required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Executando saveAnexoFase(emp={},idFase={})...", (Object)empresa, (Object)idFase);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_CADASTRAR_FASE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_CADASTRAR_FASE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            if (formData.containsKey("tipoAtivo")) {
                tipoAtivo = ((String[])formData.get("tipoAtivo"))[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            FaseMonitoracaoAnexo imagemDB = this.sigacoService.saveAnexoFase(empresa, idFase, tipoAtivo, fileInfo, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)imagemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAnexoFase", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("BizExc.saveAnexoFase", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/fasesMonitoracao/{idFase}/anexos/{idAnexoFase}"})
    @Operation(summary="Exclui o anexo da Monitora\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoFase(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFase") Integer idFase, @PathVariable(name="idAnexoFase") Integer idAnexoFase, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteAnexoFase({},{},{})", new Object[]{empresa, idFase, idAnexoFase});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXCLUIR_ANEXO_FASE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_EXCLUIR_ANEXO_FASE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.sigacoService.deleteAnexoFase(empresa, idAnexoFase), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoFase", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fasesMonitoracao/relatorios/{tipoAtivo}"})
    @Operation(summary="Efetua o download do relat\u00f3rio da fase em formato de arquivo")
    public ResponseEntity<List<UploadedFileInfo>> downloadRelatorioFases(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Exportando excel, monitora\u00e7\u00f5es (emp={}, {})...", (Object)empresa, (Object)tipoAtivo);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXPORTAR_RELATORIO_FASE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_EXPORTAR_RELATORIO_FASE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("downloadRelatorioFase({},{},{})", new Object[]{empresa, empresa, tipoAtivo});
            TipoAtivo tipoAtivoEnum = TipoAtivo.fromCode((String)tipoAtivo);
            if (tipoAtivoEnum == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ativo [%s] n\u00e3o foi encontrado.", tipoAtivo));
            }
            ArrayList<Integer> idFases = new ArrayList<Integer>();
            String[] params = request.getParameterValues("fasesMonitoracao");
            if (params != null && params.length > 0 && params[0] != null && !params[0].isEmpty()) {
                idFases.add(Integer.valueOf(params[0]));
            }
            ArrayList<FaseMonitoracaoAnexo> anexos = new ArrayList<FaseMonitoracaoAnexo>();
            ArrayList<UploadedFileInfo> files = new ArrayList<UploadedFileInfo>();
            for (Integer idFase : idFases) {
                anexos.add(this.sigacoService.getAnexoByTipo(empresa, idFase, tipoAtivo));
            }
            byte[] buffer = new byte[4096];
            for (FaseMonitoracaoAnexo anx : anexos) {
                if (anx == null || anx.getIdEmpresa() == null || anx.getAnexo() == null) continue;
                UploadedFileInfo fileInfo = this.gedService.getFileInfoByUuid(anx.getIdEmpresa(), anx.getAnexo().getUuid(), Boolean.valueOf(true));
                files.add(fileInfo);
                try {
                    InputStream fis = fileInfo.getInputStream();
                    try {
                        ByteArrayOutputStream ous = new ByteArrayOutputStream();
                        int read = 0;
                        while ((read = fis.read(buffer)) != -1) {
                            ous.write(buffer, 0, read);
                        }
                        fileInfo.setFileBytes(ous.toByteArray());
                        ous.close();
                        fileInfo.setInputStream(null);
                    }
                    finally {
                        if (fis == null) continue;
                        fis.close();
                    }
                }
                catch (IOException ioExc) {
                    logger.error("IOExc", (Throwable)ioExc);
                }
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body(files);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.downloadRelatorioFases", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    public static Double[] stringToKm(String cellValue) {
        if (cellValue == null || cellValue.isEmpty()) {
            return null;
        }
        try {
            if (cellValue.indexOf(" ") != -1) {
                cellValue = cellValue.replaceAll(" ", "+");
            }
            if (cellValue.indexOf(".") != -1) {
                String[] kmMetros = cellValue.split("\\.");
                if (kmMetros != null && kmMetros.length > 0) {
                    return new Double[]{Double.valueOf(kmMetros[0]), Double.valueOf(kmMetros[1])};
                }
                return null;
            }
            if (cellValue.indexOf(",") != -1) {
                Double kilometro = fmtPtBr.parse(cellValue).doubleValue();
                String[] kmMetros = kilometro.toString().split("\\.");
                if (kmMetros != null && kmMetros.length > 0) {
                    return new Double[]{Double.valueOf(kmMetros[0]), Double.valueOf(kmMetros[1])};
                }
                return null;
            }
            if (cellValue.indexOf("+") != -1) {
                String[] kmMetros = cellValue.split("\\+");
                if (kmMetros != null && kmMetros.length > 0) {
                    return new Double[]{Double.valueOf(kmMetros[0]), Double.valueOf(kmMetros[1]) / 1000.0};
                }
                return null;
            }
            return new Double[]{Double.valueOf(cellValue), 0.0};
        }
        catch (NumberFormatException nmfExc) {
            return null;
        }
        catch (ParseException psExc) {
            return null;
        }
    }
}

