/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.shared;

import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.EquipeEmail;
import br.com.oti.gesconsys.beans.geral.EquipeResponsavel;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.UsuarioGrupo;
import br.com.oti.gesconsys.beans.shared.Equipe;
import br.com.oti.gesconsys.beans.shared.Fornecedor;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para equipes", name="equipes")
@RequestMapping(value={"/api/equipes"})
public class EquipesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(EquipesRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Retorna uma listagem com as equipes, conforme filtro. Se informado o campo tipo, somente aquele tipos de equipe ser\u00e3o retornados")
    @ResponseBody
    public ResponseEntity<List<Equipe>> findEquipes(@PathVariable(name="empresa") String empresa, @RequestParam(name="tipo", required=false) String tipoEquipe, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB;
            logger.debug("{} - findEquipes...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue() && !(permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES_LISTAGEM")).booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String searchTxt = null;
            String status = null;
            String statusCode = "A";
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            if (request.getParameter("status") != null) {
                status = request.getParameter("status");
            }
            if (status != null && !status.isEmpty()) {
                statusCode = status.substring(0, 1);
            }
            if ((empresaDB = this.cadastroService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            List equipes = this.cadastroService.findEquipes(empresaDB.getId(), searchTxt, tipoEquipe, lastUpdate, Boolean.valueOf(!statusCode.equals("A")));
            return new ResponseEntity((Object)equipes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEquipes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idEquipe}"})
    @Operation(summary="Retorna os dados da equipe solicitada")
    @ResponseBody
    public ResponseEntity<Equipe> getEquipeById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEquipe") Integer idEquipe, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)this.cadastroService.getEquipeById(idEquipe), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEquipeById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Atualiza os dados da equipe")
    @ResponseBody
    public ResponseEntity<Equipe> saveEquipe(@RequestBody Equipe equipe, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveEquipe ({}))", (Object)usuario.getLogin(), (Object)equipe);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.saveEquipe(equipe, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveEquipe", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idEquipe}"})
    @Operation(summary="Exclui a equipe, retornando erro se houver liga\u00e7\u00e3o com outras entidades do sistema")
    public ResponseEntity<Boolean> deleteEquipe(@PathVariable(name="idEquipe") Integer idEquipe, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteEquipe({})", (Object)usuario.getLogin(), (Object)idEquipe);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteEquipe(idEquipe), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteEquipe", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idEquipe}/responsaveis"})
    @Operation(summary="Retorna os respons\u00e1veis/usu\u00e1rios da equipe solicitada")
    @ResponseBody
    public ResponseEntity<List<EquipeResponsavel>> findResponsaveisEquipe(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEquipe") Integer idEquipe, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)this.cadastroService.findEquipeResponsaveis(idEquipe), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findResponsaveisEquipe", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idEquipe}/responsaveis"})
    @Operation(summary="Atualiza os respons\u00e1veis da equipe")
    public ResponseEntity<List<EquipeResponsavel>> saveEquipeResponsaveis(@PathVariable String empresa, @RequestBody List<EquipeResponsavel> responsaveis, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            logger.debug("saveEquipeResponsavel ({}))", responsaveis != null ? Integer.valueOf(responsaveis.size()) : null);
            return new ResponseEntity((Object)this.cadastroService.saveEquipeResponsaveis(responsaveis, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveEquipeResponsavel", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idEquipe}/responsaveis/{seqResponsavel}"})
    @Operation(summary="Exclui o respons\u00e1vel da equipe, retornando erro se houver liga\u00e7\u00e3o com outras entidades do sistema")
    public ResponseEntity<Boolean> deleteResponsavel(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEquipe") Integer idEquipe, @PathVariable(name="seqResponsavel") Integer seqResponsavel, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteResponsavel({})", (Object)usuario.getLogin(), (Object)idEquipe);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteEquipeResponsavel(idEquipe, seqResponsavel), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteResponsavel", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idEquipe}/emails"})
    @Operation(summary="Retorna os emails da equipe solicitada")
    @ResponseBody
    public ResponseEntity<List<EquipeEmail>> findEmailsEquipe(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEquipe") Integer idEquipe, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)this.cadastroService.findEquipeEmails(idEquipe), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEmailsEquipe", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idEquipe}/emails"})
    @Operation(summary="Atualiza o email da equipe")
    @ResponseBody
    public ResponseEntity<EquipeEmail> saveEquipeEmails(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEquipe") Integer idEquipe, @RequestBody EquipeEmail email, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveEquipeEmail ({})", (Object)usuario.getLogin(), (Object)email);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)this.cadastroService.saveEquipeEmails(email, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveEquipeEmail", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idEquipe}/emails/{sequencia}"})
    @Operation(summary="Exclui o email da equipe, retornando erro se houver liga\u00e7\u00e3o com outras entidades do sistema")
    public ResponseEntity<Boolean> deleteEmail(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEquipe") Integer idEquipe, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteResponsavel({})", (Object)usuario.getLogin(), (Object)idEquipe);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            return new ResponseEntity((Object)this.cadastroService.deleteEquipeEmail(idEquipe, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteEmail", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fornecedores"})
    @Operation(summary="Retorna uma listagem com os fornecedores das equipes")
    @ResponseBody
    public ResponseEntity<List<Fornecedor>> findFornecedoresEquipes(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa empresaDB;
            logger.debug("{} - findFornecedoresEquipes...", (Object)usuario.getLogin());
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue() && !(permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES_LISTAGEM")).booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            if ((empresaDB = this.cadastroService.getEmpresaBySigla(empresa)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            List fornecedores = this.cadastroService.findFornecedoresByEquipes(empresaDB.getId(), searchTxt, null, lastUpdate, Boolean.valueOf(false));
            return new ResponseEntity((Object)fornecedores, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEquipes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fornecedores/{idFornecedor}/contratos"})
    @Operation(summary="Retorna uma listagem com os contratos do fornecedor da equipe")
    @ResponseBody
    public ResponseEntity<List<String>> findContratosByFornecedor(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFornecedor") Integer idFornecedor, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - findContratosByFornecedor({},{})...", new Object[]{usuario.getLogin(), empresa, idFornecedor});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES");
            if (!permissao.booleanValue() && !(permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EQUIPES_LISTAGEM")).booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EQUIPES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
            if (empresaDB == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            List gruposUsuario = this.segurancaService.findGrupoUsuariosByUsuario(user.getId());
            Integer perfilTerceiro = (Integer)this.coreService.getRefValueByName(empresaDB.getId(), TipoRefCode.LABORATORIO_PERFIL_TERCEIRO);
            Boolean flagTerceiro = false;
            if (perfilTerceiro != null) {
                for (UsuarioGrupo gpu : gruposUsuario) {
                    if (!gpu.getId().getIdGrupoUsuario().equals(perfilTerceiro)) continue;
                    flagTerceiro = true;
                    break;
                }
            }
            List responsaveis = this.cadastroService.findResponsaveisEquipeByUsuario(user.getId());
            ArrayList<String> contratos = new ArrayList<String>();
            List equipes = this.cadastroService.findEquipesByFornecedor(empresaDB.getId(), idFornecedor, Boolean.valueOf(false));
            for (Equipe eqp : equipes) {
                if (eqp.getContrato() == null || contratos.contains(eqp.getContrato())) continue;
                if (flagTerceiro != null && flagTerceiro.booleanValue()) {
                    boolean found = false;
                    for (EquipeResponsavel resp : responsaveis) {
                        if (!resp.getId().getIdEquipe().equals(eqp.getId())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        logger.debug("Terceiros: Equipe '{}', contrato '{}' ignorado...", (Object)eqp.getDescricao(), (Object)eqp.getContrato());
                        continue;
                    }
                }
                contratos.add(eqp.getContrato());
            }
            return new ResponseEntity(contratos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEquipes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

