/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.lab;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.helper.BaseImportHelper;
import br.com.oti.gesconsys.business.helper.DashboardEnsaiosHelper;
import br.com.oti.gesconsys.business.helper.lab.DownloadFichaHelper;
import br.com.oti.gesconsys.business.helper.lab.UploadFichaHelper;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.LaboratorioService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.lab.beans.DashboardEnsaioVO;
import br.com.oti.gesconsys.lab.beans.Ensaio;
import br.com.oti.gesconsys.lab.beans.EnsaioAnaliseGranulometrica;
import br.com.oti.gesconsys.lab.beans.EnsaioCaracterizacaoSolo;
import br.com.oti.gesconsys.lab.beans.EnsaioCompactacao;
import br.com.oti.gesconsys.lab.beans.EnsaioCompactacaoEspessura;
import br.com.oti.gesconsys.lab.beans.EnsaioCompactacaoEspessuraItem;
import br.com.oti.gesconsys.lab.beans.EnsaioCompressaoAxial;
import br.com.oti.gesconsys.lab.beans.EnsaioControleCompactacaoFrasco;
import br.com.oti.gesconsys.lab.beans.EnsaioControleCompactacaoFrascoItem;
import br.com.oti.gesconsys.lab.beans.EnsaioDanoUmidadeInduzida;
import br.com.oti.gesconsys.lab.beans.EnsaioDemarcacaoViaria;
import br.com.oti.gesconsys.lab.beans.EnsaioDensidadeMaxima;
import br.com.oti.gesconsys.lab.beans.EnsaioDensidadeRealAbsorcao;
import br.com.oti.gesconsys.lab.beans.EnsaioEquivalenteAreia;
import br.com.oti.gesconsys.lab.beans.EnsaioExecucaoMistura;
import br.com.oti.gesconsys.lab.beans.EnsaioGrauCompactacao;
import br.com.oti.gesconsys.lab.beans.EnsaioGrauCompactacaoItem;
import br.com.oti.gesconsys.lab.beans.EnsaioHistorico;
import br.com.oti.gesconsys.lab.beans.EnsaioIndiceCrivo;
import br.com.oti.gesconsys.lab.beans.EnsaioIndicePaquimetro;
import br.com.oti.gesconsys.lab.beans.EnsaioLamelaridade;
import br.com.oti.gesconsys.lab.beans.EnsaioLigante;
import br.com.oti.gesconsys.lab.beans.EnsaioLiganteBetuminoso;
import br.com.oti.gesconsys.lab.beans.EnsaioManchaAreia;
import br.com.oti.gesconsys.lab.beans.EnsaioManchaAreiaItem;
import br.com.oti.gesconsys.lab.beans.EnsaioMedicaoMerlin;
import br.com.oti.gesconsys.lab.beans.EnsaioMedicaoMerlinItem;
import br.com.oti.gesconsys.lab.beans.EnsaioMicroesferaVidro;
import br.com.oti.gesconsys.lab.beans.EnsaioMicrotexturaResistenciaDerrapagem;
import br.com.oti.gesconsys.lab.beans.EnsaioMicrotexturaResistenciaDerrapagemItem;
import br.com.oti.gesconsys.lab.beans.EnsaioNumero;
import br.com.oti.gesconsys.lab.beans.EnsaioResistenciaTracao;
import br.com.oti.gesconsys.lab.beans.EnsaioSondagemCilindro;
import br.com.oti.gesconsys.lab.beans.EnsaioTaxaAplicacao;
import br.com.oti.gesconsys.lab.beans.EnsaioTaxaAplicacaoItem;
import br.com.oti.gesconsys.lab.beans.EnsaioTemperaturaInsumo;
import br.com.oti.gesconsys.lab.beans.EnsaioTemperaturaInsumoItem;
import br.com.oti.gesconsys.lab.beans.EnsaioTeorGranulometria;
import br.com.oti.gesconsys.lab.beans.EnsaioTeorMicro;
import br.com.oti.gesconsys.lab.beans.EnsaioTracaoFlexao;
import br.com.oti.gesconsys.lab.beans.EnsaioUmidadeNatural;
import br.com.oti.gesconsys.lab.beans.EnsaioVigaBenkelman;
import br.com.oti.gesconsys.lab.beans.EnsaioVigaBenkelmanItem;
import br.com.oti.gesconsys.lab.beans.ProjetoEnsaio;
import br.com.oti.gesconsys.reports.lab.ExportEnsaiosExcel;
import br.com.oti.gesconsys.reports.lab.RelatorioDashboardEnsaiosPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para ensaios", name="laboratorio")
@RequestMapping(value={"/api/ensaios"})
public class EnsaiosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(EnsaiosRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private GedService gedService;
    @Autowired
    private LaboratorioService laboratorioService;
    @Autowired
    private DownloadFichaHelper downloadHelper;
    @Autowired
    private UploadFichaHelper uploadHelper;
    @Autowired
    private DashboardEnsaiosHelper dashboardEnsaiosHelper;
    @Autowired
    private RelatorioDashboardEnsaiosPdf relatorioDashboardEnsaiosPdf;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(path={"/{empresa}/ligantes"})
    @Operation(summary="Lista os ensaios de ligantes")
    public ResponseEntity<List<Ensaio>> findEnsaiosLigante(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "CONSULTAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"CONSULTAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            boolean poderConcedente = usuario.getPoderConcedente() != null && usuario.getPoderConcedente() == true;
            logger.debug("findEnsaiosLigante ({}, {}))", (Object)usuario.getLogin(), (Object)empresa);
            Map params = request.getParameterMap();
            String tipoEnsaio = request.getParameter("tipoEnsaio");
            String tipoLigante = request.getParameter("tipoLigante");
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            try {
                if (params.containsKey("dataInicial")) {
                    dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
                }
                if (params.containsKey("dataFinal")) {
                    dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
                }
            }
            catch (DateTimeParseException dtpExc) {
                logger.error("DateTimeParseExc.findEnsaiosLigante", (Throwable)dtpExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, dtpExc.getMessage());
            }
            String search = request.getParameter("search");
            String item = request.getParameter("item");
            String equipe = request.getParameter("equipe");
            String tecnico = request.getParameter("tecnico");
            String trecho = request.getParameter("trecho");
            String obra = request.getParameter("obra");
            String userTerceiro = request.getParameter("usuarioTerceiro");
            Integer fornecedor = null;
            if (params.containsKey("fornecedor")) {
                fornecedor = Integer.valueOf(((String[])params.get("fornecedor"))[0]);
            }
            String tipoLcto = request.getParameter("tipoLancamento");
            Integer responsavel = null;
            if (params.containsKey("idResponsavel")) {
                responsavel = Integer.valueOf(((String[])params.get("idResponsavel"))[0]);
            }
            Integer status = null;
            if (params.containsKey("status")) {
                status = Integer.valueOf(((String[])params.get("status"))[0]);
            }
            Integer projeto = null;
            if (params.containsKey("projeto")) {
                projeto = Integer.valueOf(((String[])params.get("projeto"))[0]);
            }
            String parametro = request.getParameter("parametro");
            String minimo = request.getParameter("minimo");
            String maximo = request.getParameter("maximo");
            if (dataInicial == null && dataFinal == null) {
                dataFinal = LocalDate.now();
                dataInicial = dataFinal.minusMonths(3L);
            }
            ArrayList<String> empresas = new ArrayList<String>();
            String siglas = request.getParameter("empresas");
            if (siglas != null && !siglas.isEmpty()) {
                String[] rawSiglas;
                for (String sigla : rawSiglas = siglas.split(",")) {
                    empresas.add(sigla);
                }
            } else {
                empresas.add(empresa);
            }
            String[] rodoviasDesc = request.getParameterValues("rodovias");
            ArrayList<Integer> rodovias = new ArrayList<Integer>();
            if (rodoviasDesc != null) {
                for (String rodovia : rodoviasDesc) {
                    rodovias.add(Integer.valueOf(rodovia));
                }
            }
            String sortBy = request.getParameter("sortBy");
            String sortDesc = request.getParameter("sortDesc");
            if (sortDesc != null) {
                if (sortDesc.equals("false")) {
                    sortDesc = null;
                } else if (sortDesc.equals("true")) {
                    sortDesc = " DESC ";
                }
            }
            ArrayList<String> grupo = new ArrayList<String>();
            grupo.add("LIG");
            List ensaios = this.laboratorioService.findEnsaios(empresas, dataInicial, dataFinal, grupo, tipoEnsaio, tipoLigante, search, tecnico, rodovias, trecho, obra, item, equipe, status, projeto, parametro, minimo, maximo, null, sortBy, sortDesc, userTerceiro, fornecedor, tipoLcto, responsavel, Boolean.valueOf(poderConcedente));
            return new ResponseEntity((Object)ensaios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEnsaiosLigante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/ligantes/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de ligante betuminoso, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioLigante> getEnsaioLiganteBetuminoso(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioLiganteBetuminoso ({}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioLigante ensaio = this.laboratorioService.getEnsaioLigante(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioLiganteBetuminoso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/ligantes"})
    @Operation(summary="Registra o ensaio do ligante")
    public ResponseEntity<Ensaio> salvarEnsaioLigante(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioLigante ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioLigante ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarEnsaioLigante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/misturas"})
    @Operation(summary="Lista os ensaios de misturas")
    public ResponseEntity<List<Ensaio>> findEnsaiosMisturas(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "CONSULTAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"CONSULTAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            boolean poderConcedente = usuario.getPoderConcedente() != null && usuario.getPoderConcedente() == true;
            logger.debug("findEnsaiosMisturas ({}, {}))", (Object)usuario.getLogin(), (Object)empresa);
            Map params = request.getParameterMap();
            String tipoEnsaio = request.getParameter("tipoEnsaio");
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            try {
                if (params.containsKey("dataInicial")) {
                    dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
                }
                if (params.containsKey("dataFinal")) {
                    dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
                }
            }
            catch (DateTimeParseException dtpExc) {
                logger.error("DateTimeParseExc.findEnsaiosLigante", (Throwable)dtpExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, dtpExc.getMessage());
            }
            String search = request.getParameter("search");
            String item = request.getParameter("item");
            String equipe = request.getParameter("equipe");
            String tecnico = request.getParameter("tecnico");
            String trecho = request.getParameter("trecho");
            String obra = request.getParameter("obra");
            String userTerceiro = request.getParameter("usuarioTerceiro");
            Integer fornecedor = null;
            if (params.containsKey("fornecedor")) {
                fornecedor = Integer.valueOf(((String[])params.get("fornecedor"))[0]);
            }
            String tipoLcto = request.getParameter("tipoLancamento");
            Integer responsavel = null;
            if (params.containsKey("idResponsavel")) {
                responsavel = Integer.valueOf(((String[])params.get("idResponsavel"))[0]);
            }
            Integer status = null;
            if (params.containsKey("status")) {
                status = Integer.valueOf(((String[])params.get("status"))[0]);
            }
            Integer projeto = null;
            if (params.containsKey("projeto")) {
                projeto = Integer.valueOf(((String[])params.get("projeto"))[0]);
            }
            String parametro = request.getParameter("parametro");
            String minimo = request.getParameter("minimo");
            String maximo = request.getParameter("maximo");
            if (dataInicial == null && dataFinal == null) {
                dataFinal = LocalDate.now();
                dataInicial = dataFinal.minusMonths(3L);
            }
            ArrayList<String> empresas = new ArrayList<String>();
            String siglas = request.getParameter("empresas");
            if (siglas != null && !siglas.isEmpty()) {
                String[] rawSiglas;
                for (String sigla : rawSiglas = siglas.split(",")) {
                    empresas.add(sigla);
                }
            } else {
                empresas.add(empresa);
            }
            String[] rodoviasDesc = request.getParameterValues("rodovias");
            ArrayList<Integer> rodovias = new ArrayList<Integer>();
            if (rodoviasDesc != null) {
                for (String rodovia : rodoviasDesc) {
                    rodovias.add(Integer.valueOf(rodovia));
                }
            }
            String sortBy = request.getParameter("sortBy");
            String sortDesc = request.getParameter("sortDesc");
            if (sortDesc != null) {
                if (sortDesc.equals("false")) {
                    sortDesc = null;
                } else if (sortDesc.equals("true")) {
                    sortDesc = " DESC ";
                }
            }
            ArrayList<String> grupo = new ArrayList<String>();
            grupo.add("MIS");
            List ensaios = this.laboratorioService.findEnsaios(empresas, dataInicial, dataFinal, grupo, tipoEnsaio, null, search, tecnico, rodovias, trecho, obra, item, equipe, status, projeto, parametro, minimo, maximo, null, sortBy, sortDesc, userTerceiro, fornecedor, tipoLcto, responsavel, Boolean.valueOf(poderConcedente));
            return new ResponseEntity((Object)ensaios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEnsaiosMisturas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/teorGranulometria/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de teor granulom\u00e9trico, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioTeorGranulometria> getEnsaioTeorGranulometria(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioTeorGranulometria ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioTeorGranulometria ensaio = this.laboratorioService.getEnsaioTeorGranulometria(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioTeorGranulometria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/teorGranulometria"})
    @Operation(summary="Registra o ensaio do Teor & Granulometria")
    public ResponseEntity<Ensaio> salvarEnsaioTeorGranulometria(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioTeorGranulometria ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioTeorGranulometria ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioTeorGranulometria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/compactacaoSolo"})
    @Operation(summary="Registra o ensaio de compactacao solo - Frasco de Areia")
    public ResponseEntity<Ensaio> salvarEnsaioCompactacaoSolo(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioControleCompactacaoFrasco ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("{} - salvarEnsaioCompactacaoSolo ({}, canal={}))", (Object)empresa, (Object)canal);
            if (ensaio.getId() == null) {
                Boolean createUpdate = false;
                String parmTxt = request.getParameter("createUpdate");
                if (parmTxt != null) {
                    createUpdate = Boolean.valueOf(parmTxt);
                }
                List itens = ensaio.getItens();
                ensaio.setItens(null);
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                if (createUpdate == null || !createUpdate.booleanValue()) {
                    return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
                }
                ensaio = (EnsaioControleCompactacaoFrasco)ensaioDB;
                ensaio.setItens(itens);
                for (EnsaioControleCompactacaoFrascoItem item : itens) {
                    item.getId().setIdEnsaio(ensaio.getId());
                }
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioCompactacaoSolo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/compactacaoSolo/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de compacta\u00e7\u00e3o solo, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioControleCompactacaoFrasco> getEnsaioCompactacaoSolo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioCompactacaoSolo ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioControleCompactacaoFrasco ensaio = this.laboratorioService.getEnsaioCompactacaoSolo(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioCompactacaoSolo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/resistenciaTracao"})
    @Operation(summary="Registra o ensaio de resist\u00eancia \u00e0 tra\u00e7\u00e3o por Compress\u00e3o Diametral")
    public ResponseEntity<Ensaio> salvarEnsaioResistenciaTracao(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioResistenciaTracao ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioResistenciaTracao ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioResistenciaTracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/resistenciaTracao/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de resist\u00eancia \u00e0 tra\u00e7\u00e3o, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioResistenciaTracao> getEnsaioResistenciaTracao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioResistenciaTracao ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioResistenciaTracao ensaio = this.laboratorioService.getEnsaioResistenciaTracao(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioResistenciaTracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/umidadeInduzida"})
    @Operation(summary="Registra o ensaio de Umidade Induzida")
    public ResponseEntity<Ensaio> salvarEnsaioUmidadeInduzida(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioDanoUmidadeInduzida ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioUmidadeInduzida ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioUmidadeInduzida", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/umidadeInduzida/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de resist\u00eancia \u00e0 tra\u00e7\u00e3o, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioDanoUmidadeInduzida> getEnsaioUmidadeInduzida(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioUmidadeInduzida ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioDanoUmidadeInduzida ensaio = this.laboratorioService.getEnsaioUmidadeInduzida(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioUmidadeInduzida", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/temperaturaInsumo"})
    @Operation(summary="Registra o ensaio de Controlde de Temperatura de Insumos e da Usina")
    public ResponseEntity<Ensaio> salvarEnsaioTemperaturaInsumo(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioTemperaturaInsumo ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioTemperaturaInsumo ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null) {
                Boolean createUpdate = false;
                String parmTxt = request.getParameter("createUpdate");
                if (parmTxt != null) {
                    createUpdate = Boolean.valueOf(parmTxt);
                }
                List itens = ensaio.getItens();
                ensaio.setItens(null);
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                if (createUpdate == null || !createUpdate.booleanValue()) {
                    return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
                }
                ensaio = (EnsaioTemperaturaInsumo)ensaioDB;
                ensaio.setItens(itens);
                for (EnsaioTemperaturaInsumoItem item : itens) {
                    item.getId().setIdEnsaio(ensaio.getId());
                }
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioTemperaturaInsumo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/temperaturaInsumo/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de Temperatura e Insumos da Usina, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioTemperaturaInsumo> getEnsaioTemperaturaUsina(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioTemperaturaUsina ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioTemperaturaInsumo ensaio = this.laboratorioService.getEnsaioTemperaturaInsumo(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioTemperaturaUsina", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/execucaoMistura"})
    @Operation(summary="Registra o ensaio de Execu\u00e7\u00e3o de Mistura na Pista")
    public ResponseEntity<Ensaio> salvarEnsaioExecucaoMistura(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioExecucaoMistura ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioExecucaoMistura ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioExecucaoMistura", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/execucaoMistura/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de Execu\u00e7\u00e3o da Mistura na Pista, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioExecucaoMistura> getEnsaioExecucaoMistura(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioExecucaoMistura ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioExecucaoMistura ensaio = this.laboratorioService.getEnsaioExecucaoMistura(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioExecucaoMistura", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/compactacaoEspessura"})
    @Operation(summary="Registra o ensaio de compactacao solo")
    public ResponseEntity<Ensaio> salvarEnsaioCompactacaoEspessura(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioCompactacaoEspessura ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioCompactacaoEspessura ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null) {
                Boolean createUpdate = false;
                String parmTxt = request.getParameter("createUpdate");
                if (parmTxt != null) {
                    createUpdate = Boolean.valueOf(parmTxt);
                }
                List itens = ensaio.getItens();
                ensaio.setItens(null);
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                if (createUpdate == null || !createUpdate.booleanValue()) {
                    return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
                }
                ensaio = (EnsaioCompactacaoEspessura)ensaioDB;
                ensaio.setItens(itens);
                for (EnsaioCompactacaoEspessuraItem item : itens) {
                    item.getId().setIdEnsaio(ensaio.getId());
                }
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioCompactacaoEspessura", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/compactacaoEspessura/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de compacta\u00e7\u00e3o espessura da mistura, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioCompactacaoEspessura> getEnsaioCompactacaoEspessura(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioCompactacaoEspessura ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioCompactacaoEspessura ensaio = this.laboratorioService.getEnsaioCompactacaoEspessura(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioCompactacaoEspessura", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/vigaBenkelman"})
    @Operation(summary="Registra o ensaio de viga benkelman")
    public ResponseEntity<Ensaio> salvarEnsaioVigaBenkelman(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioVigaBenkelman ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioVigaBenkelman ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null) {
                Boolean createUpdate = false;
                String parmTxt = request.getParameter("createUpdate");
                if (parmTxt != null) {
                    createUpdate = Boolean.valueOf(parmTxt);
                }
                List itens = ensaio.getItens();
                ensaio.setItens(null);
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                if (createUpdate == null || !createUpdate.booleanValue()) {
                    return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
                }
                ensaio = (EnsaioVigaBenkelman)ensaioDB;
                ensaio.setItens(itens);
                for (EnsaioVigaBenkelmanItem item : itens) {
                    item.getId().setIdEnsaio(ensaio.getId());
                }
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioVigaBenkelman", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/vigaBenkelman/{idEnsaio}"})
    @Operation(summary="Retorna os dados do EnsaioVigaBenkelman, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioVigaBenkelman> getEnsaioVigaBenkelman(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioVigaBenkelman ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioVigaBenkelman ensaio = this.laboratorioService.getEnsaioVigaBenkelman(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioVigaBenkelman", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/solos"})
    @Operation(summary="Lista os ensaios de Solos")
    public ResponseEntity<List<Ensaio>> findEnsaiosSolo(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "CONSULTAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"CONSULTAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            boolean poderConcedente = usuario.getPoderConcedente() != null && usuario.getPoderConcedente() == true;
            logger.debug("findEnsaiosSolo ({}, {}))", (Object)usuario.getLogin(), (Object)empresa);
            Map params = request.getParameterMap();
            String tipoEnsaio = request.getParameter("tipoEnsaio");
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            try {
                if (params.containsKey("dataInicial")) {
                    dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
                }
                if (params.containsKey("dataFinal")) {
                    dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
                }
            }
            catch (DateTimeParseException dtpExc) {
                logger.error("DateTimeParseExc.findEnsaiosLigante", (Throwable)dtpExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, dtpExc.getMessage());
            }
            String search = request.getParameter("search");
            String item = request.getParameter("item");
            String equipe = request.getParameter("equipe");
            String tecnico = request.getParameter("tecnico");
            String trecho = request.getParameter("trecho");
            String obra = request.getParameter("obra");
            String userTerceiro = request.getParameter("usuarioTerceiro");
            Integer fornecedor = null;
            if (params.containsKey("fornecedor")) {
                fornecedor = Integer.valueOf(((String[])params.get("fornecedor"))[0]);
            }
            String tipoLcto = request.getParameter("tipoLancamento");
            Integer responsavel = null;
            if (params.containsKey("idResponsavel")) {
                responsavel = Integer.valueOf(((String[])params.get("idResponsavel"))[0]);
            }
            Integer status = null;
            if (params.containsKey("status")) {
                status = Integer.valueOf(((String[])params.get("status"))[0]);
            }
            Integer projeto = null;
            if (params.containsKey("projeto")) {
                projeto = Integer.valueOf(((String[])params.get("projeto"))[0]);
            }
            String parametro = request.getParameter("parametro");
            String minimo = request.getParameter("minimo");
            String maximo = request.getParameter("maximo");
            if (dataInicial == null && dataFinal == null) {
                dataFinal = LocalDate.now();
                dataInicial = dataFinal.minusMonths(3L);
            }
            ArrayList<String> empresas = new ArrayList<String>();
            String siglas = request.getParameter("empresas");
            if (siglas != null && !siglas.isEmpty()) {
                String[] rawSiglas;
                for (String sigla : rawSiglas = siglas.split(",")) {
                    empresas.add(sigla);
                }
            } else {
                empresas.add(empresa);
            }
            String[] rodoviasDesc = request.getParameterValues("rodovias");
            ArrayList<Integer> rodovias = new ArrayList<Integer>();
            if (rodoviasDesc != null) {
                for (String rodovia : rodoviasDesc) {
                    rodovias.add(Integer.valueOf(rodovia));
                }
            }
            String sortBy = request.getParameter("sortBy");
            String sortDesc = request.getParameter("sortDesc");
            if (sortDesc != null) {
                if (sortDesc.equals("false")) {
                    sortDesc = null;
                } else if (sortDesc.equals("true")) {
                    sortDesc = " DESC ";
                }
            }
            ArrayList<String> grupo = new ArrayList<String>();
            grupo.add("SOL");
            List ensaios = this.laboratorioService.findEnsaios(empresas, dataInicial, dataFinal, grupo, tipoEnsaio, null, search, tecnico, rodovias, trecho, obra, item, equipe, status, projeto, parametro, minimo, maximo, null, sortBy, sortDesc, userTerceiro, fornecedor, tipoLcto, responsavel, Boolean.valueOf(poderConcedente));
            return new ResponseEntity((Object)ensaios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEnsaiosSolo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/geral"})
    @Operation(summary="Lista os ensaios de crit\u00e9rio geral, usados em v\u00e1rias finalidades")
    public ResponseEntity<List<Ensaio>> findEnsaiosGeral(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "CONSULTAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"CONSULTAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            boolean poderConcedente = usuario.getPoderConcedente() != null && usuario.getPoderConcedente() == true;
            logger.debug("findEnsaiosGeral ({}, {}))", (Object)usuario.getLogin(), (Object)empresa);
            Map params = request.getParameterMap();
            String tipoEnsaio = request.getParameter("tipoEnsaio");
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            try {
                if (params.containsKey("dataInicial")) {
                    dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
                }
                if (params.containsKey("dataFinal")) {
                    dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
                }
            }
            catch (DateTimeParseException dtpExc) {
                logger.error("DateTimeParseExc.findEnsaiosLigante", (Throwable)dtpExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, dtpExc.getMessage());
            }
            String search = request.getParameter("search");
            String item = request.getParameter("item");
            String equipe = request.getParameter("equipe");
            String tecnico = request.getParameter("tecnico");
            String trecho = request.getParameter("trecho");
            String obra = request.getParameter("obra");
            String userTerceiro = request.getParameter("usuarioTerceiro");
            Integer fornecedor = null;
            if (params.containsKey("fornecedor")) {
                fornecedor = Integer.valueOf(((String[])params.get("fornecedor"))[0]);
            }
            String tipoLcto = request.getParameter("tipoLancamento");
            Integer responsavel = null;
            if (params.containsKey("idResponsavel")) {
                responsavel = Integer.valueOf(((String[])params.get("idResponsavel"))[0]);
            }
            String[] rodoviasDesc = request.getParameterValues("rodovias");
            ArrayList<Integer> rodovias = new ArrayList<Integer>();
            if (rodoviasDesc != null) {
                for (String rodovia : rodoviasDesc) {
                    rodovias.add(Integer.valueOf(rodovia));
                }
            }
            Integer status = null;
            if (params.containsKey("status")) {
                status = Integer.valueOf(((String[])params.get("status"))[0]);
            }
            Integer projeto = null;
            if (params.containsKey("projeto")) {
                projeto = Integer.valueOf(((String[])params.get("projeto"))[0]);
            }
            String parametro = request.getParameter("parametro");
            String minimo = request.getParameter("minimo");
            String maximo = request.getParameter("maximo");
            if (dataInicial == null && dataFinal == null) {
                dataFinal = LocalDate.now();
                dataInicial = dataFinal.minusMonths(3L);
            }
            ArrayList<String> empresas = new ArrayList<String>();
            String siglas = request.getParameter("empresas");
            if (siglas != null && !siglas.isEmpty()) {
                String[] rawSiglas;
                for (String sigla : rawSiglas = siglas.split(",")) {
                    empresas.add(sigla);
                }
            } else {
                empresas.add(empresa);
            }
            String sortBy = request.getParameter("sortBy");
            String sortDesc = request.getParameter("sortDesc");
            if (sortDesc != null) {
                if (sortDesc.equals("false")) {
                    sortDesc = null;
                } else if (sortDesc.equals("true")) {
                    sortDesc = " DESC ";
                }
            }
            ArrayList<String> grupo = new ArrayList<String>();
            grupo.add("GER");
            List ensaios = this.laboratorioService.findEnsaios(empresas, dataInicial, dataFinal, grupo, tipoEnsaio, null, search, tecnico, rodovias, trecho, obra, item, equipe, status, projeto, parametro, minimo, maximo, null, sortBy, sortDesc, userTerceiro, fornecedor, tipoLcto, responsavel, Boolean.valueOf(poderConcedente));
            return new ResponseEntity((Object)ensaios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEnsaiosGeral", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/manchaAreia"})
    @Operation(summary="Registra o ensaio de mancha areia")
    public ResponseEntity<Ensaio> salvarEnsaioManchaAreia(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioManchaAreia ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioManchaAreia ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null) {
                Boolean createUpdate = false;
                String parmTxt = request.getParameter("createUpdate");
                if (parmTxt != null) {
                    createUpdate = Boolean.valueOf(parmTxt);
                }
                List itens = ensaio.getItens();
                ensaio.setItens(null);
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                if (createUpdate == null || !createUpdate.booleanValue()) {
                    return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
                }
                ensaio = (EnsaioManchaAreia)ensaioDB;
                ensaio.setItens(itens);
                for (EnsaioManchaAreiaItem item : itens) {
                    item.getId().setIdEnsaio(ensaio.getId());
                }
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioManchaAreia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/manchaAreia/{idEnsaio}"})
    @Operation(summary="Retorna os dados do EnsaioManchaAreia, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioManchaAreia> getEnsaioManchaAreia(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioManchaAreia ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioManchaAreia ensaio = this.laboratorioService.getEnsaioManchaAreia(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioVigaBenkelman", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/resistenciaDerrapagem"})
    @Operation(summary="Registra o ensaio de resist\u00eancia derrapagem")
    public ResponseEntity<Ensaio> salvarEnsaioResistenciaDerrapagem(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioMicrotexturaResistenciaDerrapagem ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioResistenciaDerrapagem ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null) {
                Boolean createUpdate = false;
                String parmTxt = request.getParameter("createUpdate");
                if (parmTxt != null) {
                    createUpdate = Boolean.valueOf(parmTxt);
                }
                List itens = ensaio.getItens();
                ensaio.setItens(null);
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                if (createUpdate == null || !createUpdate.booleanValue()) {
                    return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
                }
                ensaio = (EnsaioMicrotexturaResistenciaDerrapagem)ensaioDB;
                ensaio.setItens(itens);
                for (EnsaioMicrotexturaResistenciaDerrapagemItem item : itens) {
                    item.getId().setIdEnsaio(ensaio.getId());
                }
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioResistenciaDerrapagem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/resistenciaDerrapagem/{idEnsaio}"})
    @Operation(summary="Retorna os dados do EnsaioResistenciaDerrapagem, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioMicrotexturaResistenciaDerrapagem> getEnsaioResistenciaDerrapagem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioResistenciaDerrapagem ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioMicrotexturaResistenciaDerrapagem ensaio = this.laboratorioService.getEnsaioResistenciaDerrapagem(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioResistenciaDerrapagem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/caracterizacaoSolo/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de caracterizacao de solos, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioCaracterizacaoSolo> getEnsaioCaracterizacaoSolo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioCaracterizacaoSolo ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioCaracterizacaoSolo ensaio = this.laboratorioService.getEnsaioCaracterizacaoSolo(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioCaracterizacaoSolo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/caracterizacaoSolo"})
    @Operation(summary="Registra o ensaio do caracterizacaoSolo")
    public ResponseEntity<Ensaio> salvarEnsaioCaracterizacaoSolo(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioCaracterizacaoSolo ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioCaracterizacaoSolo ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioCaracterizacaoSolo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/compressaoAxial"})
    @Operation(summary="Resist\u00eancia \u00e0 Compress\u00e3o Axial de Corpoas de Provia Cil\u00edndricos")
    public ResponseEntity<Ensaio> salvarEnsaioCompressaoSimples(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioCompressaoAxial ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioCompressaoSimples ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioCompressaoSimples", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/compressaoAxial/{idEnsaio}"})
    @Operation(summary="Retorna os dados do EnsaioCompressaoAxial, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioCompressaoAxial> getEnsaioCompressaoAxial(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("EnsaioCompressaoAxial ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioCompressaoAxial ensaio = this.laboratorioService.getEnsaioCompressaoAxial(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioCompressaoAxial", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/compactacao/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de compactacao, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioCompactacao> getEnsaioCompactacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioCompactacao ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioCompactacao ensaio = this.laboratorioService.getEnsaioCompactacao(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioCompactacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/compactacao"})
    @Operation(summary="Registra o ensaio de compacta\u00e7\u00e3o")
    public ResponseEntity<Ensaio> salvarEnsaioCompactacao(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioCompactacao ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("{} - salvarEnsaioCompactacao ({}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioCompactacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/tracaoFlexao"})
    @Operation(summary="Registra o ensaio de resist\u00eancia \u00e0 tra\u00e7\u00e3o por flex\u00e3o")
    public ResponseEntity<Ensaio> salvarEnsaioTracaoFlexao(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioTracaoFlexao ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioTracaoFlexao ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioTracaoFlexao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/tracaoFlexao/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio tra\u00e7\u00e3o por flex\u00e3o, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioTracaoFlexao> getEnsaioTracaoFlexao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioTracaoFlexao ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioTracaoFlexao ensaio = this.laboratorioService.getEnsaioTracaoFlexao(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioTracaoFlexao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/equivalenteAreia"})
    @Operation(summary="Registra o ensaio de equival\u00eancia areia")
    public ResponseEntity<Ensaio> salvarEnsaioEquivalenteAreia(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioEquivalenteAreia ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("EnsaioEquivalenteAreia ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioEquivalenteAreia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/equivalenteAreia/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de equival\u00eancia areia, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioEquivalenteAreia> getEnsaioEquivalenteAreia(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioTracaoFlexao ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioEquivalenteAreia ensaio = this.laboratorioService.getEnsaioEquivalenteAreia(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioEquivalenteAreia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/analiseGranulometrica/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de an\u00e1lise granulom\u00e9trico, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioAnaliseGranulometrica> getEnsaioAnaliseGranulometrica(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioAnaliseGranulometrica ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioAnaliseGranulometrica ensaio = this.laboratorioService.getEnsaioAnaliseGranulometrica(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioAnaliseGranulometrica", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/analiseGranulometrica"})
    @Operation(summary="Registra o ensaio de an\u00e1lise & Granulometria")
    public ResponseEntity<Ensaio> salvarEnsaioAnaliseGranulometria(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioAnaliseGranulometrica ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioAnaliseGranulometria ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioAnaliseGranulometria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/concretos"})
    @Operation(summary="Lista os ensaios de concretos")
    public ResponseEntity<List<Ensaio>> findEnsaiosConcretos(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "CONSULTAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"CONSULTAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            boolean poderConcedente = usuario.getPoderConcedente() != null && usuario.getPoderConcedente() == true;
            logger.debug("findEnsaiosConcreto ({}, {}))", (Object)usuario.getLogin(), (Object)empresa);
            Map params = request.getParameterMap();
            String tipoEnsaio = request.getParameter("tipoEnsaio");
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            try {
                if (params.containsKey("dataInicial")) {
                    dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
                }
                if (params.containsKey("dataFinal")) {
                    dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
                }
            }
            catch (DateTimeParseException dtpExc) {
                logger.error("DateTimeParseExc.findEnsaiosLigante", (Throwable)dtpExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, dtpExc.getMessage());
            }
            String search = request.getParameter("search");
            String item = request.getParameter("item");
            String equipe = request.getParameter("equipe");
            String tecnico = request.getParameter("tecnico");
            String trecho = request.getParameter("trecho");
            String obra = request.getParameter("obra");
            String userTerceiro = request.getParameter("usuarioTerceiro");
            Integer fornecedor = null;
            if (params.containsKey("fornecedor")) {
                fornecedor = Integer.valueOf(((String[])params.get("fornecedor"))[0]);
            }
            String tipoLcto = request.getParameter("tipoLancamento");
            Integer responsavel = null;
            if (params.containsKey("idResponsavel")) {
                responsavel = Integer.valueOf(((String[])params.get("idResponsavel"))[0]);
            }
            String[] rodoviasDesc = request.getParameterValues("rodovias");
            ArrayList<Integer> rodovias = new ArrayList<Integer>();
            if (rodoviasDesc != null) {
                for (String rodovia : rodoviasDesc) {
                    rodovias.add(Integer.valueOf(rodovia));
                }
            }
            Integer status = null;
            if (params.containsKey("status")) {
                status = Integer.valueOf(((String[])params.get("status"))[0]);
            }
            Integer projeto = null;
            if (params.containsKey("projeto")) {
                projeto = Integer.valueOf(((String[])params.get("projeto"))[0]);
            }
            String parametro = request.getParameter("parametro");
            String minimo = request.getParameter("minimo");
            String maximo = request.getParameter("maximo");
            if (dataInicial == null && dataFinal == null) {
                dataFinal = LocalDate.now();
                dataInicial = dataFinal.minusMonths(3L);
            }
            ArrayList<String> empresas = new ArrayList<String>();
            String siglas = request.getParameter("empresas");
            if (siglas != null && !siglas.isEmpty()) {
                String[] rawSiglas;
                for (String sigla : rawSiglas = siglas.split(",")) {
                    empresas.add(sigla);
                }
            } else {
                empresas.add(empresa);
            }
            String sortBy = request.getParameter("sortBy");
            String sortDesc = request.getParameter("sortDesc");
            if (sortDesc != null) {
                if (sortDesc.equals("false")) {
                    sortDesc = null;
                } else if (sortDesc.equals("true")) {
                    sortDesc = " DESC ";
                }
            }
            ArrayList<String> grupo = new ArrayList<String>();
            grupo.add("CON");
            List ensaios = this.laboratorioService.findEnsaios(empresas, dataInicial, dataFinal, grupo, tipoEnsaio, null, search, tecnico, rodovias, trecho, obra, item, equipe, status, projeto, parametro, minimo, maximo, null, sortBy, sortDesc, userTerceiro, fornecedor, tipoLcto, responsavel, Boolean.valueOf(poderConcedente));
            return new ResponseEntity((Object)ensaios, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEnsaiosConcretos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/lamelaridade/{idEnsaio}"})
    @Operation(summary="Retorna os dados do lamelaridade, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioLamelaridade> getEnsaioLamelaridade(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioLamelaridade ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioLamelaridade ensaio = this.laboratorioService.getEnsaioLamelaridade(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioLamelaridade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/lamelaridade"})
    @Operation(summary="Registra o ensaio de lamelaridade")
    public ResponseEntity<Ensaio> salvarEnsaioLamelaridade(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioLamelaridade ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioLamelaridade ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioLamelaridade", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/parquimetro/{idEnsaio}"})
    @Operation(summary="Retorna os dados do parquimetro, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioIndicePaquimetro> getEnsaioParquimetro(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioParquimetro ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioIndicePaquimetro ensaio = this.laboratorioService.getEnsaioIndicePaquimetro(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioParquimetro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/parquimetro"})
    @Operation(summary="Registra o ensaio de parqu\u00edmetro")
    public ResponseEntity<Ensaio> salvarEnsaioIndiceParquimetro(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioIndicePaquimetro ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioIndiceParquimetro ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioIndiceParquimetro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/crivo/{idEnsaio}"})
    @Operation(summary="Retorna os dados do crivo, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioIndiceCrivo> getEnsaioCrivo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioCrivo ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioIndiceCrivo ensaio = this.laboratorioService.getEnsaioIndiceCrivo(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioCrivo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/crivo"})
    @Operation(summary="Registra o ensaio de crivo")
    public ResponseEntity<Ensaio> salvarEnsaioIndiceCrivo(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioIndiceCrivo ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioIndiceCrivo ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioIndiceCrivo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/densidadeRealAbsorcao/{idEnsaio}"})
    @Operation(summary="Retorna os dados do Ensaio Densidade Real Absor\u00e7\u00e3o, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioDensidadeRealAbsorcao> getEnsaioDensidadeRealAbsorcao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioDensidadeRealAbsorcao ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioDensidadeRealAbsorcao ensaio = this.laboratorioService.getEnsaioDensidadeRealAbsorcao(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioCrivo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/densidadeRealAbsorcao"})
    @Operation(summary="Registra o ensaio de crivo")
    public ResponseEntity<Ensaio> salvarEnsaioDensidadeRealAbsorcao(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioDensidadeRealAbsorcao ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioDensidadeRealAbsorcao ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioDensidadeRealAbsorcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/caracterizacaoLiganteBetuminoso/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de caracterizacao de ligantes betuminosos, atrav\u00e9s de seu ID")
    public ResponseEntity<EnsaioLiganteBetuminoso> getEnsaioCaracterizacaoLiganteBetuminoso(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioCaracterizacaoLiganteBetuminoso({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioLiganteBetuminoso ensaio = this.laboratorioService.getEnsaioCaracterizacaoLiganteBetuminoso(empresa, idEnsaio, Integer.valueOf(1), usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioCaracterizacaoLiganteBetuminoso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/caracterizacaoLiganteBetuminoso"})
    @Operation(summary="Registra o ensaio do caracterizacao Ligante Betuminoso")
    public ResponseEntity<Ensaio> salvarEnsaioCaracterizacaoLiganteBetuminoso(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioLiganteBetuminoso ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioCaracterizacaoLiganteBetuminoso({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioCaracterizacaoLiganteBetuminoso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/microesferaVidro/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de microesfera vidro (tipo II-A) e (tipo II-C) atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioMicroesferaVidro> getEnsaioMicroesferaVidroA(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioMicroesferaVidroA ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioMicroesferaVidro ensaio = this.laboratorioService.getEnsaioMicroesferaVidro(empresa, idEnsaio, null, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioMicroesferaVidro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage(), (Throwable)bizExc);
        }
    }

    @PostMapping(path={"/{empresa}/microesferaVidro"})
    @Operation(summary="Registra o ensaio de microesferaVidro tipo II-A e II-C")
    public ResponseEntity<Ensaio> salvarEnsaioMicroesferaVidroA(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioMicroesferaVidro ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioMicroesferaVidro ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioMicroesferaVidro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/demarcacaoViaria/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de demarca\u00e7\u00e3o vi\u00e1ria, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioDemarcacaoViaria> getEnsaioDemarcacaoViaria(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioDemarcacaoViaria ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioDemarcacaoViaria ensaio = this.laboratorioService.getEnsaioDemarcacaoViaria(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioDemarcacaoViaria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/demarcacaoViaria"})
    @Operation(summary="Registra o ensaio de demarca\u00e7\u00e3o vi\u00e1ria")
    public ResponseEntity<Ensaio> salvarEnsaioDemarcacaoViaria(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioDemarcacaoViaria ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioDemarcacaoViaria ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioDemarcacaoViaria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/teorMicro/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de teor micro, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioTeorMicro> getEnsaioTeorMicro(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioTeorMicro ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioTeorMicro ensaio = this.laboratorioService.getEnsaioTeorMicro(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioTeorMicro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/teorMicro"})
    @Operation(summary="Registra o ensaio do Teor micro e granulometria")
    public ResponseEntity<Ensaio> salvarEnsaioTeorMicro(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioTeorMicro ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioTeorMicro ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioTeorMicro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/medicaoMerlin/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de medi\u00e7\u00e3o merlin, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioMedicaoMerlin> getEnsaioMedicaoMerlin(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioMedicaoMerlin ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioMedicaoMerlin ensaio = this.laboratorioService.getEnsaioMedicaoMerlin(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioMedicaoMerlin", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/medicaoMerlin"})
    @Operation(summary="Registra o ensaio da medi\u00e7\u00e3o merlin")
    public ResponseEntity<Ensaio> salvarEnsaioMedicaoMerlin(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioMedicaoMerlin ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioMedicaoMerlin ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null) {
                Boolean createUpdate = false;
                String parmTxt = request.getParameter("createUpdate");
                if (parmTxt != null) {
                    createUpdate = Boolean.valueOf(parmTxt);
                }
                List itens = ensaio.getItens();
                ensaio.setItens(null);
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                if (createUpdate == null || !createUpdate.booleanValue()) {
                    return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
                }
                ensaio = (EnsaioMedicaoMerlin)ensaioDB;
                ensaio.setItens(itens);
                for (EnsaioMedicaoMerlinItem item : itens) {
                    item.getId().setIdEnsaio(ensaio.getId());
                }
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioMedicaoMerlin", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/grauCompactacao/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de grau compacta\u00e7\u00e3o, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioGrauCompactacao> getEnsaioGrauCompactacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioGrauCompactacao ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioGrauCompactacao ensaio = this.laboratorioService.getEnsaioGrauCompactacao(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioGrauCompactacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/grauCompactacao"})
    @Operation(summary="Registra o ensaio grau compacta\u00e7\u00e3o")
    public ResponseEntity<Ensaio> salvarEnsaioGrauCompactacao(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioGrauCompactacao ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioGrauCompactacao ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null) {
                Boolean createUpdate = false;
                String parmTxt = request.getParameter("createUpdate");
                if (parmTxt != null) {
                    createUpdate = Boolean.valueOf(parmTxt);
                }
                List itens = ensaio.getItens();
                ensaio.setItens(null);
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                if (createUpdate == null || !createUpdate.booleanValue()) {
                    return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
                }
                ensaio = (EnsaioGrauCompactacao)ensaioDB;
                ensaio.setItens(itens);
                for (EnsaioGrauCompactacaoItem item : itens) {
                    item.getId().setIdEnsaio(ensaio.getId());
                }
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioGrauCompactacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/boletimSondagem/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de boletim de sondagem cilindro, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioSondagemCilindro> getEnsaioSondagemCilindro(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioDensidadeMistura ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioSondagemCilindro ensaio = this.laboratorioService.getEnsaioSondagemCilindro(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioSondagemCilindro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/boletimSondagem"})
    @Operation(summary="Registra o ensaio de boletim de sondagem cilindro")
    public ResponseEntity<Ensaio> salvarEnsaioSondagemCilindro(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioSondagemCilindro ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioSondagemCilindro ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioSondagemCilindro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/pinturaLigacao/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de Aplica\u00e7\u00e3o, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioTaxaAplicacao> getEnsaioPinturaLigacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioPinturaLigacao ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioTaxaAplicacao ensaio = this.laboratorioService.getEnsaioPinturaLigacao(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioPinturaLigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/pinturaLigacao"})
    @Operation(summary="Registra o ensaio de ensaio de Taxa de Aplica\u00e7\u00e3o")
    public ResponseEntity<Ensaio> salvarEnsaioPinturaLigacao(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioTaxaAplicacao ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioPinturaLigacao ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null) {
                Boolean createUpdate = false;
                String parmTxt = request.getParameter("createUpdate");
                if (parmTxt != null) {
                    createUpdate = Boolean.valueOf(parmTxt);
                }
                List itens = ensaio.getItens();
                ensaio.setItens(null);
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                if (createUpdate == null || !createUpdate.booleanValue()) {
                    return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
                }
                ensaio = (EnsaioTaxaAplicacao)ensaioDB;
                ensaio.setItens(itens);
                for (EnsaioTaxaAplicacaoItem item : itens) {
                    item.getId().setIdEnsaio(ensaio.getId());
                }
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioPinturaLigacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/umidadeNatural/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de umidade natural, atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioUmidadeNatural> getEnsaioUmidadeNatural(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioUmidadeNatural ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioUmidadeNatural ensaio = this.laboratorioService.getEnsaioUmidadeNatural(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioUmidadeNatural", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/umidadeNatural"})
    @Operation(summary="Registra o ensaio de ensaio de umidade natural")
    public ResponseEntity<Ensaio> salvarEnsaioUmidadeNatural(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioUmidadeNatural ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioUmidadeNatural ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioUmidadeNatural", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/densidadeMaxima/{idEnsaio}"})
    @Operation(summary="Retorna os dados do ensaio de densidade m\u00e1xima atrav\u00e9s de seu Identificador")
    public ResponseEntity<EnsaioDensidadeMaxima> getEnsaioDensidadeMaxima(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("getEnsaioUmidadeNatural ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            EnsaioDensidadeMaxima ensaio = this.laboratorioService.getEnsaioDensidadeMaxima(empresa, idEnsaio, usuario.getLogin());
            if (ensaio != null) {
                this.laboratorioService.criarHistoricoSupervisor(empresa, ensaio.getId(), ensaio.getIdResponsavel(), usuario.getLogin());
            }
            return new ResponseEntity((Object)ensaio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioDensidadeMaxima", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/densidadeMaxima"})
    @Operation(summary="Registra o ensaio de ensaio de densidade m\u00e1xima")
    public ResponseEntity<Ensaio> salvarEnsaioDensidadeMaxima(@PathVariable(name="empresa") String empresa, @RequestBody EnsaioDensidadeMaxima ensaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CADASTRAR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CADASTRAR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (ensaio == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura do ensaio n\u00e3o informada.");
            }
            String canal = request.getParameter("canal");
            if (canal == null || canal.isEmpty()) {
                canal = "W";
            }
            logger.debug("salvarEnsaioDensidadeMaxima ({}, {}, canal={}))", new Object[]{usuario.getLogin(), empresa, canal});
            if (ensaio.getId() == null || ensaio.getId() == null) {
                Ensaio ensaioDB = this.laboratorioService.createEnsaio(empresa, ensaio, canal, usuario.getLogin());
                return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
            }
            Ensaio ensaioDB = this.laboratorioService.saveEnsaio(empresa, ensaio, usuario.getLogin());
            return new ResponseEntity((Object)ensaioDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.salvarEnsaioDensidadeMaxima", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(path={"/{empresa}/{idEnsaio}/numeros"})
    @Operation(summary="Remove o n\u00famero do ensaio gerado previamente")
    public ResponseEntity<Boolean> removeNumeroEnsaio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "EXCLUIR_NUMERO_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"EXCLUIR_NUMERO_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("removeNumeroEnsaio ({}, {}))", (Object)usuario.getLogin(), (Object)empresa);
            return new ResponseEntity((Object)this.laboratorioService.removeNumeroEnsaio(empresa, idEnsaio, usuario.getLogin()), (HttpStatusCode)HttpStatus.ACCEPTED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.removeNumeroEnsaio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/concluir"})
    @Operation(summary="Realiza o processo de conclus\u00e3o do ensaio.")
    public ResponseEntity<Boolean> concluirEnsaio(@PathVariable(name="empresa") String empresa, @RequestBody Ensaio ensaio, HttpServletRequest request) {
        try {
            logger.debug("concluirEnsaio ({}))", (Object)empresa);
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_CONCLUIR_ENSAIO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_CONCLUIR_ENSAIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.laboratorioService.concluirEnsaio(empresa, ensaio, usuario.getLogin()), (HttpStatusCode)HttpStatus.ACCEPTED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.concluirEnsaio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(path={"/{empresa}/historicos/{idEnsaio}"})
    @Operation(summary="Retorna os hist\u00f3ricos do ensaio, atrav\u00e9s de seu Identificador")
    public ResponseEntity<List<EnsaioHistorico>> findHistoricos(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("findHistoricos ({}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            List historicos = this.laboratorioService.findHistoricos(empresa, idEnsaio);
            return new ResponseEntity((Object)historicos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEnsaioLiganteBetuminoso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{grupoEnsaio}/exportacao"})
    @Operation(summary="Efetua o download dos ensaios em formato de planilha")
    public ResponseEntity<byte[]> exportExcel(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="grupoEnsaio") String grupoEnsaio) {
        logger.debug("Exportando excel, ensaios (emp={}, {})...", (Object)empresa, (Object)grupoEnsaio);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        try {
            List ensaios;
            byte[] bytes;
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_EXPORTAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_EXPORTAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            boolean poderConcedente = usuario.getPoderConcedente() != null && usuario.getPoderConcedente() == true;
            ArrayList<String> empresas = new ArrayList<String>();
            String siglas = request.getParameter("empresas");
            if (siglas != null && !siglas.isEmpty()) {
                String[] rawSiglas;
                for (String sigla : rawSiglas = siglas.split(",")) {
                    empresas.add(sigla);
                }
            } else {
                empresas.add(empresa);
            }
            Map params = request.getParameterMap();
            Integer projeto = null;
            if (params.containsKey("projeto")) {
                projeto = Integer.valueOf(((String[])params.get("projeto"))[0]);
            }
            String parametro = request.getParameter("parametro");
            String minimo = request.getParameter("minimo");
            String maximo = request.getParameter("maximo");
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            try {
                if (params.containsKey("dataInicial")) {
                    dataInicial = LocalDate.parse(((String[])params.get("dataInicial"))[0]);
                }
                if (params.containsKey("dataFinal")) {
                    dataFinal = LocalDate.parse(((String[])params.get("dataFinal"))[0]);
                }
            }
            catch (DateTimeParseException dtpExc) {
                logger.error("DateTimeParseExc.findEnsaiosLigante", (Throwable)dtpExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, dtpExc.getMessage());
            }
            if (dataInicial == null && dataFinal == null) {
                dataFinal = LocalDate.now();
                dataInicial = dataFinal.minusMonths(3L);
            }
            String sortBy = request.getParameter("sortBy");
            String sortDesc = request.getParameter("sortDesc");
            if (sortDesc != null) {
                if (sortDesc.equals("false")) {
                    sortDesc = null;
                } else if (sortDesc.equals("true")) {
                    sortDesc = " DESC ";
                }
            }
            String userTerceiro = request.getParameter("usuarioTerceiro");
            Integer fornecedor = null;
            if (params.containsKey("fornecedor")) {
                fornecedor = Integer.valueOf(((String[])params.get("fornecedor"))[0]);
            }
            String tipoLcto = request.getParameter("tipoLancamento");
            Integer responsavel = null;
            if (params.containsKey("idResponsavel")) {
                responsavel = Integer.valueOf(((String[])params.get("idResponsavel"))[0]);
            }
            ArrayList<String> grupo = new ArrayList<String>();
            grupo.add(grupoEnsaio);
            String tipoEnsaio = "";
            if (params.containsKey("tipoEnsaio")) {
                tipoEnsaio = request.getParameter("tipoEnsaio");
            }
            String search = "";
            if (params.containsKey("search")) {
                search = request.getParameter("search");
            }
            String tecnico = "";
            if (params.containsKey("tecnico")) {
                tecnico = request.getParameter("tecnico");
            }
            String[] rodoviasDesc = request.getParameterValues("rodovias");
            ArrayList<Integer> rodovias = new ArrayList<Integer>();
            if (rodoviasDesc != null) {
                for (String rodovia : rodoviasDesc) {
                    rodovias.add(Integer.valueOf(rodovia));
                }
            }
            String trecho = "";
            if (params.containsKey("trecho")) {
                trecho = request.getParameter("trecho");
            }
            String obra = "";
            if (params.containsKey("obra")) {
                obra = request.getParameter("obra");
            }
            String item = "";
            if (params.containsKey("item")) {
                item = request.getParameter("item");
            }
            String equipe = "";
            if (params.containsKey("equipe")) {
                equipe = request.getParameter("equipe");
            }
            Integer status = null;
            if (params.containsKey("status")) {
                status = Integer.valueOf(((String[])params.get("status"))[0]);
            }
            if ((bytes = new ExportEnsaiosExcel().executeXLS(ensaios = this.laboratorioService.findEnsaios(empresas, dataInicial, dataFinal, grupo, tipoEnsaio, null, search, tecnico, rodovias, trecho, obra, item, equipe, status, projeto, parametro, minimo, maximo, null, sortBy, sortDesc, userTerceiro, fornecedor, tipoLcto, responsavel, Boolean.valueOf(poderConcedente)))) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"ensaios.xlsx\"");
            headers.add("Content-Type", "application/octet-stream");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/dashboards"})
    @Operation(summary="Retorna a dashboard de ensaios conforme seu filtro.")
    @ResponseBody
    public ResponseEntity<Map<String, DashboardEnsaioVO>> findDashboard(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="unidades", required=false) List<String> unidades, @RequestParam(name="datInicial", defaultValue="", required=false) String datInicial, @RequestParam(name="datFinal", defaultValue="", required=false) String datFinal, @RequestParam(name="grupo", defaultValue="", required=false) List<String> grupo, @RequestParam(name="numeroInicial", defaultValue="", required=false) String numeroInicial, @RequestParam(name="numeroInicial", defaultValue="", required=false) String numeroFinal, @RequestParam(name="contrato", defaultValue="", required=false) String contrato, @RequestParam(name="rodovias", required=false) List<Integer> rodovias) {
        logger.debug("Executando findDashboard(emp={})...", (Object)empresa);
        try {
            boolean poderConcedente;
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_DASHBOARDS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_DASHBOARDS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            boolean bl = poderConcedente = usuario.getPoderConcedente() != null && usuario.getPoderConcedente() == true;
            if (grupo.isEmpty()) {
                grupo = null;
            }
            ArrayList<Integer> rodoviasList = null;
            if (rodovias != null) {
                rodoviasList = new ArrayList<Integer>();
                rodoviasList.addAll(rodovias);
            }
            ArrayList<String> empresas = new ArrayList<String>();
            empresas.add(empresa);
            if (unidades != null && !unidades.isEmpty()) {
                empresas.clear();
                empresas.addAll(unidades);
            }
            LocalDate datIniLdt = null;
            LocalDate datFimLdt = null;
            DateTimeFormatter dateFmt = DateTimeFormatter.ISO_LOCAL_DATE;
            if (datInicial != null && !datInicial.isEmpty()) {
                try {
                    datIniLdt = LocalDate.parse(datInicial, dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    datIniLdt = null;
                }
            }
            if (datFinal != null && !datFinal.isEmpty()) {
                try {
                    datFimLdt = LocalDate.parse(datFinal, dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    datFimLdt = null;
                }
            }
            String tipoEnsaio = request.getParameter("ensaio");
            String tipoLigante = request.getParameter("tipoLigante");
            String sortBy = request.getParameter("sortBy");
            String sortDesc = request.getParameter("sortDesc");
            if (sortDesc != null) {
                if (sortDesc.equals("false")) {
                    sortDesc = null;
                } else if (sortDesc.equals("true")) {
                    sortDesc = " DESC ";
                }
            }
            Integer fornecedor = null;
            if (request.getParameter("fornecedor") != null) {
                fornecedor = Integer.valueOf(request.getParameter("fornecedor"));
            }
            Map mapData = this.dashboardEnsaiosHelper.execute(empresas, datIniLdt, datFimLdt, rodovias, grupo, tipoEnsaio, tipoLigante, contrato, numeroInicial, numeroFinal, sortBy, sortDesc, usuario.getLogin(), fornecedor, Boolean.valueOf(poderConcedente));
            return new ResponseEntity((Object)mapData, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findDashboard", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, path={"/{empresa}/dashboards/exportPdf"})
    @Operation(summary="Exporta a dashboard em formato PDF")
    public ResponseEntity<byte[]> exportDashboardPdf(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="unidades", required=false) List<String> unidades, @RequestParam(name="datInicial", defaultValue="", required=false) String datInicial, @RequestParam(name="datFinal", defaultValue="", required=false) String datFinal, @RequestParam(name="grupo", defaultValue="", required=false) List<String> grupo, @RequestParam(name="numeroInicial", defaultValue="", required=false) String numeroInicial, @RequestParam(name="numeroFinal", defaultValue="", required=false) String numeroFinal, @RequestParam(name="contrato", defaultValue="", required=false) String contrato, @RequestParam(name="rodovias", required=false) List<Integer> rodovias) {
        logger.debug("Executando exportDashboardPdf(emp={})...", (Object)empresa);
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "LAB_DASHBOARDS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"LAB_DASHBOARDS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            logger.debug("{} - exportDashboardPdf ({}))", (Object)usuario.getLogin(), (Object)empresa);
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            if (multipartReq == null || multipartReq.getFileMap() == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 gr\u00e1ficos enviados.");
            }
            Map files = multipartReq.getFileMap();
            ArrayList<InputStream> graficos = new ArrayList<InputStream>();
            for (String fileName : files.keySet()) {
                graficos.add(((MultipartFile)files.get(fileName)).getInputStream());
            }
            byte[] bytes = this.relatorioDashboardEnsaiosPdf.executePDF(emp.getId(), unidades, datInicial, datFinal, grupo, numeroInicial, numeroFinal, contrato, rodovias, graficos, usuario.getNome());
            if (bytes == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"dashboard.pdf\"");
            headers.add("Content-Type", "application/pdf");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException | IOException bizoExc) {
            logger.error("bizExc", bizoExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizoExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/projetos/{idProjeto}/count"})
    @Operation(summary="Retorna a contagem dos projetos em ensaios")
    public ResponseEntity<Integer> getCountProjetoEnsaios(@PathVariable(name="empresa") String empresa, @PathVariable(name="idProjeto") Integer idProjeto, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("getCountProjetoEnsaios({}, {}, {})", new Object[]{usuario, empresa, idProjeto});
        try {
            return new ResponseEntity((Object)this.laboratorioService.getCountProjetoEnsaios(idProjeto), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCountProjetoEnsaios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, path={"/{empresa}/fichas/upload"})
    @Operation(summary="Efetua a importa\u00e7\u00e3o da planilha para o ensaio, de acordo com o padr\u00e3o normatizado estabelecido.", description="Tipo de ensaio deve ser informado em par\u00e2metro e conforme os padr\u00f5es (Ex: MIS/PIS) ")
    @ResponseBody
    public ResponseEntity<Map<String, Object>> importFichaEnsaio(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "UPLOAD_FICHA_ENSAIO");
        if (!permissao.booleanValue()) {
            logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"UPLOAD_FICHA_ENSAIO");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
        }
        String tipoEnsaio = request.getParameter("tipoEnsaio");
        if (tipoEnsaio == null || tipoEnsaio.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Tipo de ensaio n\u00e3o foi informado.");
        }
        String projeto = request.getParameter("idProjeto");
        if (projeto == null || projeto.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Projeto n\u00e3o foi informado.");
        }
        Integer idProjeto = Integer.valueOf(projeto);
        ProjetoEnsaio proj = this.laboratorioService.getProjetoById(empresa, idProjeto);
        if (proj == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Projeto informado n\u00e3o foi encontrado.");
        }
        StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
        if (multipartReq == null || multipartReq.getFileMap() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 arquivos enviados pelo Upload.");
        }
        String nomeFicha = request.getParameter("nomeFicha");
        String descricaoFicha = request.getParameter("descricaoFicha");
        if ((nomeFicha == null || nomeFicha.isEmpty()) && (descricaoFicha == null || descricaoFicha.isEmpty())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "\u00c9 necess\u00e1rio informar Nome ou Descri\u00e7\u00e3o da Ficha.");
        }
        Map files = multipartReq.getFileMap();
        MultipartFile uploadFile = null;
        for (String fileName : files.keySet()) {
            uploadFile = (MultipartFile)files.get(fileName);
        }
        if (uploadFile == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 arquivos para processamento.");
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            String resourcePath = (String)this.coreService.getRefValueByName(emp.getId(), TipoRefCode.INFRA_PATH_GERAL);
            List filesFicha = this.gedService.findAnexosByModulo(emp.getId(), TipoModulo.LABORATORIO, null, nomeFicha, null);
            if (filesFicha == null || filesFicha.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Modelo/ficha n\u00e3o encontrada. ('" + nomeFicha + "')");
            }
            String planilha = request.getParameter("planilha");
            String preProcessar = multipartReq.getParameter("preProcessar");
            if (preProcessar != null && !preProcessar.isEmpty()) {
                BaseImportHelper baseImport = new BaseImportHelper();
                Map planilhasMap = baseImport.fillPlanilhas(uploadFile.getInputStream(), "FE");
                payload.putAll(planilhasMap);
            } else {
                List jsonFiles = null;
                Path jsonPath = Paths.get(resourcePath, "json");
                try (Stream<Path> walk = Files.walk(jsonPath, new FileVisitOption[0]);){
                    jsonFiles = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                }
                catch (Exception ioExc) {
                    logger.error("IOExc", (Throwable)ioExc);
                    return null;
                }
                String nomeArquivo = ((Anexo)filesFicha.get(0)).getNome();
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                for (String paramName : request.getParameterMap().keySet()) {
                    paramsMap.put(paramName, request.getParameter(paramName));
                }
                Ensaio ensaioData = this.uploadHelper.upload(empresa, emp.getId(), tipoEnsaio, uploadFile.getInputStream(), planilha, nomeFicha, nomeArquivo, jsonFiles, idProjeto, paramsMap, usuario.getLogin());
                if (ensaioData != null) {
                    payload.put("idEnsaio", ensaioData.getId());
                    payload.put("tipoEnsaio", ensaioData.getTipo());
                    payload.put("grupoEnsaio", ensaioData.getGrupo());
                }
            }
            return new ResponseEntity(payload, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException | IOException bizExc) {
            logger.error("BizExc.importFichaEnsaio", bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/fichas/download/{idEnsaio}"})
    @Operation(summary="Efetua o download das fichas de ensaio em formato de planilha normatizada")
    public ResponseEntity<byte[]> exportFichaExcel(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, @RequestParam(name="nomeFicha", required=true) String nomeFicha) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "FICHAS_DOWNLOAD");
        if (!permissao.booleanValue()) {
            logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"FICHAS_DOWNLOAD");
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
        }
        logger.debug("Exportando ficha Excel, ficha (emp={}, {}, idEnsaio)...", new Object[]{empresa, nomeFicha, idEnsaio});
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        String resourcePath = (String)this.coreService.getRefValueByName(emp.getId(), TipoRefCode.INFRA_PATH_GERAL);
        List filesFicha = this.gedService.findAnexosByModulo(emp.getId(), TipoModulo.LABORATORIO, "Fichas", null, null);
        Anexo fichaGed = null;
        for (Anexo ficha : filesFicha) {
            if (!ficha.getNome().equalsIgnoreCase(nomeFicha) && !ficha.getDescricao().equalsIgnoreCase(nomeFicha)) continue;
            fichaGed = ficha;
            break;
        }
        if (fichaGed == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Modelo/ficha n\u00e3o encontrada. ('" + nomeFicha + "')");
        }
        InputStream xlsStream = this.gedService.getStreamByUUID(emp.getId(), fichaGed.getUuid(), null);
        List jsonFiles = null;
        Path jsonPath = Paths.get(resourcePath, "json");
        try (Stream<Path> walk = Files.walk(jsonPath, new FileVisitOption[0]);){
            jsonFiles = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        }
        catch (Exception ioExc) {
            logger.error("IOExc", (Throwable)ioExc);
            return null;
        }
        Ensaio ensaio = this.laboratorioService.getEnsaio(empresa, idEnsaio, usuario.getLogin());
        if (ensaio == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Ensaio n\u00e3o foi encontrado para o ID informado.");
        }
        try {
            String nomeArquivo = fichaGed != null ? fichaGed.getNome() : null;
            Map reqParams = request.getParameterMap();
            byte[] bytes = this.downloadHelper.download(empresa, xlsStream, ensaio.getTipo(), nomeFicha, nomeArquivo, ensaio, jsonFiles, reqParams, usuario.getLogin());
            xlsStream.close();
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            String fichaBaseName = FilenameUtils.removeExtension((String)nomeFicha);
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", String.format("attachment; filename=\"ensaio-%s.xlsx\"", fichaBaseName));
            headers.add("Content-Type", "application/octet-stream");
            if (bytes != null && bytes.length > 0) {
                this.laboratorioService.criarHistorico(ensaio.getIdEmpresa(), ensaio.getId(), "Download de Ensaio/Ficha", null, usuario);
            }
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (FileNotFoundException fnfExc) {
            logger.error("FNfExc", (Throwable)fnfExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Arquivo n\u00e3o foi encontrado.");
        }
        catch (IOException ioExc) {
            logger.error("IOExc", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Erro I/O no arquivo de configura\u00e7\u00e3o.");
        }
        catch (InvalidFormatException fmtExc) {
            logger.error("FMTExc", (Throwable)fmtExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Formato inv\u00e1lido da planilha.");
        }
    }

    @GetMapping(path={"/{empresa}/numeros/{idEnsaio}"})
    @Operation(summary="Busca a estrutura de numera\u00e7\u00e3o do ensaio informado, atrav\u00e9s do seu n\u00famero")
    public ResponseEntity<EnsaioNumero> findEnsaioNumero(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEnsaio") Integer idEnsaio, HttpServletRequest request) throws BusinessException {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "VISUALIZAR_ENSAIOS");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"VISUALIZAR_ENSAIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - findEnsaioNumero ({}, {}))", new Object[]{usuario.getLogin(), empresa, idEnsaio});
            return new ResponseEntity((Object)this.laboratorioService.getEnsaioNumeroByIdEnsaio(empresa, idEnsaio), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEnsaioNumero", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

