/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.core;

import br.com.oti.gesconsys.beans.ativos.TipoAtivo;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.ProcessoImportacao;
import br.com.oti.gesconsys.business.helper.BaseImportHelper;
import br.com.oti.gesconsys.business.helper.ImportacaoAtivosHelper;
import br.com.oti.gesconsys.business.helper.ImportacaoObrigacaoHelper;
import br.com.oti.gesconsys.business.helper.ImportacaoSigacoHelper;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Importa\u00e7\u00f5es em Planilhas", name="core")
@RequestMapping(value={"/api/importacoes"})
public class ImportacoesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(ImportacoesRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private ImportacaoObrigacaoHelper importaObrigacaoHelper;
    @Autowired
    private ImportacaoAtivosHelper importaAtivosHelper;
    @Autowired
    private ImportacaoSigacoHelper importaSigacoHelper;

    @PostMapping(consumes={"multipart/form-data"}, path={"/{empresa}/{modulo}"})
    @Operation(summary="Efetua a importa\u00e7\u00e3o ou atualiza\u00e7\u00e3o dos dados de item, para a empresa e m\u00f3dulo definidos.", description="M\u00f3dulo, deve ser informado conforme padr\u00f5es [OBR, CRP, PLT, ...]")
    @ResponseBody
    public ResponseEntity<Map<String, Object>> executeImportacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        logger.debug("Iniciando importa\u00e7\u00e3o, usu\u00e1rio={}, empresa={}, modulo={}", new Object[]{empresa, usuario.getLogin(), modulo});
        Empresa empresaDB = this.cadastroService.getEmpresaBySigla(empresa);
        if (empresaDB == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        PublicUser userDB = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (userDB == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o foi encontrado.");
        }
        if (modulo == null || modulo.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "M\u00f3dulo relacionado n\u00e3o foi informado.");
        }
        try {
            MultiValueMap allFiles;
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            String preProcessar = multipartReq.getParameter("preProcessar");
            String planilha = multipartReq.getParameter("planilha");
            int headerRows = 1;
            String param = multipartReq.getParameter("headerRows");
            if (param != null && !param.isEmpty()) {
                headerRows = Integer.valueOf(param);
            }
            String colunasTxt = multipartReq.getParameter("colunasImportar");
            List colunasImportacao = null;
            if (colunasTxt != null && !colunasTxt.isEmpty()) {
                ObjectMapper mapper = new ObjectMapper();
                colunasImportacao = (List)mapper.readValue(colunasTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            String tipoAtivo = multipartReq.getParameter("tipoAtivo");
            String subtipo = multipartReq.getParameter("subtipo");
            Integer faseMonitoracao = null;
            Integer cicloMonitoracao = null;
            Integer rodovia = null;
            if (multipartReq.getParameter("faseMonitoracao") != null) {
                faseMonitoracao = Integer.valueOf(multipartReq.getParameter("faseMonitoracao"));
            }
            if (multipartReq.getParameter("cicloMonitoracao") != null) {
                cicloMonitoracao = Integer.valueOf(multipartReq.getParameter("cicloMonitoracao"));
            }
            if (multipartReq.getParameter("rodovia") != null) {
                rodovia = Integer.valueOf(multipartReq.getParameter("rodovia"));
            }
            if ((allFiles = multipartReq.getMultiFileMap()) != null && !allFiles.isEmpty()) {
                HashMap<String, ProcessoImportacao> payload = new HashMap<String, ProcessoImportacao>();
                for (String filesKeyName : allFiles.keySet()) {
                    List files = (List)allFiles.get((Object)filesKeyName);
                    for (MultipartFile file : files) {
                        List importados;
                        logger.debug("Upload original.fileName={}", (Object)file.getOriginalFilename());
                        if (preProcessar != null && !preProcessar.isEmpty()) {
                            BaseImportHelper baseHelper = new BaseImportHelper();
                            payload.putAll(baseHelper.preProcess(file.getInputStream()));
                            continue;
                        }
                        if (modulo.toUpperCase().equals(TipoModulo.OBRIGACOES.getSigla())) {
                            ProcessoImportacao itens = this.importaObrigacaoHelper.importarObrigacoes(empresaDB.getId(), file.getInputStream(), userDB.getId());
                            payload.put("processo", itens);
                            continue;
                        }
                        if (modulo.toUpperCase().equals(TipoModulo.ATIVOS.getSigla())) {
                            if (tipoAtivo == null || tipoAtivo.isEmpty()) {
                                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Tipo de ativo n\u00e3o foi informado.");
                            }
                            String[] colunasPlanilhaRaw = multipartReq.getParameterValues("colunasPlanilha");
                            ArrayList<String> colunasPlanilha = new ArrayList<String>();
                            if (colunasPlanilhaRaw != null) {
                                colunasPlanilha.addAll(Arrays.asList(colunasPlanilhaRaw));
                            }
                            String tipoEntrega = multipartReq.getParameter("tipoEntrega");
                            param = multipartReq.getParameter("cronogramaEntrega");
                            if (param == null || param.isEmpty()) {
                                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Cronograma de Entrega n\u00e3o informado.");
                            }
                            Integer cronogramaEntrega = Integer.valueOf(param);
                            ProcessoImportacao processo = this.importaAtivosHelper.importarMonitoracoes(empresa, TipoAtivo.fromCode((String)tipoAtivo), subtipo, cicloMonitoracao, tipoEntrega, cronogramaEntrega, file.getInputStream(), usuario.getLogin(), planilha, Integer.valueOf(headerRows), colunasImportacao, colunasPlanilha);
                            payload.put("processo", processo);
                            continue;
                        }
                        if (!modulo.toUpperCase().equals(TipoModulo.SIGACO.getSigla())) continue;
                        if (tipoAtivo == null || tipoAtivo.isEmpty()) {
                            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Tipo de ativo n\u00e3o foi informado.");
                        }
                        String tipoElemento = multipartReq.getParameter("tipoElemento");
                        Integer idTipoElemento = null;
                        if (tipoElemento != null && !tipoElemento.isEmpty()) {
                            try {
                                idTipoElemento = Integer.valueOf(tipoElemento);
                            }
                            catch (NumberFormatException nmfExc) {
                                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Formato do Tipo de elemento inv\u00e1lido.");
                            }
                        }
                        String tipoImportacao = multipartReq.getParameter("tipoImportacao");
                        String[] colunasPlanilhaRaw = multipartReq.getParameterValues("colunasPlanilha");
                        ArrayList<String> colunasPlanilha = new ArrayList<String>();
                        if (colunasPlanilhaRaw != null) {
                            colunasPlanilha.addAll(Arrays.asList(colunasPlanilhaRaw));
                        }
                        String importacao = multipartReq.getParameter("importacao");
                        Integer idImportacao = null;
                        if (importacao != null && !importacao.isEmpty()) {
                            try {
                                idImportacao = Integer.valueOf(importacao);
                            }
                            catch (NumberFormatException nmfExc) {
                                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Sequ\u00eancia da importa\u00e7\u00e3o inv\u00e1lida (" + importacao + ").");
                            }
                        }
                        if (tipoImportacao == null || tipoImportacao.isEmpty() || tipoImportacao.equalsIgnoreCase("dados")) {
                            ProcessoImportacao processo = this.importaSigacoHelper.importarMonitoracoes(empresa, TipoAtivo.fromCode((String)tipoAtivo), subtipo, idTipoElemento, faseMonitoracao, rodovia, idImportacao, userDB.getId(), file.getInputStream(), planilha, Integer.valueOf(headerRows), colunasImportacao, colunasPlanilha);
                            payload.put("processo", processo);
                            continue;
                        }
                        if (tipoImportacao.equalsIgnoreCase("imagens")) {
                            this.importaSigacoHelper.importarImagensMonitoracao(empresa, TipoAtivo.fromCode((String)tipoAtivo), faseMonitoracao, file, usuario.getLogin());
                            continue;
                        }
                        if (tipoImportacao.equalsIgnoreCase("anexos")) {
                            this.importaSigacoHelper.importarAnexosMonitoracao(empresa, TipoAtivo.fromCode((String)tipoAtivo), faseMonitoracao, file, usuario.getLogin());
                            continue;
                        }
                        if (!tipoImportacao.equalsIgnoreCase("planosAcao") || (importados = this.importaSigacoHelper.importarPlanosAcao(empresa, TipoAtivo.fromCode((String)tipoAtivo), rodovia, faseMonitoracao, file, usuario.getLogin())) != null && !importados.isEmpty()) continue;
                        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o foram encontrados dados para importa\u00e7\u00e3o/atualiza\u00e7\u00e3o.");
                    }
                }
                return new ResponseEntity(payload, (HttpStatusCode)HttpStatus.CREATED);
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 arquivos de carga para processamento.");
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.executeImportacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("IOExc.executeImportacao", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }
}

