/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.conserva;

import br.com.oti.gesconsys.beans.conserva.SolicitacaoServico;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.solicitacao.SolicitacaoServicoItem;
import br.com.oti.gesconsys.business.services.ConservaService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Solicita\u00e7\u00f5es de Servi\u00e7os", name="solicitacoes-servicos")
@RequestMapping(value={"/api/solicitacoes"})
public class SolicitacoesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(SolicitacoesRestServices.class);
    private static DateTimeFormatter dataHoraFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static NumberFormat nbrFmt = DecimalFormat.getInstance();
    @Autowired
    private ConservaService conservaService;
    @Autowired
    private GedService gedService;
    @Autowired
    private SegurancaService segurancaService;

    @PostMapping(consumes={"multipart/form-data"})
    @Operation(summary="Efetua o registro da solicita\u00e7\u00e3o, juntamente com a(s) imagem(ns) relacionada(s)")
    @ResponseBody
    public ResponseEntity<SolicitacaoServico> registrar(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Iniciando registro Solicita\u00e7\u00e3o (Upload)...");
        Integer idEmpresa = null;
        Integer idEquipe = null;
        LocalDateTime dataLancamento = null;
        String mobileGuid = null;
        String latitude = null;
        String longitude = null;
        Double kmInicial = null;
        Double kmFinal = null;
        String observacao = null;
        String descricao = null;
        Integer idRodovia = null;
        Integer idTrecho = null;
        Integer idGrupoServico = null;
        Double quantidade = null;
        try {
            Map formData = request.getParameterMap();
            if (formData.containsKey("idEmpresa")) {
                idEmpresa = Integer.valueOf(((String[])formData.get("idEmpresa"))[0]);
            }
            if (formData.containsKey("idRodovia")) {
                idRodovia = Integer.valueOf(((String[])formData.get("idRodovia"))[0]);
            }
            if (formData.containsKey("idTrecho")) {
                idTrecho = Integer.valueOf(((String[])formData.get("idTrecho"))[0]);
            }
            if (formData.containsKey("idMobile")) {
                mobileGuid = ((String[])formData.get("idMobile"))[0];
            }
            if (formData.containsKey("dataLancamento")) {
                dataLancamento = LocalDateTime.parse(((String[])formData.get("dataLancamento"))[0], dataHoraFmt);
            }
            if (formData.containsKey("idGrupoServico")) {
                idGrupoServico = Integer.valueOf(((String[])formData.get("idGrupoServico"))[0]);
            }
            Number posNbr = null;
            if (formData.containsKey("quantidade")) {
                posNbr = nbrFmt.parse(((String[])formData.get("quantidade"))[0]);
                quantidade = posNbr.doubleValue();
            }
            if (formData.containsKey("latitude")) {
                latitude = ((String[])formData.get("latitude"))[0];
            }
            if (formData.containsKey("longitude")) {
                longitude = ((String[])formData.get("longitude"))[0];
            }
            if (formData.containsKey("kmInicial")) {
                kmInicial = Double.valueOf(((String[])formData.get("kmInicial"))[0]);
            }
            if (formData.containsKey("kmFinal")) {
                kmFinal = Double.valueOf(((String[])formData.get("kmFinal"))[0]);
            }
            if (formData.containsKey("idEquipe")) {
                idEquipe = Integer.valueOf(((String[])formData.get("idEquipe"))[0]);
            }
            if (formData.containsKey("observacao")) {
                observacao = ((String[])formData.get("observacao"))[0];
            }
            if (formData.containsKey("descricao")) {
                descricao = ((String[])formData.get("descricao"))[0];
            }
        }
        catch (NumberFormatException nmfExc) {
            logger.error("NmfExc", (Throwable)nmfExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, nmfExc.toString());
        }
        catch (ParseException parExc) {
            logger.error("ParExc", (Throwable)parExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, parExc.toString());
        }
        Integer idSolicita = null;
        SolicitacaoServico solicita = this.conservaService.getSolicitacaoByGUID(idEmpresa, usuario.getLogin(), mobileGuid);
        if (solicita == null) {
            logger.debug("Novo lan\u00e7amento, registrando...");
            SolicitacaoServicoItem item = this.conservaService.registrarSolicitacao(idEmpresa, mobileGuid, usuario.getLogin(), idRodovia, idTrecho, idGrupoServico, dataLancamento, descricao, quantidade, latitude, longitude, idEquipe, kmInicial, kmFinal, observacao, request.getRemoteAddr());
            if (item != null) {
                solicita = item.getSolicitacao();
                idSolicita = item.getId().getIdSolicitacao();
                logger.debug("Iniciando upload, lancamento={}", (Object)idSolicita);
                Integer idArea = null;
                try {
                    StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
                    List files = multipartReq.getFiles("files[]");
                    if (files != null) {
                        PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
                        MultipartFile file = (MultipartFile)files.get(0);
                        logger.debug("Upload original.fileName={}", (Object)file.getOriginalFilename());
                        Anexo anexo = this.gedService.createAnexo(item.getId().getIdEmpresa(), TipoModulo.CONSERVACAO.getSigla(), "Itens", "Solicita\u00e7\u00f5es\\Imagens", file.getOriginalFilename(), idArea, file, user.getId(), LocalDateTime.now());
                        if (anexo != null) {
                            this.conservaService.updateAnexoItem(item.getId().getIdEmpresa(), item.getId().getIdSolicitacao(), item.getId().getSequencia(), anexo.getId().getIdAnexo());
                        }
                    }
                }
                catch (BusinessException bizExc) {
                    logger.error("BizExc", (Throwable)bizExc);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
                }
            }
        }
        return new ResponseEntity((Object)solicita, (HttpStatusCode)HttpStatus.CREATED);
    }
}

