/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.beans;

import br.com.oti.gesconsys.beans.conserva.Previsto;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

public class PrevistoJson {
    private Integer idEmpresa;
    private Integer idPrevisto;
    private String descricao;
    private String equipe;
    private String rodovia;
    private String usuario;
    private Double kmInicial;
    private Double kmFinal;
    private LocalDate dataInicial;
    private LocalDate dataFinal;
    private String observacaoEquipe;
    private String observacaoAdicional;
    private Integer idEquipe;
    private String descricaoEquipe;
    private Integer idRodovia;
    private String siglaRodovia;
    private Integer idServico;
    private String descricaoServico;
    private String descricaoUnidade;

    public PrevistoJson() {
    }

    public PrevistoJson(Previsto previsto) {
        this();
        if (previsto != null) {
            this.idEmpresa = previsto.getId().getIdEmpresa();
            this.idPrevisto = previsto.getId().getIdPrevisto();
            this.dataInicial = Instant.ofEpochMilli(previsto.getDatHorInicio().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
            if (previsto.getDatHorTermino() != null) {
                this.dataFinal = Instant.ofEpochMilli(previsto.getDatHorTermino().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
            }
            this.descricao = previsto.getDescricao();
            this.observacaoAdicional = previsto.getObservacaoAdicional();
            this.observacaoEquipe = previsto.getObservacaoEquipe();
            if (previsto.getKmInicial() != null) {
                this.kmInicial = previsto.getKmInicial().doubleValue();
            }
            if (previsto.getKmFinal() != null) {
                this.kmFinal = previsto.getKmFinal().doubleValue();
            }
            this.idEquipe = previsto.getIdEquipe();
            if (previsto.getIdEquipe() != null) {
                this.descricaoEquipe = previsto.getEquipe().getDescricao();
            }
            this.idRodovia = previsto.getIdRodovia();
            if (previsto.getIdRodovia() != null) {
                this.siglaRodovia = previsto.getRodovia().getDescricao();
            }
            this.idServico = previsto.getIdServico();
            if (previsto.getIdServico() != null) {
                this.descricaoServico = previsto.getServico().getDescricao();
                if (previsto.getServico().getIdUnidade() != null) {
                    this.descricaoUnidade = previsto.getServico().getUnidade().getSigla();
                }
            }
        }
    }

    public Integer getIdEmpresa() {
        return this.idEmpresa;
    }

    public void setIdEmpresa(Integer idEmpresa) {
        this.idEmpresa = idEmpresa;
    }

    public Integer getIdPrevisto() {
        return this.idPrevisto;
    }

    public void setIdPrevisto(Integer idPrevisto) {
        this.idPrevisto = idPrevisto;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public String getEquipe() {
        return this.equipe;
    }

    public void setEquipe(String equipe) {
        this.equipe = equipe;
    }

    public String getRodovia() {
        return this.rodovia;
    }

    public void setRodovia(String rodovia) {
        this.rodovia = rodovia;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public Double getKmInicial() {
        return this.kmInicial;
    }

    public void setKmInicial(Double kmInicial) {
        this.kmInicial = kmInicial;
    }

    public Double getKmFinal() {
        return this.kmFinal;
    }

    public void setKmFinal(Double kmFinal) {
        this.kmFinal = kmFinal;
    }

    public LocalDate getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(LocalDate dataInicial) {
        this.dataInicial = dataInicial;
    }

    public LocalDate getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(LocalDate dataFinal) {
        this.dataFinal = dataFinal;
    }

    public String getObservacaoEquipe() {
        return this.observacaoEquipe;
    }

    public void setObservacaoEquipe(String observacaoEquipe) {
        this.observacaoEquipe = observacaoEquipe;
    }

    public String getObservacaoAdicional() {
        return this.observacaoAdicional;
    }

    public void setObservacaoAdicional(String observacaoAdicional) {
        this.observacaoAdicional = observacaoAdicional;
    }

    public Integer getIdEquipe() {
        return this.idEquipe;
    }

    public void setIdEquipe(Integer idEquipe) {
        this.idEquipe = idEquipe;
    }

    public String getDescricaoEquipe() {
        return this.descricaoEquipe;
    }

    public void setDescricaoEquipe(String descricaoEquipe) {
        this.descricaoEquipe = descricaoEquipe;
    }

    public Integer getIdRodovia() {
        return this.idRodovia;
    }

    public void setIdRodovia(Integer idRodovia) {
        this.idRodovia = idRodovia;
    }

    public String getSiglaRodovia() {
        return this.siglaRodovia;
    }

    public void setSiglaRodovia(String siglaRodovia) {
        this.siglaRodovia = siglaRodovia;
    }

    public Integer getIdServico() {
        return this.idServico;
    }

    public void setIdServico(Integer idServico) {
        this.idServico = idServico;
    }

    public String getDescricaoServico() {
        return this.descricaoServico;
    }

    public void setDescricaoServico(String descricaoServico) {
        this.descricaoServico = descricaoServico;
    }

    public String getDescricaoUnidade() {
        return this.descricaoUnidade;
    }

    public void setDescricaoUnidade(String descricaoUnidade) {
        this.descricaoUnidade = descricaoUnidade;
    }

    public String toString() {
        return "PrevistoJson [idEmpresa=" + this.idEmpresa + ", idPrevisto=" + this.idPrevisto + ", descricao=" + this.descricao + ", equipe=" + this.equipe + ", rodovia=" + this.rodovia + ", usuario=" + this.usuario + ", kmInicial=" + this.kmInicial + ", kmFinal=" + this.kmFinal + ", dataInicial=" + this.dataInicial + ", dataFinal=" + this.dataFinal + ", observacaoEquipe=" + this.observacaoEquipe + ", observacaoAdicional=" + this.observacaoAdicional + ", idEquipe=" + this.idEquipe + ", descricaoEquipe=" + this.descricaoEquipe + ", idRodovia=" + this.idRodovia + ", siglaRodovia=" + this.siglaRodovia + ", idServico=" + this.idServico + ", descricaoServico=" + this.descricaoServico + ", descricaoUnidade=" + this.descricaoUnidade + "]";
    }
}

