/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ativos;

import br.com.oti.gesconsys.beans.ativos.CronogramaEntrega;
import br.com.oti.gesconsys.beans.ativos.ImportacaoMonitoracao;
import br.com.oti.gesconsys.beans.ativos.Monitoracao;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoAnexo;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoDrenagem;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoEps;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoHistorico;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoImagem;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoParametro;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoSinalizacaoHorizontal;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoSinalizacaoVertical;
import br.com.oti.gesconsys.beans.ativos.MonitoracaoTerrapleno;
import br.com.oti.gesconsys.beans.ativos.TipoAtivo;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.AtivoService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.ativos.ExportModeloImportacaoMonitoracaoExcel;
import br.com.oti.gesconsys.reports.ativos.ExportMonitoracaoExcel;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Monitora\u00e7\u00f5es/Inspe\u00e7\u00f5es dos ativos", name="ativos")
@RequestMapping(value={"/api/monitoracoes/ativos"})
public class MonitoracoesRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(MonitoracoesRestServices.class);
    @Autowired
    private AtivoService ativoService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private ExportModeloImportacaoMonitoracaoExcel modeloImportacaoExcel;

    @GetMapping(value={"/{empresa}/{tipo}/{tipoAtivo}"})
    public ResponseEntity<List<Monitoracao>> findMonitoracoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipo") String tipo, @PathVariable(name="tipoAtivo") String tipoAtivo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findMonitoracoes({})", (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ArrayList<Integer> ciclos = new ArrayList<Integer>();
            String[] params = request.getParameterValues("ciclos");
            if (params != null && params.length > 0) {
                ciclos = new ArrayList();
                for (String iteParm : params) {
                    ciclos.add(Integer.valueOf(iteParm));
                }
            }
            Integer idRodovia = null;
            Integer idCategoria = null;
            String situacao = null;
            String param = request.getParameter("rodovia");
            if (param != null) {
                idRodovia = Integer.valueOf(param);
            }
            if ((param = request.getParameter("categoria")) != null) {
                idCategoria = Integer.valueOf(param);
            }
            situacao = request.getParameter("situacao");
            TipoAtivo tipoAtv = TipoAtivo.fromCode((String)tipoAtivo);
            String[] empresasArray = request.getParameterValues("empresa");
            ArrayList<String> empresasLst = new ArrayList<String>();
            if (empresasArray != null && empresasArray.length > 0) {
                for (String emp : empresasArray) {
                    empresasLst.add(emp);
                }
            } else {
                empresasLst.add(empresa);
            }
            Map reqParams = request.getParameterMap();
            HashMap<String, String> paramsAtivos = new HashMap<String, String>();
            for (String paramKey : reqParams.keySet()) {
                String[] paramValues = (String[])reqParams.get(paramKey);
                if (paramValues.length <= 0) continue;
                String paramValue = paramValues[0];
                paramsAtivos.put(paramKey, paramValue);
            }
            return ResponseEntity.ok().body((Object)this.ativoService.findMonitoracoes(empresasLst, tipoAtv, tipo, ciclos, idRodovia, idCategoria, situacao, null, null, null, null, null, paramsAtivos));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findMonitoracoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}"})
    public ResponseEntity<Monitoracao> getMonitoracaoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getMonitoracaoById({}, {})", (Object)empresa, (Object)idMonitoracao);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getMonitoracaoById(empresa, idMonitoracao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getMonitoracaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/drenagens"})
    public ResponseEntity<Monitoracao> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoDrenagem monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveMonitoracao({}, {})", new Object[]{usuario.getLogin(), empresa, monitoracao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Monitoracao monitoracaoDB = this.ativoService.saveMonitoracao(empresa, (Monitoracao)monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[DRE]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/sinalizacoesHorizontais"})
    public ResponseEntity<Monitoracao> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoSinalizacaoHorizontal monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveMonitoracao({}, {})", new Object[]{usuario.getLogin(), empresa, monitoracao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            MonitoracaoSinalizacaoHorizontal monitoracaoDB = this.ativoService.saveMonitoracao(empresa, monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[SNH]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/sinalizacoesVerticais"})
    public ResponseEntity<Monitoracao> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoSinalizacaoVertical monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveMonitoracao({}, {})", new Object[]{usuario.getLogin(), empresa, monitoracao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            MonitoracaoSinalizacaoVertical monitoracaoDB = this.ativoService.saveMonitoracao(empresa, monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[SNV]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/equipamentosSeguranca"})
    public ResponseEntity<Monitoracao> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoEps monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveMonitoracao({}, {})", new Object[]{usuario.getLogin(), empresa, monitoracao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Monitoracao monitoracaoDB = this.ativoService.saveMonitoracao(empresa, (Monitoracao)monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[EPS]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/terraplenos"})
    public ResponseEntity<Monitoracao> saveMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody MonitoracaoTerrapleno monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - saveMonitoracao({}, {})", new Object[]{usuario.getLogin(), empresa, monitoracao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Monitoracao monitoracaoDB = this.ativoService.saveMonitoracao(empresa, (Monitoracao)monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveMonitoracao[TEC]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{empresa}"})
    public ResponseEntity<Monitoracao> updateMonitoracao(@PathVariable(name="empresa") String empresa, @RequestBody Monitoracao monitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_ALTERAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_ALTERAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Monitoracao monitoracaoDB = this.ativoService.saveMonitoracao(empresa, monitoracao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)monitoracaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateMonitoracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idMonitoracao}"})
    public ResponseEntity<Boolean> deleteMonitoracao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteMonitoracao(empresa, idMonitoracao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteMonitoracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/parametros"})
    public ResponseEntity<List<MonitoracaoParametro>> findParametros(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) {
        try {
            logger.debug("findMonitoracaosParametros({}, {})", (Object)empresa, (Object)idMonitoracao);
            return ResponseEntity.ok().body((Object)this.ativoService.findParametrosMonitoracao(empresa, idMonitoracao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findMonitoracaosParametros", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/parametros/{seqParametro}"})
    public ResponseEntity<MonitoracaoParametro> getParametroById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @PathVariable(name="seqParametro") Integer seqParametro) {
        try {
            logger.debug("getParametroById({}, {}, {})", new Object[]{empresa, idMonitoracao, seqParametro});
            return ResponseEntity.ok().body((Object)this.ativoService.getParametroMonitoracaoById(empresa, idMonitoracao, seqParametro));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getParametroById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idMonitoracao}/parametros"})
    public ResponseEntity<MonitoracaoParametro> saveParametro(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @RequestBody MonitoracaoParametro parametro, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            MonitoracaoParametro parametroDB = this.ativoService.saveParametroMonitoracao(parametro, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)parametroDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveParametro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idMonitoracao}/parametros/{seqParametro}"})
    public ResponseEntity<Boolean> deleteParametro(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @PathVariable(name="seqParametro") Integer seqParametro) throws BusinessException {
        try {
            logger.debug("deleteParametro({}, {}, {})", new Object[]{empresa, idMonitoracao, seqParametro});
            return new ResponseEntity((Object)this.ativoService.deleteParametroMonitoracao(empresa, idMonitoracao, seqParametro), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteParametro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/imagens"})
    public ResponseEntity<List<MonitoracaoImagem>> findImagens(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findImagens({})", (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_IMAGENS_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_IMAGENS_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.findImagensMonitoracao(empresa, idMonitoracao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findImagens", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/imagens/{sequencia}"})
    public ResponseEntity<MonitoracaoImagem> getImagemById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getImagemById({}, {})", (Object)empresa, (Object)idMonitoracao);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_IMAGEM_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_IMAGEM_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getImagemMonitoracaoById(empresa, idMonitoracao, sequencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getImagemById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{idMonitoracao}/imagens"})
    @ResponseBody
    public ResponseEntity<MonitoracaoImagem> saveImagem(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @RequestParam(name="file", required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("saveImagem({}, {})", (Object)empresa, (Object)idMonitoracao);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_IMAGEM_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_IMAGEM_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            String tipoMovto = null;
            String tipoImagem = null;
            if (formData.containsKey("tipoAtivo")) {
                tipoAtivo = ((String[])formData.get("tipoAtivo"))[0];
            }
            if (formData.containsKey("tipoMovimento")) {
                tipoMovto = ((String[])formData.get("tipoMovimento"))[0];
            }
            if (formData.containsKey("tipoImagem")) {
                tipoImagem = ((String[])formData.get("tipoImagem"))[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            MonitoracaoImagem imagemDB = this.ativoService.saveImagemMonitoracao(empresa, idMonitoracao, tipoAtivo, tipoImagem, tipoMovto, fileInfo, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)imagemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveImagem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("BizExc.saveImagem", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idMonitoramento}/imagens/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da Inspe\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteImagemMonitoracao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoramento") Integer idMonitoramento, @PathVariable(name="seqAnexo") Integer seqAnexo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteImagemMonitoracao({},{},{})", new Object[]{empresa, idMonitoramento, seqAnexo});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_IMAGEM_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_IMAGEM_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteImagemMonitoracao(empresa, idMonitoramento, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteImagemMonitoracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/anexos"})
    public ResponseEntity<List<MonitoracaoAnexo>> findAnexos(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findImagens({})", (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_ANEXOS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_ANEXOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.findAnexosMonitoracao(empresa, idMonitoracao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findImagens", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/anexos/{sequencia}"})
    public ResponseEntity<MonitoracaoAnexo> getAnexoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getAnexoById({}, {})", (Object)empresa, (Object)idMonitoracao);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_ANEXO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_ANEXO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getAnexoMonitoracaoById(empresa, idMonitoracao, sequencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAnexoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{idMonitoracao}/anexos"})
    @ResponseBody
    public ResponseEntity<MonitoracaoAnexo> saveAnexo(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, @RequestParam(name="file", required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("saveAnexo({}, {})", (Object)empresa, (Object)idMonitoracao);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_ANEXO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_ANEXO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            String tipoAnexo = null;
            if (formData.containsKey("tipoAtivo")) {
                tipoAtivo = ((String[])formData.get("tipoAtivo"))[0];
            }
            if (formData.containsKey("tipoAnexo")) {
                tipoAnexo = ((String[])formData.get("tipoAnexo"))[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            MonitoracaoAnexo imagemDB = this.ativoService.saveAnexoMonitoracao(empresa, idMonitoracao, tipoAtivo, tipoAnexo, fileInfo, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)imagemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("BizExc.saveAnexo", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idMonitoramento}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da Monitora\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoMonitoracao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoramento") Integer idMonitoramento, @PathVariable(name="seqAnexo") Integer seqAnexo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteAnexoMonitoracao({},{},{})", new Object[]{empresa, idMonitoramento, seqAnexo});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_ANEXO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_ANEXO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteAnexoMonitoracao(empresa, idMonitoramento, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{tipoAtivo}/exportacao"})
    @Operation(summary="Realiza o download das monitora\u00e7\u00f5es em formato de planilha")
    public ResponseEntity<byte[]> exportExcel(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        try {
            logger.debug("Exportando excel, monitora\u00e7\u00f5es (emp={}, atv={})...", (Object)empresa, (Object)tipoAtivo);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXPORTAR_MONITORACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXPORTAR_MONITORACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            TipoAtivo tipoAtivoEnum = TipoAtivo.fromCode((String)tipoAtivo);
            if (tipoAtivoEnum == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ativo [%s]n\u00e3o encontrado.", tipoAtivo));
            }
            Integer idTipoElemento = null;
            Integer idRodovia = null;
            String situacao = null;
            String param = null;
            ArrayList<Integer> ciclos = null;
            String[] params = request.getParameterValues("cicloMonitoracao");
            if (params != null && params.length > 0) {
                ciclos = new ArrayList<Integer>();
                if (params[0] != null && !params[0].isEmpty()) {
                    ciclos.add(Integer.valueOf(params[0]));
                }
            }
            if ((param = request.getParameter("rodovia")) != null) {
                idRodovia = Integer.valueOf(param);
            }
            situacao = request.getParameter("situacao");
            String[] empresasArray = request.getParameterValues("empresa");
            ArrayList<String> empresasLst = new ArrayList<String>();
            if (empresasArray != null && empresasArray.length > 0) {
                for (String emp : empresasArray) {
                    empresasLst.add(emp);
                }
            } else {
                empresasLst.add(empresa);
            }
            List monitoracoes = this.ativoService.findMonitoracoes(empresasLst, tipoAtivoEnum, "M", ciclos, idRodovia, idTipoElemento, situacao, null, null, null, null, null, null);
            byte[] bytes = new ExportMonitoracaoExcel().executeXLS(monitoracoes);
            if (bytes == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"monitoracoes.xlsx\"");
            headers.add("Content-Type", "application/octet-stream");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idMonitoracao}/historicosAtividades"})
    public ResponseEntity<List<MonitoracaoHistorico>> findHistoricosAtividades(@PathVariable(name="empresa") String empresa, @PathVariable(name="idMonitoracao") Integer idMonitoracao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findHistoricosAtividades({}, {}, {})", (Object)empresa, (Object)idMonitoracao);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_HISTORICO_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_HISTORICO_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.findHistoricosAtividades(empresa, idMonitoracao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosAtividades", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/importacoes/{empresa}"})
    public ResponseEntity<List<ImportacaoMonitoracao>> findImportacoes(@PathVariable(name="empresa") String empresa, @RequestParam(name="idCiclo", required=false) Integer idCiclo, @RequestParam(name="status", required=false) Integer status, @RequestParam(name="responsavel", required=false) String responsavel, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_IMPORTACOES");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_IMPORTACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String[] empresasArray = request.getParameterValues("empresas");
            String[] disciplinas = request.getParameterValues("disciplinas");
            logger.debug("{} - findImportacoes({}, {}, {}, {})", new Object[]{usuario.getLogin(), empresa, idCiclo, disciplinas, responsavel});
            ArrayList<String> empresasLst = new ArrayList<String>();
            ArrayList<String> disciplinasLst = new ArrayList<String>();
            if (empresasArray != null && empresasArray.length > 0) {
                for (String emp : empresasArray) {
                    empresasLst.add(emp);
                }
            } else {
                empresasLst.add(empresa);
            }
            if (disciplinas != null && disciplinas.length > 0) {
                for (String disc : disciplinas) {
                    disciplinasLst.add(disc);
                }
            }
            LocalDate datIniLdt = null;
            LocalDate datFimLdt = null;
            String datInicial = request.getParameter("dataInicial");
            String datFinal = request.getParameter("dataFinal");
            DateTimeFormatter dateFmt = DateTimeFormatter.ISO_LOCAL_DATE;
            if (datInicial != null && !datInicial.isEmpty()) {
                try {
                    datIniLdt = LocalDate.parse(datInicial, dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    datIniLdt = null;
                }
            }
            if (datFinal != null && !datFinal.isEmpty()) {
                try {
                    datFimLdt = LocalDate.parse(datFinal, dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    datFimLdt = null;
                }
            }
            List importacoes = this.ativoService.findImportacoes(empresasLst, idCiclo, disciplinasLst, status, responsavel, datIniLdt, datFimLdt);
            return ResponseEntity.ok().body((Object)importacoes);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/importacoes/{empresa}/{idCiclo}/{seqImportacao}"})
    public ResponseEntity<ImportacaoMonitoracao> getImportacaoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCiclo") Integer idCiclo, @PathVariable(name="seqImportacao") Integer seqImportacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getImportacaoById({}, {}, {})", new Object[]{empresa, idCiclo, seqImportacao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_IMPORTACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_IMPORTACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ImportacaoMonitoracao importacao = this.ativoService.getImportacaoById(empresa, idCiclo, seqImportacao);
            return ResponseEntity.ok().body((Object)importacao);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getImportacaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/importacoes/{empresa}/{ciclo}/{importacao}/aprovar"})
    public ResponseEntity<Boolean> aprovarImportacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="ciclo") Integer ciclo, @PathVariable(name="importacao") Integer importacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("aprovarImportacoes({}, {})", (Object)empresa, (Object)importacao);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_APROVAR_REPROVAR_IMPORTACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_APROVAR_REPROVAR_IMPORTACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.aprovarImportacoes(empresa, ciclo, importacao, usuario.getLogin()));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.aprovarImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/importacoes/{empresa}/{ciclo}/{importacao}/reprovarImportacao"})
    public ResponseEntity<Boolean> reprovarImportacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="ciclo") Integer ciclo, @PathVariable(name="importacao") Integer importacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("reprovarImportacoes({}, {}, {})", new Object[]{empresa, ciclo, importacao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_APROVAR_REPROVAR_IMPORTACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_APROVAR_REPROVAR_IMPORTACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.reprovarImportacoes(empresa, ciclo, importacao, usuario.getLogin()));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.reprovarImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/importacoes/{empresa}/{ciclo}/{importacao}/publicar"})
    public ResponseEntity<Boolean> publicarImportacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="ciclo") Integer ciclo, @PathVariable(name="importacao") Integer importacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("aprovarImportacoes({}, {}, {})", new Object[]{empresa, ciclo, importacao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_APROVAR_REPROVAR_PUBLICACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_APROVAR_REPROVAR_PUBLICACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.aprovarImportacoes(empresa, ciclo, importacao, usuario.getLogin()));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.aprovarImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/importacoes/{empresa}/{ciclo}/{importacao}/reprovarPublicacao"})
    public ResponseEntity<Boolean> reprovarPublicacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="ciclo") Integer ciclo, @PathVariable(name="importacao") Integer importacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("reprovarImportacoes({}, {}, {})", new Object[]{empresa, ciclo, importacao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_APROVAR_REPROVAR_PUBLICACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_APROVAR_REPROVAR_PUBLICACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.reprovarImportacoes(empresa, ciclo, importacao, usuario.getLogin()));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.reprovarImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/importacoes/{empresa}/{ciclo}/{importacao}/excluir"})
    public ResponseEntity<Boolean> deleteImportacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="ciclo") Integer ciclo, @PathVariable(name="importacao") Integer importacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("excluirImportacoes({}, {}, {})", new Object[]{empresa, ciclo, importacao});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_IMPORTACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_IMPORTACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.deleteImportacoes(empresa, ciclo, importacao, usuario.getLogin()));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.excluirImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/cronogramas/{empresa}"})
    @Operation(summary="Busca os cronogramas de acordo com os filtros.")
    public ResponseEntity<List<CronogramaEntrega>> findCronogramas(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_CRONOGRAMAS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_CRONOGRAMAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ArrayList<Integer> ciclos = new ArrayList<Integer>();
            String[] params = request.getParameterValues("ciclos");
            if (params != null && params.length > 0) {
                ciclos = new ArrayList();
                for (String iteParm : params) {
                    ciclos.add(Integer.valueOf(iteParm));
                }
            }
            TipoAtivo tipoAtivo = null;
            if (request.getParameter("tipoAtivo") != null) {
                tipoAtivo = TipoAtivo.fromCode((String)request.getParameter("tipoAtivo"));
            }
            LocalDate datIniLdt = null;
            LocalDate datFimLdt = null;
            String datInicial = request.getParameter("dataInicial");
            String datFinal = request.getParameter("dataFinal");
            DateTimeFormatter dateFmt = DateTimeFormatter.ISO_LOCAL_DATE;
            if (datInicial != null && !datInicial.isEmpty()) {
                try {
                    datIniLdt = LocalDate.parse(datInicial, dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    datIniLdt = null;
                }
            }
            if (datFinal != null && !datFinal.isEmpty()) {
                try {
                    datFimLdt = LocalDate.parse(datFinal, dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    datFimLdt = null;
                }
            }
            logger.debug("{} - findCronogramas({}, {}, {}, {})", new Object[]{usuario, empresa, tipoAtivo, datInicial, datFinal});
            ArrayList<String> empresas = new ArrayList<String>();
            empresas.add(empresa);
            List cronogramas = this.ativoService.findCronogramasEntrega(empresas, tipoAtivo, ciclos, datIniLdt, datFimLdt);
            return ResponseEntity.ok().body((Object)cronogramas);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCronogramas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/cronogramas/{empresa}"})
    @Operation(summary="Salva o cronograma de entregas.")
    public ResponseEntity<CronogramaEntrega> saveCronogramaEntrega(@PathVariable(name="empresa") String empresa, @RequestBody CronogramaEntrega cronograma, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("saveCronograma({})", (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_CRONOGRAMA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_CRONOGRAMA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            CronogramaEntrega cronogramaDB = this.ativoService.saveCronogramaEntrega(empresa, cronograma, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)cronogramaDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCronograma", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{tipoAtivo}/ciclos/{idAtivo}"})
    public ResponseEntity<List<Monitoracao>> findMonitoracoesAnteriores(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, @PathVariable(name="idAtivo") Integer idAtivo, @RequestParam(name="fase") Integer faseMonitoracao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - findMonitoracoesAnteriores({}, {}, {})", new Object[]{usuario.getLogin(), empresa, tipoAtivo, idAtivo});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_MONITORACOES_ANTERIORES");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_MONITORACOES_ANTERIORES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            TipoAtivo tipoAtv = TipoAtivo.fromCode((String)tipoAtivo);
            if (tipoAtv == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ativo [%s] n\u00e3o encontrado.", tipoAtivo));
            }
            return ResponseEntity.ok().body((Object)this.ativoService.findMonitoracoesAnteriores(empresa, tipoAtv, idAtivo, faseMonitoracao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findMonitoracoesAnteriores", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{tipoAtivo}/exportacoes/modelos"})
    @Operation(summary="Realiza o download do modelo de importa\u00e7\u00e3o em formato de planilha")
    public ResponseEntity<byte[]> exportModeloExcel(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        try {
            byte[] bytes;
            logger.debug("Exportando excel, modelo das monitora\u00e7\u00f5es (emp={}, atv={})...", (Object)empresa, (Object)tipoAtivo);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXPORTA_MODELO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXPORTA_MODELO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            TipoAtivo tipoAtivoEnum = TipoAtivo.fromCode((String)tipoAtivo);
            if (tipoAtivoEnum == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Tipo de Ativo [%s] n\u00e3o foi encontrado.", tipoAtivo));
            }
            String[] empresasArray = request.getParameterValues("empresa");
            ArrayList<String> empresasLst = new ArrayList<String>();
            if (empresasArray != null && empresasArray.length > 0) {
                for (String emp : empresasArray) {
                    empresasLst.add(emp);
                }
            } else {
                empresasLst.add(empresa);
            }
            String param = request.getParameter("tipoConteudo");
            boolean incluirDados = param != null && param.equalsIgnoreCase("MON");
            String subTipo = null;
            param = request.getParameter("subTipo");
            if (param != null && !param.isEmpty()) {
                subTipo = param;
            }
            param = request.getParameter("campos");
            ArrayList<String> campos = new ArrayList<String>();
            if (param != null && !param.isEmpty()) {
                for (String rawData : param.split(",")) {
                    campos.add(rawData);
                }
            }
            if ((bytes = this.modeloImportacaoExcel.executeXLS(empresasLst, tipoAtivo, subTipo, Boolean.valueOf(incluirDados), campos)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"modelo-monitoracoes.xlsx\"");
            headers.add("Content-Type", "application/octet-stream");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

