/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ativos;

import br.com.oti.gesconsys.beans.ativos.HistoricoIntervencao;
import br.com.oti.gesconsys.beans.ativos.HistoricoIntervencaoAnexo;
import br.com.oti.gesconsys.beans.ativos.TipoAtivo;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.AtivoService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Hist\u00f3ricos de Interven\u00e7\u00e3o dos ativos", name="ativos")
@RequestMapping(value={"/api/historicosIntervencoes"})
public class HistoricosIntervencaoRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(HistoricosIntervencaoRestServices.class);
    @Autowired
    private AtivoService ativoService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    public ResponseEntity<List<HistoricoIntervencao>> findIntervencoes(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findIntervencoes({})", (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_INTERVENCOES");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_INTERVENCOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            TipoAtivo tipoAtivo = TipoAtivo.DRENAGEM;
            return ResponseEntity.ok().body((Object)this.ativoService.findIntervencoes(empresa, tipoAtivo));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findIntervencoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idHistorico}"})
    public ResponseEntity<HistoricoIntervencao> getIntervencaoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idHistorico") Integer idHistorico, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getIntervencaoById({}, {})", (Object)empresa, (Object)idHistorico);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_INTERVENCAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_INTERVENCAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getIntervencaoById(empresa, idHistorico));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getIntervencaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}"})
    public ResponseEntity<HistoricoIntervencao> saveIntervencao(@PathVariable(name="empresa") String empresa, @RequestBody HistoricoIntervencao intervencao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("saveIntervencao({})", (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_INTERVENCAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_INTERVENCAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            HistoricoIntervencao intervencaoDB = this.ativoService.saveIntervencao(empresa, intervencao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)intervencaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveIntervencao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{empresa}"})
    public ResponseEntity<HistoricoIntervencao> updateIntervencao(@PathVariable(name="empresa") String empresa, @RequestBody HistoricoIntervencao intervencao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateIntervencao({})", (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_ATUALIZAR_INTERVENCAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_ATUALIZAR_INTERVENCAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            HistoricoIntervencao intervencaoDB = this.ativoService.saveIntervencao(empresa, intervencao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)intervencaoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateIntervencao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idIntervencao}"})
    public ResponseEntity<Boolean> deleteIntervencao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIntervencao") Integer idIntervencao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteIntervencao({}, {})", (Object)empresa, (Object)idIntervencao);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_INTERVENCAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_INTERVENCAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteIntervencao(empresa, idIntervencao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteIntervencao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idIntervencao}/imagens"})
    public ResponseEntity<List<HistoricoIntervencaoAnexo>> findImagens(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIntervencao") Integer idIntervencao, HttpServletRequest request) {
        try {
            logger.debug("findImagens({})", (Object)empresa);
            return ResponseEntity.ok().body((Object)this.ativoService.findImagensIntervencao(empresa, idIntervencao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findImagens", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idIntervencao}/{sequencia}/imagem"})
    public ResponseEntity<HistoricoIntervencaoAnexo> getImagemById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIntervencao") Integer idIntervencao, @PathVariable(name="sequencia") Integer sequencia) {
        try {
            logger.debug("getImagemById({}, {})", (Object)empresa, (Object)idIntervencao);
            return ResponseEntity.ok().body((Object)this.ativoService.getImagemIntervencaoById(empresa, idIntervencao, sequencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getImagemById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{idIntervencao}/imagens"})
    @ResponseBody
    public ResponseEntity<HistoricoIntervencaoAnexo> saveImagem(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idIntervencao") Integer idIntervencao, @RequestParam(name="file", required=false) MultipartFile file) {
        logger.debug("Executando saveImagem(emp={},idIntervencao={})...", (Object)empresa, (Object)idIntervencao);
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o foi informado.");
            }
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            String tipoImagem = null;
            if (formData.containsKey("tipoAtivo")) {
                tipoAtivo = ((String[])formData.get("tipoAtivo"))[0];
            }
            if (formData.containsKey("tipoImagem")) {
                tipoImagem = ((String[])formData.get("tipoImagem"))[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            HistoricoIntervencaoAnexo imagemDB = this.ativoService.saveImagemIntervencao(empresa, idIntervencao, tipoAtivo, tipoImagem, fileInfo, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)imagemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveImagem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("BizExc.saveImagem", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }
}

