/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ativos;

import br.com.oti.gesconsys.beans.ativos.CategoriaAtivo;
import br.com.oti.gesconsys.beans.ativos.CicloMonitoracao;
import br.com.oti.gesconsys.beans.ativos.CicloMonitoracaoAnexo;
import br.com.oti.gesconsys.beans.ativos.EstacaoSinalizacao;
import br.com.oti.gesconsys.beans.ativos.ItemAtivo;
import br.com.oti.gesconsys.beans.ativos.ItemAtivoAnexo;
import br.com.oti.gesconsys.beans.ativos.ItemAtivoDrenagem;
import br.com.oti.gesconsys.beans.ativos.ItemAtivoEps;
import br.com.oti.gesconsys.beans.ativos.ItemAtivoParametro;
import br.com.oti.gesconsys.beans.ativos.ItemAtivoSinalizacaoHorizontal;
import br.com.oti.gesconsys.beans.ativos.ItemAtivoSinalizacaoVertical;
import br.com.oti.gesconsys.beans.ativos.ItemAtivoTerrapleno;
import br.com.oti.gesconsys.beans.ativos.Monitoracao;
import br.com.oti.gesconsys.beans.ativos.OcorrenciaClimatica;
import br.com.oti.gesconsys.beans.ativos.PrecoUnitario;
import br.com.oti.gesconsys.beans.ativos.TipoAtivo;
import br.com.oti.gesconsys.beans.ativos.TipoOcorrenciaClimatica;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.AtivoService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Cadastros de estruturas dos Ativos", name="ativos")
@RequestMapping(value={"/api/cadastros/atv"})
public class CadastrosAtivosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(CadastrosAtivosRestServices.class);
    @Autowired
    private AtivoService ativoService;
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/categorias"})
    @Operation(summary="Busca as categorias de ativos.")
    public ResponseEntity<List<CategoriaAtivo>> findCategorias(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_CATEGORIAS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_CATEGORIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String search = null;
            String tipoAtivo = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (request.getParameter("tipoAtivo") != null) {
                tipoAtivo = request.getParameter("tipoAtivo");
            }
            logger.debug("findCategorias({}, {})", (Object)search, (Object)tipoAtivo);
            List categorias = this.ativoService.findCategorias(search, tipoAtivo);
            return ResponseEntity.ok().body((Object)categorias);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCategorias", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/categorias/{idCategoria}"})
    @Operation(summary="Busca a categoria conforme seu identificador.")
    public ResponseEntity<CategoriaAtivo> getCategoriaById(@PathVariable(name="idCategoria") Integer idCategoria, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getCategoriaById({})", (Object)idCategoria);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_CATEGORIA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_CATEGORIA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getCategoriaById(idCategoria));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCategoriaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/categorias"})
    @Operation(summary="Salva a categoria de ativo.")
    public ResponseEntity<CategoriaAtivo> saveCategoria(@RequestBody CategoriaAtivo categoria, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_CATEGORIA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_CATEGORIA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            CategoriaAtivo categoriaDB = this.ativoService.saveCategoria(categoria, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)categoriaDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCategoria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/categorias/{idCategoria}"})
    @Operation(summary="Deleta a categoria de ativo de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteCategoria(@PathVariable(name="idCategoria") Integer idCategoria, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteCategoria({})", (Object)idCategoria);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_CATEGORIA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_CATEGORIA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteCategoria(idCategoria), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCategoria", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/itens/{tipoAtivo}/all"})
    @Operation(summary="Busca os itens de ativo.")
    public ResponseEntity<List<ItemAtivo>> findItens(@PathVariable(name="empresa") String empresa, @PathVariable(name="tipoAtivo") String tipoAtivo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Integer idCategoria = null;
        Integer idRodovia = null;
        BigDecimal kmInicial = null;
        BigDecimal kmFinal = null;
        LocalDate dataInicial = null;
        LocalDate dataFinal = null;
        try {
            logger.debug("findItens({}, {})", (Object)empresa, (Object)tipoAtivo);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_ITEM");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_ITEM");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            if (request.getParameter("idRodovia") != null) {
                idRodovia = Integer.valueOf(request.getParameter("idRodovia"));
            }
            if (request.getParameter("idCategoria") != null) {
                idCategoria = Integer.valueOf(request.getParameter("idCategoria"));
            }
            if (request.getParameter("kmInicial") != null) {
                kmInicial = new BigDecimal(request.getParameter("kmInicial"));
            }
            if (request.getParameter("kmFinal") != null) {
                kmFinal = new BigDecimal(request.getParameter("kmFinal"));
            }
            if (request.getParameter("dataInicial") != null) {
                dataInicial = LocalDate.parse(request.getParameter("dataInicial"));
            }
            if (request.getParameter("dataFinal") != null) {
                dataFinal = LocalDate.parse(request.getParameter("dataFinal"));
            }
            String[] empresasArray = request.getParameterValues("empresa");
            ArrayList<String> empresasLst = new ArrayList<String>();
            if (empresasArray != null && empresasArray.length > 0) {
                for (String emp : empresasArray) {
                    empresasLst.add(emp);
                }
            } else {
                empresasLst.add(empresa);
            }
            TipoAtivo tipoAtivoBase = TipoAtivo.fromCode((String)tipoAtivo);
            List itens = this.ativoService.findItensAtivos(empresasLst, tipoAtivoBase, idCategoria, idRodovia, search, kmInicial, kmFinal, dataInicial, dataFinal);
            return ResponseEntity.ok().body((Object)itens);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findItens", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/itens/{idItem}"})
    @Operation(summary="Busca o item de ativo por seu identificador e empresa.")
    public ResponseEntity<ItemAtivo> getItemById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idItem") Integer idItem, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getItemById({})", (Object)idItem);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_ITEM");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_ITEM");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getItemAtivoById(empresa, idItem));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getItemById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/itensDrenagem"})
    @Operation(summary="Salva o item de ativo drenagem.")
    public ResponseEntity<ItemAtivo> saveItem(@PathVariable(name="empresa") String empresa, @RequestBody ItemAtivoDrenagem item, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_ITEM");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_ITEM");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ItemAtivo itemDB = this.ativoService.saveItemAtivo(empresa, (ItemAtivo)item, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)itemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveItemDrenagem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/itensSinalizacaoVertical"})
    @Operation(summary="Salva o item de ativo sinaliza\u00e7\u00e3o vertical.")
    public ResponseEntity<ItemAtivo> saveItem(@PathVariable(name="empresa") String empresa, @RequestBody ItemAtivoSinalizacaoVertical item, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_ITEM");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_ITEM");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (item.getStatus() == null) {
                item.setStatus(Integer.valueOf(0));
            }
            ItemAtivo itemDB = this.ativoService.saveItemAtivo(empresa, (ItemAtivo)item, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)itemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveItemSinalizacaoVertical", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/itensSinalizacaoHorizontal"})
    @Operation(summary="Salva o item de ativo sinaliza\u00e7\u00e3o horizontal.")
    public ResponseEntity<ItemAtivo> saveItem(@PathVariable(name="empresa") String empresa, @RequestBody ItemAtivoSinalizacaoHorizontal item, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_ITEM");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_ITEM");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (item.getStatus() == null) {
                item.setStatus(Integer.valueOf(0));
            }
            ItemAtivo itemDB = this.ativoService.saveItemAtivo(empresa, (ItemAtivo)item, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)itemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveItemSinalizacaoHorizontal", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/itensTerrapleno"})
    @Operation(summary="Salva o item de ativo Terrapleno.")
    public ResponseEntity<ItemAtivo> saveItem(@PathVariable(name="empresa") String empresa, @RequestBody ItemAtivoTerrapleno item, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_ITEM");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_ITEM");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (item.getStatus() == null) {
                item.setStatus(Integer.valueOf(0));
            }
            ItemAtivo itemDB = this.ativoService.saveItemAtivo(empresa, (ItemAtivo)item, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)itemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveItemTerrapleno", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/itensEps"})
    @Operation(summary="Salva o item de ativo EPS.")
    public ResponseEntity<ItemAtivo> saveItem(@PathVariable(name="empresa") String empresa, @RequestBody ItemAtivoEps item, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_ITEM");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_ITEM");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            if (item.getStatus() == null) {
                item.setStatus(Integer.valueOf(0));
            }
            ItemAtivo itemDB = this.ativoService.saveItemAtivo(empresa, (ItemAtivo)item, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)itemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveItemEps", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/itens/{idItem}"})
    @Operation(summary="Deleta o item de ativo de acordo com seu identificador e empresa.")
    public ResponseEntity<Boolean> deleteItem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idItem") Integer idItem, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteItem({})", (Object)idItem);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_ITEM");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_ITEM");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteItemAtivo(empresa, idItem), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteItem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/parametros/{idAtivo}"})
    @Operation(summary="Busca os parametros de ativo.")
    public ResponseEntity<List<ItemAtivoParametro>> findItensParametro(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAtivo") Integer idAtivo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findParametros()");
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_PARAMETROS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_PARAMETROS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            List itens = this.ativoService.findAtivoParametros(empresa, idAtivo);
            return ResponseEntity.ok().body((Object)itens);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findParametros", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/parametro/{idParametro}/{sequencia}"})
    @Operation(summary="Busca o par\u00e2metro de ativo por seu identificador, sequ\u00eancia e empresa.")
    public ResponseEntity<ItemAtivoParametro> getParametroById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAtivo") Integer idAtivo, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getParametroById({})", (Object)idAtivo);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_PARAMETRO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_PARAMETRO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getParametroAtivoById(empresa, idAtivo, sequencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getParametroById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/parametro"})
    @Operation(summary="Salva o par\u00e2metro de ativo.")
    public ResponseEntity<ItemAtivoParametro> saveParametro(@PathVariable(name="empresa") String empresa, @RequestBody ItemAtivoParametro parametro, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_PARAMETRO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_PARAMETRO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            ItemAtivoParametro itemDB = this.ativoService.saveAtivoParametro(parametro, usr.getId());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)itemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveParametro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/parametros/{idAtivo}/{sequencia}"})
    @Operation(summary="Deleta o par\u00e2metro de ativo de acordo com seu identificador e empresa.")
    public ResponseEntity<Boolean> deleteParametro(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAtivo") Integer idAtivo, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteParametro({})", (Object)idAtivo);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_PARAMETRO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_PARAMETRO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteParametroAtivo(empresa, idAtivo, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteParametro", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/itens/{idAtivo}/anexos/{sequencia}"})
    @Operation(summary="Retorna o anexo de ativos conforme seu identificador.")
    public ResponseEntity<ItemAtivoAnexo> getAnexoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAtivo") Integer idAtivo, @PathVariable(name="sequencia") Integer sequencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getAnexoById({})", (Object)idAtivo);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_ANEXO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_ANEXO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getItemAtivoAnexo(empresa, idAtivo, sequencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAnexoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"{empresa}/itens/{idAtivo}/anexos"})
    @Operation(summary="Lista os anexos do ativo.")
    public ResponseEntity<List<ItemAtivoAnexo>> findAnexosByAtivo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAtivo") Integer idAtivo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findAnexosByAtivo({})", (Object)idAtivo);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_ANEXO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_ANEXO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.findAnexosByAtivo(empresa, idAtivo));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosByAtivo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/itens/{idAtivo}/anexos"})
    @Operation(summary="Persiste o anexo do item de ativo")
    public ResponseEntity<ItemAtivoAnexo> saveItemAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAtivo") Integer idAtivo, @RequestParam(name="files", required=false) MultipartFile[] files, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_ANEXO_ATIVO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_ANEXO_ATIVO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Integer seqAnexo = null;
            ItemAtivoAnexo anexoDB = this.ativoService.saveAnexo(empresa, idAtivo, seqAnexo, files[0], usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)anexoDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveItem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/precosUnitarios"})
    @Operation(summary="Lista os pre\u00e7os unit\u00e1rios de acordo com o filtro")
    @ResponseBody
    public ResponseEntity<List<PrecoUnitario>> findPrecosUnitarios(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("API findPrecosUnitarios (empresa={})...", (Object)empresa);
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_PRECOS_UNITARIOS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_PRECOS_UNITARIOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            List precos = this.ativoService.findPrecosUnitarios(empresa, null);
            return new ResponseEntity((Object)precos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findPrecosUnitarios", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findPrecosUnitarios", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/precosUnitarios/{idPeneira}"})
    @Operation(summary="Lista a peneira de acordo com o identificador")
    @ResponseBody
    public ResponseEntity<PrecoUnitario> getPrecoUnitarioById(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idPrecoUnitario") Integer idPrecoUnitario) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("API getPrecoUnitarioById (empresa={})...", (Object)empresa);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_PRECO_UNITARIO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_PRECO_UNITARIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PrecoUnitario preco = this.ativoService.getPrecoUnitarioById(empresa, idPrecoUnitario);
            return new ResponseEntity((Object)preco, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getPrecoUnitarioById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.getPrecoUnitarioById", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/precosUnitarios"})
    @Operation(summary="Grava as informa\u00e7\u00f5es do cadastro das peneiras e seus itens")
    public ResponseEntity<PrecoUnitario> savePrecoUnitario(@PathVariable(name="empresa") String empresa, @RequestBody PrecoUnitario precoUnitario, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("savePrecoUnitario={})", (Object)precoUnitario);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_PRECO_UNITARIO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_PRECO_UNITARIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            PrecoUnitario precoDB = this.ativoService.savePrecoUnitario(empresa, precoUnitario, usuario.getLogin());
            return new ResponseEntity((Object)precoDB, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.savePrecoUnitario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/precosUnitarios/{idPrecoUnitario}"})
    @Operation(summary="Exclui a peneira atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deletePrecoUnitario(@PathVariable(name="empresa") String empresa, @PathVariable(name="idPrecoUnitario") Integer idPrecoUnitario, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deletePrecoUnitario({}, {})", (Object)empresa, (Object)idPrecoUnitario);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_PRECO_UNITARIO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_PRECO_UNITARIO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deletePrecoUnitario(empresa, idPrecoUnitario), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deletePrecoUnitario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/ciclosMonitoracao/{empresa}"})
    @Operation(summary="Busca os ciclos de monitora\u00e7\u00e3o de ativos.")
    public ResponseEntity<List<CicloMonitoracao>> findCiclos(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            String tipoAtivo = null;
            if (request.getParameter("tipoAtivo") != null) {
                tipoAtivo = request.getParameter("tipoAtivo");
            }
            logger.debug("{} - findCiclos({}, {}, {})", new Object[]{usuario.getLogin(), empresa, search, tipoAtivo});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_CICLOS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_CICLOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            List ciclos = this.ativoService.findCiclosMonitoracoes(empresa, tipoAtivo, search);
            return ResponseEntity.ok().body((Object)ciclos);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findCiclos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/ciclosMonitoracao/{empresa}/{idCiclo}"})
    @Operation(summary="Busca a ciclo de monitora\u00e7\u00e3o conforme seu identificador.")
    public ResponseEntity<CicloMonitoracao> getCicloById(@PathVariable(name="idCiclo") Integer idCiclo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getCicloById({})", (Object)idCiclo);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_CICLO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_CICLOS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getCicloMonitoracaoById(idCiclo));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getCicloById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/ciclosMonitoracao/{empresa}"})
    @Operation(summary="Salva o ciclo de monitora\u00e7\u00e3o de ativo.")
    public ResponseEntity<CicloMonitoracao> saveCiclo(@PathVariable(name="empresa") String empresa, @RequestBody CicloMonitoracao ciclo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_CICLO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_CICLO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            ciclo.setIdEmpresa(emp.getId());
            CicloMonitoracao cicloDB = this.ativoService.saveCicloMonitoracao(ciclo, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)cicloDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/ciclosMonitoracao/{empresa}/{idCiclo}"})
    @Operation(summary="Exclui o ciclo de monitora\u00e7\u00e3o de ativo de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteCiclo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCiclo") Integer idCiclo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteCiclo({})", (Object)idCiclo);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_CICLO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_CICLO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteCicloMonitoracao(idCiclo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/ciclosMonitoracao/{empresa}/{idCiclo}/encerrar"})
    @Operation(summary="Encerra o ciclo de monitora\u00e7\u00e3o de acordo com seu identificador.")
    public ResponseEntity<Boolean> encerrarCiclo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCiclo") Integer idCiclo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - encerrarCiclo({}, {})", new Object[]{usuario.getLogin(), empresa, idCiclo});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_ENCERRAR_CICLO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_ENCERRAR_CICLO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.encerrarCicloMonitoracao(idCiclo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.encerrarCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/ciclosMonitoracao/{empresa}/{idCiclo}/reabrir"})
    @Operation(summary="Reabre o ciclo de monitora\u00e7\u00e3o de acordo com seu identificador.")
    public ResponseEntity<Boolean> reabrirCiclo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCiclo") Integer idCiclo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - reabrirCiclo({}, {})", new Object[]{usuario.getLogin(), empresa, idCiclo});
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_REABRIR_CICLO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_REABRIR_CICLO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.reabrirCicloMonitoracao(idCiclo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.reabrirCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/ciclosMonitoracao/{empresa}/{idCiclo}/anexos"})
    public ResponseEntity<List<CicloMonitoracaoAnexo>> findAnexosCiclo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCiclo") Integer idCiclo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_CICLO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_CICLO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - findAnexosCiclo({})", (Object)usuario.getLogin(), (Object)empresa);
            return ResponseEntity.ok().body((Object)this.ativoService.findAnexosCiclo(empresa, idCiclo));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/ciclosMonitoracao/{empresa}/{idCiclo}/anexos/{idAnexo}"})
    public ResponseEntity<CicloMonitoracaoAnexo> getAnexoFaseById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCiclo") Integer idCiclo, @PathVariable(name="idAnexoFase") Integer idAnexoFase, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_CICLO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_CICLO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - getAnexoFaseById({}, {}, {})", new Object[]{usuario.getLogin(), empresa, idCiclo, idAnexoFase});
            return ResponseEntity.ok().body((Object)this.ativoService.getAnexoCicloById(empresa, idAnexoFase));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAnexoFaseById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/ciclosMonitoracao/{empresa}/{idCiclo}/anexos"})
    @ResponseBody
    public ResponseEntity<CicloMonitoracaoAnexo> saveAnexoFase(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCiclo") Integer idCiclo, @RequestParam(name="file", required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - saveAnexoCiclo(emp={},idFase={})...", new Object[]{usuario.getLogin(), empresa, idCiclo});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_CICLO");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_CICLO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            if (formData.containsKey("tipoAtivo")) {
                tipoAtivo = ((String[])formData.get("tipoAtivo"))[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            CicloMonitoracaoAnexo imagemDB = this.ativoService.saveAnexoCiclo(empresa, idCiclo, tipoAtivo, fileInfo, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)imagemDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAnexoFase", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            logger.error("BizExc.saveAnexoFase", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @DeleteMapping(value={"/ciclosMonitoracao/{empresa}/{idCiclo}/anexos/{idAnexoFase}"})
    @Operation(summary="Exclui o anexo da Monitora\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoCiclo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCiclo") Integer idCiclo, @PathVariable(name="idAnexoFase") Integer idAnexoFase, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - deleteAnexoCiclo({},{},{})", new Object[]{usuario.getLogin(), empresa, idCiclo, idAnexoFase});
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "GAC_EXCLUIR_ANEXO_FASE");
            if (!permissao.booleanValue()) {
                logger.error("Erro permiss\u00e3o ({} {})", (Object)usuario.getLogin(), (Object)"GAC_EXCLUIR_ANEXO_FASE");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteAnexoCiclo(empresa, idAnexoFase), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoCiclo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/ocorrenciasClimaticas"})
    @Operation(summary="Busca as ocorr\u00eancias clim\u00e1ticas de ativos.")
    public ResponseEntity<List<OcorrenciaClimatica>> findOcorrenciasClimaticas(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findOcorrenciasClimaticas()");
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_OCORRENCIAS_CLIMATICAS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_OCORRENCIAS_CLIMATICAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            List ocorrencias = this.ativoService.findOcorrenciasClimaticas(empresa, search);
            return ResponseEntity.ok().body((Object)ocorrencias);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findOcorrenciasClimaticas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/ocorrenciasClimaticas/{idOcorrencia}"})
    @Operation(summary="Busca as ocorr\u00eancias clim\u00e1ticas conforme seu identificador.")
    public ResponseEntity<OcorrenciaClimatica> getOcorrenciaClimaticaById(@PathVariable(name="idOcorrencia") Integer idOcorrencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getOcorrenciaClimaticaById({})", (Object)idOcorrencia);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_OCORRENCIA_CLIMATICA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_OCORRENCIA_CLIMATICA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getOcorrenciaClimaticaById(idOcorrencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getOcorrenciaClimaticaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/ocorrenciasClimaticas"})
    @Operation(summary="Salva as ocorr\u00eancias clim\u00e1ticas de ativo.")
    public ResponseEntity<OcorrenciaClimatica> saveOcorrenciasClimaticas(@PathVariable(name="empresa") String empresa, @RequestBody OcorrenciaClimatica ocorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_OCORRENCIA_CLIMATICA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_OCORRENCIA_CLIMATICA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new BusinessException("Empresa n\u00e3o encontrada para a sigla informada.");
            }
            ocorrencia.setIdEmpresa(emp.getId());
            OcorrenciaClimatica ocorrenciaDB = this.ativoService.saveOcorrenciaClimatica(ocorrencia, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)ocorrenciaDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveOcorrenciasClimaticas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/ocorrenciasClimaticas/{idOcorrencia}"})
    @Operation(summary="Deleta a ocorr\u00eancia clim\u00e1tica de ativo de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteOcorrenciaClimatica(@PathVariable(name="idOcorrencia") Integer idOcorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteOcorrenciaClimatica({})", (Object)idOcorrencia);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_OCORRENCIA_CLIMATICA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_OCORRENCIA_CLIMATICA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteOcorrenciaClimatica(idOcorrencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteOcorrenciaClimatica", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tiposOcorrenciasClimaticas"})
    @Operation(summary="Busca os tipos de ocorr\u00eancias clim\u00e1ticas de ativos.")
    public ResponseEntity<List<TipoOcorrenciaClimatica>> findTiposOcorrenciasClimaticas(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("findTiposOcorrenciasClimaticas()");
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_TIPOS_OCORRENCIAS");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_TIPOS_OCORRENCIAS");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            List ocorrencias = this.ativoService.findTiposOcorrenciasClimaticas(search);
            return ResponseEntity.ok().body((Object)ocorrencias);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposOcorrenciasClimaticas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/tiposOcorrenciasClimaticas/{idOcorrencia}"})
    @Operation(summary="Busca os tipos de ocorr\u00eancias clim\u00e1ticas conforme seu identificador.")
    public ResponseEntity<TipoOcorrenciaClimatica> getTipoOcorrenciaClimaticaById(@PathVariable(name="idOcorrencia") Integer idOcorrencia, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getTipoOcorrenciaClimaticaById({})", (Object)idOcorrencia);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_TIPO_OCORRENCIA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_TIPO_OCORRENCIA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getTipoOcorrenciaClimaticaById(idOcorrencia));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTipoOcorrenciaClimaticaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/tiposOcorrenciasClimaticas"})
    @Operation(summary="Salva os tipos de ocorr\u00eancias clim\u00e1ticas de ativo.")
    public ResponseEntity<TipoOcorrenciaClimatica> saveTiposOcorrenciasClimaticas(@RequestBody TipoOcorrenciaClimatica ocorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_TIPO_OCORRENCIA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_TIPO_OCORRENCIA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            TipoOcorrenciaClimatica ocorrenciaDB = this.ativoService.saveTipocorrenciaClimatica(ocorrencia, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)ocorrenciaDB);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTiposOcorrenciasClimaticas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/tiposOcorrenciasClimaticas/{idOcorrencia}"})
    @Operation(summary="Deleta a ocorr\u00eancia clim\u00e1tica de ativo de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteTipoOcorrenciaClimatica(@PathVariable(name="idOcorrencia") Integer idOcorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteTipoOcorrenciaClimatica({})", (Object)idOcorrencia);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_TIPO_OCORRENCIA");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_TIPO_OCORRENCIA");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteTipoOcorrenciaClimatica(idOcorrencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoOcorrenciaClimatica", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/sinalizacoes/estacoes"})
    @Operation(summary="Busca as esta\u00e7\u00f5es dos ativos de Sinaliza\u00e7\u00e3o.")
    public ResponseEntity<List<EstacaoSinalizacao>> findEstacoes(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_ESTACOES");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_ESTACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            String search = null;
            if (request.getParameter("search") != null) {
                search = request.getParameter("search");
            }
            logger.debug("findEstacoes({}, {})", (Object)search);
            List estacoes = this.ativoService.findEstacoes(search);
            return ResponseEntity.ok().body((Object)estacoes);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findEstacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/sinalizacoes/estacoes/{idEstacao}"})
    @Operation(summary="Carrega a Esta\u00e7\u00e3o conforme seu ID.")
    public ResponseEntity<EstacaoSinalizacao> getEstacaoById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEstacao") Integer idEstacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getEstacaoById({})", (Object)idEstacao);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_VISUALIZAR_ESTACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_VISUALIZAR_ESTACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return ResponseEntity.ok().body((Object)this.ativoService.getEstacaoById(idEstacao));
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getEstacaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/sinalizacoes/estacoes"})
    @Operation(summary="Salva a Esta\u00e7\u00e3o da Sinaliza\u00e7\u00e3o.")
    public ResponseEntity<EstacaoSinalizacao> saveEstacao(@PathVariable(name="empresa") String empresa, @RequestBody EstacaoSinalizacao estacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CADASTRAR_ESTACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CADASTRAR_ESTACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            estacao = this.ativoService.saveEstacao(empresa, estacao, usuario.getLogin());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)estacao);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveEstacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/sinalizacoes/estacoes/{idEstacao}"})
    @Operation(summary="Deleta a esta\u00e7\u00e3o da sinaliza\u00e7\u00e3o de acordo com seu identificador.")
    public ResponseEntity<Boolean> deleteEstacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idEstacao") Integer idEstacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteEstacao({})", (Object)idEstacao);
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_EXCLUIR_ESTACAO");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_EXCLUIR_ESTACAO");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            return new ResponseEntity((Object)this.ativoService.deleteEstacao(idEstacao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteEstacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/disciplinas"})
    @Operation(summary="Busca os ativos por tipo e suas quantidades")
    public ResponseEntity<List<Monitoracao>> findByDisciplina(@RequestParam(name="idEmpresa", required=false) List<Integer> empresas, HttpServletRequest request) {
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            Boolean permissao = this.segurancaService.hasPermissaoByModulo(usuario.getId(), "ATV_CONSULTAR_MONITORACOES");
            if (!permissao.booleanValue()) {
                logger.debug("Erro permiss\u00e3o ({}, {})", (Object)usuario.getLogin(), (Object)"ATV_CONSULTAR_MONITORACOES");
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o possui permiss\u00e3o para esta a\u00e7\u00e3o.");
            }
            logger.debug("{} - findByTipoAtivo({})", (Object)usuario.getLogin());
            return new ResponseEntity((Object)this.ativoService.findByDisciplina(empresas), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findByTipoAtivo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

