/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.rac.TipoFicha;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para tipos de fichas ambientais", name="ambiental")
@RequestMapping(value={"/api/tiposFicha"})
public class TiposFichaRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(TiposFichaRestServices.class);
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/all/{tipoFicha}"})
    @Operation(summary="Lista os tipos de Ficha")
    public ResponseEntity<List<TipoFicha>> findTiposFicha(@PathVariable(name="tipoFicha") String tipoFicha, HttpServletRequest request) {
        try {
            logger.debug("Iniciando findTipos...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                logger.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findTiposFicha(tipoFicha, searchTxt, lastUpdate), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findTiposFicha", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idTipo}"})
    @Operation(summary="Carrega o tipo de Ficha pelo seu ID")
    public ResponseEntity<TipoFicha> getTipo(@PathVariable Integer idTipo) {
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.getTipoFichaById(idTipo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getTipo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Salva o Tipo de Ficha")
    public ResponseEntity<TipoFicha> saveTipoFicha(@RequestBody TipoFicha tipoFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveTipoFicha ({}))", (Object)tipoFicha);
            return new ResponseEntity((Object)this.meioAmbienteService.saveTipoFicha(tipoFicha, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveTipoFicha", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idTipo}"})
    @Operation(summary="Exclui o Tipo de Ficha atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteTipoFicha(@PathVariable(name="empresa") String empresa, @PathVariable(name="idTipo") Integer idTipo, HttpServletRequest request) throws BusinessException {
        logger.debug("deleteTipoFicha({}, {})", (Object)empresa, (Object)idTipo);
        try {
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteTipoFicha(empresa, idTipo, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteTipoFicha", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

