/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.fichas.AnexoFichaVO;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaAprovacao;
import br.com.oti.gesconsys.ambiental.beans.inspecao.FiltroInspecao;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAmbiental;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAmbientalPK;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAnexo;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoEvento;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoFicha;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoFichaAnexo;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoFichaPK;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoFlorestal;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoHistorico;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoOcorrenciaPK;
import br.com.oti.gesconsys.ambiental.beans.rac.Ocorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.Rac;
import br.com.oti.gesconsys.ambiental.beans.rac.TipoEventoFicha;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.ambiental.RelatorioInspecaoExcel;
import br.com.oti.gesconsys.reports.ambiental.RelatorioInspecaoPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import reactor.netty.http.client.HttpClient;

@RestController
@Tag(description="REST Services para Inspe\u00e7\u00f5es Ambientais", name="ambiental")
@RequestMapping(value={"/api/inspecoes"})
public class InspecoesAmbientaisRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(InspecoesAmbientaisRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private GedService gedService;
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private RelatorioInspecaoExcel relatorioInspecoesExcel;
    @Autowired
    private RelatorioInspecaoPdf relatorioInspecaoPdf;

    @Deprecated(forRemoval=true)
    @PostMapping(value={"/{empresa}/filtro"})
    @Operation(summary="Retorna as inspe\u00e7\u00f5es dispon\u00edveis, de acordo com o filtro")
    public ResponseEntity<List<InspecaoAmbiental>> findInspecoes(@PathVariable(name="empresa") String empresa, @RequestBody FiltroInspecao filtroInspecao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "M\u00e9todo marcao para remo\u00e7\u00e3o, nenhum retorno ser\u00e1 feito.");
    }

    @PostMapping(value={"/{empresa}/filtros"})
    @Operation(summary="Retorna as inspe\u00e7\u00f5es dispon\u00edveis, de acordo com os filtros informados")
    public ResponseEntity<Page<InspecaoAmbiental>> findInspecoesMobile(@PathVariable String empresa, @RequestBody FiltroInspecao filtroInspecao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            int pageNbr = 1;
            int pageSize = 15;
            String sortField = "numero";
            boolean sortDesc = true;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            if (request.getParameter("sortField") != null) {
                sortField = request.getParameter("sortField");
            }
            if (request.getParameter("sortDesc") != null) {
                sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
            }
            logger.debug("[{}] - Iniciando findInspecoesMobile({}, {}, {}, {}, {})...", new Object[]{usuario.getLogin(), empresa, pageNbr, pageSize, sortField, sortDesc});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (filtroInspecao == null) {
                filtroInspecao = new FiltroInspecao();
            }
            if (filtroInspecao.getConcessionaria() == null || filtroInspecao.getConcessionaria().isEmpty()) {
                ArrayList<Integer> empList = new ArrayList<Integer>();
                empList.add(emp.getId());
                filtroInspecao.setConcessionaria(empList);
            }
            Page inspecoes = this.meioAmbienteService.findInspecoes(filtroInspecao, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            for (InspecaoAmbiental inspecao : inspecoes) {
                Set fichas;
                Set ocorrencias;
                List anexos;
                if (inspecao.getRodovia() != null) {
                    Rodovia rdv = inspecao.getRodovia();
                    rdv.setEmpresa(null);
                    inspecao.setRodovia(rdv);
                }
                if (inspecao.getSupervisorAmbiental() != null) {
                    Usuario supe = inspecao.getSupervisorAmbiental();
                    supe.setGrupos(null);
                }
                if (inspecao.getCoordenadorObra() != null) {
                    Usuario coamb = inspecao.getCoordenadorObra();
                    coamb.setGrupos(null);
                }
                Empresa empInsp = inspecao.getEmpresa();
                if (emp != null) {
                    Empresa empPayload = new Empresa();
                    empPayload.setId(empInsp.getId());
                    empPayload.setSigla(empInsp.getSigla());
                    empPayload.setRazaoSocial(empInsp.getRazaoSocial());
                    empPayload.setNomeFantasia(empInsp.getNomeFantasia());
                    inspecao.setEmpresa(empPayload);
                }
                if ((anexos = inspecao.getAnexos()) != null) {
                    for (InspecaoAnexo anx : anexos) {
                        anx.setUsuario(null);
                        if (anx.getAnexo() == null) continue;
                        Anexo anxGed = anx.getAnexo();
                        anxGed.setArea(null);
                        anxGed.setUsuario(null);
                    }
                }
                if ((ocorrencias = inspecao.getOcorrencias()) != null) {
                    InspecaoAnexo anx;
                    anx = ocorrencias.iterator();
                    while (anx.hasNext()) {
                        InspecaoOcorrencia oco = (InspecaoOcorrencia)anx.next();
                        oco.setInspecao(null);
                        oco.setDatHorCadastro(null);
                    }
                }
                if ((fichas = inspecao.getFichas()) == null) continue;
                for (InspecaoFicha fic : fichas) {
                    fic.setInspecao(null);
                    fic.setUsuario(null);
                    fic.setStatus(null);
                }
            }
            return new ResponseEntity((Object)inspecoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findInspecoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}"})
    @Operation(summary="Carrega a Inspe\u00e7\u00e3o Ambiental de acordo com seu identificador")
    public ResponseEntity<InspecaoAmbiental> getInspecaoAmbiental(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - Iniciando getInspecaoAmbiental({})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            InspecaoAmbiental insp = this.meioAmbienteService.getInspecaoById(empresa, idInspecao);
            if (insp.getRodovia() != null) {
                insp.getRodovia().setIdUsuarioIns(null);
                insp.getRodovia().setDatHorAlteracao(null);
                insp.getRodovia().setDatHorCadastro(null);
                insp.getRodovia().setEmpresa(null);
                insp.getRodovia().setIdUsuarioIns(null);
                insp.getRodovia().setIdUsuarioUpd(null);
            }
            if (insp.getCoordenadorObra() != null) {
                insp.getCoordenadorObra().setDatHorAlteracao(null);
                insp.getCoordenadorObra().setDatHorCadastro(null);
                insp.getCoordenadorObra().setDatHorUltimoLogin(null);
                insp.getCoordenadorObra().setGrupos(null);
                insp.getCoordenadorObra().setIdPoderConcedente(null);
                insp.getCoordenadorObra().setIdUsuarioIns(null);
                insp.getCoordenadorObra().setIdUsuarioUpd(null);
                insp.getCoordenadorObra().setSessionUUID(null);
            }
            if (insp.getEquipeAmbiental() != null) {
                insp.getEquipeAmbiental().setDatHorAlteracao(null);
                insp.getEquipeAmbiental().setDatHorCadastro(null);
                insp.getEquipeAmbiental().setIdEmpresa(null);
                insp.getEquipeAmbiental().setIdUsuarioIns(null);
                insp.getEquipeAmbiental().setIdUsuarioUpd(null);
            }
            if (insp.getEquipeConcessao() != null) {
                insp.getEquipeConcessao().setDatHorAlteracao(null);
                insp.getEquipeConcessao().setDatHorCadastro(null);
                insp.getEquipeConcessao().setIdEmpresa(null);
                insp.getEquipeConcessao().setIdUsuarioIns(null);
                insp.getEquipeConcessao().setIdUsuarioUpd(null);
            }
            if (insp.getEquipeEmpreiteira() != null) {
                insp.getEquipeEmpreiteira().setDatHorAlteracao(null);
                insp.getEquipeEmpreiteira().setDatHorCadastro(null);
                insp.getEquipeEmpreiteira().setIdEmpresa(null);
                insp.getEquipeEmpreiteira().setIdUsuarioIns(null);
                insp.getEquipeEmpreiteira().setIdUsuarioUpd(null);
            }
            return new ResponseEntity((Object)insp, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getInspecaoAmbiental", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra a Inspe\u00e7\u00e3o Ambiental")
    public ResponseEntity<InspecaoAmbiental> registrarInspecao(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String anexosTxt;
            String ocorrenciasTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            InspecaoAmbiental inspecao = (InspecaoAmbiental)mapper.readValue(((String[])formData.get("inspecao"))[0], InspecaoAmbiental.class);
            if (inspecao.getId() == null) {
                inspecao.setId(new InspecaoAmbientalPK());
            }
            logger.debug("{} - registrarInspecao ({}))", (Object)usuario, (Object)inspecao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (inspecao.getId().getIdEmpresa() == null) {
                    inspecao.getId().setIdEmpresa(emp.getId());
                }
            }
            List ocorrencias = null;
            if (formData.containsKey("ocorrencias") && (ocorrenciasTxt = ((String[])formData.get("ocorrencias"))[0]).length() > 0) {
                ocorrencias = (List)mapper.readValue(ocorrenciasTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List anexos = null;
            if (formData.containsKey("anexos") && (anexosTxt = ((String[])formData.get("anexos"))[0]).length() > 0) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            InspecaoAmbiental inspDb = this.meioAmbienteService.registrarInspecao(empresa, inspecao, ocorrencias, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)inspDb, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarInspecao", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarInspecao", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idInspecao}"})
    @Operation(summary="Exclui a Inspe\u00e7\u00e3o atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, HttpServletRequest request) throws BusinessException {
        logger.debug("deleteInspecao({}, {})", (Object)empresa, (Object)idInspecao);
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteInspecao(empresa, idInspecao, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idInspecao}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<List<InspecaoAnexo>> createAnexoInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createAnexoInspecao({},{})", (Object)empresa, (Object)idInspecao);
            Map formData = request.getParameterMap();
            String comentario = null;
            if (formData.containsKey("comentario")) {
                comentario = ((String[])formData.get("comentario"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<InspecaoAnexo> anexos = new ArrayList<InspecaoAnexo>();
            for (MultipartFile file : filesMap) {
                InspecaoAnexo anexo = new InspecaoAnexo();
                anexo.setAnexo(new Anexo());
                anexo.getAnexo().setNome(file.getOriginalFilename());
                anexo.setComentario(comentario);
                anexos.add(anexo);
            }
            List response = this.meioAmbienteService.createAnexoInspecao(empresa, idInspecao, anexos, Boolean.valueOf(false), usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexoInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}/anexos"})
    @Operation(summary="Lista os anexos presentes na Inspe\u00e7\u00e3o")
    public ResponseEntity<List<InspecaoAnexo>> findAnexosInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findAnexosInspecao(emp.getId(), idInspecao, null), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}/assinaturas"})
    @Operation(summary="Lista as Assinaturas presentes na Inspe\u00e7\u00e3o")
    public ResponseEntity<List<InspecaoAnexo>> findAssinaturasInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List anexos = this.meioAmbienteService.findAnexosInspecao(emp.getId(), idInspecao, "S");
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idInspecao}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da Inspe\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @PathVariable(name="seqAnexo") Integer seqAnexo) throws BusinessException {
        logger.debug("deleteAnexo({},{},{})", new Object[]{empresa, idInspecao, seqAnexo});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAnexoInspecao(emp.getId(), idInspecao, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idInspecao}/ocorrencias"})
    @Operation(summary="Salva a ocorrencia, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<InspecaoOcorrencia> updateOcorrenciaInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @RequestBody InspecaoOcorrencia ocorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateOcorrenciaInspecao({},{})", (Object)idInspecao, (Object)ocorrencia);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (ocorrencia.getId().getIdInspecao() == null) {
                ocorrencia.getId().setIdEmpresa(emp.getId());
            }
            InspecaoOcorrencia response = this.meioAmbienteService.saveOcorrenciaInspecao(empresa, idInspecao, ocorrencia, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateOcorrencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}/ocorrencias"})
    @Operation(summary="Lista as ocorr\u00eancias associadas a inspens\u00e3o ambiental")
    public ResponseEntity<Map<String, Object>> findOcorrenciasDeposito(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List ocorrenciasBase = this.meioAmbienteService.findOcorrencias(null, null);
            List depositosOcorrencias = this.meioAmbienteService.findOcorrenciasInspecao(emp.getId(), idInspecao);
            HashMap<Integer, Ocorrencia> mapSoluOcorre = new HashMap<Integer, Ocorrencia>();
            ArrayList<Ocorrencia> associadas = new ArrayList<Ocorrencia>();
            ArrayList<InspecaoOcorrenciaPK> soluAssocList = new ArrayList<InspecaoOcorrenciaPK>();
            for (InspecaoOcorrencia inspOcorre : depositosOcorrencias) {
                if (!mapSoluOcorre.containsKey(inspOcorre.getId().getIdOcorrencia())) {
                    mapSoluOcorre.put(inspOcorre.getId().getIdOcorrencia(), inspOcorre.getOcorrencia());
                }
                soluAssocList.add(inspOcorre.getId());
            }
            for (int idxOco = 0; idxOco < ocorrenciasBase.size(); ++idxOco) {
                Ocorrencia base = (Ocorrencia)ocorrenciasBase.get(idxOco);
                if (!mapSoluOcorre.containsKey(base.getId())) continue;
                ocorrenciasBase.remove(idxOco);
                idxOco = 0;
            }
            for (Integer idOcorre : mapSoluOcorre.keySet()) {
                associadas.add((Ocorrencia)mapSoluOcorre.get(idOcorre));
            }
            HashMap<String, List> mapOcorrencias = new HashMap<String, List>();
            mapOcorrencias.put("associadas", associadas);
            mapOcorrencias.put("disponiveis", ocorrenciasBase);
            mapOcorrencias.put("solucoes", soluAssocList);
            return new ResponseEntity(mapOcorrencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findOcorrenciasDeposito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idInspecao}/ocorrencias/{idOcorrencia}/{idSolucao}"})
    @Operation(summary="Exclui o anexo da Inspe\u00e7\u00e3o a partir de seu identificador")
    public ResponseEntity<Boolean> deleteOcorrenciaInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @PathVariable(name="idOcorrencia") Integer idOcorrencia, @PathVariable(name="idSolucao") Integer idSolucao) throws BusinessException {
        logger.debug("deleteOcorrencia({}, {}, {}, {})", new Object[]{empresa, idInspecao, idOcorrencia, idSolucao});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteOcorrenciaInspecao(emp.getId(), idInspecao, idOcorrencia, idSolucao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteOcorrencia", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados na Inspe\u00e7\u00e3o")
    public ResponseEntity<List<InspecaoHistorico>> findHistoricosInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao) {
        try {
            logger.debug("findHistoricos({},{})", (Object)empresa, (Object)idInspecao);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findHistoricosInspecao(emp.getId(), idInspecao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idInspecao}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico da Inspe\u00e7\u00e3o de acordo com o payload informado")
    public ResponseEntity<InspecaoHistorico> createHistoricoInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createHistorico({},{})", (Object)empresa, (Object)idInspecao);
            Map formData = request.getParameterMap();
            InspecaoHistorico hist = new InspecaoHistorico();
            if (formData.containsKey("descricao")) {
                hist.setDescricao(((String[])formData.get("descricao"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            InspecaoHistorico response = this.meioAmbienteService.saveHistoricoInspecao(emp.getId(), idInspecao, hist, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createHistorico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idInspecao}/fichas"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra a ficha da Inspe\u00e7\u00e3o Ambiental")
    public ResponseEntity<InspecaoFicha> registrarFichaInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String anexosTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            if (!formData.containsKey("ficha")) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Informa\u00e7\u00e3o da ficha n\u00e3o dispon\u00edvel.");
            }
            InspecaoFicha ficha = (InspecaoFicha)mapper.readValue(((String[])formData.get("ficha"))[0], InspecaoFicha.class);
            if (ficha.getId() == null) {
                ficha.setId(new InspecaoFichaPK());
            }
            if (ficha.getId().getIdInspecao() == null) {
                ficha.getId().setIdInspecao(idInspecao);
            }
            logger.debug("registrarFichaInspecao ({}))", (Object)ficha);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (ficha.getId().getIdEmpresa() == null) {
                    ficha.getId().setIdEmpresa(emp.getId());
                }
            }
            List anexos = null;
            if (formData.containsKey("anexos") && (anexosTxt = ((String[])formData.get("anexos"))[0]).length() > 0) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            InspecaoFicha fichaDb = this.meioAmbienteService.registrarFichaInspecao(ficha, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)fichaDb, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarFichaInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarFichaInspecao", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarFichaInspecao", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}/fichas"})
    @Operation(summary="Lista as fichas presentes na Inspe\u00e7\u00e3o")
    public ResponseEntity<List<InspecaoFicha>> findFichasInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findFichasInspecao(emp.getId(), idInspecao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFichasInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}/fichas/{seqFicha}"})
    @Operation(summary="Carrega a ficha selecionada da Inspe\u00e7\u00e3o Ambiental")
    public ResponseEntity<InspecaoFicha> getFichaInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @PathVariable(name="seqFicha") Integer seqFicha) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            InspecaoFicha ficha = this.meioAmbienteService.getFichaInspecaoById(emp.getId(), idInspecao, seqFicha);
            return new ResponseEntity((Object)ficha, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFichaInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idInspecao}/fichas/{seqFicha}"})
    @Operation(summary="Exclui a ficha da Inspe\u00e7\u00e3o Ambiental atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteFichaInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @PathVariable(name="seqFicha") Integer seqFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteFichaInspecao({}, {}, {})", new Object[]{empresa, idInspecao, seqFicha});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteFichaInspecao(emp.getId(), idInspecao, seqFicha, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFichaInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}/fichas/{seqFicha}/anexos"})
    @Operation(summary="Lista os anexos presentes na ficha da Inspe\u00e7\u00e3o")
    public ResponseEntity<List<InspecaoFichaAnexo>> findAnexosFichaInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @PathVariable(name="seqFicha") Integer seqFicha) {
        try {
            logger.debug("findAnexosFichaInspecao({}, {}, {})", new Object[]{empresa, idInspecao, seqFicha});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            String tipoAnexo = "I";
            List anexos = this.meioAmbienteService.findAnexosFichaInspecao(emp.getId(), idInspecao, seqFicha, tipoAnexo);
            logger.debug("anexos.size=> {}", (Object)anexos.size());
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosFichaInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idInspecao}/fichas/{seqFicha}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da Ficha da Inspe\u00e7\u00e3o a partir de seu ID")
    public ResponseEntity<Boolean> deleteAnexoFichaInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @PathVariable(name="seqFicha") Integer seqFicha, @PathVariable(name="seqAnexo") Integer seqAnexo) throws BusinessException {
        logger.debug("deleteAnexoFichaInspecao({},{},{},{})", new Object[]{empresa, idInspecao, seqFicha, seqAnexo});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAnexoFichaInspecao(emp.getId(), idInspecao, seqFicha, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoFichaInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idInspecao}/fichas/{seqFicha}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<List<InspecaoFichaAnexo>> createAnexoFichaInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @PathVariable(name="seqFicha") Integer seqFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createAnexo({},{})", (Object)empresa, (Object)idInspecao);
            Map formData = request.getParameterMap();
            String comentario = null;
            if (formData.containsKey("comentario")) {
                comentario = ((String[])formData.get("comentario"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<InspecaoFichaAnexo> anexos = new ArrayList<InspecaoFichaAnexo>();
            for (MultipartFile file : filesMap) {
                InspecaoFichaAnexo anexo = new InspecaoFichaAnexo();
                anexo.setAnexo(new Anexo());
                anexo.getAnexo().setNome(file.getOriginalFilename());
                anexo.setComentario(comentario);
                anexos.add(anexo);
            }
            List response = this.meioAmbienteService.createAnexoFichaInspecao(emp.getId(), idInspecao, seqFicha, anexos, Boolean.valueOf(false), usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download da Inspe\u00e7\u00e3o em Excel")
    public ResponseEntity<StreamingResponseBody> exportaInspecaoExcel(@PathVariable String empresa, @RequestBody FiltroInspecao filtroInspecao) {
        logger.debug("Exportando excel, inspecao (emp={})...", (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtroInspecao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Filtro base n\u00e3o informado.");
        }
        if (filtroInspecao.getConcessionaria() == null || filtroInspecao.getConcessionaria().isEmpty()) {
            ArrayList<Integer> empList = new ArrayList<Integer>();
            empList.add(emp.getId());
            filtroInspecao.setConcessionaria(empList);
        }
        try {
            boolean joinOcorrencias = false;
            boolean joinAnexos = false;
            boolean joinEventos = false;
            Page inspecoes = this.meioAmbienteService.findInspecoes(filtroInspecao, 1, 5000, null, null, Boolean.valueOf(joinOcorrencias), Boolean.valueOf(joinAnexos), Boolean.valueOf(joinEventos));
            StreamingResponseBody responseBody = response -> response.write(this.relatorioInspecoesExcel.executeXLS(inspecoes.getContent(), filtroInspecao.getConfigCampos()));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"inspecoes.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacaoPdf/{idInspecao}"})
    @Operation(summary="Efetua o download da Inspe\u00e7\u00e3o Ambiental em PDF")
    public ResponseEntity<StreamingResponseBody> exportaInspecaoPdf(@PathVariable String empresa, @PathVariable Integer idInspecao, HttpServletRequest request) {
        logger.debug("Exportando PDF, Inspe\u00e7\u00e3o (emp={}, {})...", (Object)empresa, (Object)idInspecao);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            InspecaoAmbiental inspecao = this.meioAmbienteService.getInspecaoById(empresa, idInspecao);
            StreamingResponseBody responseBody = response -> {
                String tipoMapa = request.getParameter("tipoMapa");
                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                byte[] mapaGoogle = null;
                if (inspecao.getLatitude() != null && inspecao.getLongitude() != null) {
                    mapaGoogle = this.getMapaEstatico(inspecao.getLatitude(), inspecao.getLongitude(), tipoMapa);
                }
                response.write(this.relatorioInspecaoPdf.executePDF(emp.getId(), inspecao, mapaGoogle, false));
            };
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"inspecao-ambiental.pdf\""})).contentType(MediaType.APPLICATION_PDF).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private byte[] getMapaEstatico(BigDecimal latitude, BigDecimal longitude, String mapType) {
        String mapaUrl = "https://maps.googleapis.com";
        String uri = "/maps/api/staticmap?zoom=18&size=640x480&maptype=%s&key=%s&markers=color:red|%f,%f";
        InputStream streamCustom = this.getClass().getClassLoader().getResourceAsStream("custom.properties");
        String apiKey = "nonono";
        if (streamCustom != null) {
            Properties props = new Properties();
            try {
                props.load(streamCustom);
            }
            catch (IOException ioExc) {
                logger.error("ioExc", (Throwable)ioExc);
            }
            apiKey = props.getProperty("googlemaps.api.key", "nonono");
        }
        HttpClient httpClient = HttpClient.create();
        WebClient webClient = WebClient.builder().baseUrl(mapaUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(0x100000)).build()).build();
        return (byte[])webClient.get().uri(String.format(uri, mapType, apiKey, latitude.doubleValue(), longitude.doubleValue()), new Object[0]).retrieve().bodyToMono(byte[].class).block(Duration.ofSeconds(10L));
    }

    @PostMapping(path={"/{empresa}/{idInspecao}/assinaturas"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva a Assinatura na Inspe\u00e7\u00e3o Ambiental")
    public ResponseEntity<List<InspecaoAnexo>> saveAssinaturaInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - saveAssinaturaInspecao({}, {}))", new Object[]{usuario.getLogin(), empresa, idInspecao});
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            if (!formData.containsKey("assinaturas")) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura de assinaturas n\u00e3o foi encontrada.");
            }
            String assinaturasTxt = ((String[])formData.get("assinaturas"))[0];
            InspecaoAnexo[] assinaturasVet = (InspecaoAnexo[])mapper.readValue(assinaturasTxt, InspecaoAnexo[].class);
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            logger.debug("Assinaturas.size={}", (Object)assinaturasVet.length);
            ArrayList<InspecaoAnexo> assinaturas = new ArrayList<InspecaoAnexo>();
            for (InspecaoAnexo assinatura : assinaturasVet) {
                if (assinatura.getComentario() == null) {
                    assinatura.setComentario("Assinatura - Inspe\u00e7\u00e3o");
                }
                assinaturas.add(assinatura);
            }
            List anexosInspecao = this.meioAmbienteService.createAnexoInspecao(empresa, idInspecao, assinaturas, Boolean.valueOf(true), usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)anexosInspecao, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveAssinaturaInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.saveAssinaturaInspecao", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.saveAssinaturaInspecao", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idInspecao}/anexos/comentarios"})
    @Operation(summary="Salva o coment\u00e1rio do Anexo/Anexo Ficha da Inspe\u00e7\u00e3o Ambiental")
    public ResponseEntity<AnexoFichaVO> saveComentarioAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @RequestBody AnexoFichaVO anexoFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - saveComentarioAnexo({}, {}))", new Object[]{usuario.getLogin(), empresa, idInspecao});
            this.meioAmbienteService.saveComentarioAnexoInspecao(empresa, idInspecao, anexoFicha.getSeqAnexo(), anexoFicha.getSeqFicha(), anexoFicha.getComentario());
            return new ResponseEntity((Object)anexoFicha, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idInspecao}/anexos/girar/{idAnexo}/{angulo}"})
    @Operation(summary="Gira a imagem \u00e0 esquerda ou direita, conforme \u00e2ngulo definido")
    public ResponseEntity<Boolean> girarImagem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @PathVariable(name="idAnexo") Integer idAnexo, @PathVariable(name="angulo") Integer angulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - girarImagem({}, {}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idInspecao, idAnexo, angulo});
            Boolean resultado = this.gedService.girarImagem(empresa, idAnexo, angulo, usuario.getLogin());
            return new ResponseEntity((Object)resultado, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idInspecao}/racs"})
    public ResponseEntity<Rac> gerarRacInspecaoAmbiental(@PathVariable String empresa, @PathVariable Integer idInspecao, HttpServletRequest request, @RequestParam Integer idTipoRac) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Rac rac = this.meioAmbienteService.gerarRacInspecaoAmbiental(empresa, idInspecao, usuario.getLogin(), idTipoRac);
            return new ResponseEntity((Object)rac, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.gerarRacInspecaoAmbiental", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}/inspecoesFlorestais"})
    @Operation(summary="Lista as inspe\u00e7\u00f5es florestais associadas a inspens\u00e3o ambiental")
    public ResponseEntity<List<InspecaoFlorestal>> findInspecoesFlorestais(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List florestais = this.meioAmbienteService.findInspecoesFlorestaisInspecao(emp.getId(), idInspecao);
            return new ResponseEntity((Object)florestais, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findInspecoesFlorestais", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idInspecao}/eventos/{tipoEvento}"})
    @Operation(summary="Executa o fluxo dos eventos da Inspe\u00e7\u00e3o (Iniciar aprova\u00e7\u00e3o, Aprova\u00e7\u00e3o Obras, Aprova\u00e7\u00e3o MeioAmbiente, Cancelar Aprova\u00e7\u00e3o, Encerrar Inspe\u00e7\u00e3o, Finalizar Inspe\u00e7\u00e3o, Reabrir Inspe\u00e7\u00e3o)")
    public ResponseEntity<InspecaoEvento> executeEvento(@PathVariable String empresa, @PathVariable Integer idInspecao, @PathVariable String tipoEvento, @RequestParam(required=false) String descricao, @RequestParam(required=false) String perfilReprovar, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            InspecaoEvento evento;
            logger.debug("{} - executeEvento({},{},{})", new Object[]{usuario.getLogin(), empresa, idInspecao, tipoEvento});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa n\u00e3o encontrada (%s).", empresa));
            }
            Integer seqAprovacao = null;
            if (request.getParameter("seqAprovacao") != null) {
                try {
                    seqAprovacao = Integer.valueOf(request.getParameter("seqAprovacao"));
                }
                catch (NumberFormatException nmfExc) {
                    seqAprovacao = null;
                }
            }
            if (tipoEvento.equals(TipoEventoFicha.ENVIO_APROVACAO.getCode())) {
                evento = this.meioAmbienteService.enviarAprovacaoInspecao(empresa, idInspecao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.APROVACAO.getCode())) {
                evento = this.meioAmbienteService.aprovarInspecao(empresa, idInspecao, seqAprovacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.REPROVACAO.getCode())) {
                evento = this.meioAmbienteService.reprovarInspecao(empresa, idInspecao, seqAprovacao, descricao, perfilReprovar, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.ENCERRAMENTO.getCode())) {
                evento = this.meioAmbienteService.encerrarInspecao(empresa, idInspecao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.FINALIZACAO.getCode())) {
                evento = this.meioAmbienteService.finalizarInspecao(empresa, idInspecao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.NAO_FINALIZACAO.getCode())) {
                evento = this.meioAmbienteService.naoFinalizarInspecao(empresa, idInspecao, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.REABERTURA.getCode())) {
                evento = this.meioAmbienteService.reabrirInspecao(empresa, idInspecao, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.CANCELAMENTO.getCode())) {
                evento = this.meioAmbienteService.cancelarInspecao(empresa, idInspecao, usuario.getLogin(), descricao, perfilReprovar);
            } else {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Evento n\u00e3o reconhecido: " + tipoEvento + ".");
            }
            return new ResponseEntity((Object)evento, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateCorrecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}/fichas/assinaturas"})
    @Operation(summary="Lista as Assinaturas presentes nas Fichas de Inspe\u00e7\u00e3o")
    public ResponseEntity<List<InspecaoFichaAnexo>> findAssinaturasFichasInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List anexos = this.meioAmbienteService.findAnexosFichaInspecao(emp.getId(), idInspecao, null, "S");
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idInspecao}/fichas/{seqFicha}/assinaturas"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva a Assinatura na Ficha da Inspe\u00e7\u00e3o Ambiental")
    public ResponseEntity<List<InspecaoFichaAnexo>> saveAssinaturaFichaInspecao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao, @PathVariable(name="seqFicha") Integer seqFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - saveAssinaturaFichaInspecao({}, {}))", new Object[]{usuario.getLogin(), empresa, idInspecao});
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            if (!formData.containsKey("assinaturas")) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura de assinaturas n\u00e3o foi encontrada.");
            }
            String assinaturasTxt = ((String[])formData.get("assinaturas"))[0];
            InspecaoFichaAnexo[] assinaturasVet = (InspecaoFichaAnexo[])mapper.readValue(assinaturasTxt, InspecaoFichaAnexo[].class);
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            logger.debug("Assinaturas.size={}", (Object)assinaturasVet.length);
            ArrayList<InspecaoFichaAnexo> assinaturas = new ArrayList<InspecaoFichaAnexo>();
            for (InspecaoFichaAnexo assinatura : assinaturasVet) {
                if (assinatura.getComentario() == null) {
                    assinatura.setComentario("Assinatura - Inspe\u00e7\u00e3o");
                }
                assinaturas.add(assinatura);
            }
            List anexosInspecao = this.meioAmbienteService.createAnexoFichaInspecao(emp.getId(), idInspecao, seqFicha, assinaturas, Boolean.valueOf(true), usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)anexosInspecao, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveAssinaturaFichaInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.saveAssinaturaFichaInspecao", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.saveAssinaturaFichaInspecao", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspecao}/racs"})
    @Operation(summary="Consulta a Rac de acordo com a Inspe\u00e7\u00e3o Ambiental")
    @ResponseBody
    public ResponseEntity<Rac> findRacByInspecao(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idInspecao") Integer idInspecao) {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findRacsByInspecao({})", (Object)usuario, (Object)empresa);
        try {
            Rac rac = this.meioAmbienteService.findRacByInspecao(empresa, idInspecao);
            return new ResponseEntity((Object)rac, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findRacsByInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findRacsByInspecao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idInspe}/aprovacoes"})
    @Operation(summary="Lista as aprova\u00e7\u00f5es registrados no Inspe\u00e7\u00e3o")
    public ResponseEntity<List<FichaAprovacao>> findAprovacoesInspe(@PathVariable String empresa, @PathVariable Integer idInspe) {
        try {
            logger.debug("findAprovacoes({},{})", (Object)empresa, (Object)idInspe);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            List aprovacoes = this.meioAmbienteService.findAprovacoesById(emp.getId(), idInspe, "INSPE");
            return new ResponseEntity((Object)aprovacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAprovacoesRac", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

