/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.checklist.CheckList;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListAnexo;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListEstrutura;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListFicha;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListFichaItem;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListHistorico;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListItem;
import br.com.oti.gesconsys.ambiental.beans.checklist.FiltroChecklist;
import br.com.oti.gesconsys.ambiental.beans.fichas.AnexoFichaVO;
import br.com.oti.gesconsys.ambiental.beans.rac.Rac;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.business.CoreService;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.ambiental.RelatorioCheckListExcel;
import br.com.oti.gesconsys.reports.ambiental.RelatorioCheckListPdf;
import br.com.oti.gesconsys.reports.ambiental.RelatorioCheckListsExcel;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import reactor.netty.http.client.HttpClient;

@RestController
@Tag(description="REST Services para CheckLists", name="ambiental")
@RequestMapping(value={"/api/checkLists"})
public class CheckListsRestServices
extends BaseRestService {
    private static Logger LOG = LoggerFactory.getLogger(CheckListsRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CoreService coreService;
    @Autowired
    private GedService gedService;
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private RelatorioCheckListsExcel relatorioCheckListsXls;
    @Autowired
    private RelatorioCheckListPdf relatorioCheckListPdf;
    @Autowired
    private RelatorioCheckListExcel relatorioCheckListXls;

    @GetMapping(value={"/estruturas"})
    @Operation(summary="Lista as estruturas de checklist dispon\u00edveis")
    public ResponseEntity<List<CheckListEstrutura>> findEstruturas(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("Iniciando findEstruturas({})...", (Object)usuario.getLogin());
            String searchTxt = null;
            String classe = null;
            Integer estruturaPai = null;
            String situacao = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            if (request.getParameter("classe") != null) {
                classe = request.getParameter("classe");
            }
            if (request.getParameter("estruturaPai") != null) {
                estruturaPai = Integer.valueOf(request.getParameter("estruturaPai"));
            }
            if (request.getParameter("situacao") != null) {
                situacao = request.getParameter("situacao");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findCheckListEstruturas(searchTxt, classe, situacao, estruturaPai), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.findEstruturas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/estruturasPai"})
    @Operation(summary="Lista as estruturas Pai de checklist dispon\u00edveis")
    public ResponseEntity<List<CheckListEstrutura>> findEstruturasPai(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("Iniciando findEstruturasPai({})...", (Object)usuario.getLogin());
            String searchTxt = null;
            String classe = null;
            String situacao = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            if (request.getParameter("classe") != null) {
                classe = request.getParameter("classe");
            }
            if (request.getParameter("situacao") != null) {
                situacao = request.getParameter("situacao");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findCheckListEstruturasPai(searchTxt, classe, situacao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.findEstruturasPai", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/estruturas/{idEstrutura}"})
    @Operation(summary="Carrega a estrutura de um checklist atrav\u00e9s de seu ID")
    public ResponseEntity<CheckListEstrutura> getEstruturaById(@PathVariable(name="idEstrutura") Integer idEstrutura) {
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.getCheckListEstruturaById(idEstrutura), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.getEstruturaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/estruturas"})
    @Operation(summary="Salva a estrutura do CheckList")
    public ResponseEntity<CheckListEstrutura> saveEstrutura(@RequestBody CheckListEstrutura estrutura, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            LOG.debug("saveEstrutura ({}))", (Object)estrutura);
            return new ResponseEntity((Object)this.meioAmbienteService.saveCheckListEstrutura(estrutura, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.saveEstrutura", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/estruturas/{idEstrutura}"})
    @Operation(summary="Exclui a estrutura do checklist atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteEstrutura(@PathVariable(name="idEstrutura") Integer idEstrutura) throws BusinessException {
        LOG.debug("deleteCheckList({})", (Object)idEstrutura);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteCheckListEstrutura(idEstrutura), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.deleteCheckList", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/fichas"})
    @Operation(summary="Lista as fichas de checklist dispon\u00edveis")
    public ResponseEntity<List<CheckListFicha>> findFichas(HttpServletRequest request) {
        try {
            LOG.debug("Iniciando findFichas...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            List fichas = this.meioAmbienteService.findCheckListFichas(searchTxt);
            for (CheckListFicha fch : fichas) {
                List itens = fch.getItens();
                if (itens == null) continue;
                for (CheckListFichaItem item : itens) {
                    item.setFicha(null);
                }
            }
            return ResponseEntity.ok().body((Object)fichas);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.findFichas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/fichas/{idFicha}"})
    @Operation(summary="Carrega a ficha de um checklist atrav\u00e9s de seu ID")
    public ResponseEntity<CheckListFicha> getFichaById(@PathVariable(name="idFicha") Integer idFicha) {
        try {
            CheckListFicha ficha = this.meioAmbienteService.getCheckListFichaById(idFicha);
            if (ficha.getItens() != null) {
                for (CheckListFichaItem fch : ficha.getItens()) {
                    fch.setFicha(null);
                }
            }
            return ResponseEntity.ok().body((Object)ficha);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.getFichaById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/fichas"})
    @Operation(summary="Salva a ficha do CheckList")
    public ResponseEntity<CheckListFicha> saveFicha(@RequestBody CheckListFicha estrutura, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            LOG.debug("saveFicha ({}))", (Object)estrutura);
            return new ResponseEntity((Object)this.meioAmbienteService.saveCheckListFicha(estrutura, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.saveFicha", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/fichas/{idFicha}"})
    @Operation(summary="Exclui a ficha do checklist atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteFicha(@PathVariable(name="idFicha") Integer idFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        LOG.debug("deleteFicha({})", (Object)idFicha);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteCheckListFicha(idFicha), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.deleteFicha", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/lancamentos/filtro/{empresa}"})
    @Operation(summary="Filtra os lan\u00e7amentos de checklist dispon\u00edveis")
    public ResponseEntity<Page<CheckList>> findLancamentosFiltro(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestBody FiltroChecklist filtro) {
        String modulo = "AMB";
        return this.findLancamentosFiltro(request, empresa, modulo, filtro);
    }

    @PostMapping(value={"/lancamentos/filtro/{empresa}/{modulo}"})
    @Operation(summary="Filtra os lan\u00e7amentos de checklist dispon\u00edveis")
    public ResponseEntity<Page<CheckList>> findLancamentosFiltro(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, @RequestBody FiltroChecklist filtro) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            int pageNbr = 1;
            int pageSize = 15;
            String sortField = "numero";
            boolean sortDesc = false;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            if (request.getParameter("sortField") != null) {
                sortField = request.getParameter("sortField");
            }
            if (request.getParameter("sortDesc") != null) {
                sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
            }
            LOG.debug("{} - Iniciando findLancamentos({})...", (Object)usuario.getLogin(), (Object)empresa);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (filtro == null) {
                filtro = new FiltroChecklist();
            }
            if (filtro.getConcessionaria() == null || filtro.getConcessionaria().isEmpty()) {
                ArrayList<Integer> empList = new ArrayList<Integer>();
                empList.add(emp.getId());
                filtro.setConcessionaria(empList);
            }
            filtro.setModulo(modulo);
            return new ResponseEntity((Object)this.meioAmbienteService.findCheckLists(filtro, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.findLancamentos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/lancamentos/{empresa}/filtro"})
    @Operation(summary="Lista os lan\u00e7amentos de checklist dispon\u00edveis, com toda a estrutura interna inclu\u00edda (CheckList, Itens, Anexos) ")
    public ResponseEntity<Page<CheckList>> findLancamentosMobile(HttpServletRequest request, @PathVariable(name="empresa") String empresa) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            int pageNbr = 1;
            int pageSize = 15;
            String sortField = "numero";
            boolean sortDesc = false;
            if (request.getParameter("page") != null) {
                pageNbr = Integer.valueOf(request.getParameter("page"));
            }
            if (request.getParameter("size") != null) {
                pageSize = Integer.valueOf(request.getParameter("size"));
            }
            if (request.getParameter("sortField") != null) {
                sortField = request.getParameter("sortField");
            }
            if (request.getParameter("sortDesc") != null) {
                sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
            }
            LocalDateTime lastUpdate = null;
            if (request.getParameter("lastUpdate") != null) {
                DateTimeFormatter dateFmt;
                try {
                    lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"));
                }
                catch (DateTimeParseException dteExc) {
                    lastUpdate = null;
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy-HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                if (lastUpdate == null) {
                    try {
                        dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                        lastUpdate = LocalDateTime.parse(request.getParameter("lastUpdate"), dateFmt);
                    }
                    catch (DateTimeParseException dteExc) {
                        lastUpdate = null;
                    }
                }
                LOG.debug("Usando lastUpdate==> {}", (Object)lastUpdate);
            }
            LOG.debug("{} - Iniciando findLancamentosMobile({}, {}, {})...", new Object[]{usuario.getLogin(), empresa, pageNbr, sortField});
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            String searchTxt = null;
            LocalDate datInicial = null;
            LocalDate datFinal = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            if (request.getParameter("datInicial") != null && request.getParameter("datFinal") != null) {
                try {
                    DateTimeFormatter dateFmt = DateTimeFormatter.ofPattern("dd/MM/yyyy");
                    datInicial = LocalDate.parse(request.getParameter("datInicial"), dateFmt);
                    datFinal = LocalDate.parse(request.getParameter("datFinal"), dateFmt);
                }
                catch (DateTimeParseException dteExc) {
                    datInicial = null;
                    datFinal = null;
                }
            }
            FiltroChecklist filtro = new FiltroChecklist();
            filtro.setConcessionaria(new ArrayList());
            filtro.getConcessionaria().add(emp.getId());
            filtro.setDescricao(searchTxt);
            filtro.setDatInspecaoFim(datInicial);
            filtro.setDatInspecaoFim(datFinal);
            Page rows = this.meioAmbienteService.findCheckListsMobile(filtro, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), lastUpdate);
            if (rows != null && !rows.isEmpty()) {
                for (CheckList row : rows.getContent()) {
                    row.setEmpresa(null);
                    row.setCidade(null);
                    row.setObra(null);
                    row.setRodovia(null);
                    row.setCoordenadorObra(null);
                    row.setSupervisorAmbiental(null);
                    row.setEquipeAmbiental(null);
                    row.setEquipeConcessao(null);
                    row.setEquipeEmpreiteira(null);
                    row.setPontoControle(null);
                    row.setFicha(null);
                    if (row.getItens() != null) {
                        for (CheckListItem item : row.getItens()) {
                            item.setCheckList(null);
                            if (item.getAnexos() == null) continue;
                            for (CheckListAnexo anexo : item.getAnexos()) {
                                anexo.setCheckList(null);
                                anexo.setUsuario(null);
                                if (anexo.getAnexo() == null) continue;
                                Anexo anxRepo = anexo.getAnexo();
                                anxRepo.setRepoPath(null);
                                anxRepo.setHierarquia(null);
                                anxRepo.setUsuario(null);
                                anxRepo.setStatusGed(null);
                            }
                        }
                    }
                    if (row.getAnexos() == null) continue;
                    for (CheckListAnexo anx : row.getAnexos()) {
                        anx.setCheckList(null);
                        anx.setUsuario(null);
                    }
                }
            }
            return new ResponseEntity((Object)rows, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.findLancamentosMobile", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/lancamentos/{empresa}/{idCheckList}"})
    @Operation(summary="Carrega o lan\u00e7amento de um checklist atrav\u00e9s de seu ID")
    public ResponseEntity<CheckList> getChecklistById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList) {
        String modulo = "AMB";
        return this.getChecklistById(empresa, idCheckList, modulo);
    }

    @GetMapping(value={"/lancamentos/{empresa}/{idCheckList}/{modulo}"})
    @Operation(summary="Carrega o lan\u00e7amento de um checklist atrav\u00e9s de seu ID")
    public ResponseEntity<CheckList> getChecklistById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="modulo") String modulo) {
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            CheckList checklist = this.meioAmbienteService.getCheckListById(emp.getId(), idCheckList, modulo);
            if (checklist.getItens() != null) {
                for (CheckListItem item : checklist.getItens()) {
                    item.setCheckList(null);
                    if (item.getEstrutura() == null) continue;
                    item.getEstrutura().setItens(null);
                }
            }
            return new ResponseEntity((Object)checklist, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.getCheckListById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/lancamentos/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva todo o CheckList")
    public ResponseEntity<CheckList> saveLancamento(@PathVariable(name="empresa") String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            CheckList lancamento = (CheckList)mapper.readValue(((String[])formData.get("lancamento"))[0], (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (lancamento.getId().getModulo() == null) {
                lancamento.getId().setModulo(TipoModulo.AMBIENTAL.getSigla());
            }
            if (formData.containsKey("assinaturas")) {
                String assinaturasTxt = ((String[])formData.get("assinaturas"))[0];
                CheckListAnexo[] assinaturas = (CheckListAnexo[])mapper.readValue(assinaturasTxt, CheckListAnexo[].class);
                ArrayList<CheckListAnexo> anexos = new ArrayList<CheckListAnexo>();
                for (CheckListAnexo sign : assinaturas) {
                    if (sign.getTipo() == null) {
                        sign.setTipo("S");
                    }
                    anexos.add(sign);
                }
                lancamento.setAnexos(anexos);
            }
            LOG.debug("{} - saveLancamento ({}, itens={}))", new Object[]{usuario, empresa, lancamento.getItens() != null ? lancamento.getItens().size() : 0});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (lancamento.getId().getIdEmpresa() == null) {
                    lancamento.getId().setIdEmpresa(emp.getId());
                }
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            MultiValueMap filesMap = multipartReq.getMultiFileMap();
            Integer idChecklist = lancamento.getId().getIdCheckList();
            if (idChecklist == null) {
                Integer sequencia;
                idChecklist = sequencia = this.coreService.registrarSequencia(lancamento.getId().getIdEmpresa(), "checklist_lancamento", "ambiental", "oid_checklist");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.registrarCheckList(lancamento, idChecklist, lancamento.getId().getModulo(), filesMap, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.saveCheckList", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            LOG.error("JsmExc.saveCheckList", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/lancamentos/{empresa}/{idChecklist}"})
    @Operation(summary="Exclui o checklist atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteCheckList(@PathVariable(name="empresa") String empresa, @PathVariable(name="idChecklist") Integer idChecklist, HttpServletRequest request) throws BusinessException {
        String modulo = "AMB";
        return this.deleteCheckList(empresa, idChecklist, modulo, request);
    }

    @DeleteMapping(value={"/lancamentos/{empresa}/{idChecklist}/{modulo}"})
    @Operation(summary="Exclui o checklist atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteCheckList(@PathVariable(name="empresa") String empresa, @PathVariable(name="idChecklist") Integer idChecklist, @PathVariable(name="modulo") String modulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        LOG.debug("{} - deleteCheckList({},{})", new Object[]{usuario.getLogin(), idChecklist, modulo});
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.meioAmbienteService.deleteCheckList(emp.getId(), idChecklist, modulo, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.deleteCheckList", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/lancamentos/itens/{empresa}/{idCheckList}"})
    @Operation(summary="Lista os itens de checklist dispon\u00edveis")
    public ResponseEntity<List<CheckListItem>> findItens(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList) {
        String modulo = "AMB";
        return this.findItens(request, empresa, idCheckList, modulo);
    }

    @GetMapping(value={"/lancamentos/itens/{empresa}/{idCheckList}/{modulo}"})
    @Operation(summary="Lista os itens de checklist dispon\u00edveis")
    public ResponseEntity<List<CheckListItem>> findItens(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="modulo") String modulo) {
        try {
            List anexos;
            PublicUser usuario = this.getUsuarioByJWT(request);
            if (usuario == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            LOG.debug("{} - Iniciando findItens({}, {})...", new Object[]{usuario.getLogin(), empresa, idCheckList});
            if (idCheckList == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "CheckList n\u00e3o informado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            List itens = this.meioAmbienteService.findItensByCheckList(emp.getId(), idCheckList, modulo);
            if (itens != null && (anexos = this.meioAmbienteService.findAnexosCheckList(emp.getId(), idCheckList, modulo, "I")) != null) {
                for (CheckListItem item : itens) {
                    for (CheckListAnexo anexo : anexos) {
                        if (!item.getId().getSequencia().equals(anexo.getIdItem())) continue;
                        if (item.getAnexos() == null) {
                            item.setAnexos(new ArrayList());
                        }
                        item.getAnexos().add(anexo);
                    }
                }
            }
            return new ResponseEntity((Object)itens, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.findItens", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/lancamentos/itens/{empresa}/{idCheckList}/{modulo}/{sequencia}"})
    @Operation(summary="Carrega o item de um checklist atrav\u00e9s de seu ID")
    public ResponseEntity<CheckListItem> getItemById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="modulo") String modulo, @PathVariable(name="sequencia") Integer sequencia) {
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.meioAmbienteService.getCheckListItemById(emp.getId(), idCheckList, modulo, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.getItemById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/lancamentos/itens/{empresa}/{idCheckList}/{sequencia}"})
    @Operation(summary="Exclui o item do checklist atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteItem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="modulo") String modulo, @PathVariable(name="sequencia") Integer sequencia) throws BusinessException {
        LOG.debug("deleteItem({})", (Object)idCheckList);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.meioAmbienteService.deleteCheckListItem(emp.getId(), idCheckList, modulo, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.deleteItem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/fichas/itens/{idFicha}"})
    @Operation(summary="Lista os itens de Ficha do Checklist dispon\u00edveis/atividade")
    public ResponseEntity<List<CheckListFichaItem>> findItensFicha(HttpServletRequest request, @PathVariable(name="idFicha") Integer idFicha) {
        try {
            LOG.debug("Iniciando findItensFicha...");
            if (idFicha == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Ficha n\u00e3o informada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findItensByFicha(idFicha), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.findItensFicha", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/fichas/itens/{idFicha}/{sequencia}"})
    @Operation(summary="Carrega o item de um checklist atrav\u00e9s de seu ID")
    public ResponseEntity<CheckListFichaItem> getFichaItemById(@PathVariable(name="idFicha") Integer idFicha, @PathVariable(name="sequencia") Integer sequencia) {
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.getCheckListFichaItemById(idFicha, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.getFichaItemById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/fichas/itens"})
    @Operation(summary="Salva o item da ficha do CheckList")
    public ResponseEntity<CheckListFichaItem> saveFichaItem(@RequestBody CheckListFichaItem item, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            LOG.debug("saveFichaItem ({}))", (Object)item);
            return new ResponseEntity((Object)this.meioAmbienteService.saveCheckListFichaItem(item, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.saveItem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/fichas/itens/{idFicha}/{sequencia}"})
    @Operation(summary="Exclui o item da ficha atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteFichaItem(@PathVariable(name="idFicha") Integer idFicha, @PathVariable(name="sequencia") Integer sequencia) throws BusinessException {
        LOG.debug("deleteFichaItem({})", (Object)idFicha);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteCheckListFichaItem(idFicha, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.deleteItem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/lancamentos/anexos/{empresa}/{idCheckList}"})
    @Operation(summary="Lista os anexos de checklist dispon\u00edveis")
    public ResponseEntity<List<CheckListAnexo>> findAnexosCheckList(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList) {
        String modulo = "AMB";
        return this.findAnexosCheckList(request, empresa, idCheckList, modulo);
    }

    @GetMapping(value={"/lancamentos/anexos/{empresa}/{idCheckList}/{modulo}"})
    @Operation(summary="Lista os anexos de checklist dispon\u00edveis")
    public ResponseEntity<List<CheckListAnexo>> findAnexosCheckList(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="modulo") String modulo) {
        try {
            LOG.debug("Iniciando findAnexos...");
            if (idCheckList == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "CheckList n\u00e3o informado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            List anexos = this.meioAmbienteService.findAnexosCheckList(emp.getId(), idCheckList, modulo, "I");
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.findAnexos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/lancamentos/assinaturas/{empresa}/{idCheckList}"})
    @Operation(summary="Lista as Assinaturas de checklists dispon\u00edveis")
    public ResponseEntity<List<CheckListAnexo>> findAssinaturasCheckList(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList) {
        String modulo = "AMB";
        return this.findAssinaturasCheckList(request, empresa, idCheckList, modulo);
    }

    @GetMapping(value={"/lancamentos/assinaturas/{empresa}/{idCheckList}/{modulo}"})
    @Operation(summary="Lista as Assinaturas de checklists dispon\u00edveis")
    public ResponseEntity<List<CheckListAnexo>> findAssinaturasCheckList(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="modulo") String modulo) {
        try {
            LOG.debug("Iniciando findAssinaturasCheckList({})...", (Object)empresa);
            if (idCheckList == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "CheckList n\u00e3o informado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            List anexos = this.meioAmbienteService.findAnexosCheckList(emp.getId(), idCheckList, modulo, "S");
            return new ResponseEntity((Object)anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.findAssinaturasCheckList", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/lancamentos/anexos/{empresa}/{idCheckList}/{sequencia}"})
    @Operation(summary="Carrega o anexo de um CheckList (ID), para um item (sequencia)")
    public ResponseEntity<CheckListAnexo> getAnexoCheckListById(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="sequencia") Integer sequencia) {
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.meioAmbienteService.getCheckListAnexoById(emp.getId(), idCheckList, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.getAnexoCheckListById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/lancamentos/{idCheckList}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva os Anexos do CheckList (Imagens/Documentos)")
    public ResponseEntity<CheckListAnexo> saveAnexoCheckList(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, HttpServletRequest request) throws BusinessException {
        String modulo = "AMB";
        return this.saveAnexoCheckList(empresa, idCheckList, modulo, request);
    }

    @PostMapping(value={"/{empresa}/lancamentos/{idCheckList}/{modulo}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva os Anexos do CheckList (Imagens/Documentos)")
    public ResponseEntity<CheckListAnexo> saveAnexoCheckList(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="modulo") String modulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("{} - saveAnexoCheckList ({}, {}))", new Object[]{usuario.getLogin(), empresa, idCheckList});
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            if (!formData.containsKey("anexo")) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura dos Anexos n\u00e3o foi encontrada.");
            }
            String anexoTxt = ((String[])formData.get("anexo"))[0];
            CheckListAnexo anexo = (CheckListAnexo)mapper.readValue(anexoTxt, CheckListAnexo.class);
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            MultiValueMap filesMap = multipartReq.getMultiFileMap();
            return new ResponseEntity((Object)this.meioAmbienteService.createAnexoChecklist(anexo.getId().getIdEmpresa(), anexo.getId().getIdCheckList(), modulo, anexo.getIdItem(), anexo, Boolean.valueOf(false), usuario.getLogin(), filesMap), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.saveAnexoCheckList", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            LOG.error("JsmExc.saveAnexoCheckList", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            LOG.error("JspExc.saveAnexoCheckList", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/lancamentos/{idCheckList}/assinaturas"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva as Assinaturas do CheckList")
    public ResponseEntity<List<CheckListAnexo>> saveAssinaturaCheckList(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, HttpServletRequest request) throws BusinessException {
        String modulo = "AMB";
        return this.saveAssinaturaCheckList(empresa, idCheckList, modulo, request);
    }

    @PostMapping(path={"/{empresa}/lancamentos/{idCheckList}/{modulo}/assinaturas"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva as Assinaturas do CheckList")
    public ResponseEntity<List<CheckListAnexo>> saveAssinaturaCheckList(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="modulo") String modulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("{} - saveAssinaturaCheckList ({}, {}, {}))", new Object[]{usuario.getLogin(), empresa, modulo, idCheckList});
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
            }
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            if (!formData.containsKey("assinaturas")) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Estrutura de assinaturas n\u00e3o foi encontrada.");
            }
            String assinaturasTxt = ((String[])formData.get("assinaturas"))[0];
            CheckListAnexo[] assinaturas = (CheckListAnexo[])mapper.readValue(assinaturasTxt, CheckListAnexo[].class);
            ArrayList<CheckListAnexo> anexosChecklist = new ArrayList<CheckListAnexo>();
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            MultiValueMap filesMap = multipartReq.getMultiFileMap();
            for (CheckListAnexo assinatura : assinaturas) {
                anexosChecklist.add(this.meioAmbienteService.createAnexoChecklist(emp.getId(), idCheckList, modulo, assinatura.getIdItem(), assinatura, Boolean.valueOf(true), usuario.getLogin(), filesMap));
            }
            return new ResponseEntity(anexosChecklist, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.saveAssinaturaCheckList", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            LOG.error("JsmExc.saveAssinaturaCheckList", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            LOG.error("JspExc.saveAssinaturaCheckList", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/lancamentos/anexos/{empresa}/{idCheckList}/{sequencia}"})
    @Operation(summary="Exclui o anexo do checklist atrav\u00e9s de seu ID")
    public ResponseEntity<Boolean> deleteAnexoCheckList(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="sequencia") Integer sequencia) throws BusinessException {
        LOG.debug("deleteAnexoCheckList({})", (Object)idCheckList);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.meioAmbienteService.deleteCheckListAnexo(emp.getId(), idCheckList, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.deleteAnexoCheckList", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel/{modulo}"})
    @Operation(summary="Efetua o download da Lista de CheckLists em Excel")
    public ResponseEntity<StreamingResponseBody> exportaChecklistsExcel(@PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, @RequestBody FiltroChecklist filtro, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        LOG.debug("Exportando excel, Checklist (usr={}, emp={})...", (Object)usuario, (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtro.getConcessionaria() == null || filtro.getConcessionaria().isEmpty()) {
            ArrayList<Integer> empList = new ArrayList<Integer>();
            empList.add(emp.getId());
            filtro.setConcessionaria(empList);
        }
        filtro.setModulo(modulo);
        try {
            List usersLst = this.segurancaService.findUsuarios(null, Boolean.valueOf(true));
            HashMap<Integer, Usuario> usersMap = new HashMap<Integer, Usuario>();
            for (Usuario user : usersLst) {
                usersMap.put(user.getId(), user);
            }
            StreamingResponseBody responseBody = response -> {
                int pageNbr = 1;
                int pageSize = 1500;
                String sortField = "numero";
                boolean sortDesc = false;
                if (request.getParameter("page") != null) {
                    pageNbr = Integer.valueOf(request.getParameter("page"));
                }
                if (request.getParameter("size") != null) {
                    pageSize = Integer.valueOf(request.getParameter("size"));
                }
                if (request.getParameter("sortField") != null) {
                    sortField = request.getParameter("sortField");
                }
                if (request.getParameter("sortDesc") != null) {
                    sortDesc = Boolean.valueOf(request.getParameter("sortDesc"));
                }
                Page rows = this.meioAmbienteService.findCheckLists(filtro, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc));
                response.write(this.relatorioCheckListsXls.executeXLS(empresa, rows.getContent(), (Map)usersMap, filtro.getConfigCampos()));
            };
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"checklists.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacaoPdf/{idChecklist}"})
    @Operation(summary="Efetua o download do CheckList em PDF")
    public ResponseEntity<StreamingResponseBody> exportaChecklistPdf(@PathVariable(name="empresa") String empresa, @PathVariable(name="idChecklist") Integer idChecklist, HttpServletRequest request) throws IOException {
        String modulo = "AMB";
        return this.exportaChecklistPdf(empresa, idChecklist, modulo, request);
    }

    @GetMapping(value={"/{empresa}/exportacaoPdf/{idChecklist}/{modulo}"})
    @Operation(summary="Efetua o download do CheckList em PDF")
    public ResponseEntity<StreamingResponseBody> exportaChecklistPdf(@PathVariable(name="empresa") String empresa, @PathVariable(name="idChecklist") Integer idChecklist, @PathVariable(name="modulo") String modulo, HttpServletRequest request) throws IOException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        LOG.debug("{} - Exportando pdf, checklist ({},{})...", new Object[]{usuario.getLogin(), empresa, modulo});
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            CheckList checklist = this.meioAmbienteService.getCheckListById(emp.getId(), idChecklist, modulo);
            StreamingResponseBody responseBody = response -> {
                String tipoMapa = request.getParameter("tipoMapa");
                tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
                byte[] mapaGoogle = this.getMapaEstatico(checklist.getLatitude(), checklist.getLongitude(), tipoMapa);
                response.write(this.relatorioCheckListPdf.executePdf(emp.getId(), checklist, mapaGoogle, false));
            };
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"checklist.pdf\""})).contentType(MediaType.APPLICATION_PDF).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacaoXls/{idChecklist}"})
    @Operation(summary="Efetua o download do CheckList em Excel")
    public ResponseEntity<StreamingResponseBody> exportaChecklistXls(@PathVariable(name="empresa") String empresa, @PathVariable(name="idChecklist") Integer idChecklist, HttpServletRequest request) throws IOException {
        String modulo = "AMB";
        return this.exportaChecklistXls(empresa, idChecklist, modulo, request);
    }

    @GetMapping(value={"/{empresa}/exportacaoXls/{idChecklist}/{modulo}"})
    @Operation(summary="Efetua o download do CheckList em Excel")
    public ResponseEntity<StreamingResponseBody> exportaChecklistXls(@PathVariable(name="empresa") String empresa, @PathVariable(name="idChecklist") Integer idChecklist, @PathVariable(name="modulo") String modulo, HttpServletRequest request) throws IOException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        LOG.debug("{} - Exportando XLS, checklist ({}, {})...", new Object[]{usuario.getLogin(), empresa, modulo});
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            CheckList checklist = this.meioAmbienteService.getCheckListById(emp.getId(), idChecklist, modulo);
            StreamingResponseBody responseBody = response -> response.write(this.relatorioCheckListXls.executeXLS(checklist));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"checklist.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private byte[] getMapaEstatico(BigDecimal latitude, BigDecimal longitude, String mapType) {
        String mapaUrl = "https://maps.googleapis.com";
        String uri = "/maps/api/staticmap?zoom=18&size=640x480&maptype=%s&key=%s&markers=color:red|%f,%f";
        InputStream streamCustom = this.getClass().getClassLoader().getResourceAsStream("custom.properties");
        String apiKey = "nonono";
        if (streamCustom != null) {
            Properties props = new Properties();
            try {
                props.load(streamCustom);
            }
            catch (IOException ioExc) {
                LOG.error("ioExc", (Throwable)ioExc);
            }
            apiKey = props.getProperty("googlemaps.api.key", "nonono");
        }
        HttpClient httpClient = HttpClient.create();
        WebClient webClient = WebClient.builder().baseUrl(mapaUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(0x100000)).build()).build();
        return (byte[])webClient.get().uri(String.format(uri, mapType, apiKey, latitude.doubleValue(), longitude.doubleValue()), new Object[0]).retrieve().bodyToMono(byte[].class).block(Duration.ofSeconds(10L));
    }

    @PostMapping(path={"/{empresa}/{idChecklist}/anexos/comentarios"})
    @Operation(summary="Salva o coment\u00e1rio do Anexo/Anexo Ficha da Inspe\u00e7\u00e3o Ambiental")
    public ResponseEntity<AnexoFichaVO> saveComentarioAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idChecklist") Integer idChecklist, @RequestBody AnexoFichaVO anexoFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("({}) - saveComentarioAnexo({}, {}))", new Object[]{usuario.getLogin(), empresa, idChecklist});
            this.meioAmbienteService.saveComentarioAnexoCheckList(empresa, idChecklist, anexoFicha.getSeqAnexo(), anexoFicha.getComentario());
            return new ResponseEntity((Object)anexoFicha, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idCheckList}/anexos/girar/{idAnexo}/{angulo}"})
    @Operation(summary="Gira a imagem \u00e0 esquerda ou direita, conforme \u00e2ngulo definido")
    public ResponseEntity<Boolean> girarImagem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="idAnexo") Integer idAnexo, @PathVariable(name="angulo") Integer angulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("({}) - girarImagem({}, {}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idCheckList, idAnexo, angulo});
            Boolean resultado = this.gedService.girarImagem(empresa, idAnexo, angulo, usuario.getLogin());
            return new ResponseEntity((Object)resultado, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idChecklist}/{modulo}/racs"})
    public ResponseEntity<Rac> gerarRacCheckList(@PathVariable String empresa, @PathVariable Integer idChecklist, @PathVariable String modulo, HttpServletRequest request, @RequestParam Integer idTipoRac) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Rac rac = this.meioAmbienteService.gerarRacChecklist(empresa, idChecklist, modulo, usuario.getLogin(), idTipoRac);
            return new ResponseEntity((Object)rac, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("bizExc.gerarRacCheckList", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idCheckList}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados no CheckList")
    public ResponseEntity<List<CheckListHistorico>> findHistoricosCheckList(@PathVariable(name="idCheckList") Integer idCheckList, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("{} - findHistoricos({})", (Object)usuario.getLogin(), (Object)idCheckList);
            return new ResponseEntity((Object)this.meioAmbienteService.findHistoricosCheckList(idCheckList), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.findHistoricosCheckList", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idCheckList}/{modulo}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico do CheckList de acordo com o payload informado")
    public ResponseEntity<CheckListHistorico> createHistoricoCheckList(@PathVariable(name="empresa") String empresa, @PathVariable(name="idCheckList") Integer idCheckList, @PathVariable(name="modulo") String modulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("createHistoricoCheckList({},{})", (Object)empresa, (Object)idCheckList);
            Map formData = request.getParameterMap();
            CheckListHistorico anexo = new CheckListHistorico();
            if (formData.containsKey("descricao")) {
                anexo.setDescricao(((String[])formData.get("descricao"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            CheckListHistorico response = this.meioAmbienteService.saveHistoricoCheckList(emp.getId(), idCheckList, modulo, anexo, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.createHistoricoCheckList", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idCheckList}/{modulo}/racs"})
    @Operation(summary="Consulta a Rac de acordo com a Checklist")
    public ResponseEntity<Rac> findRacByCheckList(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idCheckList, @PathVariable String modulo) {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        LOG.debug("{} - findRacByCheckList({})", (Object)usuario, (Object)empresa);
        try {
            Rac rac = this.meioAmbienteService.findRacByCheckList(empresa, idCheckList, modulo);
            return new ResponseEntity((Object)rac, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.findRacsByInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            LOG.error("Exception.findRacsByInspecao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

