/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.rac.AreaProtegida;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para \u00c1reas legalmente protegidas", name="area-protegida")
@RequestMapping(value={"/api/areasProtegidas"})
public class AreasProtegidasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(AreasProtegidasRestServices.class);
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping
    @Operation(summary="Lista as \u00e1reas protegidas")
    public ResponseEntity<List<AreaProtegida>> findAreasProtegidas(HttpServletRequest request) {
        try {
            logger.debug("Iniciando findAreasProtegidas...");
            String searchTxt = null;
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findAreasProtegidas(searchTxt), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAreasProtegidas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idAreaProtegida}"})
    @Operation(summary="Carrega a \u00e1rea protegida pelo seu Identificador")
    public ResponseEntity<AreaProtegida> getAreaProtegida(@PathVariable(name="idAreaProtegida") Integer idAreaProtegida) {
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.getAreaProtegidaById(idAreaProtegida), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAreaProtegida", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Salva a \u00e1rea protegida")
    public ResponseEntity<AreaProtegida> saveAreaProtegida(@RequestBody AreaProtegida areaProtegida, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveAreaProtegida ({}))", (Object)areaProtegida);
            return new ResponseEntity((Object)this.meioAmbienteService.saveAreaProtegida(areaProtegida, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveAreaProtegida", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idAreaProtegida}"})
    @Operation(summary="Exclui a \u00e1rea protegida atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteAreaProtegida(@PathVariable(name="idAreaProtegida") Integer idAreaProtegida) throws BusinessException {
        logger.debug("deleteAreaProtegida({})", (Object)idAreaProtegida);
        try {
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAreaProtegida(idAreaProtegida), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAreaProtegida", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

