/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.rac;

import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoio;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoioAnexo;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoioHistorico;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoioOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoioOcorrenciaPK;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoioPK;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoioSituacao;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.FiltroAreaApoio;
import br.com.oti.gesconsys.ambiental.beans.fichas.AnexoFichaVO;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaAprovacao;
import br.com.oti.gesconsys.ambiental.beans.fichas.FichaEvento;
import br.com.oti.gesconsys.ambiental.beans.rac.Ocorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.TipoEventoFicha;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAreaApoioExcel;
import br.com.oti.gesconsys.reports.ambiental.RelatorioAreaApoioPdf;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;
import reactor.netty.http.client.HttpClient;

@RestController
@Tag(description="REST Services para \u00c1reas de Apoio", name="ambiental")
@RequestMapping(value={"/api/areasApoio"})
public class AreasApoioRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(AreasApoioRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private MeioAmbienteService meioAmbienteService;
    @Autowired
    private GedService gedService;
    @Autowired
    private RelatorioAreaApoioPdf relatorioDepositoPdf;

    @PostMapping(value={"/{empresa}/filtro"})
    @Operation(summary="Retorna as \u00e1reas de apoio, de acordo com o filtro")
    public ResponseEntity<List<AreaApoio>> findAreasApoio(@PathVariable String empresa, @RequestBody FiltroAreaApoio filtro, HttpServletRequest request) {
        try {
            logger.debug("Iniciando findAreasApoio...");
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (filtro == null) {
                filtro = new FiltroAreaApoio();
            }
            if (filtro.getConcessionaria() == null || filtro.getConcessionaria().isEmpty()) {
                ArrayList<Integer> empList = new ArrayList<Integer>();
                empList.add(emp.getId());
                filtro.setConcessionaria(empList);
            }
            boolean joinAnexos = true;
            boolean joinOcorrencias = true;
            List areasApoio = this.meioAmbienteService.findAreasApoio(filtro, Boolean.valueOf(joinAnexos), Boolean.valueOf(joinOcorrencias));
            for (AreaApoio depos : areasApoio) {
                if (depos.getRodovia() == null) continue;
                Rodovia rdv = depos.getRodovia();
                rdv.setEmpresa(null);
                depos.setRodovia(rdv);
            }
            return new ResponseEntity((Object)areasApoio, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAreasApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAreaApoio}"})
    @Operation(summary="Carrega a \u00c1rea de Apoio de acordo com seu identificador")
    public ResponseEntity<AreaApoio> getAreaApoio(@PathVariable String empresa, @PathVariable Integer idAreaApoio) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            AreaApoio areas = this.meioAmbienteService.getAreaApoioById(emp.getId(), idAreaApoio);
            areas.getRodovia().setIdUsuarioIns(null);
            areas.getRodovia().setDatHorAlteracao(null);
            areas.getRodovia().setDatHorCadastro(null);
            areas.getRodovia().setEmpresa(null);
            areas.getRodovia().setIdUsuarioIns(null);
            areas.getRodovia().setIdUsuarioUpd(null);
            areas.getCoordenadorObra().setDatHorAlteracao(null);
            areas.getCoordenadorObra().setDatHorCadastro(null);
            areas.getCoordenadorObra().setDatHorUltimoLogin(null);
            areas.getCoordenadorObra().setGrupos(null);
            areas.getCoordenadorObra().setIdPoderConcedente(null);
            areas.getCoordenadorObra().setIdUsuarioIns(null);
            areas.getCoordenadorObra().setIdUsuarioUpd(null);
            areas.getCoordenadorObra().setSessionUUID(null);
            areas.getEquipeAmbiental().setDatHorAlteracao(null);
            areas.getEquipeAmbiental().setDatHorCadastro(null);
            areas.getEquipeAmbiental().setIdEmpresa(null);
            areas.getEquipeAmbiental().setIdUsuarioIns(null);
            areas.getEquipeAmbiental().setIdUsuarioUpd(null);
            areas.getEquipeConcessao().setDatHorAlteracao(null);
            areas.getEquipeConcessao().setDatHorCadastro(null);
            areas.getEquipeConcessao().setIdEmpresa(null);
            areas.getEquipeConcessao().setIdUsuarioIns(null);
            areas.getEquipeConcessao().setIdUsuarioUpd(null);
            areas.getEquipeEmpreiteira().setDatHorAlteracao(null);
            areas.getEquipeEmpreiteira().setDatHorCadastro(null);
            areas.getEquipeEmpreiteira().setIdEmpresa(null);
            areas.getEquipeEmpreiteira().setIdUsuarioIns(null);
            areas.getEquipeEmpreiteira().setIdUsuarioUpd(null);
            return new ResponseEntity((Object)areas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}"}, consumes={"multipart/form-data"})
    @Operation(summary="Registra a \u00c1rea de Apoio")
    public ResponseEntity<AreaApoio> registrarAreaApoio(@PathVariable String empresa, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            String situacaoTxt;
            String anexosTxt;
            String ocorrenciasTxt;
            Map formData = request.getParameterMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            AreaApoio depos = (AreaApoio)mapper.readValue(((String[])formData.get("areaApoio"))[0], AreaApoio.class);
            if (depos.getId() == null) {
                depos.setId(new AreaApoioPK());
            }
            logger.debug("registrarAreaApoio({}))", (Object)depos);
            if (empresa != null) {
                Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
                }
                if (depos.getId().getIdEmpresa() == null) {
                    depos.getId().setIdEmpresa(emp.getId());
                }
            }
            List ocorrencias = null;
            if (formData.containsKey("ocorrencias") && (ocorrenciasTxt = ((String[])formData.get("ocorrencias"))[0]).length() > 0) {
                ocorrencias = (List)mapper.readValue(ocorrenciasTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List anexos = null;
            if (formData.containsKey("anexos") && (anexosTxt = ((String[])formData.get("anexos"))[0]).length() > 0) {
                anexos = (List)mapper.readValue(anexosTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            List situacoes = null;
            if (formData.containsKey("situacoes") && !(situacaoTxt = ((String[])formData.get("situacoes"))[0]).isEmpty()) {
                situacoes = (List)mapper.readValue(situacaoTxt, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            AreaApoio deposDb = this.meioAmbienteService.registrarAreaApoio(depos, ocorrencias, anexos, situacoes, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)deposDb, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (JsonMappingException jsmExc) {
            logger.error("JsmExc.registrarAreaApoio", (Throwable)jsmExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jsmExc.getMessage());
        }
        catch (JsonProcessingException jspExc) {
            logger.error("JspExc.registrarAreaApoio", (Throwable)jspExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, jspExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAreaApoio}"})
    @Operation(summary="Exclui a \u00c1rea de Apoio atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteAreaApoio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio) throws BusinessException {
        logger.debug("deleteAreaApoio({}, {})", (Object)empresa, (Object)idAreaApoio);
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAreaApoio(emp.getId(), idAreaApoio), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAreaApoio}/anexos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria o anexo de acordo com o payload informado")
    public ResponseEntity<List<AreaApoioAnexo>> createAnexoAreaApoio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createAnexoDeposito({},{})", (Object)empresa, (Object)idAreaApoio);
            Map formData = request.getParameterMap();
            String comentario = null;
            if (formData.containsKey("comentario")) {
                comentario = ((String[])formData.get("comentario"))[0];
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            ArrayList filesMap = new ArrayList();
            Iterator fileNameIterator = multipartReq.getFileNames();
            while (fileNameIterator.hasNext()) {
                String uploadedName = (String)fileNameIterator.next();
                filesMap.addAll(multipartReq.getFiles(uploadedName));
            }
            ArrayList<AreaApoioAnexo> anexos = new ArrayList<AreaApoioAnexo>();
            for (MultipartFile file : filesMap) {
                AreaApoioAnexo anexo = new AreaApoioAnexo();
                anexo.setAnexo(new Anexo());
                anexo.getAnexo().setNome(file.getOriginalFilename());
                anexo.setComentario(comentario);
                anexos.add(anexo);
            }
            List response = this.meioAmbienteService.createAnexoAreaApoio(emp.getId(), idAreaApoio, anexos, usuario.getLogin(), filesMap);
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAreaApoio}/anexos"})
    @Operation(summary="Lista os anexos presentes na \u00c1rea de Apoio")
    public ResponseEntity<List<AreaApoioAnexo>> findAnexosAreaApoio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findAnexosAreaApoio(emp.getId(), idAreaApoio), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAnexosAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAreaApoio}/anexos/{seqAnexo}"})
    @Operation(summary="Exclui o anexo da \u00c1rea de Apoio a partir de seu identificador")
    public ResponseEntity<Boolean> deleteAnexoAreaApoio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio, @PathVariable(name="seqAnexo") Integer seqAnexo) throws BusinessException {
        logger.debug("deleteAnexoAreaApoio({},{},{})", new Object[]{empresa, idAreaApoio, seqAnexo});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteAnexoAreaApoio(emp.getId(), idAreaApoio, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteAnexoAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAreaApoio}/anexos/comentarios"})
    @Operation(summary="Salva o coment\u00e1rio do Anexo na Ficha da \u00c1rea de Apoio")
    public ResponseEntity<AnexoFichaVO> saveComentarioAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio, @RequestBody AnexoFichaVO anexoFicha, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - saveComentarioAnexo({}, {}))", new Object[]{usuario.getLogin(), empresa, idAreaApoio});
            this.meioAmbienteService.saveComentarioAnexoAreaApoio(empresa, idAreaApoio, anexoFicha.getSeqAnexo(), anexoFicha.getComentario());
            return new ResponseEntity((Object)anexoFicha, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/{idAreaApoio}/anexos/girar/{idAnexo}/{angulo}"})
    @Operation(summary="Gira a imagem \u00e0 esquerda ou direita, conforme \u00e2ngulo definido")
    public ResponseEntity<Boolean> girarImagem(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio, @PathVariable(name="idAnexo") Integer idAnexo, @PathVariable(name="angulo") Integer angulo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - girarImagem({}, {}, {}, {}))", new Object[]{usuario.getLogin(), empresa, idAreaApoio, idAnexo, angulo});
            Boolean resultado = this.gedService.girarImagem(empresa, idAnexo, angulo, usuario.getLogin());
            return new ResponseEntity((Object)resultado, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.saveComentarioAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAreaApoio}/ocorrencias"})
    @Operation(summary="Salva a ocorrencia, criando ou atualizando de acordo com o payload informado")
    public ResponseEntity<AreaApoioOcorrencia> updateOcorrenciaAreaApoio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio, @RequestBody AreaApoioOcorrencia ocorrencia, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("updateOcorrenciaAreaApoio({},{})", (Object)idAreaApoio, (Object)ocorrencia);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            if (ocorrencia.getId().getIdEmpresa() == null) {
                ocorrencia.getId().setIdEmpresa(emp.getId());
            }
            AreaApoioOcorrencia response = this.meioAmbienteService.saveOcorrenciaAreaApoio(emp.getId(), idAreaApoio, ocorrencia, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateOcorrenciaAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAreaApoio}/ocorrencias"})
    @Operation(summary="Lista as ocorr\u00eancias associadas \u00e0 \u00c1rea de Apoio")
    public ResponseEntity<Map<String, Object>> findOcorrenciasAreaApoio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            List ocorrenciasBase = this.meioAmbienteService.findOcorrencias(null, null);
            List depositosOcorrencias = this.meioAmbienteService.findOcorrenciasAreaApoio(emp.getId(), idAreaApoio);
            HashMap<Integer, Ocorrencia> mapSoluOcorre = new HashMap<Integer, Ocorrencia>();
            ArrayList<Ocorrencia> associadas = new ArrayList<Ocorrencia>();
            ArrayList<AreaApoioOcorrenciaPK> soluAssocList = new ArrayList<AreaApoioOcorrenciaPK>();
            for (AreaApoioOcorrencia desOcorre : depositosOcorrencias) {
                if (!mapSoluOcorre.containsKey(desOcorre.getId().getIdOcorrencia())) {
                    mapSoluOcorre.put(desOcorre.getId().getIdOcorrencia(), desOcorre.getOcorrencia());
                }
                soluAssocList.add(desOcorre.getId());
            }
            for (int idxOco = 0; idxOco < ocorrenciasBase.size(); ++idxOco) {
                Ocorrencia base = (Ocorrencia)ocorrenciasBase.get(idxOco);
                if (!mapSoluOcorre.containsKey(base.getId())) continue;
                ocorrenciasBase.remove(idxOco);
                idxOco = 0;
            }
            for (Integer idOcorre : mapSoluOcorre.keySet()) {
                associadas.add((Ocorrencia)mapSoluOcorre.get(idOcorre));
            }
            HashMap<String, List> mapOcorrencias = new HashMap<String, List>();
            mapOcorrencias.put("associadas", associadas);
            mapOcorrencias.put("disponiveis", ocorrenciasBase);
            mapOcorrencias.put("solucoes", soluAssocList);
            return new ResponseEntity(mapOcorrencias, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findOcorrenciasAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAreaApoio}/ocorrencias/{idOcorrencia}/{idSolucao}"})
    @Operation(summary="Exclui o anexo da \u00c1rea de Apoio a partir de seu identificador")
    public ResponseEntity<Boolean> deleteOcorrenciaAreaApoio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio, @PathVariable(name="idOcorrencia") Integer idOcorrencia, @PathVariable(name="idSolucao") Integer idSolucao) throws BusinessException {
        logger.debug("deleteOcorrenciaDeposito({}, {}, {}, {})", new Object[]{empresa, idAreaApoio, idOcorrencia, idSolucao});
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteOcorrenciaAreaApoio(emp.getId(), idAreaApoio, idOcorrencia, idSolucao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteOcorrenciaAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAreaApoio}/historicos"})
    @Operation(summary="Lista os hist\u00f3ricos registrados na \u00c1rea de Apoio")
    public ResponseEntity<List<AreaApoioHistorico>> findHistoricosAreaApoio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio) {
        try {
            logger.debug("findHistoricosAreaApoio({},{})", (Object)empresa, (Object)idAreaApoio);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findHistoricosAreaApoio(emp.getId(), idAreaApoio), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findHistoricosAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAreaApoio}/historicos"})
    @Operation(summary="Cria o hist\u00f3rico do Dep\u00f3sito de acordo com o payload informado")
    public ResponseEntity<AreaApoioHistorico> createHistoricoAreaApoio(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("createHistoricoAreaApoio({},{})", (Object)empresa, (Object)idAreaApoio);
            Map formData = request.getParameterMap();
            AreaApoioHistorico anexo = new AreaApoioHistorico();
            if (formData.containsKey("descricao")) {
                anexo.setDescricao(((String[])formData.get("descricao"))[0]);
            }
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            AreaApoioHistorico response = this.meioAmbienteService.saveHistoricoAreaApoio(emp.getId(), idAreaApoio, anexo, usuario.getLogin());
            return new ResponseEntity((Object)response, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.createHistoricoAreaApoio", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/exportacaoPdf/{idAreaApoio}"})
    @Operation(summary="Efetua o download da \u00c1rea de Apoio em PDF")
    public ResponseEntity<byte[]> exportaAreaApoioPdf(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio, HttpServletRequest request) throws IOException {
        logger.debug("Exportando PDF, \u00c1rea Apoio (emp={}, {})...", (Object)empresa, (Object)idAreaApoio);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        try {
            byte[] bytes;
            AreaApoio deposito = this.meioAmbienteService.getAreaApoioById(emp.getId(), idAreaApoio);
            byte[] mapaGoogle = null;
            String tipoMapa = request.getParameter("tipoMapa");
            tipoMapa = tipoMapa == null || tipoMapa.isEmpty() ? "satellite" : (tipoMapa.equalsIgnoreCase("S") ? "satellite" : "roadmap");
            if (deposito.getLatitude() != null && deposito.getLongitude() != null) {
                mapaGoogle = this.getMapaEstatico(deposito.getLatitude(), deposito.getLongitude(), tipoMapa);
            }
            if ((bytes = this.relatorioDepositoPdf.executePDF(emp.getId(), deposito, mapaGoogle, false)) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Relat\u00f3rio n\u00e3o foi gerado corretamente.");
            }
            logger.debug("Bytes.length gerados==> {}", (Object)(bytes.length > 0 ? bytes.length / 1024 : 0));
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            headers.add("Content-Disposition", "attachment; filename=\"area-apoio.pdf\"");
            headers.add("Content-Type", "application/pdf");
            return new ResponseEntity((Object)bytes, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    private byte[] getMapaEstatico(BigDecimal latitude, BigDecimal longitude, String mapType) {
        String mapaUrl = "https://maps.googleapis.com";
        String uri = "/maps/api/staticmap?zoom=18&size=640x480&maptype=%s&key=%s&markers=color:red|%f,%f";
        InputStream streamCustom = this.getClass().getClassLoader().getResourceAsStream("custom.properties");
        String apiKey = "nonono";
        if (streamCustom != null) {
            Properties props = new Properties();
            try {
                props.load(streamCustom);
            }
            catch (IOException ioExc) {
                logger.error("ioExc", (Throwable)ioExc);
            }
            apiKey = props.getProperty("googlemaps.api.key", "nonono");
        }
        HttpClient httpClient = HttpClient.create();
        WebClient webClient = WebClient.builder().baseUrl(mapaUrl).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecs.defaultCodecs().maxInMemorySize(0x100000)).build()).build();
        return (byte[])webClient.get().uri(String.format(uri, mapType, apiKey, latitude.doubleValue(), longitude.doubleValue()), new Object[0]).retrieve().bodyToMono(byte[].class).block(Duration.ofSeconds(10L));
    }

    @PostMapping(value={"/{empresa}/exportacaoExcel"})
    @Operation(summary="Efetua o download de \u00c1rea de Apoio em Excel")
    public ResponseEntity<StreamingResponseBody> exportaRacExcel(@PathVariable(name="empresa") String empresa, @RequestBody FiltroAreaApoio filtroDeposito, HttpServletRequest request) {
        logger.debug("Exportando excel, dep\u00f3sito materiais (emp={})...", (Object)empresa);
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
        }
        ArrayList<Integer> emps = new ArrayList<Integer>();
        emps.add(emp.getId());
        if (filtroDeposito == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Filtro base n\u00e3o informado.");
        }
        if (filtroDeposito.getConcessionaria() == null || filtroDeposito.getConcessionaria().isEmpty()) {
            ArrayList<Integer> empList = new ArrayList<Integer>();
            empList.add(emp.getId());
            filtroDeposito.setConcessionaria(empList);
        }
        try {
            boolean joinItem = true;
            boolean joinAnexos = true;
            List depositosMateriais = this.meioAmbienteService.findAreasApoio(filtroDeposito, Boolean.valueOf(joinItem), Boolean.valueOf(joinAnexos));
            StreamingResponseBody responseBody = response -> response.write(new RelatorioAreaApoioExcel(this.meioAmbienteService).executeXLS(depositosMateriais, filtroDeposito.getConfigCampos()));
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Cache-Control", new String[]{"no-cache, no-store, must-revalidate"})).header("Pragma", new String[]{"no-cache"})).header("Expires", new String[]{"0"})).header("Content-Disposition", new String[]{"attachment; filename=\"deposito.xlsx\""})).header("Content-Type", new String[]{"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})).body((Object)responseBody);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAreaApoio}/aprovacoes"})
    @Operation(summary="Lista as aprova\u00e7\u00f5es registrados na \u00c1rea de Apoio")
    public ResponseEntity<List<FichaAprovacao>> findAprovacoes(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAreaApoio") Integer idAreaApoio) {
        try {
            logger.debug("findAprovacoes({},{})", (Object)empresa, (Object)idAreaApoio);
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            List aprovacoes = this.meioAmbienteService.findAprovacoesById(emp.getId(), idAreaApoio, "AAP");
            return new ResponseEntity((Object)aprovacoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findAprovacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAreaApoio}/eventos/{tipoEvento}"})
    @Operation(summary="Executa o fluxo dos eventos da \u00c1rea de Apoio (Iniciar aprova\u00e7\u00e3o, Aprova\u00e7\u00e3o Obras, Aprova\u00e7\u00e3o MeioAmbiente, Cancelar Aprova\u00e7\u00e3o, Encerrar, Reabrir)")
    @ResponseBody
    public ResponseEntity<FichaEvento> executeEvento(@PathVariable String empresa, @PathVariable Integer idAreaApoio, @PathVariable String tipoEvento, @RequestParam(required=false) String descricao, @RequestParam(required=false) String perfilReprovar, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            FichaEvento evento;
            logger.debug("executeEvento({},{},{})", new Object[]{empresa, idAreaApoio, tipoEvento});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Empresa n\u00e3o encontrada (%s).", empresa));
            }
            Integer seqAprovacao = null;
            if (request.getParameter("seqAprovacao") != null) {
                try {
                    seqAprovacao = Integer.valueOf(request.getParameter("seqAprovacao"));
                }
                catch (NumberFormatException nmfExc) {
                    seqAprovacao = null;
                }
            }
            if (tipoEvento.equals(TipoEventoFicha.ENVIO_APROVACAO.getCode())) {
                evento = this.meioAmbienteService.enviarAprovacaoAreaApoio(empresa, idAreaApoio, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.APROVACAO.getCode())) {
                evento = this.meioAmbienteService.aprovarAreaApoio(empresa, idAreaApoio, seqAprovacao, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.REPROVACAO.getCode())) {
                evento = this.meioAmbienteService.reprovarAreaApoio(empresa, idAreaApoio, seqAprovacao, descricao, perfilReprovar, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.ENCERRAMENTO.getCode())) {
                evento = this.meioAmbienteService.encerrarAreaApoio(empresa, idAreaApoio, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.FINALIZACAO.getCode())) {
                evento = this.meioAmbienteService.finalizarAreaApoio(empresa, idAreaApoio, usuario.getLogin());
            } else if (tipoEvento.equals(TipoEventoFicha.NAO_FINALIZACAO.getCode())) {
                evento = this.meioAmbienteService.naoFinalizarAreaApoio(empresa, idAreaApoio, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.REABERTURA.getCode())) {
                evento = this.meioAmbienteService.reabrirAreaApoio(empresa, idAreaApoio, usuario.getLogin(), descricao);
            } else if (tipoEvento.equals(TipoEventoFicha.CANCELAMENTO.getCode())) {
                evento = this.meioAmbienteService.cancelarAreaApoio(empresa, idAreaApoio, usuario.getLogin(), perfilReprovar);
            } else {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Evento n\u00e3o reconhecido: " + tipoEvento + ".");
            }
            return new ResponseEntity((Object)evento, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateCorrecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAreaApoio}/situacoes"})
    public List<AreaApoioSituacao> findSituacoes(@PathVariable String empresa, @PathVariable Integer idAreaApoio, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("[{}] - Iniciando findSituacoes ({}, {})", new Object[]{usuario.getLogin(), empresa, idAreaApoio});
        Empresa emp = null;
        if (empresa != null) {
            emp = this.cadastroService.getEmpresaBySigla(empresa);
        }
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        if (idAreaApoio == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "\u00c1rea de Apoio n\u00e3o foi encontrada.");
        }
        try {
            return this.meioAmbienteService.findSituacoesByAreaApoio(emp.getId(), idAreaApoio);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarDadoDeUsoInterno", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAreaApoio}/situacoes/{idSituacao}"})
    public AreaApoioSituacao getSituacaoById(HttpServletRequest request, @PathVariable String empresa, @PathVariable Integer idAreaApoio, @PathVariable Integer idSituacao) {
        logger.debug("Iniciando getSituacaoById...");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Empresa emp = null;
        if (empresa != null) {
            emp = this.cadastroService.getEmpresaBySigla(empresa);
        }
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        if (idAreaApoio == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "\u00c1rea de Apoio n\u00e3o foi encontrada.");
        }
        if (idSituacao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Situa\u00e7\u00e3o n\u00e3o foi encontrada.");
        }
        try {
            logger.debug("[{}] - getSituacaoById ({}, {},{})", new Object[]{usuario.getLogin(), empresa, idAreaApoio, idSituacao});
            return this.meioAmbienteService.getSituacaoById(idSituacao);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getSituacaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAreaApoio}/situacoes"})
    @Operation(summary="Registrar uma situa\u00e7\u00e3o")
    public ResponseEntity<AreaApoioSituacao> registrarSituacao(@PathVariable String empresa, @PathVariable Integer idAreaApoio, @RequestBody AreaApoioSituacao areaApoioSituacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - registrarSituacao ({})", (Object)usuario.getLogin(), (Object)areaApoioSituacao);
            return new ResponseEntity((Object)this.meioAmbienteService.saveSituacao(empresa, idAreaApoio, areaApoioSituacao, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.registrarSituacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{empresa}/{idAreaApoio}/situacoes/{idSituacao}"})
    @Operation(summary="Atualizar uma Situa\u00e7\u00e3o ")
    public AreaApoioSituacao updateSituacao(@PathVariable String empresa, @PathVariable Integer idAreaApoio, @RequestBody AreaApoioSituacao areaApoioSituacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("[{}] - updateSituacao({})", (Object)usuario, (Object)areaApoioSituacao);
            return this.meioAmbienteService.saveSituacao(empresa, idAreaApoio, areaApoioSituacao, usuario.getLogin());
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.updateSituacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idAreaApoio}/situacoes/{idSituacao}"})
    @Operation(summary="Excluir uma Situa\u00e7\u00e3o ")
    public Boolean deleteSituacaoById(@PathVariable String empresa, @PathVariable Integer idAreaApoio, @PathVariable Integer idSituacao, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("[{}] - deleteDadoUsoInternoById ({}, {}, {})", new Object[]{usuario.getLogin(), empresa, idAreaApoio, idSituacao});
        Empresa emp = null;
        if (empresa != null) {
            emp = this.cadastroService.getEmpresaBySigla(empresa);
        }
        if (emp == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        if (idAreaApoio == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "\u00c1rea de Apoio n\u00e3o foi encontrada.");
        }
        if (idSituacao == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Situa\u00e7\u00e3o n\u00e3o foi encontrada.");
        }
        try {
            return this.meioAmbienteService.deleteSituacaoById(emp.getId(), idAreaApoio, idSituacao);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteSituacaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

