/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.iqma;

import br.com.oti.gesconsys.ambiental.beans.IndiceQualidadeAmbiental;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckList;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListEstrutura;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListItem;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListItemVO;
import br.com.oti.gesconsys.ambiental.beans.checklist.FiltroChecklist;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para IQMAS", name="ambiental")
@RequestMapping(value={"/api/ambiental/iqmas"})
public class IqmasRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(IqmasRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private MeioAmbienteService ambientalService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Retorna os IQMAS dispon\u00edveis, de acordo com o filtro")
    public ResponseEntity<List<IndiceQualidadeAmbiental>> findIqmas(@PathVariable(name="empresa") String empresa) {
        try {
            List iqmas = this.ambientalService.findIqmas(empresa);
            return new ResponseEntity((Object)iqmas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findIqmas", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idIqma}"})
    @Operation(summary="Retorna os IQMAS dispon\u00edveis, de acordo com o filtro")
    public ResponseEntity<IndiceQualidadeAmbiental> getIqma(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIqma") Integer idIqma) {
        try {
            IndiceQualidadeAmbiental iqma = this.ambientalService.getIqmaById(idIqma);
            return new ResponseEntity((Object)iqma, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getIqma", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(path={"/{empresa}/gerar"})
    @Operation(summary="Gerar o IQMA")
    public ResponseEntity<IndiceQualidadeAmbiental> gerarIqma(@PathVariable(name="empresa") String empresa, @RequestBody IndiceQualidadeAmbiental iqma, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("({}) - gerarIqma({}))", (Object)usuario.getLogin(), (Object)iqma);
            IndiceQualidadeAmbiental iqmas = this.ambientalService.gerarIqma(empresa, iqma.getDataInicial(), iqma.getDataFinal(), iqma.getIdFornecedor(), iqma.getContrato(), iqma.getIdFicha(), usuario.getLogin());
            return new ResponseEntity((Object)iqmas, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc.gerarIqma", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idIqma}"})
    @Operation(summary="Exclui o IQMA a partir de seu identificador")
    public ResponseEntity<Boolean> deleteIqma(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIqma") Integer idIqma, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("{} - deleteIqma({}, {})", new Object[]{usuario.getLogin(), empresa, idIqma});
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.ambientalService.deleteIqma(emp.getId(), idIqma), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteIqma", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idIqma}/checklists"})
    @Operation(summary="Retorna os Checklists, de acordo com a Empresa e IQMA informados")
    public ResponseEntity<Map<String, List<CheckListItemVO>>> findChecklists(@PathVariable(name="empresa") String empresa, @PathVariable(name="idIqma") Integer idIqma) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            FiltroChecklist filtroChkLst = new FiltroChecklist();
            if (filtroChkLst.getModulo() == null) {
                filtroChkLst.setModulo("AMB");
            }
            ArrayList<Integer> empresas = new ArrayList<Integer>();
            empresas.add(emp.getId());
            filtroChkLst.setConcessionaria(empresas);
            filtroChkLst.setIdIqma(idIqma);
            Page lista = this.ambientalService.findCheckListsMobile(filtroChkLst, 1, 50000, "numero", Boolean.valueOf(false), Boolean.valueOf(false), null);
            LinkedHashMap keyMap = new LinkedHashMap();
            List rows = lista.getContent();
            Iterator iterator = rows.iterator();
            while (iterator.hasNext()) {
                CheckList row;
                CheckList chkLst = row = (CheckList)iterator.next();
                String rawData = row.getId().getIdCheckList() + ":" + row.getNumero() + ":" + row.getDatInspecao().toString();
                ArrayList<CheckListItemVO> items = (ArrayList<CheckListItemVO>)keyMap.get(rawData);
                if (items == null) {
                    items = new ArrayList<CheckListItemVO>();
                    keyMap.put((CallSite)((Object)rawData), items);
                }
                for (CheckListItem item : row.getItens()) {
                    CheckListItemVO itemVO = new CheckListItemVO();
                    itemVO.setIdEmpresa(item.getId().getIdEmpresa());
                    itemVO.setIdCheckList(item.getId().getIdCheckList());
                    itemVO.setModulo(item.getId().getModulo());
                    itemVO.setSequencia(item.getId().getSequencia());
                    itemVO.setIdEstrutura(item.getIdEstrutura());
                    CheckListEstrutura estr = item.getEstrutura();
                    if (estr != null) {
                        itemVO.setNumeroItem(estr.getNumero());
                    }
                    itemVO.setData(item.getData());
                    itemVO.setValor(item.getValor());
                    itemVO.setObservacao(item.getObservacao());
                    itemVO.setIqmaCalc(item.getIqmaCalc());
                    itemVO.setNumero(chkLst.getNumero());
                    itemVO.setEquipeEmpreiteira(chkLst.getEquipeEmpreiteira());
                    items.add(itemVO);
                }
            }
            return new ResponseEntity(keyMap, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findChecklists", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

