/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.fichas;

import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoFlorestal;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.helper.ImportacaoFlorestalHelper;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Inspe\u00e7\u00f5es Florestais", name="ambiental")
@RequestMapping(value={"/api/inspecoesFlorestais"})
public class InspecoesFlorestaisRestServices
extends BaseRestService {
    private static Logger LOG = LoggerFactory.getLogger(InspecoesFlorestaisRestServices.class);
    @Autowired
    private ImportacaoFlorestalHelper importacaoFlorestal;

    @PostMapping(consumes={"multipart/form-data"}, path={"/{empresa}/processar"})
    @Operation(summary="Processa a lista de itens arb\u00f3reos da Inspe\u00e7\u00e3o.")
    @ResponseBody
    public ResponseEntity<List<InspecaoFlorestal>> executeProcessamento(@PathVariable(name="empresa") String empresa, @PathVariable(name="modulo") String modulo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
        }
        LOG.debug("{} - Iniciando importa\u00e7\u00e3o, empresa={}", (Object)usuario.getLogin(), (Object)empresa);
        ArrayList inspecoes = new ArrayList();
        try {
            StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
            return new ResponseEntity(inspecoes, (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.executeProcessamento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

