/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental.fichas;

import br.com.oti.gesconsys.ambiental.beans.fichas.FluxoAprovacaoFicha;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para Fluxos de Aprova\u00e7\u00e3o", name="ambiental")
@RequestMapping(value={"/api/fluxosAprovacoes"})
public class FluxosAprovacaoRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(FluxosAprovacaoRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private MeioAmbienteService meioAmbienteService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Lista os fluxos de aprova\u00e7\u00e3o")
    public ResponseEntity<List<FluxoAprovacaoFicha>> findFluxosAprovacao(@PathVariable(name="empresa") String empresa, HttpServletRequest request) {
        try {
            logger.debug("Iniciando findFluxosAprovacao...");
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.findFluxosAprovacao(emp.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findFluxosAprovacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idFluxoAprovacao}"})
    @Operation(summary="Carrega a \u00e1rea protegida pelo seu Identificador")
    public ResponseEntity<FluxoAprovacaoFicha> getFluxoAprovacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFluxoAprovacao") Integer idFluxoAprovacao) {
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.getFluxoAprovacaoById(idFluxoAprovacao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getFluxoAprovacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    @Operation(summary="Salva o Fluxo de Aprova\u00e7\u00e3o")
    public ResponseEntity<FluxoAprovacaoFicha> saveFluxoAprovacao(@RequestBody FluxoAprovacaoFicha fluxo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("saveFluxoAprovacao ({}))", (Object)fluxo);
            return new ResponseEntity((Object)this.meioAmbienteService.saveFluxoAprovacao(fluxo, usuario.getLogin()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveFluxoAprovacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{empresa}/{idFluxoAprovacao}"})
    @Operation(summary="Exclui o fluxo de aprova\u00e7\u00e3o atrav\u00e9s de seu Identificador")
    public ResponseEntity<Boolean> deleteFluxoAprovacao(@PathVariable(name="empresa") String empresa, @PathVariable(name="idFluxoAprovacao") Integer idFluxoAprovacao, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("deleteFluxoAprovacao({})", (Object)idFluxoAprovacao);
        try {
            Empresa emp = null;
            if (empresa != null) {
                emp = this.cadastroService.getEmpresaBySigla(empresa);
            }
            if (emp == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
            }
            return new ResponseEntity((Object)this.meioAmbienteService.deleteFluxoAprovacao(idFluxoAprovacao), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteFluxoAprovacao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

