/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest.ambiental;

import br.com.oti.gesconsys.ambiental.beans.analise.AnaliseAmbiental;
import br.com.oti.gesconsys.ambiental.beans.analise.AnaliseAnexo;
import br.com.oti.gesconsys.ambiental.beans.analise.FiltroAnalise;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoio;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoioAnexo;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.AreaApoioSituacao;
import br.com.oti.gesconsys.ambiental.beans.areasApoio.FiltroAreaApoio;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckList;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListAnexo;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListFicha;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListFichaItem;
import br.com.oti.gesconsys.ambiental.beans.checklist.CheckListItem;
import br.com.oti.gesconsys.ambiental.beans.checklist.FiltroChecklist;
import br.com.oti.gesconsys.ambiental.beans.inspecao.FiltroInspecao;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAmbiental;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoAnexo;
import br.com.oti.gesconsys.ambiental.beans.inspecao.InspecaoFicha;
import br.com.oti.gesconsys.ambiental.beans.intervencao.AutorizacaoIntervencao;
import br.com.oti.gesconsys.ambiental.beans.intervencao.FiltroIntervencao;
import br.com.oti.gesconsys.ambiental.beans.intervencao.IntervencaoAnexo;
import br.com.oti.gesconsys.ambiental.beans.intervencao.IntervencaoOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.ptc.FiltroPontoControle;
import br.com.oti.gesconsys.ambiental.beans.ptc.PontoControle;
import br.com.oti.gesconsys.ambiental.beans.rac.BoaPratica;
import br.com.oti.gesconsys.ambiental.beans.rac.BoaPraticaAnexo;
import br.com.oti.gesconsys.ambiental.beans.rac.FiltroRac;
import br.com.oti.gesconsys.ambiental.beans.rac.Rac;
import br.com.oti.gesconsys.ambiental.beans.rac.RacAnexo;
import br.com.oti.gesconsys.ambiental.beans.rac.RacCorrecao;
import br.com.oti.gesconsys.ambiental.beans.rac.RacFicha;
import br.com.oti.gesconsys.ambiental.beans.rac.RacFichaAnexo;
import br.com.oti.gesconsys.ambiental.beans.rac.RacOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.rac.RacRegraOuro;
import br.com.oti.gesconsys.ambiental.beans.rap.AutorizacaoAnexo;
import br.com.oti.gesconsys.ambiental.beans.rap.AutorizacaoOcorrencia;
import br.com.oti.gesconsys.ambiental.beans.rap.AutorizacaoRap;
import br.com.oti.gesconsys.ambiental.beans.rap.FiltroRap;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.core.TipoRefCode;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.seguranca.GrupoAcessoUsuario;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.seguranca.Usuario;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresa;
import br.com.oti.gesconsys.beans.seguranca.UsuarioEmpresaAreaVO;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.MeioAmbienteService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@Tag(description="REST Services para Endpoints Gerais do Mobile Ambiental", name="ambiental")
@RequestMapping(value={"/api/ambiental/mobile"})
public class AmbientalMobileRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(AmbientalMobileRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;
    @Autowired
    private MeioAmbienteService ambientalService;

    @GetMapping(value={"/{empresa}/downloadInitData"})
    public ResponseEntity<StreamingResponseBody> downloadInitData(@PathVariable(name="empresa") String empresa, HttpServletRequest request, HttpServletResponse response) {
        if (empresa == null || empresa.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
        }
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        response.setContentType("application/zip");
        LocalDateTime lastUpdate = null;
        String searchTxt = null;
        StreamingResponseBody stream = out -> {
            try {
                Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
                if (emp == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o encontrada.");
                }
                ArrayList<Integer> empresas = new ArrayList<Integer>();
                if (request.getParameter("empresas") != null) {
                    String[] param;
                    for (String empParm : param = request.getParameterValues("empresas")) {
                        empresas.add(Integer.valueOf(empParm));
                    }
                } else {
                    empresas.add(emp.getId());
                }
                if (empresas.size() > 1) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "N\u00e3o \u00e9 poss\u00edvel gerar ZIP de mais de uma empresa no momento.");
                }
                LocalDateTime sysDate = LocalDateTime.now();
                StringBuilder fileName = new StringBuilder();
                fileName.append(empresa).append("-");
                int day = sysDate.getDayOfMonth();
                fileName.append(day < 10 ? "0" : "").append(day);
                int month = sysDate.getMonthValue();
                fileName.append(month < 10 ? "0" : "").append(month);
                fileName.append(sysDate.getYear()).append("-");
                int hour = sysDate.getHour();
                fileName.append(hour < 10 ? "0" : "").append(hour);
                fileName.append(".zip");
                Path zipPath = Path.of(System.getProperty("java.io.tmpdir"), fileName.toString());
                logger.debug("zipfile.name={}", (Object)zipPath);
                File zipFile = zipPath.toFile();
                if (zipFile.exists()) {
                    LocalDateTime created = Instant.ofEpochMilli(zipFile.lastModified()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                    Long createdMinutes = ChronoUnit.MINUTES.between(created, LocalDateTime.now());
                    if (createdMinutes.intValue() <= 15) {
                        Long fileLength = zipFile.length();
                        response.setContentLength(fileLength.intValue());
                        response.setHeader("Content-Disposition", "attachment;filename=" + zipFile.getName());
                        Files.copy(zipPath, out);
                        logger.debug("{} - Devolvendo zipfile existente: {}", (Object)usuario.getLogin(), (Object)zipFile.getName());
                        return;
                    }
                    zipFile.delete();
                }
                this.createZipFile(zipPath, empresas, empresa, lastUpdate, searchTxt);
                Long fileLength = zipFile.length();
                response.setContentLength(fileLength.intValue());
                response.setHeader("Content-Disposition", "attachment;filename=" + zipFile.getName());
                Files.copy(zipPath, out);
            }
            catch (FileNotFoundException fnfExc) {
                logger.error("fnfExc", (Throwable)fnfExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, fnfExc.getMessage());
            }
            catch (IOException ioExc) {
                logger.error("ioExc", (Throwable)ioExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
            }
            catch (BusinessException bizExc) {
                logger.error("bizExc", (Throwable)bizExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
            }
        };
        logger.info("{} - retornando streaming response", (Object)usuario.getLogin());
        return new ResponseEntity((Object)stream, (HttpStatusCode)HttpStatus.OK);
    }

    private void createZipFile(Path zipPath, List<Integer> empresas, String empresa, LocalDateTime lastUpdate, String searchTxt) throws IOException {
        Integer idEmpresa = empresas.get(0);
        JsonFactory msgFactory = new JsonFactory();
        msgFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        ObjectMapper mapper = new ObjectMapper(msgFactory);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        try (OutputStream outputStream = Files.newOutputStream(zipPath, StandardOpenOption.CREATE_NEW);){
            FiltroRap filtroDesc;
            FiltroIntervencao filtroInte;
            FiltroAreaApoio filtroArea;
            FiltroAnalise filtroAnalise;
            Object oco2;
            FiltroInspecao filtroInsp;
            FiltroRac filtroRac;
            Page racs;
            List obras;
            List gravidades;
            List cidades;
            List equipes;
            UsuarioEmpresaAreaVO user;
            List tipoStatusUtil;
            List orgaoAprovador;
            List parecer;
            List linhas;
            List eixos;
            ZipOutputStream zipOut = new ZipOutputStream(outputStream);
            List ocorrencias = this.ambientalService.findOcorrencias(null, null);
            if (ocorrencias != null && !ocorrencias.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("ocorrencias.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)ocorrencias);
            }
            if ((eixos = this.ambientalService.findEixos(searchTxt)) != null && !eixos.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("eixos-estrategicos.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)eixos);
            }
            if ((linhas = this.ambientalService.findLinhas(searchTxt)) != null && !linhas.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("linhas-negocio.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)linhas);
            }
            if ((parecer = this.ambientalService.findPareceresAreasApoio(searchTxt)) != null && !parecer.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("parecer-autorizativo.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)parecer);
            }
            if ((orgaoAprovador = this.ambientalService.findOrgaosAprovadoresAreasApoio(searchTxt)) != null && !orgaoAprovador.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("orgao-aprovador.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)orgaoAprovador);
            }
            if ((tipoStatusUtil = this.ambientalService.findTipoStatusAreasApoio(searchTxt, null)) != null && !tipoStatusUtil.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("tipo-status.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)tipoStatusUtil);
            }
            FiltroPontoControle filtro = new FiltroPontoControle();
            filtro.setConcessionaria(empresas);
            List pontos = this.ambientalService.findPontosControle(filtro);
            Map contagem = this.ambientalService.getCountFichasByPontoControle(idEmpresa, Boolean.valueOf(false));
            for (PontoControle ponto : pontos) {
                Object idPontoTxt;
                if (ponto.getObra() != null) {
                    ponto.getObra().setTipoObra(null);
                }
                if (ponto.getRodovia() != null) {
                    ponto.getRodovia().setEmpresa(null);
                }
                if (!contagem.containsKey(idPontoTxt = ponto.getId().toString())) continue;
                ponto.setNroFichas((Integer)contagem.get(idPontoTxt));
            }
            if (pontos != null && !pontos.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("pontos-controle.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)pontos);
            }
            List usuariosEmp = this.segurancaService.findUsuariosByEmpresasAndGrupos(empresas, null, null, null, Boolean.valueOf(false), null, null);
            ArrayList<UsuarioEmpresaAreaVO> usuarios = new ArrayList<UsuarioEmpresaAreaVO>();
            if (usuariosEmp != null) {
                for (UsuarioEmpresa usuEmp : usuariosEmp) {
                    UsuarioEmpresaAreaVO user2 = UsuarioEmpresaAreaVO.fromUsuario((UsuarioEmpresa)usuEmp);
                    if (usuarios.contains(user2)) continue;
                    usuarios.add(user2);
                }
            }
            if (usuarios != null && !usuarios.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("usuarios.json"));
                mapper.writeValue((OutputStream)zipOut, usuarios);
            }
            ArrayList<String> perfis = new ArrayList<String>();
            GrupoAcessoUsuario perfilCoord = this.segurancaService.getGrupoUsuarioByRefCode(idEmpresa, TipoRefCode.GERAL_PERFIL_COORDENACAO_OBRAS);
            perfis.add(perfilCoord.getDescricao());
            usuarios.clear();
            usuariosEmp = this.segurancaService.findUsuariosByEmpresasAndGrupos(empresas, null, perfis, null, Boolean.valueOf(false), null, null);
            if (usuariosEmp != null) {
                for (Object usuEmp : usuariosEmp) {
                    user = UsuarioEmpresaAreaVO.fromUsuario((UsuarioEmpresa)usuEmp);
                    if (usuarios.contains(user)) continue;
                    usuarios.add(user);
                }
            }
            if (usuarios != null && !usuarios.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("usuarios-cooare.json"));
                mapper.writeValue((OutputStream)zipOut, usuarios);
            }
            perfis.clear();
            perfilCoord = this.segurancaService.getGrupoUsuarioByRefCode(idEmpresa, TipoRefCode.MEIO_AMBIENTE_PERFIL_COORDENACAO_AMBIENTAL);
            perfis.add(perfilCoord.getDescricao());
            usuarios.clear();
            usuariosEmp = this.segurancaService.findUsuariosByEmpresasAndGrupos(empresas, null, perfis, null, Boolean.valueOf(false), null, null);
            if (usuariosEmp != null) {
                for (Object usuEmp : usuariosEmp) {
                    user = UsuarioEmpresaAreaVO.fromUsuario((UsuarioEmpresa)usuEmp);
                    if (usuarios.contains(user)) continue;
                    usuarios.add(user);
                }
            }
            if (usuarios != null && !usuarios.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("usuarios-cooamb.json"));
                mapper.writeValue((OutputStream)zipOut, usuarios);
            }
            perfis.clear();
            GrupoAcessoUsuario perfilSup = this.segurancaService.getGrupoUsuarioByRefCode(idEmpresa, TipoRefCode.MEIO_AMBIENTE_PERFIL_SUPERVISAO_AMBIENTAL);
            perfis.add(perfilSup.getDescricao());
            usuarios.clear();
            usuariosEmp = this.segurancaService.findUsuariosByEmpresasAndGrupos(empresas, null, perfis, null, Boolean.valueOf(false), null, null);
            if (usuariosEmp != null) {
                for (UsuarioEmpresa usuEmp : usuariosEmp) {
                    UsuarioEmpresaAreaVO user3 = UsuarioEmpresaAreaVO.fromUsuario((UsuarioEmpresa)usuEmp);
                    if (usuarios.contains(user3)) continue;
                    usuarios.add(user3);
                }
            }
            if (usuarios != null && !usuarios.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("usuarios-supamb.json"));
                mapper.writeValue((OutputStream)zipOut, usuarios);
            }
            if ((equipes = this.cadastroService.findEquipes(idEmpresa, null, null, null, null)) != null && !equipes.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("equipes.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)equipes);
            }
            if ((cidades = this.cadastroService.findCidades(null, lastUpdate)) != null && !cidades.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("cidades.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)cidades);
            }
            if ((gravidades = this.ambientalService.findGravidades(searchTxt, lastUpdate)) != null && !gravidades.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("gravidades.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)gravidades);
            }
            if ((obras = this.cadastroService.findObras(idEmpresa, searchTxt, null, null, null, null, lastUpdate)) != null && !obras.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("obras.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)obras);
            }
            List regras = this.ambientalService.findRegrasOuro(searchTxt);
            for (Object reg : regras) {
                reg.setUsuarios(null);
            }
            if (regras != null && !regras.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("regras-ouro.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)regras);
            }
            List rodovias = this.cadastroService.findRodovias(searchTxt, idEmpresa, lastUpdate);
            for (Rodovia rdv : rodovias) {
                rdv.setEmpresa(null);
            }
            zipOut.putNextEntry(new ZipEntry("rodovias.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)rodovias);
            List tiposRac = this.ambientalService.findTiposFicha("RAC", searchTxt, lastUpdate);
            zipOut.putNextEntry(new ZipEntry("tipos-rac.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)tiposRac);
            List tiposAnalise = this.ambientalService.findTiposFicha("ANAMB", searchTxt, lastUpdate);
            zipOut.putNextEntry(new ZipEntry("tipos-analise-ambiental.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)tiposAnalise);
            List tiposArea = this.ambientalService.findTiposFicha("DEPOS", searchTxt, lastUpdate);
            zipOut.putNextEntry(new ZipEntry("tipos-area-apoio.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)tiposArea);
            List tiposInterv = this.ambientalService.findTiposFicha("AUINT", searchTxt, lastUpdate);
            zipOut.putNextEntry(new ZipEntry("tipos-autorizacao-intervencao.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)tiposInterv);
            List tiposDesc = this.ambientalService.findTiposFicha("AURAP", searchTxt, lastUpdate);
            zipOut.putNextEntry(new ZipEntry("tipos-autorizacao-descarte.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)tiposDesc);
            List tiposInspecao = this.ambientalService.findTiposFicha("INSPE", searchTxt, lastUpdate);
            zipOut.putNextEntry(new ZipEntry("tipos-inspecao.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)tiposInspecao);
            List statusFichas = this.ambientalService.findStatusFicha(searchTxt, null);
            zipOut.putNextEntry(new ZipEntry("status-ficha.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)statusFichas);
            List areasProtegidas = this.ambientalService.findAreasProtegidas(searchTxt);
            zipOut.putNextEntry(new ZipEntry("areas-protegidas.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)areasProtegidas);
            List requisitosLegais = this.ambientalService.findRequisitosLegais(searchTxt);
            zipOut.putNextEntry(new ZipEntry("requisitos-legais.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)requisitosLegais);
            List boasPraticas = this.ambientalService.findBoasPraticas(searchTxt);
            for (BoaPratica row : boasPraticas) {
                if (row.getAnexos() == null) continue;
                for (BoaPraticaAnexo anx : row.getAnexos()) {
                    anx.setUsuario(null);
                }
            }
            if (boasPraticas != null && !boasPraticas.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("boas-praticas.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)boasPraticas);
            }
            List fichasBase = this.ambientalService.findCheckListFichas(searchTxt);
            ArrayList<CheckListFicha> fichas = new ArrayList<CheckListFicha>();
            for (CheckListFicha fch : fichasBase) {
                CheckListFicha ficha = this.ambientalService.getCheckListFichaById(fch.getId());
                if (ficha.getItens() != null) {
                    for (CheckListFichaItem item : ficha.getItens()) {
                        item.setFicha(null);
                    }
                }
                fichas.add(ficha);
            }
            if (fichas != null && !fichas.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("checklists-fichas.json"));
                mapper.writeValue((OutputStream)zipOut, fichas);
            }
            List analisesGrupos = this.ambientalService.findAnaliseGrupos(null);
            zipOut.putNextEntry(new ZipEntry("analises-grupos.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)analisesGrupos);
            List analisesTipos = this.ambientalService.findAnaliseTipos(null);
            zipOut.putNextEntry(new ZipEntry("analises-tipos.json"));
            mapper.writeValue((OutputStream)zipOut, (Object)analisesTipos);
            int pageNbr = 1;
            int pageSize = 10000;
            String sortField = "numero";
            boolean sortDesc = true;
            FiltroChecklist filtroCheck = new FiltroChecklist();
            if (filtroCheck.getConcessionaria() == null || filtroCheck.getConcessionaria().isEmpty()) {
                filtroCheck.setConcessionaria(empresas);
            }
            filtroCheck.setModulo(TipoModulo.AMBIENTAL.getSigla());
            Page checklistLctos = this.ambientalService.findCheckListsMobile(filtroCheck, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), lastUpdate);
            for (CheckList row : checklistLctos) {
                if (row.getSupervisorAmbiental() != null) {
                    row.getSupervisorAmbiental().setGrupos(null);
                }
                if (row.getCoordenadorObra() != null) {
                    row.getCoordenadorObra().setGrupos(null);
                }
                row.setRodovia(null);
                row.setPontoControle(null);
                row.setEmpresa(null);
                row.setSupervisorAmbiental(null);
                row.setCoordenadorObra(null);
                row.setEquipeConcessao(null);
                row.setEquipeEmpreiteira(null);
                row.setEquipeAmbiental(null);
                row.setCidade(null);
                row.setObra(null);
                row.setCoordenadorAmbiental(null);
                row.setFicha(null);
                if (row.getItens() != null) {
                    for (CheckListItem item : row.getItens()) {
                        item.setCheckList(null);
                        if (item.getAnexos() == null) continue;
                        for (CheckListAnexo anexo : item.getAnexos()) {
                            anexo.setCheckList(null);
                            anexo.setUsuario(null);
                            if (anexo.getAnexo() == null) continue;
                            Anexo anxRepo = anexo.getAnexo();
                            anxRepo.setRepoPath(null);
                            anxRepo.setHierarquia(null);
                            anxRepo.setUsuario(null);
                            anxRepo.setStatusGed(null);
                        }
                    }
                }
                if (row.getAnexos() == null) continue;
                for (CheckListAnexo anx : row.getAnexos()) {
                    anx.setCheckList(null);
                    anx.setUsuario(null);
                }
            }
            if (checklistLctos != null && !checklistLctos.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("fichas-checklists.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)checklistLctos);
            }
            if ((racs = this.ambientalService.findRacsMobile(filtroRac = new FiltroRac(), pageNbr = 1, pageSize = 10000, sortField = "numero", Boolean.valueOf(sortDesc = true), empresa, Boolean.valueOf(false))) != null && !racs.isEmpty()) {
                for (Rac rac : racs) {
                    rac.setEvento(null);
                    rac.setCidade(null);
                    rac.setEmpresa(null);
                    rac.setGravidade(null);
                    rac.setTipoRac(null);
                    rac.setObra(null);
                    rac.setSupervisorAmbiental(null);
                    rac.setCoordenadorAmbiental(null);
                    rac.setCoordenadorObra(null);
                    rac.setEquipeConcessao(null);
                    rac.setEquipeEmpreiteira(null);
                    rac.setEquipeAmbiental(null);
                    rac.setPontoControle(null);
                    if (rac.getRodovia() != null) {
                        Iterator rdv = rac.getRodovia();
                        rdv.setEmpresa(null);
                        rac.setRodovia((Rodovia)rdv);
                    }
                    rac.setFichaAtual(null);
                    if (rac.getFichasRac() != null) {
                        for (RacFicha ficha : rac.getFichasRac()) {
                            ficha.setRac(null);
                            ficha.setUsuario(null);
                            if (ficha.getCorrecoes() == null || !ficha.getCorrecoes().isEmpty()) continue;
                            ficha.setCorrecoes(null);
                        }
                    }
                    if (rac.getOcorrencias() != null) {
                        for (RacOcorrencia ocorr : rac.getOcorrencias()) {
                            ocorr.setRac(null);
                            ocorr.setUsuario(null);
                        }
                    }
                    if (rac.getCorrecoes() != null) {
                        for (RacCorrecao corr : rac.getCorrecoes()) {
                            corr.setRac(null);
                            if (corr.getUsuario() == null) continue;
                            corr.setUsuario(this.getUsuarioBase(corr.getUsuario()));
                        }
                    }
                    if (rac.getRegrasOuro() != null) {
                        for (RacRegraOuro regra : rac.getRegrasOuro()) {
                            regra.setRac(null);
                            regra.setRegraOuro(null);
                        }
                    }
                    if (rac.getAnexos() != null) {
                        for (RacAnexo anx : rac.getAnexos()) {
                            anx.setRac(null);
                            anx.setUsuario(null);
                            if (anx.getAnexo() == null) continue;
                            anx.getAnexo().setDescricao(null);
                            anx.getAnexo().setHierarquia(null);
                            anx.getAnexo().setRepoPath(null);
                            anx.getAnexo().setIdProprietario(null);
                            anx.getAnexo().setStatusGed(null);
                            anx.getAnexo().setUsuario(null);
                        }
                    }
                    if (rac.getFichasRacAnexo() != null) {
                        for (RacFichaAnexo anxFicha : rac.getFichasRacAnexo()) {
                            anxFicha.setRac(null);
                            anxFicha.setUsuario(null);
                            if (anxFicha.getAnexo() == null) continue;
                            anxFicha.getAnexo().setDescricao(null);
                            anxFicha.getAnexo().setHierarquia(null);
                            anxFicha.getAnexo().setRepoPath(null);
                            anxFicha.getAnexo().setStatusGed(null);
                            anxFicha.getAnexo().setDatHorUpload(null);
                            anxFicha.getAnexo().setIdProprietario(null);
                            anxFicha.getAnexo().setUsuario(null);
                        }
                    }
                    if (rac.getRequisitosLegais() == null) continue;
                    for (RacRegraOuro regra : rac.getRequisitosLegais()) {
                        regra.setRac(null);
                        regra.setRequisito(null);
                    }
                }
            }
            if (racs != null && !racs.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("fichas-racs.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)racs);
            }
            if ((filtroInsp = new FiltroInspecao()).getConcessionaria() == null || filtroInsp.getConcessionaria().isEmpty()) {
                filtroInsp.setConcessionaria(empresas);
            }
            Page inspecoes = this.ambientalService.findInspecoes(filtroInsp, pageNbr, pageSize, sortField, Boolean.valueOf(sortDesc), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            for (InspecaoAmbiental insp : inspecoes) {
                Set fichasInsp;
                Set ocorrenciasInsp;
                insp.setRodovia(null);
                insp.setEmpresa(null);
                insp.setTipoInspecao(null);
                insp.setSupervisorAmbiental(null);
                insp.setCoordenadorObra(null);
                insp.setEquipeConcessao(null);
                insp.setEquipeEmpreiteira(null);
                insp.setEquipeAmbiental(null);
                insp.setCidade(null);
                insp.setObra(null);
                insp.setCoordenadorAmbiental(null);
                insp.setFichaAtual(null);
                insp.setAreaProtegida(null);
                insp.setInspecoesFlorestais(null);
                List anexos = insp.getAnexos();
                if (anexos != null) {
                    Iterator iterator = anexos.iterator();
                    while (iterator.hasNext()) {
                        InspecaoAnexo anx = (InspecaoAnexo)iterator.next();
                        anx.setUsuario(null);
                        if (anx.getAnexo() == null) continue;
                        Anexo anxGed = anx.getAnexo();
                        anxGed.setArea(null);
                        anxGed.setUsuario(null);
                    }
                }
                if ((ocorrenciasInsp = insp.getOcorrencias()) != null) {
                    for (Object oco2 : ocorrenciasInsp) {
                        oco2.setOcorrencia(null);
                        oco2.setSolucao(null);
                        oco2.setInspecao(null);
                        oco2.setUsuario(null);
                        oco2.setDatHorCadastro(null);
                    }
                }
                if ((fichasInsp = insp.getFichas()) == null) continue;
                oco2 = fichasInsp.iterator();
                while (oco2.hasNext()) {
                    InspecaoFicha fic = (InspecaoFicha)oco2.next();
                    fic.setInspecao(null);
                    fic.setUsuario(null);
                    fic.setStatus(null);
                }
            }
            if (inspecoes != null && !inspecoes.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("fichas-inspecoes.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)inspecoes);
            }
            if ((filtroAnalise = new FiltroAnalise()).getConcessionaria() == null || filtroAnalise.getConcessionaria().isEmpty()) {
                filtroAnalise.setConcessionaria(empresas);
            }
            List analises = this.ambientalService.findAnalises(filtroAnalise, Boolean.valueOf(true), Boolean.valueOf(true));
            for (AnaliseAmbiental analise : analises) {
                Set itens;
                if (analise.getSupervisorAmbiental() != null) {
                    analise.getSupervisorAmbiental().setGrupos(null);
                }
                if (analise.getCoordenadorObra() != null) {
                    analise.getCoordenadorObra().setGrupos(null);
                }
                analise.setRodovia(null);
                analise.setEmpresa(null);
                analise.setTipoAnalise(null);
                analise.setSupervisorAmbiental(null);
                analise.setCoordenadorObra(null);
                analise.setEquipeConcessao(null);
                analise.setEquipeEmpreiteira(null);
                analise.setEquipeAmbiental(null);
                analise.setCidade(null);
                analise.setObra(null);
                Set anexos = analise.getAnexos();
                if (anexos != null) {
                    oco2 = anexos.iterator();
                    while (oco2.hasNext()) {
                        AnaliseAnexo anx = (AnaliseAnexo)oco2.next();
                        anx.setUsuario(null);
                        if (anx.getAnexo() == null) continue;
                        Anexo anxGed = anx.getAnexo();
                        anxGed.setArea(null);
                        anxGed.setUsuario(null);
                    }
                }
                if ((itens = analise.getItens()) == null) continue;
                for (Object itn : itens) {
                    itn.setGrupo(null);
                    itn.setTipo(null);
                }
            }
            if (analises != null && !analises.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("fichas-analises.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)analises);
            }
            if ((filtroArea = new FiltroAreaApoio()).getConcessionaria() == null || filtroArea.getConcessionaria().isEmpty()) {
                filtroArea.setConcessionaria(empresas);
            }
            List areas = this.ambientalService.findAreasApoio(filtroArea, Boolean.valueOf(true), Boolean.valueOf(true));
            for (AreaApoio area : areas) {
                List situacoesArea;
                Object oco32;
                List ocorrenciasArea;
                if (area.getSupervisorAmbiental() != null) {
                    area.getSupervisorAmbiental().setGrupos(null);
                }
                if (area.getCoordenadorObra() != null) {
                    area.getCoordenadorObra().setGrupos(null);
                }
                area.setRodovia(null);
                area.setEmpresa(null);
                area.setTipoDeposito(null);
                area.setRegraOuro(null);
                area.setSupervisorAmbiental(null);
                area.setCoordenadorObra(null);
                area.setEquipeConcessao(null);
                area.setEquipeEmpreiteira(null);
                area.setEquipeAmbiental(null);
                area.setCidade(null);
                area.setObra(null);
                Set anexos = area.getAnexos();
                if (anexos != null) {
                    Object itn;
                    itn = anexos.iterator();
                    while (itn.hasNext()) {
                        AreaApoioAnexo anx = (AreaApoioAnexo)itn.next();
                        anx.setUsuario(null);
                        if (anx.getAnexo() == null) continue;
                        Anexo anxGed = anx.getAnexo();
                        anxGed.setArea(null);
                        anxGed.setUsuario(null);
                    }
                }
                if ((ocorrenciasArea = area.getOcorrencias()) != null) {
                    for (Object oco32 : ocorrenciasArea) {
                        oco32.setOcorrencia(null);
                        oco32.setSolucao(null);
                        oco32.setUsuario(null);
                        oco32.setDatHorCadastro(null);
                    }
                }
                if ((situacoesArea = area.getSituacoes()) == null) continue;
                oco32 = situacoesArea.iterator();
                while (oco32.hasNext()) {
                    AreaApoioSituacao sit = (AreaApoioSituacao)oco32.next();
                    sit.setDatHorCadastro(null);
                }
            }
            if (areas != null && !areas.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("fichas-areas-apoio.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)areas);
            }
            if ((filtroInte = new FiltroIntervencao()).getConcessionaria() == null || filtroInte.getConcessionaria().isEmpty()) {
                filtroInte.setConcessionaria(empresas);
            }
            List intervencoes = this.ambientalService.findAutorizacoesIntervencao(filtroInte, Boolean.valueOf(true), Boolean.valueOf(true));
            for (AutorizacaoIntervencao inte : intervencoes) {
                Set ocorrenciasInte;
                IntervencaoAnexo anx2;
                if (inte.getSupervisorAmbiental() != null) {
                    inte.getSupervisorAmbiental().setGrupos(null);
                }
                if (inte.getCoordenadorObra() != null) {
                    inte.getCoordenadorObra().setGrupos(null);
                }
                inte.setRodovia(null);
                inte.setEmpresa(null);
                inte.setTipoAutorizacao(null);
                inte.setRegraOuro(null);
                inte.setSupervisorAmbiental(null);
                inte.setCoordenadorObra(null);
                inte.setEquipeConcessao(null);
                inte.setEquipeEmpreiteira(null);
                inte.setEquipeAmbiental(null);
                inte.setCidade(null);
                inte.setObra(null);
                inte.setInspecoesFlorestais(null);
                Set anexos = inte.getAnexos();
                if (anexos != null) {
                    for (IntervencaoAnexo anx2 : anexos) {
                        anx2.setUsuario(null);
                        if (anx2.getAnexo() == null) continue;
                        Anexo anxGed = anx2.getAnexo();
                        anxGed.setArea(null);
                        anxGed.setUsuario(null);
                    }
                }
                if ((ocorrenciasInte = inte.getOcorrencias()) == null) continue;
                anx2 = ocorrenciasInte.iterator();
                while (anx2.hasNext()) {
                    IntervencaoOcorrencia oco4 = (IntervencaoOcorrencia)anx2.next();
                    oco4.setOcorrencia(null);
                    oco4.setSolucao(null);
                    oco4.setUsuario(null);
                    oco4.setDatHorCadastro(null);
                }
            }
            if (intervencoes != null && !intervencoes.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("fichas-autorizacao-intervencao.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)intervencoes);
            }
            if ((filtroDesc = new FiltroRap()).getConcessionaria() == null || filtroDesc.getConcessionaria().isEmpty()) {
                filtroDesc.setConcessionaria(empresas);
            }
            List descartes = this.ambientalService.findAutorizacoesRap(filtroDesc, Boolean.valueOf(true), Boolean.valueOf(true));
            for (AutorizacaoRap desc : descartes) {
                Set ocorrenciasInsp;
                if (desc.getSupervisorAmbiental() != null) {
                    desc.getSupervisorAmbiental().setGrupos(null);
                }
                if (desc.getCoordenadorObra() != null) {
                    desc.getCoordenadorObra().setGrupos(null);
                }
                desc.setRodovia(null);
                desc.setEmpresa(null);
                desc.setTipoAutorizacao(null);
                desc.setRegraOuro(null);
                desc.setSupervisorAmbiental(null);
                desc.setCoordenadorObra(null);
                desc.setEquipeConcessao(null);
                desc.setEquipeEmpreiteira(null);
                desc.setEquipeAmbiental(null);
                desc.setCidade(null);
                desc.setObra(null);
                Set anexos = desc.getAnexos();
                if (anexos != null) {
                    for (AutorizacaoAnexo anx : anexos) {
                        anx.setUsuario(null);
                        if (anx.getAnexo() == null) continue;
                        Anexo anxGed = anx.getAnexo();
                        anxGed.setArea(null);
                        anxGed.setUsuario(null);
                    }
                }
                if ((ocorrenciasInsp = desc.getOcorrencias()) == null) continue;
                for (AutorizacaoOcorrencia oco5 : ocorrenciasInsp) {
                    oco5.setOcorrencia(null);
                    oco5.setSolucao(null);
                }
            }
            if (descartes != null && !descartes.isEmpty()) {
                zipOut.putNextEntry(new ZipEntry("fichas-autorizacoes-descarte.json"));
                mapper.writeValue((OutputStream)zipOut, (Object)descartes);
            }
            zipOut.close();
        }
        logger.debug("Processo conclu\u00eddo, arquivo ZIP gerado com sucesso.");
    }

    private Usuario getUsuarioBase(Usuario usuario) {
        if (usuario == null) {
            return null;
        }
        Usuario user = new Usuario();
        user.setLogin(usuario.getLogin());
        user.setNome(usuario.getNome());
        user.setEmail(usuario.getEmail());
        return user;
    }
}

