/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.conserva.ServicoRealizado;
import br.com.oti.gesconsys.beans.conserva.TipoClasseServico;
import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.Rodovia;
import br.com.oti.gesconsys.beans.geral.Trecho;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.Servico;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.ConservaService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.rest.beans.TicketRegistroJson;
import br.com.otisw.gesconsys.util.ImageStamper;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para registro de eventos", name="registro-evento")
@RequestMapping(value={"/api/servicosRealizados"})
public class ServicosRealizadosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(ServicosRealizadosRestServices.class);
    private static DateTimeFormatter dataFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static DateTimeFormatter dataHoraFmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static NumberFormat nbrFmt = DecimalFormat.getInstance();
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private ConservaService conservaService;
    @Autowired
    private GedService gedService;
    @Autowired
    private SegurancaService segurancaService;

    @PostMapping(consumes={"multipart/form-data"})
    @ResponseBody
    public ResponseEntity<TicketRegistroJson> registrarServicoRealizado(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("Iniciando registro do Servi\u00e7o...");
        Integer idEmpresa = null;
        String classeServico = null;
        Integer idEquipe = null;
        LocalDateTime dataLancamento = null;
        String latitude = null;
        String longitude = null;
        BigDecimal kmInicial = null;
        BigDecimal kmFinal = null;
        String pista = null;
        String faixa = null;
        String mobileGuid = null;
        String observacao = null;
        Integer idGrupoServico = null;
        Integer idServico = null;
        BigDecimal quantidade = null;
        Integer idRodovia = null;
        Integer idTrecho = null;
        String trechoDesc = "";
        Integer idOrdemServico = null;
        Integer idContrato = null;
        Integer idFornecedor = null;
        try {
            Trecho trecho;
            Map formData = request.getParameterMap();
            if (formData.containsKey("idEmpresa")) {
                idEmpresa = Integer.valueOf(((String[])formData.get("idEmpresa"))[0]);
            }
            if (formData.containsKey("classeServico") && (classeServico = ((String[])formData.get("classeServico"))[0]).length() == 1) {
                classeServico = TipoClasseServico.fromCode((Character)Character.valueOf(classeServico.charAt(0))).getSigla();
            }
            if (formData.containsKey("guid")) {
                mobileGuid = ((String[])formData.get("guid"))[0];
            }
            if (formData.containsKey("dataLancamento")) {
                dataLancamento = LocalDateTime.parse(((String[])formData.get("dataLancamento"))[0], dataHoraFmt);
            }
            if (formData.containsKey("idGrupoServico")) {
                idGrupoServico = Integer.valueOf(((String[])formData.get("idGrupoServico"))[0]);
            }
            if (formData.containsKey("idServico")) {
                idServico = Integer.valueOf(((String[])formData.get("idServico"))[0]);
            } else if (formData.containsKey("servico")) {
                String servicoDesc = ((String[])formData.get("servico"))[0];
                Servico servico = this.cadastroService.getServicoByReferencia(idEmpresa, servicoDesc);
                if (servico == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Servi\u00e7o %s n\u00e3o encontrado.", servicoDesc));
                }
                idServico = servico.getId().getIdServico();
            }
            if (formData.containsKey("idRodovia")) {
                idRodovia = Integer.valueOf(((String[])formData.get("idRodovia"))[0]);
            } else if (formData.containsKey("rodovia")) {
                String rodoviaDesc = ((String[])formData.get("rodovia"))[0];
                Rodovia rodovia = this.cadastroService.getRodoviaByReferencia(idEmpresa, rodoviaDesc);
                if (rodovia == null) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, String.format("Rodovia '%s' n\u00e3o encontrada.", rodoviaDesc));
                }
                idRodovia = rodovia.getId();
            }
            if (formData.containsKey("idTrecho")) {
                idTrecho = Integer.valueOf(((String[])formData.get("idTrecho"))[0]);
                trecho = this.cadastroService.getTrechoById(idTrecho);
                trechoDesc = trecho.getDescricaoFmt();
            } else if (formData.containsKey("trecho") && (trecho = this.cadastroService.getTrechoByReferencia(trechoDesc = ((String[])formData.get("trecho"))[0])) != null) {
                idTrecho = trecho.getId();
                trechoDesc = trecho.getDescricaoFmt();
            }
            Number posNbr = null;
            if (formData.containsKey("quantidade")) {
                posNbr = nbrFmt.parse(((String[])formData.get("quantidade"))[0]);
                quantidade = new BigDecimal(posNbr.toString());
            }
            if (formData.containsKey("latitude")) {
                latitude = ((String[])formData.get("latitude"))[0];
            }
            if (formData.containsKey("longitude")) {
                longitude = ((String[])formData.get("longitude"))[0];
            }
            if (formData.containsKey("kmInicial")) {
                kmInicial = new BigDecimal(((String[])formData.get("kmInicial"))[0]);
            }
            if (formData.containsKey("kmFinal")) {
                kmFinal = new BigDecimal(((String[])formData.get("kmFinal"))[0]);
            }
            if (formData.containsKey("idEquipe")) {
                idEquipe = Integer.valueOf(((String[])formData.get("idEquipe"))[0]);
            }
            if (formData.containsKey("pista")) {
                pista = ((String[])formData.get("pista"))[0];
            }
            if (formData.containsKey("faixa")) {
                faixa = ((String[])formData.get("faixa"))[0];
            }
            if (formData.containsKey("observacao")) {
                observacao = ((String[])formData.get("observacao"))[0];
            }
            if (formData.containsKey("idOrdemServico")) {
                idOrdemServico = Integer.valueOf(((String[])formData.get("idOrdemServico"))[0]);
            }
            if (formData.containsKey("idContrato")) {
                idContrato = Integer.valueOf(((String[])formData.get("idContrato"))[0]);
            }
            if (formData.containsKey("idFornecedor")) {
                idFornecedor = Integer.valueOf(((String[])formData.get("idFornecedor"))[0]);
            }
        }
        catch (NumberFormatException nmfExc) {
            logger.error("NmfExc", (Throwable)nmfExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, nmfExc.toString());
        }
        catch (ParseException parExc) {
            logger.error("ParExc", (Throwable)parExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, parExc.toString());
        }
        catch (Exception exc) {
            logger.error("exc", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.toString());
        }
        try {
            Integer idRealizado = null;
            ServicoRealizado realizado = this.conservaService.getServicoRealizadoByUUID(idEmpresa, classeServico, usuario.getLogin(), mobileGuid);
            if (realizado == null) {
                logger.debug("Novo lan\u00e7amento, registrando...");
                realizado = this.conservaService.registrarRealizado(idEmpresa, mobileGuid, usuario.getLogin(), classeServico, idServico, dataLancamento, quantidade, latitude, longitude, kmInicial, kmFinal, idEquipe, pista, faixa, observacao, idOrdemServico, idContrato, idFornecedor);
                Integer idArea = null;
                idRealizado = realizado.getId().getIdRealizado();
                logger.debug("Iniciando upload, lancamento={}", (Object)idRealizado);
                StandardMultipartHttpServletRequest multipartReq = (StandardMultipartHttpServletRequest)request;
                List files = multipartReq.getFiles("files[]");
                if (files != null) {
                    PublicUser user = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
                    for (MultipartFile file : files) {
                        logger.debug("Upload original.fileName={}", (Object)file.getOriginalFilename());
                        ImageStamper stamper = new ImageStamper();
                        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                        String extensao = FilenameUtils.getExtension((String)file.getOriginalFilename()).toLowerCase();
                        ByteArrayOutputStream outStream = stamper.execute(file.getInputStream(), extensao, dataLancamento, null, null, null, latitude, longitude, null, trechoDesc, kmInicial != null ? kmInicial.toString() : null, kmFinal != null ? kmFinal.toString() : null);
                        outStream.writeTo(byteStream);
                        outStream.close();
                        ByteArrayInputStream fisStream = new ByteArrayInputStream(byteStream.toByteArray());
                        Anexo anexo = this.gedService.createAnexo(idEmpresa, TipoModulo.CONSERVACAO.getSigla(), "Registro Fotos", file.getOriginalFilename(), "Servi\u00e7os Realizados\\Imagens", idArea, file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), (InputStream)fisStream, user.getId(), LocalDateTime.now());
                        if (anexo != null) {
                            this.conservaService.saveAnexoRealizado(idEmpresa, idRealizado, classeServico, anexo.getId().getIdAnexo(), usuario.getLogin());
                        }
                        fisStream.close();
                        byteStream.close();
                    }
                }
            }
            return new ResponseEntity((Object)new TicketRegistroJson(realizado), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("exc", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping
    @ResponseBody
    public ResponseEntity<List<ServicoRealizado>> findServicosRealizados(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        LocalDate datInicial = null;
        LocalDate datFinal = null;
        String cnpjEmpresa = null;
        String parmVal = null;
        parmVal = request.getParameter("datInicial");
        if (parmVal != null) {
            try {
                datInicial = LocalDate.parse(parmVal, dataFmt);
            }
            catch (DateTimeParseException pseExc) {
                logger.error("pseExc", (Throwable)pseExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Par\u00e2metro: Data inicial n\u00e3o informada.");
            }
        }
        if ((parmVal = request.getParameter("datFinal")) != null) {
            try {
                datFinal = LocalDate.parse(parmVal, dataFmt);
            }
            catch (DateTimeParseException pseExc) {
                logger.error("pseExc", (Throwable)pseExc);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Par\u00e2metro: Data final n\u00e3o informada.");
            }
        }
        if ((parmVal = request.getParameter("cnpjEmpresa")) != null) {
            cnpjEmpresa = parmVal;
        }
        logger.debug("Executando findRealizados, parms=({})", new Object[]{datInicial, datFinal, cnpjEmpresa});
        try {
            Empresa empresa = this.cadastroService.getEmpresaByCnpj(cnpjEmpresa);
            if (empresa == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada para o CNPJ informado.");
            }
            List loopRealizados = this.conservaService.findRealizados(empresa.getId(), datInicial, datFinal, null, null, null, null, null, null, null);
            ArrayList<ServicoRealizado> realizados = new ArrayList<ServicoRealizado>();
            for (ServicoRealizado realizado : loopRealizados) {
                realizado.setEmpresa(null);
                realizado.setUsuario(null);
                realizado.setIdServico(null);
                realizado.setIdUsuario(null);
                realizado.setTipoSistemaOperacional(null);
                realizado.getServico().setIdUsuarioIns(null);
                realizado.getServico().setIdUsuarioUpd(null);
                realizado.getServico().setDatHorAlteracao(null);
                realizado.getServico().setDatHorCadastro(null);
                realizados.add(realizado);
            }
            return new ResponseEntity(realizados, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getOcrs", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

