/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.correspondencia.Correspondencia;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.geral.EstruturaPer;
import br.com.oti.gesconsys.beans.geral.ItemRelacaoVO;
import br.com.oti.gesconsys.beans.notificacoes.Notificacao;
import br.com.oti.gesconsys.beans.obrigacao.ObrigacaoLancamento;
import br.com.oti.gesconsys.beans.pleito.Pleito;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.Licenca;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.CorrespondenciaService;
import br.com.oti.gesconsys.business.services.LicencaService;
import br.com.oti.gesconsys.business.services.NotificacaoService;
import br.com.oti.gesconsys.business.services.ObrigacaoService;
import br.com.oti.gesconsys.business.services.PleitoService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para itens contratos", name="itensContratos")
@RequestMapping(value={"/api/itensContratos"})
public class ItensContratosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(ItensContratosRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private CorrespondenciaService correspondenciaService;
    @Autowired
    private LicencaService licencaService;
    @Autowired
    private ObrigacaoService obrigacaoService;
    @Autowired
    private NotificacaoService notificacaoService;
    @Autowired
    private PleitoService pleitoService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta os itens de contrato, de acordo com os filtros informados")
    @ResponseBody
    public ResponseEntity<List<EstruturaPer>> findItensContrato(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="itemPer", required=false) String itemPer, @RequestParam(name="itemPep", required=false) String itemPep) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findItensContrato(empresa={})...", (Object)usuario.getLogin(), (Object)empresa);
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(emp.getId());
            List itens = this.cadastroService.findEstruturasPer(emp.getId(), itemPer, itemPep);
            return new ResponseEntity((Object)itens, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findItensContrato", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.findItensContrato", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/analises"})
    @Operation(summary="Retorna os itens contratuais, de acordo com seu filtro e relacionamentos")
    @ResponseBody
    public ResponseEntity<List<ItemRelacaoVO>> findAnaliseItens(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="itemContratual", required=false) Integer itemContratual) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        logger.debug("{} - findAnaliseItens(empresa={})...", (Object)usuario.getLogin(), (Object)empresa);
        try {
            ItemRelacaoVO row;
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            empresasInt.add(emp.getId());
            EstruturaPer item = this.cadastroService.getEstruturaPerById(emp.getId(), itemContratual);
            Integer idItem = item.getId().getIdEstrutura();
            List itensCorresp = this.correspondenciaService.findCorrespondenciasByItemContratual(emp.getId(), idItem);
            List itensObriga = this.obrigacaoService.findObrigacoesByItemContratual(emp.getId(), idItem);
            List itensLicenca = this.licencaService.findLicencasByItemContratual(emp.getId(), idItem);
            List itensPleitos = this.pleitoService.findPleitosByItemContratual(emp.getId(), item.getItemPer());
            List itensNotif = this.notificacaoService.findNotificacoesByItemContratual(emp.getId(), idItem);
            ArrayList<ItemRelacaoVO> itens = new ArrayList<ItemRelacaoVO>();
            for (Correspondencia corresp : itensCorresp) {
                row = new ItemRelacaoVO("CRP");
                row.setIdEmpresa(corresp.getId().getIdEmpresa());
                if (corresp.getDatRecebimento() != null) {
                    LocalDate datRec = Instant.ofEpochMilli(corresp.getDatRecebimento().getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
                    row.setData(datRec);
                }
                row.setTitulo(corresp.getAssunto());
                row.setNumero(corresp.getId().getIdCorrespondencia().toString());
                itens.add(row);
            }
            for (ObrigacaoLancamento obriga : itensObriga) {
                row = new ItemRelacaoVO("OBR");
                row.setIdEmpresa(obriga.getId().getIdEmpresa());
                if (obriga.getDatObrigacao() != null) {
                    row.setData(obriga.getDatObrigacao());
                }
                row.setTitulo(obriga.getObrigacao().getDescricao());
                itens.add(row);
            }
            for (Notificacao notifica : itensNotif) {
                row = new ItemRelacaoVO("NTF");
                row.setIdEmpresa(notifica.getId().getIdEmpresa());
                if (notifica.getDatRecebimento() != null) {
                    row.setData(notifica.getDatRecebimento());
                }
                row.setTitulo(notifica.getDescricao());
                row.setNumero(notifica.getNroDocumento());
                itens.add(row);
            }
            for (Licenca licenca : itensLicenca) {
                row = new ItemRelacaoVO("LIC");
                row.setIdEmpresa(licenca.getIdEmpresa());
                if (licenca.getDataVencimento() != null) {
                    row.setData(licenca.getDataVencimento().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                }
                row.setTitulo(licenca.getDescricao());
                row.setNumero(licenca.getNroLicenca());
                itens.add(row);
            }
            for (Pleito pleito : itensPleitos) {
                row = new ItemRelacaoVO("PLT");
                row.setIdEmpresa(pleito.getId().getIdEmpresa());
                if (pleito.getDataFatoGerador() != null) {
                    row.setData(pleito.getDataFatoGerador());
                } else if (pleito.getDataBaseContrato() != null) {
                    row.setData(pleito.getDataBaseContrato());
                } else if (pleito.getDataInicial() != null) {
                    row.setData(pleito.getDataInicial().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                } else {
                    row.setData(pleito.getDatHorCadastro().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
                }
                row.setTitulo(pleito.getDescricao());
                row.setNumero(pleito.getId().getIdPleito().toString());
                itens.add(row);
            }
            return new ResponseEntity(itens, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.search", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            logger.error("Exception.search", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

