/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.beans.shared.GrupoServico;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(description="REST Services para grupos de servi\u00e7os", name="grupos-servicos")
@RequestMapping(value={"/api/gruposServicos"})
public class GruposServicosRestServices
extends BaseRestService {
    private static Logger logger = LoggerFactory.getLogger(GruposServicosRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/all/{idEmpresa}"})
    @ResponseBody
    public ResponseEntity<List<GrupoServico>> findGruposServicos(@PathVariable(value="idEmpresa") Integer idEmpresa, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("Iniciando findGruposServicos...");
            if (idEmpresa == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o informada.");
            }
            String searchTxt = null;
            Long lastUpdateVal = null;
            if (request.getParameter("lastUpdate") != null) {
                lastUpdateVal = Long.valueOf(request.getParameter("lastUpdate"));
            }
            if (request.getParameter("search") != null) {
                searchTxt = request.getParameter("search");
            }
            LocalDateTime lastUpdt = null;
            if (lastUpdateVal != null) {
                lastUpdt = Instant.ofEpochMilli(lastUpdateVal).atZone(ZoneId.systemDefault()).toLocalDateTime();
            }
            return new ResponseEntity((Object)this.cadastroService.findGrupos(idEmpresa, searchTxt, lastUpdt), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.findGruposServicos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idGrupoServico}"})
    public ResponseEntity<GrupoServico> getGrupoServicoById(@PathVariable(name="idGrupoServico") Integer idGrupoServico, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("getGrupoServicoById({})", (Object)idGrupoServico);
            return new ResponseEntity((Object)this.cadastroService.getGrupoServicoById(idGrupoServico), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.getGrupoServicoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping
    public ResponseEntity<GrupoServico> saveGrupoServico(@RequestBody GrupoServico grupoServico, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usr = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (usr == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        try {
            logger.debug("saveGrupoServico({})", (Object)grupoServico);
            return new ResponseEntity((Object)this.cadastroService.saveGrupoServico(grupoServico, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.saveGrupoServico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idGrupoServico}"})
    public ResponseEntity<Boolean> deleteGrupoServico(@PathVariable(name="idGrupoServico") Integer idGrupoServico, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            logger.debug("deleteCidade({})", (Object)idGrupoServico);
            return new ResponseEntity((Object)this.cadastroService.deleteGrupoServico(idGrupoServico), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            logger.error("BizExc.deleteGrupoServico", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

