/*
 * Decompiled with CFR 0.152.
 */
package br.com.oti.gesconsys.rest;

import br.com.oti.gesconsys.beans.core.TipoModulo;
import br.com.oti.gesconsys.beans.ged.Anexo;
import br.com.oti.gesconsys.beans.ged.AnexoConteudo;
import br.com.oti.gesconsys.beans.ged.AnexoIdVO;
import br.com.oti.gesconsys.beans.geral.Empresa;
import br.com.oti.gesconsys.beans.seguranca.PublicUser;
import br.com.oti.gesconsys.business.services.CadastroService;
import br.com.oti.gesconsys.business.services.GedService;
import br.com.oti.gesconsys.business.services.SegurancaService;
import br.com.oti.gesconsys.exceptions.BusinessException;
import br.com.oti.gesconsys.rest.BaseRestService;
import br.com.oti.gesconsys.utils.io.UploadedFileInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@Tag(description="REST Services para documentos", name="ged")
@RequestMapping(value={"/api/ged"})
public class GedRestServices
extends BaseRestService {
    private static final Logger LOG = LoggerFactory.getLogger(GedRestServices.class);
    @Autowired
    private CadastroService cadastroService;
    @Autowired
    private GedService gedService;
    @Autowired
    private SegurancaService segurancaService;

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta os anexos, de acordo com os filtros informados")
    @ResponseBody
    public ResponseEntity<List<Anexo>> findArquivos(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @RequestParam(name="search", required=false) String search, @RequestParam(name="modulo", required=false) String modulo) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            DateTimeFormatter dateFmt = DateTimeFormatter.ISO_LOCAL_DATE;
            String parmVal = request.getParameter("dataInicial");
            if (parmVal != null && !parmVal.isEmpty()) {
                dataInicial = LocalDate.parse(parmVal, dateFmt);
            }
            if ((parmVal = request.getParameter("dataFinal")) != null && !parmVal.isEmpty()) {
                dataFinal = LocalDate.parse(parmVal, dateFmt);
            }
            LOG.debug("API search (empresa={},search={},datIni={},datFim={})...", new Object[]{empresa, search, dataInicial, dataFinal});
            if ((search == null || search.isEmpty()) && dataInicial == null && dataFinal == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Informe o crit\u00e9rio de busca (Palavra-chave, intervalo busca, ...).");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            LocalDate dataIni = null;
            LocalDate dataFim = null;
            List areas = null;
            List docs = this.gedService.fullSearch(emp.getId(), search, dataIni, dataFim, modulo, Integer.valueOf(100), areas);
            ArrayList<Anexo> anexos = new ArrayList<Anexo>();
            for (Anexo anexo : docs) {
                anexo.setId(null);
                anexo.setErroGed(null);
                anexo.setNroErrosGed(null);
                anexo.setRepoPath(null);
                anexos.add(anexo);
            }
            return new ResponseEntity(anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.search", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            LOG.error("Exception.search", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/processar/{reprocessar}"})
    @Operation(summary="Consulta os documentos que devem ser processados no OCR")
    @ResponseBody
    public ResponseEntity<List<AnexoIdVO>> findProcessar(@PathVariable(value="reprocessar") Boolean reprocessar, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("findProcessar (reprocessar={})...", (Object)reprocessar);
            List docs = this.gedService.findProcessar(reprocessar);
            LOG.debug("findProcessar.size={}", (Object)docs.size());
            return new ResponseEntity((Object)docs, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.findProcessar", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            LOG.error("Exception.findProcessar", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAnexo}"})
    @Operation(summary="Retorna os dados completos do Anexo, atrav\u00e9s de seu identificador.")
    @ResponseBody
    public ResponseEntity<Anexo> getAnexo(@PathVariable(value="empresa") String empresa, @PathVariable(value="idAnexo") Integer idAnexo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("getAnexo({},{})...", (Object)empresa, (Object)idAnexo);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            Anexo anx = this.gedService.getAnexoById(emp.getId(), idAnexo);
            return new ResponseEntity((Object)anx, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.getAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            LOG.error("Exception.getAnexo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{idAnexo}/conteudo"})
    @Operation(summary="Retorna o conte\u00fado processado do Anexo.")
    @ResponseBody
    public ResponseEntity<AnexoConteudo> getAnexoConteudo(@PathVariable(value="empresa") String empresa, @PathVariable(value="idAnexo") Integer idAnexo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("getAnexoConteudo({},{})...", (Object)empresa, (Object)idAnexo);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            AnexoConteudo anx = this.gedService.getAnexoConteudoById(emp.getId(), idAnexo);
            return new ResponseEntity((Object)anx, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.getAnexoConteudo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            LOG.error("Exception.getAnexoConteudo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/{idAnexo}"})
    @Operation(summary="Reindexa o anexo da empresa, para atualizar dados como metadados e indexadores do GED")
    public ResponseEntity<String> reindexAnexo(@PathVariable(value="empresa") String empresa, @PathVariable(value="idAnexo") Integer idAnexo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            this.gedService.manualIndex(emp.getId(), idAnexo);
            return new ResponseEntity((Object)"Indexa\u00e7\u00e3o realizada com sucesso.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.search", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            LOG.error("Exception.search", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/metadata"})
    @Operation(summary="Atualiza as informa\u00e7\u00f5es do metadados")
    public ResponseEntity<String> updateMetadata(@RequestBody AnexoConteudo conteudo, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            Integer updated = this.gedService.updateMetadata(conteudo);
            if (updated != null) {
                if (updated > 0) {
                    return new ResponseEntity((Object)"Atualiza\u00e7\u00e3o do metadados realizada com sucesso.", (HttpStatusCode)HttpStatus.OK);
                }
                return new ResponseEntity((Object)"Metadados n\u00e3o executado, conte\u00fado inv\u00e1lido.", (HttpStatusCode)HttpStatus.OK);
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Erro atualizando GED.");
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.updateMetadata", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            LOG.error("Exception.updateMetadata", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/uuid"})
    @Operation(summary="Itera no reposit\u00f3rio buscando padr\u00f5es de documentos que n\u00e3o estejam associados com o padr\u00e3o de UUID.")
    public ResponseEntity<Boolean> generateUuid(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            return new ResponseEntity((Object)this.gedService.generateUuid(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.generateUuid", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/fillFiles"})
    @Operation(summary="Carrega arquivos da pasta definida e efetua a liga\u00e7\u00e3o no m\u00f3dulo GED")
    public ResponseEntity<Integer> fillFiles(HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            return new ResponseEntity((Object)this.gedService.postFillFiles(usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.fillFiles", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/{modulo}/{moduloItem}"})
    @Operation(summary="Retorna os dados completos de Anexo por m\u00f3dulo, item m\u00f3dulo.")
    @ResponseBody
    public ResponseEntity<List<Anexo>> getAnexoByModulo(@PathVariable(value="empresa") String empresa, @PathVariable(value="modulo") String modulo, @PathVariable(value="moduloItem") String moduloItem, HttpServletRequest request) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("getAnexoByModulo({},{},{})...", new Object[]{empresa, modulo, moduloItem});
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            TipoModulo moduloEnum = TipoModulo.fromSigla((String)modulo);
            String search = request.getParameter("search");
            String hierarquia = request.getParameter("hierarquia");
            List anx = this.gedService.findAnexosByModulo(emp.getId(), moduloEnum, moduloItem, search, hierarquia);
            return new ResponseEntity((Object)anx, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.getAnexoByModulo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            LOG.error("Exception.getAnexoByModulo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{modulo}/{moduloItem}"})
    @ResponseBody
    @Operation(summary="Salva o anexo a partir de seu m\u00f3dulo e item de m\u00f3dulo")
    public ResponseEntity<Anexo> saveAnexo(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(value="modulo") String modulo, @PathVariable(value="moduloItem") String moduloItem, @RequestParam(name="file", required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("saveAnexo({},{},{})...", new Object[]{empresa, modulo, moduloItem});
            if (file == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Arquivo n\u00e3o foi informado.");
            }
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            TipoModulo moduloEnum = TipoModulo.fromSigla((String)modulo);
            PublicUser usu = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
            String descricao = null;
            String hierarquia = null;
            String categoria = null;
            Integer tipoVersao = null;
            if (request.getParameter("categoria") != null) {
                categoria = request.getParameter("categoria");
            }
            if (request.getParameter("descricao") != null) {
                descricao = request.getParameter("descricao");
            }
            if (request.getParameter("hierarquia") != null) {
                hierarquia = request.getParameter("hierarquia");
            }
            if (request.getParameter("tipoVersao") != null) {
                tipoVersao = Integer.valueOf(request.getParameter("tipoVersao"));
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            Anexo arquivo = this.gedService.createAnexo(emp.getId(), moduloEnum.getSigla(), moduloItem, descricao, hierarquia, categoria, null, fileInfo, usu.getId(), LocalDateTime.now(), null, tipoVersao);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)arquivo);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.saveAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            LOG.error("BizExc.saveAnexo", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @PutMapping(consumes={"multipart/form-data"}, value={"/{empresa}/{uuid}"})
    @ResponseBody
    @Operation(summary="Atualiza o anexo a partir de seu m\u00f3dulo e item de m\u00f3dulo, substituindo ou n\u00e3o o anexo no reposit\u00f3rio (se informado)")
    public ResponseEntity<Anexo> updateAnexo(HttpServletRequest request, @PathVariable(name="empresa") String empresa, @PathVariable(value="uuid") String uuidAnexo, @RequestParam(name="file", required=false) MultipartFile file) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("updateAnexo({},{})...", (Object)empresa, (Object)uuidAnexo);
            String descricao = null;
            String hierarquia = null;
            Integer tipoVersao = null;
            String categoria = null;
            if (request.getParameter("categoria") != null) {
                categoria = request.getParameter("categoria");
            }
            if (request.getParameter("descricao") != null) {
                descricao = request.getParameter("descricao");
            }
            if (request.getParameter("hierarquia") != null) {
                hierarquia = request.getParameter("hierarquia");
            }
            if (request.getParameter("tipoVersao") != null) {
                try {
                    tipoVersao = Integer.valueOf(request.getParameter("tipoVersao"));
                }
                catch (NumberFormatException nmfExc) {
                    tipoVersao = 2;
                }
            }
            Anexo arquivo = this.gedService.updateAnexoOrFile(empresa, uuidAnexo, descricao, hierarquia, categoria, usuario.getLogin(), LocalDateTime.now(), tipoVersao, file);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.ACCEPTED).body((Object)arquivo);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.updateAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/remover/{empresa}/{idAnexo}"})
    @Operation(summary="Deleta o anexo de acordo com seu ID.")
    public ResponseEntity<Boolean> deleteAnexo(@PathVariable(name="empresa") String empresa, @PathVariable(name="idAnexo") Integer idAnexo, HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("deleteAnexo({}, {})", (Object)empresa, (Object)idAnexo);
            Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
            return new ResponseEntity((Object)this.gedService.removeAnexo(emp.getId(), idAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.deleteTipoDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/deleteCachedAnexos"})
    @Operation(summary="Exclui todos os anexo pendentes de remo\u00e7\u00e3o, em lotes definidos (ex: 500, 1000)")
    public ResponseEntity<Integer> deleteCachedAnexos(HttpServletRequest request) throws BusinessException {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        try {
            LOG.debug("deleteCachedAnexos");
            return new ResponseEntity((Object)this.gedService.deleteAnexos(), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            LOG.error("BizExc.deleteCachedAnexos", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/download/{empresa}/anexos"})
    @Operation(summary="Efetua o download dos anexos, considerando o maximo aceit\u00e1vel pelo spring")
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> downloadAnexos(@PathVariable(name="empresa") String empresa, List<String> uuidList, HttpServletRequest request, HttpServletResponse response) {
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        LOG.debug("{} - API downloadAnexos...", (Object)usuario.getLogin());
        if (uuidList == null || uuidList.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Lista de anexos n\u00e3o informada.");
        }
        LocalDateTime sysDate = LocalDateTime.now();
        StreamingResponseBody stream = out -> {
            StringBuilder fileName = new StringBuilder();
            fileName.append(empresa).append("-");
            int day = sysDate.getDayOfMonth();
            fileName.append(day < 10 ? "0" : "").append(day);
            int month = sysDate.getMonthValue();
            fileName.append(month < 10 ? "0" : "").append(month);
            fileName.append(sysDate.getYear()).append("-");
            int hour = sysDate.getHour();
            fileName.append(hour < 10 ? "0" : "").append(hour);
            fileName.append(".zip");
            Path zipPath = Path.of(System.getProperty("java.io.tmpdir"), fileName.toString());
            LOG.debug("zipfile.name = {}", (Object)zipPath);
            File zipFile = zipPath.toFile();
            Long fileLength = zipFile.length();
            response.setContentLength(fileLength.intValue());
            response.setHeader("Content-Disposition", "attachment;filename=" + zipFile.getName());
            Files.copy(zipPath, out);
        };
        LOG.info("streaming response({})", (Object)empresa);
        return new ResponseEntity((Object)stream, (HttpStatusCode)HttpStatus.OK);
    }

    private void createZipFile(Path zipPath, String empresa, List<String> uuidList) throws IOException {
        Empresa emp = this.cadastroService.getEmpresaBySigla(empresa);
        JsonFactory msgFactory = new JsonFactory();
        msgFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        ObjectMapper mapper = new ObjectMapper(msgFactory);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        String alternatePath = null;
        try (OutputStream outputStream = Files.newOutputStream(zipPath, StandardOpenOption.CREATE_NEW);){
            ZipOutputStream zipOut = new ZipOutputStream(outputStream);
            for (String uuid : uuidList) {
                try {
                    byte[] byArray = this.gedService.getFileBytesByUUID(emp.getId(), uuid, alternatePath);
                }
                catch (BusinessException bizExc) {
                    LOG.error("Anexo {} n\u00e3o foi encontrado = {}", (Object)uuid, (Object)bizExc);
                }
            }
            zipOut.close();
        }
    }
}

