/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.spring.security.keycloak;

import br.gov.antt.sgctt.core.beans.seguranca.Usuario;
import br.gov.antt.sgctt.services.dao.seguranca.UsuarioDAO;
import br.gov.antt.sgctt.spring.security.keycloak.KeycloakAdminManager;
import java.time.LocalDateTime;
import java.util.List;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeycloakSyncService {
    @Value(value="${keycloak.realm}")
    private String realm;
    private static final Logger logger = LoggerFactory.getLogger(KeycloakSyncService.class);
    private final KeycloakAdminManager keycloakAdminManager;
    private final UsuarioDAO usuarioDAO;

    public KeycloakSyncService(KeycloakAdminManager keycloakAdminManager, UsuarioDAO usuarioDAO) {
        this.keycloakAdminManager = keycloakAdminManager;
        this.usuarioDAO = usuarioDAO;
    }

    @Transactional
    public void syncUsersFromKeycloak() {
        logger.debug("Inicializando processo de sincroniza\u00e7\u00e3o de usu\u00e1rios com Keycloak...");
        List usersDB = this.usuarioDAO.findAll();
        RealmResource realmResource = (RealmResource)this.keycloakAdminManager.execute(x -> x);
        UsersResource usersResource = realmResource.users();
        for (Usuario user : usersDB) {
            try {
                List keycloakUsers = usersResource.searchByUsername(user.getLogin(), Boolean.valueOf(true));
                if (!keycloakUsers.isEmpty()) {
                    UserRepresentation keycloakUser = (UserRepresentation)keycloakUsers.getFirst();
                    this.updateLocalUser(keycloakUser, user);
                    this.usuarioDAO.save((Object)user);
                    continue;
                }
                logger.debug("Usu\u00e1rio {} existe localmente mas n\u00e3o foi encontrado no Keycloak", (Object)user.getLogin());
            }
            catch (Exception e) {
                logger.debug("Um erro ocorreu na sincroniza\u00e7\u00e3o do usu\u00e1rio: {}", (Object)user.getLogin(), (Object)e);
            }
        }
        logger.debug("Processo de sincroniza\u00e7\u00e3o dos usu\u00e1rios finalizado com sucesso");
    }

    protected void updateLocalUser(UserRepresentation keycloakUser, Usuario user) {
        boolean updatable = this.needsUpdate(keycloakUser, user);
        if (updatable) {
            user.setLogin(keycloakUser.getUsername());
            user.setEmail(keycloakUser.getEmail());
            user.setDatHorAlteracao(LocalDateTime.now());
            user.setNome(keycloakUser.getFirstName() + " " + keycloakUser.getLastName());
            logger.debug("Cadastro ATUALIZADO: O usu\u00e1rio [{}] teve suas informa\u00e7\u00f5es sincronizadas com o Keycloak.", (Object)user.getLogin());
        } else {
            logger.debug("As informa\u00e7\u00f5es do usu\u00e1rio [{}] continuam as mesmas, nada para alterar...", (Object)user.getLogin());
        }
    }

    protected boolean needsUpdate(UserRepresentation keycloakUser, Usuario user) {
        return !user.getLogin().equals(keycloakUser.getUsername()) || !user.getEmail().equals(keycloakUser.getEmail()) || !user.getNome().equals(keycloakUser.getFirstName() + " " + keycloakUser.getLastName());
    }
}

