/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.spring.security.keycloak;

import br.gov.antt.sgctt.spring.security.keycloak.KeycloakCoreService;
import br.gov.antt.sgctt.spring.security.keycloak.KeycloakRoleInitializer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/keycloak"})
public class KeycloakSampleSyncRestService {
    private final KeycloakCoreService keycloakCoreService;
    private final KeycloakRoleInitializer keycloakRoleInitializer;

    public KeycloakSampleSyncRestService(KeycloakCoreService keycloakCoreService, KeycloakRoleInitializer keycloakRoleInitializer) {
        this.keycloakCoreService = keycloakCoreService;
        this.keycloakRoleInitializer = keycloakRoleInitializer;
    }

    @PostMapping(value={"/sync"})
    public void syncKeycloak() {
        this.keycloakCoreService.syncUsersFromKeycloak();
    }

    @PostMapping(value={"/migrate"})
    private void migrateKeycloak() {
        this.keycloakCoreService.migrateUsers();
    }

    @PostMapping(path={"/migrate/modulosAcesso"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> importRolesFromFile(@RequestPart(value="file") MultipartFile file) {
        try {
            if (file.isEmpty()) {
                return ResponseEntity.badRequest().body((Object)"Arquivo est\u00e1 vazio");
            }
            String fileName = file.getOriginalFilename();
            if (fileName == null || !fileName.toLowerCase().endsWith(".csv")) {
                return ResponseEntity.badRequest().body((Object)"Arquivo deve ser .csv");
            }
            List results = this.keycloakCoreService.createRolesFromCsv(file);
            return ResponseEntity.ok(Map.of("message", "Processamento conclu\u00eddo", "totalProcessed", results.size(), "details", results));
        }
        catch (IOException e) {
            return ResponseEntity.status((int)500).body((Object)("Erro ao ler arquivo: " + e.getMessage()));
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)("Erro interno: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/sync/roles"})
    public void importRolesFromFile() {
        this.keycloakRoleInitializer.runKeycloakRolesSync();
    }
}

