/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.spring.security.keycloak;

import br.gov.antt.sgctt.spring.security.keycloak.KeycloakAdminManager;
import br.gov.antt.sgctt.spring.security.keycloak.KeycloakCoreService;
import br.gov.antt.sgctt.spring.security.keycloak.KeycloakRequiredRoles;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.representations.idm.RoleRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeycloakRoleInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeycloakRoleInitializer.class);
    private final KeycloakAdminManager keycloakAdminManager;
    private final KeycloakCoreService keycloakCoreService;
    @Value(value="${keycloak.realm}")
    private String realm;
    @Value(value="${keycloak.admin-client.id}")
    private String client;

    public KeycloakRoleInitializer(KeycloakCoreService keycloakCoreService, KeycloakAdminManager keycloakAdminManager) {
        this.keycloakCoreService = keycloakCoreService;
        this.keycloakAdminManager = keycloakAdminManager;
    }

    public void runKeycloakRolesSync() {
        LOGGER.debug("Come\u00e7ando sincroniza\u00e7\u00e3o de cargos com Keycloak...");
        String clientUUID = this.keycloakCoreService.getClientUuid(this.client);
        try {
            Set existingRoles = (Set)this.keycloakAdminManager.execute(x -> x.clients().get(clientUUID).roles().list().stream().map(RoleRepresentation::getName).collect(Collectors.toSet()));
            LOGGER.debug("Encontrados {} cargos no realm '{}'.", (Object)existingRoles.size(), (Object)this.realm);
            for (KeycloakRequiredRoles requiredRole : KeycloakRequiredRoles.values()) {
                String roleName = requiredRole.name();
                if (existingRoles.contains(roleName)) continue;
                RoleRepresentation newRole = new RoleRepresentation();
                newRole.setName(roleName);
                newRole.setDescription("Role for " + roleName.replace("_", " ").toLowerCase());
                ((RolesResource)this.keycloakAdminManager.execute(x -> x.clients().get(clientUUID).roles())).create(newRole);
                LOGGER.info("Criado cargo faltante no Keycloak: {}", (Object)roleName);
            }
            LOGGER.info("Sincroniza\u00e7\u00e3o de cargos com Keycloak finalizada com sucesso.");
        }
        catch (Exception e) {
            LOGGER.debug("FATAL: N\u00e3o foi poss\u00edvel sincronizar cargos com o Keycloak: {}.", (Throwable)e);
            throw new RuntimeException("Failed to synchronize Keycloak roles", e);
        }
    }
}

