/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.spring.security.keycloak;

import br.gov.antt.sgctt.core.beans.geral.Empresa;
import br.gov.antt.sgctt.core.beans.seguranca.DTOs.RefreshTokenResponseDTO;
import br.gov.antt.sgctt.core.beans.seguranca.DTOs.RevokeRefreshTokenDTO;
import br.gov.antt.sgctt.core.beans.seguranca.DTOs.TokenResponseDTO;
import br.gov.antt.sgctt.core.beans.seguranca.GrupoAcessoUsuario;
import br.gov.antt.sgctt.core.beans.seguranca.Usuario;
import br.gov.antt.sgctt.core.beans.seguranca.UsuarioEmpresa;
import br.gov.antt.sgctt.core.beans.seguranca.UsuarioEmpresaPK;
import br.gov.antt.sgctt.core.beans.seguranca.UsuarioGrupo;
import br.gov.antt.sgctt.core.beans.seguranca.UsuarioGrupoPK;
import br.gov.antt.sgctt.core.beans.seguranca.UsuarioPerfil;
import br.gov.antt.sgctt.core.beans.seguranca.VOs.UsuarioChangePasswordRequestVO;
import br.gov.antt.sgctt.core.dto.keycloak.RoleDTO;
import br.gov.antt.sgctt.geral.TipoRefCode;
import br.gov.antt.sgctt.seguranca.UsuarioSessao;
import br.gov.antt.sgctt.seguranca.UsuarioSessaoPK;
import br.gov.antt.sgctt.services.CoreService;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.SegurancaService;
import br.gov.antt.sgctt.services.dao.geral.EmpresaDAO;
import br.gov.antt.sgctt.services.dao.seguranca.GrupoAcessoUsuarioDAO;
import br.gov.antt.sgctt.services.dao.seguranca.ModuloAcessoDAO;
import br.gov.antt.sgctt.services.dao.seguranca.UsuarioDAO;
import br.gov.antt.sgctt.services.dao.seguranca.UsuarioEmpresaDAO;
import br.gov.antt.sgctt.services.dao.seguranca.UsuarioGrupoDAO;
import br.gov.antt.sgctt.services.dao.seguranca.UsuarioPerfilDAO;
import br.gov.antt.sgctt.services.dao.seguranca.UsuarioSessaoDAO;
import br.gov.antt.sgctt.spring.security.keycloak.KeycloakAdminManager;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleScopeResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class KeycloakCoreService {
    @Value(value="${keycloak.realm}")
    private String realm;
    @Value(value="${keycloak.default-password}")
    private String defaultPassword;
    @Value(value="${keycloak.server-url}")
    private String serverUrl;
    @Value(value="${keycloak.admin-client.id}")
    private String clientId;
    @Value(value="${keycloak.admin-client.secret}")
    private String clientSecret;
    @Value(value="${keycloak.server-realm-url}")
    private String keycloakUntilRealmURL;
    @Value(value="${keycloak.server-realm-url}/protocol/openid-connect/token")
    private String tokenEndpoint;
    private static final Logger logger = LoggerFactory.getLogger(KeycloakCoreService.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final UsuarioGrupoDAO usuarioGrupoDAO;
    private final KeycloakAdminManager keycloakAdminManager;
    private final UsuarioDAO usuarioDAO;
    private final SegurancaService segurancaService;
    private final JwtDecoder jwtDecoder;
    private final CoreService coreService;
    private final GrupoAcessoUsuarioDAO grupoAcessoUsuarioDAO;
    private final UsuarioSessaoDAO usuarioSessaoDAO;
    private final UsuarioEmpresaDAO usuarioEmpresaDAO;
    private final EmpresaDAO empresaDAO;
    private final UsuarioPerfilDAO usuarioPerfilDAO;
    private final ModuloAcessoDAO moduloAcessoDAO;
    private final ObjectMapper objectMapper;
    private String cachedToken;
    private LocalDateTime tokenExpiry;
    private static final String AUTHORIZATION_PROPERTY = "Authorization";
    private static final String AUTHENTICATION_SCHEME = "Bearer";

    public KeycloakCoreService(UsuarioDAO usuarioDAO, SegurancaService segurancaService, JwtDecoder jwtDecoder, CoreService coreService, GrupoAcessoUsuarioDAO grupoAcessoUsuarioDAO, UsuarioGrupoDAO usuarioGrupoDAO, KeycloakAdminManager keycloakAdminManager, UsuarioSessaoDAO usuarioSessaoDAO, UsuarioEmpresaDAO usuarioEmpresaDAO, EmpresaDAO empresaDAO, UsuarioPerfilDAO usuarioPerfilDAO, ModuloAcessoDAO moduloAcessoDAO, ObjectMapper objectMapper) {
        this.usuarioDAO = usuarioDAO;
        this.segurancaService = segurancaService;
        this.jwtDecoder = jwtDecoder;
        this.coreService = coreService;
        this.grupoAcessoUsuarioDAO = grupoAcessoUsuarioDAO;
        this.usuarioGrupoDAO = usuarioGrupoDAO;
        this.keycloakAdminManager = keycloakAdminManager;
        this.usuarioSessaoDAO = usuarioSessaoDAO;
        this.usuarioEmpresaDAO = usuarioEmpresaDAO;
        this.empresaDAO = empresaDAO;
        this.usuarioPerfilDAO = usuarioPerfilDAO;
        this.moduloAcessoDAO = moduloAcessoDAO;
        this.objectMapper = objectMapper;
    }

    @Transactional
    public TokenResponseDTO authenticate(String username, String password, HttpServletRequest request) {
        logger.debug("Realizando autentica\u00e7\u00e3o para usu\u00e1rio - {}", (Object)username);
        Keycloak authenticator = KeycloakBuilder.builder().serverUrl(this.serverUrl).realm(this.realm).clientId(this.clientId).clientSecret(this.clientSecret).username(username).password(password).build();
        try {
            AccessTokenResponse keycloakResponse = authenticator.tokenManager().getAccessToken();
            Jwt jwt = this.jwtDecoder.decode(keycloakResponse.getToken());
            Usuario user = this.usuarioDAO.getByLoginFetchGruposAndEmpresas(username);
            this.verifyUserIsInativoOrExpirado(user);
            user = this.processUserCreationOrSync(jwt, user, request);
            this.setGroups(jwt, user);
            Set roles = this.getRolesByUserKeycloakId(user.getKeycloakId());
            return new TokenResponseDTO(keycloakResponse.getToken(), keycloakResponse.getExpiresIn(), keycloakResponse.getRefreshToken(), user.getEmpresas().stream().map(UsuarioEmpresa::getEmpresa).toList(), roles);
        }
        catch (NotAuthorizedException noaExc) {
            logger.error("Erro acessando keyCloadk: {}", (Object)noaExc.getMessage());
            throw new ErrorCodeException(ErrorCode.INCORRECT_CREDENTIALS, new String[0]);
        }
    }

    public Set<RoleDTO> getRolesByUserId(Integer idUsuario) {
        Set<RoleDTO> userRoles;
        Usuario user = (Usuario)this.usuarioDAO.findById((Object)idUsuario).orElseThrow(() -> new ErrorCodeException(ErrorCode.USER_NOT_FOUND, new String[0]));
        if (user.getKeycloakId() == null || user.getKeycloakId().toString().isBlank()) {
            throw new ErrorCodeException(ErrorCode.KEYCLOAK_USER_UUID_NOT_FOUND, new String[0]);
        }
        UserResource userResource = (UserResource)this.keycloakAdminManager.execute(x -> x.users().get(user.getKeycloakId().toString()));
        String clientUUID = this.getClientUuid(this.clientId);
        try {
            userRoles = userResource.roles().clientLevel(clientUUID).listAll().stream().map(r -> new RoleDTO(r.getName(), r.getDescription(), r.isComposite())).collect(Collectors.toSet());
        }
        catch (ClientErrorException e) {
            if (e.getResponse().getStatus() == 403) {
                logger.error("Acesso negado (403) ao listar roles diretas do usu\u00e1rio {}. O client de servi\u00e7o '{}' precisa da role 'view-users' do client 'realm-management'.", new Object[]{user.getLogin(), this.clientId, e});
                throw new RuntimeException("Permiss\u00e3o insuficiente no Keycloak para listar roles de usu\u00e1rio. A role necess\u00e1ria \u00e9 'view-users'.", e);
            }
            throw e;
        }
        Set groupRoles = userResource.groups().stream().map(GroupRepresentation::getId).map(groupId -> (GroupResource)this.keycloakAdminManager.execute(x -> x.groups().group(groupId))).flatMap(groupRes -> {
            try {
                return groupRes.roles().clientLevel(clientUUID).listAll().stream();
            }
            catch (ClientErrorException e) {
                if (e.getResponse().getStatus() == 403) {
                    logger.error("Acesso negado (403) ao listar roles do grupo {}. O client de servi\u00e7o '{}' precisa da role 'view-users' do client 'realm-management'.", new Object[]{groupRes.toRepresentation().getName(), this.clientId, e});
                    throw new RuntimeException("Permiss\u00e3o insuficiente no Keycloak para listar roles de grupo. A role necess\u00e1ria \u00e9 'view-users'.", e);
                }
                throw e;
            }
        }).map(r -> new RoleDTO(r.getName(), r.getDescription(), r.isComposite())).collect(Collectors.toSet());
        userRoles.addAll(groupRoles);
        return userRoles;
    }

    public Page<RoleDTO> getPaginatedClientRoles(String search, Pageable pageable) {
        try {
            RolesResource rolesResource = (RolesResource)this.keycloakAdminManager.execute(x -> x.clients().get(this.getClientUuid(this.clientId)).roles());
            List paginatedRoleRepresentations = rolesResource.list(search, Integer.valueOf((int)pageable.getOffset()), Integer.valueOf(pageable.getPageSize()));
            List<RoleDTO> roleNames = paginatedRoleRepresentations.stream().filter(role -> !"uma_protection".equals(role.getName())).map(role -> new RoleDTO(role.getName(), role.getDescription(), role.isComposite())).toList();
            long totalRoles = rolesResource.list(search, Integer.valueOf(-1), Integer.valueOf(-1)).stream().filter(role -> !"uma_protection".equals(role.getName())).count();
            return new PageImpl(roleNames, pageable, totalRoles);
        }
        catch (ClientErrorException e) {
            if (e.getResponse().getStatus() == 403) {
                logger.error("Acesso negado (403) ao listar roles do client {}. O client de servi\u00e7o '{}' precisa da role 'view-clients' do client 'realm-management'.", new Object[]{this.clientId, this.clientId, e});
                throw new RuntimeException("Permiss\u00e3o insuficiente no Keycloak para listar roles de client. A role necess\u00e1ria \u00e9 'view-clients'.", e);
            }
            throw e;
        }
    }

    public Set<String> getRolesByUserKeycloakId(UUID userKeycloakId) {
        return (Set)this.keycloakAdminManager.executeWithFallback(x -> {
            Set userRoles;
            UserResource userResource = x.users().get(userKeycloakId.toString());
            String clientUUID = this.getClientUuid(this.clientId);
            try {
                userRoles = userResource.roles().clientLevel(clientUUID).listAll().stream().map(RoleRepresentation::getName).collect(Collectors.toSet());
            }
            catch (ClientErrorException e) {
                if (e.getResponse().getStatus() == 403) {
                    logger.warn("Acesso negado (403) ao listar roles diretas do usu\u00e1rio {}. Usando fallback ADMIN.", (Object)userKeycloakId);
                    return Set.of("ADMIN");
                }
                throw e;
            }
            Set groupRoles = userResource.groups().stream().map(GroupRepresentation::getId).map(groupId -> (GroupResource)this.keycloakAdminManager.executeWithFallback(y -> y.groups().group(groupId), null)).filter(Objects::nonNull).flatMap(groupRes -> {
                try {
                    return groupRes.roles().clientLevel(clientUUID).listAll().stream();
                }
                catch (ClientErrorException e) {
                    if (e.getResponse().getStatus() == 403) {
                        logger.warn("Acesso negado (403) ao listar roles do grupo. Ignorando grupo.");
                        return Stream.empty();
                    }
                    throw e;
                }
            }).map(RoleRepresentation::getName).collect(Collectors.toSet());
            userRoles.addAll(groupRoles);
            return userRoles;
        }, Set.of("ADMIN"));
    }

    public List<RoleDTO> setUserRoles(Set<String> desiredRoles, Integer idUsuario) {
        Set currentUserRoleNames;
        Map allClientRolesMap;
        Usuario user = (Usuario)this.usuarioDAO.findById((Object)idUsuario).orElseThrow(() -> new ErrorCodeException(ErrorCode.USER_NOT_FOUND, new String[0]));
        String keycloakUserId = user.getKeycloakId().toString();
        logger.debug("Inicializando sincroniza\u00e7\u00e3o de roles para o usu\u00e1rio: {}", (Object)keycloakUserId);
        String clientUUID = this.getClientUuid(this.clientId);
        RealmResource realmResource = (RealmResource)this.keycloakAdminManager.execute(x -> x);
        ClientResource clientResource = realmResource.clients().get(clientUUID);
        RoleScopeResource userClientRolesResource = realmResource.users().get(keycloakUserId).roles().clientLevel(clientUUID);
        try {
            allClientRolesMap = clientResource.roles().list().stream().collect(Collectors.toMap(role -> role.getName().toUpperCase(), Function.identity(), (existing, replacement) -> existing));
        }
        catch (ClientErrorException e) {
            if (e.getResponse().getStatus() == 403) {
                logger.error("Acesso negado (403) ao listar roles do client {}. O client de servi\u00e7o '{}' precisa da role 'view-clients'.", new Object[]{this.clientId, this.clientId, e});
                throw new RuntimeException("Permiss\u00e3o insuficiente no Keycloak para listar roles de client. Verifique a role 'view-clients'.", e);
            }
            throw e;
        }
        Set desiredRoleNames = desiredRoles.stream().map(String::toUpperCase).collect(Collectors.toSet());
        HashSet rolesToCreate = new HashSet(desiredRoleNames);
        rolesToCreate.removeAll(allClientRolesMap.keySet());
        if (!rolesToCreate.isEmpty()) {
            logger.info("As seguintes roles n\u00e3o existem no client e ser\u00e3o criadas: {}", rolesToCreate);
            for (String roleName2 : rolesToCreate) {
                RoleRepresentation newRole = new RoleRepresentation(roleName2, "Criada pelo sistema.", false);
                try {
                    clientResource.roles().create(newRole);
                    RoleRepresentation createdRole = clientResource.roles().get(roleName2).toRepresentation();
                    allClientRolesMap.put(roleName2, createdRole);
                    logger.debug("Role '{}' criada com sucesso.", (Object)roleName2);
                }
                catch (ClientErrorException e) {
                    if (e.getResponse().getStatus() == 409) {
                        logger.warn("Race condition: A role '{}' j\u00e1 existia. Recuperando e continuando.", (Object)roleName2);
                        allClientRolesMap.putIfAbsent(roleName2, clientResource.roles().get(roleName2).toRepresentation());
                        continue;
                    }
                    if (e.getResponse().getStatus() == 403) {
                        logger.error("Acesso negado (403) ao criar a role '{}' no client {}. O client de servi\u00e7o '{}' precisa da role 'manage-clients'.", new Object[]{roleName2, this.clientId, this.clientId, e});
                        throw new RuntimeException("Permiss\u00e3o insuficiente no Keycloak para criar roles. Verifique a role 'manage-clients'.", e);
                    }
                    logger.error("Erro ao criar a role '{}': {}", (Object)roleName2, (Object)e.getMessage());
                    throw e;
                }
            }
        }
        try {
            currentUserRoleNames = userClientRolesResource.listAll().stream().map(r -> r.getName().toUpperCase()).collect(Collectors.toSet());
        }
        catch (ClientErrorException e) {
            if (e.getResponse().getStatus() == 403) {
                logger.error("Acesso negado (403) ao listar roles do usu\u00e1rio {} no client {}. O client de servi\u00e7o '{}' precisa da role 'view-users'.", new Object[]{user.getLogin(), this.clientId, this.clientId, e});
                throw new RuntimeException("Permiss\u00e3o insuficiente no Keycloak para listar roles de usu\u00e1rio. Verifique a role 'view-users'.", e);
            }
            throw e;
        }
        HashSet rolesToAddNames = new HashSet(desiredRoleNames);
        rolesToAddNames.removeAll(currentUserRoleNames);
        HashSet rolesToRemoveNames = new HashSet(currentUserRoleNames);
        rolesToRemoveNames.removeAll(desiredRoleNames);
        if (!rolesToAddNames.isEmpty()) {
            logger.debug("Adicionando as roles {} para o usu\u00e1rio {}", rolesToAddNames, (Object)keycloakUserId);
            List rolesToAdd = rolesToAddNames.stream().map(allClientRolesMap::get).collect(Collectors.toList());
            try {
                userClientRolesResource.add(rolesToAdd);
            }
            catch (ClientErrorException e) {
                if (e.getResponse().getStatus() == 403) {
                    logger.error("Acesso negado (403) ao ADICIONAR roles para o usu\u00e1rio {}. O client de servi\u00e7o '{}' precisa da role 'manage-users'.", new Object[]{user.getLogin(), this.clientId, e});
                    throw new RuntimeException("Permiss\u00e3o insuficiente no Keycloak para adicionar roles a um usu\u00e1rio. Verifique a role 'manage-users'.", e);
                }
                throw e;
            }
        }
        if (!rolesToRemoveNames.isEmpty()) {
            logger.debug("Removendo as roles {} do usu\u00e1rio {}", rolesToRemoveNames, (Object)keycloakUserId);
            List rolesToRemove = rolesToRemoveNames.stream().map(allClientRolesMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            try {
                userClientRolesResource.remove(rolesToRemove);
            }
            catch (ClientErrorException e) {
                if (e.getResponse().getStatus() == 403) {
                    logger.error("Acesso negado (403) ao REMOVER roles do usu\u00e1rio {}. O client de servi\u00e7o '{}' precisa da role 'manage-users'.", new Object[]{user.getLogin(), this.clientId, e});
                    throw new RuntimeException("Permiss\u00e3o insuficiente no Keycloak para remover roles de um usu\u00e1rio. Verifique a role 'manage-users'.", e);
                }
                throw e;
            }
        }
        logger.debug("Roles do usu\u00e1rio {} sincronizadas com sucesso.", (Object)keycloakUserId);
        return desiredRoleNames.stream().map(roleName -> {
            RoleRepresentation finalRole = (RoleRepresentation)allClientRolesMap.get(roleName);
            return new RoleDTO(finalRole.getName(), finalRole.getDescription(), finalRole.isComposite());
        }).collect(Collectors.toList());
    }

    @Transactional
    public RefreshTokenResponseDTO revokeToken(RevokeRefreshTokenDTO dto, HttpServletRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"grant_type", (Object)"refresh_token");
        map.add((Object)"refresh_token", (Object)dto.refreshToken());
        HttpEntity refreshRequest = new HttpEntity((Object)map, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(this.tokenEndpoint, (Object)refreshRequest, RefreshTokenResponseDTO.class, new Object[0]);
            RefreshTokenResponseDTO responseDTO = (RefreshTokenResponseDTO)response.getBody();
            if (responseDTO == null || responseDTO.getToken() == null) {
                throw new ErrorCodeException(ErrorCode.TOKEN_NOT_IN_RESPONSE, new String[0]);
            }
            Jwt jwt = this.jwtDecoder.decode(responseDTO.getToken());
            Map claims = jwt.getClaims();
            String username = claims.get("preferred_username").toString();
            Usuario user = this.usuarioDAO.getByLogin(username);
            this.invalidateUserSessions(user);
            this.createUserSession(request, user, responseDTO.getToken());
            responseDTO.setPermissoes(this.getRolesByUserKeycloakId(user.getKeycloakId()));
            return responseDTO;
        }
        catch (HttpClientErrorException hcee) {
            String errorBody = hcee.getResponseBodyAsString();
            try {
                ObjectMapper mapper = new ObjectMapper();
                Map errorDetails = (Map)mapper.readValue(errorBody, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                String description = (String)errorDetails.get("error_description");
                throw new ErrorCodeException(ErrorCode.KEYCLOAK_REVOKE_TOKEN_BODY_ERROR, new String[]{"%error_description%", description});
            }
            catch (Exception parseException) {
                throw new RuntimeException("Erro ao renovar token e n\u00e3o foi poss\u00edvel ler a resposta JSON", parseException);
            }
        }
    }

    @Transactional
    public void logout(HttpServletRequest request) {
        UsuarioSessao sessao = this.getUsuarioByJWT(request);
        sessao.setDatHorLogout(new Date(System.currentTimeMillis()));
        this.usuarioSessaoDAO.save((Object)sessao);
    }

    @Transactional
    public void setGroups(Jwt jwt, Usuario user) {
        if (jwt.getClaim("groups") != null) {
            this.setJwtKeycloakGroups(jwt, user);
        }
        if (jwt.getClaim("groups") == null) {
            this.setDefaultSystemGroup(user);
        }
    }

    @Transactional
    public void setJwtKeycloakGroups(Jwt jwt, Usuario user) {
        List<String> jwtGroups = jwt.getClaimAsStringList("groups").stream().map(String::toUpperCase).map(group -> group.replaceAll("[^a-zA-Z0-9\u00c7\u00e7\u00c3\u00e3\u00c1\u00e1\u00c0\u00e0\u00c9\u00e9\u00c8\u00e8\u00cd\u00ed\u00cc\u00ec\u00d3\u00f3\u00d2\u00f2\u00d5\u00f5\u00da\u00fa\u00d9\u00f9\u00dc\u00fc\\s]", "")).toList();
        List dbGroupsByJwt = this.grupoAcessoUsuarioDAO.getByDescricoes(jwtGroups);
        if (dbGroupsByJwt.isEmpty()) {
            logger.debug("Nenhum grupo equivalente aos informados no JWT foi encontrado no sistema para o usu\u00e1rio: {}", (Object)user.getLogin());
        }
        Set dbGroupsByJwtDescriptions = dbGroupsByJwt.stream().map(GrupoAcessoUsuario::getDescricao).map(String::toUpperCase).collect(Collectors.toSet());
        logger.debug("Grupos enviados no JWT: {}", jwtGroups);
        logger.debug("Grupos equivalentes do JWT que foram encontrados no sistema: {}", dbGroupsByJwtDescriptions);
        Set userCurrentGroups = user.getGrupos().stream().map(group -> group.getGrupoAcesso().getDescricao()).map(String::toUpperCase).collect(Collectors.toSet());
        Set groupsToBeAdded = dbGroupsByJwtDescriptions.stream().filter(group -> !userCurrentGroups.contains(group)).collect(Collectors.toSet());
        List<UsuarioGrupo> groupsToBeAddedEntities = dbGroupsByJwt.stream().map(group -> {
            UsuarioGrupo userGroup = new UsuarioGrupo();
            userGroup.setId(new UsuarioGrupoPK(user.getId(), group.getId()));
            userGroup.setUsuario(user);
            userGroup.setGrupoAcesso(group);
            return userGroup;
        }).toList();
        user.setGrupos(new HashSet<UsuarioGrupo>(groupsToBeAddedEntities));
        this.usuarioDAO.save((Object)user);
        if (groupsToBeAdded.isEmpty()) {
            logger.debug("Nenhuma altera\u00e7\u00e3o de grupos necess\u00e1ria para o usu\u00e1rio: {}", (Object)user.getLogin());
        } else {
            logger.debug("A adi\u00e7\u00e3o de novos grupos ocorreu com sucesso! Grupos adicionados ao usu\u00e1rio {} - {}", (Object)user.getLogin(), groupsToBeAdded);
        }
    }

    @Transactional
    public void setDefaultSystemGroup(Usuario user) {
        Integer groupId = (Integer)Optional.ofNullable(this.coreService.getRefValueByName(null, TipoRefCode.KEYCLOAK_ID_GRUPO_PADRAO)).orElseThrow(() -> new ErrorCodeException(ErrorCode.DEFAULT_KEYCLOAK_GROUP_NOT_DEFINED, new String[0]));
        GrupoAcessoUsuario group = (GrupoAcessoUsuario)this.grupoAcessoUsuarioDAO.findById((Object)groupId).orElseThrow(() -> new ErrorCodeException(ErrorCode.GROUP_NOT_FOUND, new String[0]));
        boolean precisaDoGrupoPadrao = user.getGrupos().stream().noneMatch(grupo -> grupo.getGrupoAcesso().getId().equals(groupId));
        if (precisaDoGrupoPadrao) {
            UsuarioGrupo userGroup = new UsuarioGrupo();
            userGroup.setId(new UsuarioGrupoPK(user.getId(), group.getId()));
            userGroup.setUsuario(user);
            userGroup.setGrupoAcesso(group);
            userGroup.setDatHorCadastro(LocalDateTime.now());
            userGroup.setIdUsuarioIns(Integer.valueOf(1));
            logger.debug("Nenhum grupo encontrado no JWT para usu\u00e1rio: {}, adicionando grupo {} (padr\u00e3o configurado no sistema)", (Object)user.getLogin(), (Object)group.getDescricao());
            this.usuarioGrupoDAO.save((Object)userGroup);
        }
    }

    @Transactional
    public Usuario processUserCreationOrSync(Jwt jwt, Usuario user, HttpServletRequest request) {
        Map claims = jwt.getClaims();
        String keycloakIdStr = this.getRequiredClaim(claims, "sub");
        String username = this.getRequiredClaim(claims, "preferred_username");
        String email = this.getRequiredClaim(claims, "email");
        String name = this.getRequiredClaim(claims, "name");
        UUID keycloakId = UUID.fromString(keycloakIdStr);
        if (user == null) {
            logger.debug("Usu\u00e1rio de login [{}] n\u00e3o identificado. Criando novo usu\u00e1rio no sistema...", (Object)username);
            Integer userId = this.usuarioDAO.getNextId();
            Usuario newUser = new Usuario();
            newUser.setId(userId);
            newUser.setLogin(username);
            newUser.setEmail(email);
            newUser.setNome(name);
            newUser.setKeycloakId(keycloakId);
            newUser.setDatHorCadastro(LocalDateTime.now());
            newUser.setTipo("N");
            user = (Usuario)this.usuarioDAO.save((Object)newUser);
            this.createUserProfile(user);
            logger.info("Novo usu\u00e1rio criado com sucesso: {}", (Object)username);
        } else {
            boolean userFoiAlterado = false;
            if (!keycloakId.equals(user.getKeycloakId())) {
                user.setKeycloakId(keycloakId);
                userFoiAlterado = true;
            }
            if (!(Objects.equals(user.getNome(), name) && Objects.equals(user.getEmail(), email) && Objects.equals(user.getLogin(), username))) {
                user.setNome(name);
                user.setEmail(email);
                user.setLogin(username);
                user.setDatHorAlteracao(LocalDateTime.now());
                logger.info("Dados do usu\u00e1rio {} foram alterados no Keycloak. Sincronizando banco de dados.", (Object)user.getLogin());
                userFoiAlterado = true;
            }
            if (userFoiAlterado) {
                this.usuarioDAO.save((Object)user);
                logger.debug("Usu\u00e1rio {} foi atualizado no banco de dados.", (Object)user.getLogin());
            } else {
                logger.debug("Nenhuma altera\u00e7\u00e3o detectada para o usu\u00e1rio {}. Nenhuma sincroniza\u00e7\u00e3o necess\u00e1ria.", (Object)user.getLogin());
            }
        }
        Empresa agencia = (Empresa)this.empresaDAO.getAgencia().orElseThrow(() -> new ErrorCodeException(ErrorCode.AGENCIA_NOT_DEFINED, new String[0]));
        Optional usuarioTemAgencia = this.usuarioEmpresaDAO.findUserHasAgencia(user.getId(), agencia.getId());
        if (usuarioTemAgencia.isEmpty()) {
            UsuarioEmpresa usuarioEmpresa = new UsuarioEmpresa();
            usuarioEmpresa.setId(new UsuarioEmpresaPK(user.getId(), agencia.getId()));
            usuarioEmpresa.setDatHorCadastro(LocalDateTime.now());
            usuarioEmpresa.setIdUsuarioIns(Integer.valueOf(1));
            this.usuarioEmpresaDAO.save((Object)usuarioEmpresa);
        }
        this.createUserSession(request, user, jwt.getTokenValue());
        return user;
    }

    private String getRequiredClaim(Map<String, Object> claims, String claimName) {
        Object claimValue = claims.get(claimName);
        if (claimValue == null || !StringUtils.hasText((String)claimValue.toString())) {
            logger.error("A claim obrigat\u00f3ria '{}' est\u00e1 faltando ou est\u00e1 vazia no token JWT.", (Object)claimName);
            throw new ErrorCodeException(ErrorCode.MISSING_JWT_CLAIM, new String[]{"%claim%", claimName});
        }
        return claimValue.toString();
    }

    @Transactional
    public void createUserSession(HttpServletRequest request, Usuario user, String token) {
        UsuarioSessao sessao = new UsuarioSessao();
        String agente = request.getHeader("User-Agent");
        sessao.setId(new UsuarioSessaoPK(user.getId(), this.usuarioSessaoDAO.getNextId(user.getId())));
        sessao.setUserAgent(agente);
        sessao.setUsuario(user);
        sessao.setIpAcesso(request.getRemoteAddr());
        sessao.setSessionApi(token);
        sessao.getId().setIdUsuario(user.getId());
        sessao.setDatHorLogin(new Date(System.currentTimeMillis()));
        this.usuarioSessaoDAO.save((Object)sessao);
    }

    @Transactional
    public void invalidateUserSessions(Usuario user) {
        List sessoes = this.usuarioSessaoDAO.findSessoesAtivasByIdUsuario(user.getId());
        for (UsuarioSessao sessao : sessoes) {
            sessao.setDatHorLogout(new Date(System.currentTimeMillis()));
        }
        this.usuarioSessaoDAO.saveAll((Iterable)sessoes);
    }

    @Transactional
    public void createUserProfile(Usuario user) {
        UsuarioPerfil perfil = new UsuarioPerfil();
        perfil.setIdUsuario(user.getId());
        perfil.setSenha("sigescantt");
        perfil.setBloqueado(Integer.valueOf(0));
        perfil.setAdministrador(Integer.valueOf(0));
        perfil.setInativo(Integer.valueOf(0));
        perfil.setDatHorExpiracao(LocalDateTime.now().plusMonths(6L));
        this.usuarioPerfilDAO.save((Object)perfil);
    }

    public void alterarSenhaUsuario(String token, String novaSenha) {
        this.segurancaService.validateUserByRequest(token);
        Usuario usuarioToken = this.segurancaService.validateUserByBearerToken(token);
        UserResource userResource = (UserResource)this.keycloakAdminManager.execute(r -> r.users().get(String.valueOf(usuarioToken.getKeycloakId())));
        UserRepresentation keycloakUser = userResource.toRepresentation();
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(novaSenha);
        keycloakUser.setCredentials(Collections.singletonList(credential));
        try {
            userResource.update(keycloakUser);
        }
        catch (ClientErrorException e) {
            if (e.getResponse().getStatus() == 403) {
                logger.error("Acesso negado (403) ao tentar alterar a pr\u00f3pria senha para o usu\u00e1rio {}. O client de servi\u00e7o '{}' precisa da role 'manage-users' do client 'realm-management'.", new Object[]{keycloakUser.getUsername(), this.clientId, e});
                throw new RuntimeException("Permiss\u00e3o insuficiente no Keycloak para alterar senha. A role necess\u00e1ria \u00e9 'manage-users'.", e);
            }
            throw e;
        }
    }

    @Transactional
    public void alterarSenhaAdmin(String token, UsuarioChangePasswordRequestVO vo) {
        this.segurancaService.validateUserIsAdmin(token);
        Usuario usuarioNovaSenha = (Usuario)this.usuarioDAO.findById((Object)vo.idUsuario()).orElseThrow(() -> new ErrorCodeException(ErrorCode.USER_NOT_FOUND, new String[0]));
        if (usuarioNovaSenha.getKeycloakId() == null || usuarioNovaSenha.getKeycloakId().toString().isBlank()) {
            throw new ErrorCodeException(ErrorCode.KEYCLOAK_USER_UUID_NOT_FOUND, new String[0]);
        }
        UserResource userResource = (UserResource)this.keycloakAdminManager.execute(r -> r.users().get(String.valueOf(usuarioNovaSenha.getKeycloakId())));
        UserRepresentation keycloakUser = userResource.toRepresentation();
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(vo.novaSenha());
        keycloakUser.setCredentials(Collections.singletonList(credential));
        try {
            userResource.update(keycloakUser);
        }
        catch (ClientErrorException e) {
            if (e.getResponse().getStatus() == 403) {
                logger.error("Acesso negado (403) ao tentar alterar a senha do usu\u00e1rio {}. O client de servi\u00e7o '{}' precisa da role 'manage-users' do client 'realm-management'.", new Object[]{keycloakUser.getUsername(), this.clientId, e});
                throw new RuntimeException("Permiss\u00e3o insuficiente no Keycloak para alterar a senha de outro usu\u00e1rio. A role necess\u00e1ria \u00e9 'manage-users'.", e);
            }
            throw e;
        }
    }

    public void migrateUsers() {
        List usersDB = this.usuarioDAO.findAll();
        UsersResource usersResource = (UsersResource)this.keycloakAdminManager.execute(r -> r.users());
        for (Usuario userDB : usersDB) {
            String lastNameUserDB;
            String firstNameUserDB;
            String nomeCompletoUserDB = userDB.getNome();
            String nomeLimpo = nomeCompletoUserDB.trim();
            int primeiroEspaco = nomeLimpo.indexOf(32);
            if (primeiroEspaco == -1) {
                firstNameUserDB = nomeLimpo;
                lastNameUserDB = "";
            } else {
                firstNameUserDB = nomeLimpo.substring(0, primeiroEspaco);
                lastNameUserDB = nomeLimpo.substring(primeiroEspaco + 1).trim();
            }
            UserRepresentation keycloakUser = new UserRepresentation();
            keycloakUser.setUsername(userDB.getLogin());
            keycloakUser.setEmail(userDB.getEmail());
            keycloakUser.setFirstName(firstNameUserDB);
            keycloakUser.setLastName(lastNameUserDB);
            keycloakUser.setEnabled(Boolean.valueOf(true));
            keycloakUser.setEmailVerified(Boolean.valueOf(true));
            CredentialRepresentation credential = new CredentialRepresentation();
            credential.setType("password");
            credential.setValue(this.defaultPassword);
            keycloakUser.setCredentials(Collections.singletonList(credential));
            try {
                Response response = usersResource.create(keycloakUser);
                try {
                    if (response.getStatus() == 201) {
                        logger.debug("Usu\u00e1rio criado com sucesso: {}", (Object)userDB.getLogin());
                        continue;
                    }
                    if (response.getStatus() == 409) {
                        logger.debug("Usu\u00e1rio j\u00e1 existe: {}", (Object)userDB.getLogin());
                        continue;
                    }
                    if (response.getStatus() == 403) {
                        logger.error("Acesso negado (403) ao tentar criar o usu\u00e1rio {}. O client de servi\u00e7o '{}' precisa da role 'manage-users' do client 'realm-management'.", (Object)userDB.getLogin(), (Object)this.clientId);
                        break;
                    }
                    logger.warn("Erro n\u00e3o esperado ao criar usu\u00e1rio {} - Status: {}, Raz\u00e3o: {}", new Object[]{userDB.getLogin(), response.getStatus(), response.getStatusInfo().getReasonPhrase()});
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            catch (ClientErrorException e) {
                if (e.getResponse().getStatus() == 403) {
                    logger.error("Acesso negado (403) ao tentar criar o usu\u00e1rio {}. O client de servi\u00e7o '{}' precisa da role 'manage-users' do client 'realm-management'.", new Object[]{userDB.getLogin(), this.clientId, e});
                    break;
                }
                logger.error("Exception de client ao criar usu\u00e1rio {}: {}", new Object[]{userDB.getLogin(), e.getMessage(), e});
            }
            catch (Exception e) {
                logger.error("Exception geral ao criar usu\u00e1rio {}: {}", new Object[]{userDB.getLogin(), e.getMessage(), e});
            }
        }
    }

    public List<String> createRolesFromCsv(MultipartFile csvFile) throws IOException {
        List roles = this.parseCsvToRoles(csvFile);
        return this.createRolesParallel(roles);
    }

    private List<RoleDTO> parseCsvToRoles(MultipartFile csvFile) throws IOException {
        ArrayList<RoleDTO> roles = new ArrayList<RoleDTO>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(csvFile.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            boolean isFirstLine = true;
            while ((line = reader.readLine()) != null) {
                if (isFirstLine) {
                    isFirstLine = false;
                    continue;
                }
                String[] parts = line.split(",");
                if (parts.length < 2) continue;
                String dsNome = parts[0].trim();
                String dsModulo = parts[1].trim();
                if (dsNome.isEmpty()) continue;
                roles.add(new RoleDTO(dsNome, dsModulo));
            }
        }
        return roles;
    }

    public List<String> createRolesParallel(List<RoleDTO> roles) {
        List<CompletableFuture> futures = roles.stream().map(arg_0 -> this.createRoleAsync(arg_0)).toList();
        CompletableFuture<Void> allOf = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        ArrayList<String> results = new ArrayList<String>();
        try {
            allOf.get();
            for (CompletableFuture future : futures) {
                try {
                    String result = (String)future.get();
                    results.add(result);
                    System.out.println(result);
                }
                catch (Exception e) {
                    String error = "Erro ao processar role: " + e.getMessage();
                    results.add(error);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            results.add("Erro geral no processamento: " + e.getMessage());
            e.printStackTrace();
        }
        return results;
    }

    private String getAccessToken() {
        if (this.cachedToken != null && this.tokenExpiry != null && LocalDateTime.now().isBefore(this.tokenExpiry)) {
            return this.cachedToken;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"grant_type", (Object)"client_credentials");
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        String tokenUrl = this.serverUrl + "/realms/" + this.realm + "/protocol/openid-connect/token";
        try {
            ResponseEntity response = this.restTemplate.postForEntity(tokenUrl, (Object)request, Map.class, new Object[0]);
            Map body = (Map)response.getBody();
            this.cachedToken = (String)body.get("access_token");
            Integer expiresIn = (Integer)body.get("expires_in");
            this.tokenExpiry = LocalDateTime.now().plusSeconds(expiresIn - 30);
            return this.cachedToken;
        }
        catch (RestClientException e) {
            throw new RuntimeException("Erro ao obter token: " + e.getMessage());
        }
    }

    @Async
    public CompletableFuture<String> createRoleAsync(RoleDTO role) {
        String accessToken = this.getAccessToken();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(accessToken);
        HttpEntity request = new HttpEntity((Object)role, (MultiValueMap)headers);
        String migrationUrl = this.serverUrl + "/admin/realms/" + this.realm + "/roles";
        try {
            ResponseEntity response = this.restTemplate.postForEntity(migrationUrl, (Object)request, Void.class, new Object[0]);
            return CompletableFuture.completedFuture("Role " + role.getName() + ": " + String.valueOf(response.getStatusCode()));
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode().value() == 403) {
                return CompletableFuture.completedFuture(String.format("Erro na role %s: Acesso Negado (403). O client de servi\u00e7o '%s' precisa da role 'manage-realm'.", role.getName(), this.clientId));
            }
            if (e.getStatusCode().value() == 409) {
                return CompletableFuture.completedFuture(String.format("Erro na role %s: Role j\u00e1 existe (409).", role.getName()));
            }
            return CompletableFuture.completedFuture(String.format("Erro de HTTP client na role %s: %s", role.getName(), e.getMessage()));
        }
        catch (RestClientException e) {
            return CompletableFuture.completedFuture("Erro de Rest client na role " + role.getName() + ": " + e.getMessage());
        }
    }

    @Transactional
    public void syncUsersFromKeycloak() {
        logger.debug("Inicializando processo de sincroniza\u00e7\u00e3o de usu\u00e1rios com Keycloak...");
        List usersDB = this.usuarioDAO.findAll();
        UsersResource usersResource = (UsersResource)this.keycloakAdminManager.execute(realmResource -> realmResource.users());
        for (Usuario user : usersDB) {
            try {
                List keycloakUsers = usersResource.searchByUsername(user.getLogin(), Boolean.valueOf(true));
                if (!keycloakUsers.isEmpty()) {
                    UserRepresentation keycloakUser = (UserRepresentation)keycloakUsers.getFirst();
                    this.updateLocalUser(keycloakUser, user);
                    continue;
                }
                logger.warn("Usu\u00e1rio {} existe localmente mas n\u00e3o foi encontrado no Keycloak", (Object)user.getLogin());
            }
            catch (ClientErrorException e) {
                if (e.getResponse().getStatus() == 403) {
                    logger.error("Acesso negado (403) ao pesquisar usu\u00e1rios no Keycloak. O client de servi\u00e7o '{}' precisa da role 'query-users' ou 'view-users' do client 'realm-management'.", (Object)this.clientId, (Object)e);
                    break;
                }
                logger.error("Um erro de client ocorreu na sincroniza\u00e7\u00e3o do usu\u00e1rio: {}", (Object)user.getLogin(), (Object)e);
            }
            catch (Exception e) {
                logger.error("Um erro inesperado ocorreu na sincroniza\u00e7\u00e3o do usu\u00e1rio: {}", (Object)user.getLogin(), (Object)e);
            }
        }
        logger.debug("Processo de sincroniza\u00e7\u00e3o dos usu\u00e1rios finalizado com sucesso");
    }

    @Transactional
    protected void updateLocalUser(UserRepresentation keycloakUser, Usuario user) {
        boolean updatable = this.needsUpdate(keycloakUser, user);
        if (updatable) {
            user.setLogin(keycloakUser.getUsername());
            user.setEmail(keycloakUser.getEmail());
            user.setDatHorAlteracao(LocalDateTime.now());
            user.setNome(keycloakUser.getFirstName() + " " + keycloakUser.getLastName());
            user.setKeycloakId(UUID.fromString(keycloakUser.getId()));
            this.usuarioDAO.save((Object)user);
            logger.debug("Cadastro ATUALIZADO: O usu\u00e1rio [{}] teve suas informa\u00e7\u00f5es sincronizadas com o Keycloak.", (Object)user.getLogin());
        } else {
            logger.debug("As informa\u00e7\u00f5es do usu\u00e1rio [{}] continuam as mesmas, nada para alterar...", (Object)user.getLogin());
        }
    }

    protected boolean needsUpdate(UserRepresentation keycloakUser, Usuario user) {
        return !user.getLogin().equals(keycloakUser.getUsername()) || !user.getEmail().equals(keycloakUser.getEmail()) || !user.getNome().equals(keycloakUser.getFirstName() + " " + keycloakUser.getLastName());
    }

    protected UsuarioSessao getUsuarioByJWT(HttpServletRequest request) {
        String bearerToken = this.getToken(request);
        UsuarioSessao sessao = this.segurancaService.getSessaoUsuarioByToken(bearerToken);
        if (sessao != null) {
            return sessao;
        }
        logger.info(String.format("BearerToken '%s' n\u00e3o encontrado ou inv\u00e1lido. ", bearerToken));
        return null;
    }

    protected String getToken(HttpServletRequest request) {
        Enumeration headers = request.getHeaders(AUTHORIZATION_PROPERTY);
        if (headers == null || !headers.hasMoreElements()) {
            logger.error("No Header AuthProperty ");
            return null;
        }
        return ((String)headers.nextElement()).replaceFirst("Bearer ", "");
    }

    protected void verifyUserIsInativoOrExpirado(Usuario user) {
        if (user != null && user.getPerfil() != null) {
            if (user.getPerfil().getDatHorExpiracao() != null && user.getPerfil().getDatHorExpiracao().isBefore(LocalDateTime.now())) {
                throw new ErrorCodeException(ErrorCode.EXPIRED_USER, new String[0]);
            }
            if (user.getPerfil().getInativoBoolean().booleanValue()) {
                throw new ErrorCodeException(ErrorCode.INACTIVE_USER, new String[0]);
            }
        }
    }

    public String getClientUuid(String clientIdString) {
        return (String)this.keycloakAdminManager.executeWithFallback(r -> {
            List clients = r.clients().findByClientId(clientIdString);
            if (clients.isEmpty()) {
                logger.error("Nenhum client do Keycloak foi encontrado com o client-id: {}", (Object)clientIdString);
                throw new RuntimeException("Client do Keycloak n\u00e3o encontrado com client-id: " + clientIdString);
            }
            return ((ClientRepresentation)clients.get(0)).getId();
        }, (Object)"fallback-client-uuid");
    }
}

