/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.spring.security.keycloak;

import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.NotAuthorizedException;
import java.util.function.Function;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.RealmResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KeycloakAdminManager {
    private static final Logger logger = LoggerFactory.getLogger(KeycloakAdminManager.class);
    @Value(value="${keycloak.server-url}")
    private String serverUrl;
    @Value(value="${keycloak.realm}")
    private String realm;
    @Value(value="${keycloak.admin-client.id}")
    private String clientId;
    @Value(value="${keycloak.admin-client.secret}")
    private String clientSecret;
    private volatile Keycloak keycloakAdminClient;

    private Keycloak buildClient() {
        return KeycloakBuilder.builder().serverUrl(this.serverUrl).realm(this.realm).grantType("client_credentials").clientId(this.clientId).clientSecret(this.clientSecret).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Keycloak getInstance() {
        if (this.keycloakAdminClient == null) {
            KeycloakAdminManager keycloakAdminManager = this;
            synchronized (keycloakAdminManager) {
                if (this.keycloakAdminClient == null) {
                    logger.info("Initializing Keycloak admin client...");
                    this.keycloakAdminClient = this.buildClient();
                }
            }
        }
        return this.keycloakAdminClient;
    }

    private synchronized void forceReinitialization() {
        logger.debug("For\u00e7ando reinicializa\u00e7\u00e3o do Keycloak Admin Client por conta de expira\u00e7\u00e3o do token de ADMIN.");
        if (this.keycloakAdminClient != null && !this.keycloakAdminClient.isClosed()) {
            this.keycloakAdminClient.close();
        }
        this.keycloakAdminClient = this.buildClient();
    }

    public <T> T execute(Function<RealmResource, T> function) {
        try {
            RealmResource realmResource = this.getInstance().realm(this.realm);
            return function.apply(realmResource);
        }
        catch (NotAuthorizedException e) {
            logger.debug("NotAuthorizedException. Token de ADMIN provavelmente expirado. Tentando novamente a opera\u00e7\u00e3o...");
            this.forceReinitialization();
            RealmResource realmResource = this.getInstance().realm(this.realm);
            return function.apply(realmResource);
        }
    }

    public <T> T executeWithFallback(Function<RealmResource, T> function, T fallbackResult) {
        try {
            return (T)this.execute(function);
        }
        catch (Exception e) {
            RuntimeException runtimeEx;
            if (e instanceof ClientErrorException) {
                ClientErrorException clientError = (ClientErrorException)((Object)e);
                int status = clientError.getResponse().getStatus();
                if (status == 403) {
                    logger.warn("Permiss\u00e3o insuficiente no Keycloak. Retornando resultado de fallback. Erro: {}", (Object)e.getMessage());
                    return fallbackResult;
                }
                if (status == 404) {
                    logger.warn("Recurso n\u00e3o encontrado no Keycloak. Retornando resultado de fallback. Erro: {}", (Object)e.getMessage());
                    return fallbackResult;
                }
            } else if (e instanceof RuntimeException && (runtimeEx = (RuntimeException)e).getMessage() != null && runtimeEx.getMessage().contains("Permiss\u00e3o insuficiente")) {
                logger.warn("Permiss\u00e3o insuficiente no Keycloak. Retornando resultado de fallback. Erro: {}", (Object)e.getMessage());
                return fallbackResult;
            }
            throw e;
        }
    }
}

