/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.spring.security;

import br.gov.antt.sgctt.spring.security.SchedulerApiKeyAuthenticationFilter;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtGrantedAuthoritiesConverter;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@ComponentScan(value={"br.gov.antt.sgctt"})
public class SecurityConfig {
    @Value(value="${spring.security.oauth2.resourceserver.jwt.jwk-set-uri}")
    String jwkSetUri;
    @Autowired
    private SchedulerApiKeyAuthenticationFilter schedulerApiKeyAuthenticationFilter;

    @Bean
    @Order(value=1)
    public SecurityFilterChain publicSecurityFilterChain(HttpSecurity http) throws Exception {
        String[] allowedList = new String[]{"/api/ping", "/api/assinaturas/**", "/api/downloads/**", "/api/core/refCodes/empresaAutenticacao", "/api/empresas/all", "/api/reset/**", "/api/register/**", "/api/ambiental/analises/**", "/sso/**", "/swagger-resources/**", "/swagger-ui/**", "/swagger-ui.html", "/v3/api-docs", "/v3/api-docs/**", "/api/auth", "/api/auth/refreshToken"};
        return (SecurityFilterChain)http.securityMatcher(allowedList).csrf(csrf -> csrf.disable()).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).permitAll()).build();
    }

    @Bean
    @Order(value=2)
    public SecurityFilterChain protectedSecurityFilterChain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)http.csrf(csrf -> csrf.disable()).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.ERROR})).permitAll().anyRequest()).authenticated()).addFilterBefore((Filter)this.schedulerApiKeyAuthenticationFilter, UsernamePasswordAuthenticationFilter.class).oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.jwtAuthenticationConverter(this.keycloakJwtAuthenticationConverter()))).build();
    }

    @Bean
    public JwtDecoder jwtDecoder() {
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)this.jwkSetUri).build();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Converter<Jwt, ? extends AbstractAuthenticationToken> keycloakJwtAuthenticationConverter() {
        JwtGrantedAuthoritiesConverter grantedAuthoritiesConverter = new JwtGrantedAuthoritiesConverter();
        grantedAuthoritiesConverter.setAuthoritiesClaimName("realm_access.roles");
        grantedAuthoritiesConverter.setAuthorityPrefix("ROLE_");
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        converter.setJwtGrantedAuthoritiesConverter((Converter)grantedAuthoritiesConverter);
        return converter;
    }
}

