/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.spring.config;

import br.gov.antt.sgctt.spring.config.converters.TipoAtivoSiglaConverter;
import br.gov.antt.sgctt.spring.config.converters.TipoModuloSiglaConverter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.hibernate6.Hibernate6Module;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfig
implements WebMvcConfigurer {
    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new TipoAtivoSiglaConverter());
        registry.addConverter((Converter)new TipoModuloSiglaConverter());
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer customizeObjectMapper() {
        return builder -> {
            Hibernate6Module hibernate6Module = new Hibernate6Module();
            hibernate6Module.configure(Hibernate6Module.Feature.FORCE_LAZY_LOADING, false);
            builder.modulesToInstall(new Module[]{hibernate6Module});
            builder.featuresToDisable(new Object[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
        };
    }

    @Bean
    public ObjectMapper objectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper objectMapper = builder.build();
        Hibernate6Module hibernate6Module = new Hibernate6Module();
        hibernate6Module.configure(Hibernate6Module.Feature.FORCE_LAZY_LOADING, false);
        objectMapper.registerModule((Module)hibernate6Module);
        return objectMapper;
    }
}

