/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.server.helpers;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapSearchRepoImpl {
    private Logger logger = LoggerFactory.getLogger(LdapSearchRepoImpl.class);

    public Map<String, String> getUserCommonName(String ldapUrl, String rootDn, String domainName, String searchName, String domainAdmin, String domainPasswd) {
        HashMap<String, String> list;
        block66: {
            Attributes attributes;
            SearchResult searchResult;
            InitialDirContext ctx;
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.referral", "ignore");
            env.put("java.naming.provider.url", ldapUrl);
            if (domainAdmin != null && domainPasswd != null) {
                env.put("java.naming.security.authentication", "simple");
                if (domainName != null) {
                    env.put("java.naming.security.principal", domainAdmin + "@" + domainName);
                } else {
                    env.put("java.naming.security.principal", domainAdmin);
                }
                env.put("java.naming.security.credentials", domainPasswd);
            }
            for (String envKey : env.keySet()) {
                this.logger.debug("env.key={}, env.value={}", (Object)envKey, env.get(envKey));
            }
            try {
                ctx = new InitialDirContext(env);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            list = new HashMap<String, String>();
            NamingEnumeration<SearchResult> results = null;
            try {
                results = ctx.search(rootDn, "(sAMAccountName=" + searchName + ")", controls);
                while (results.hasMore()) {
                    Attribute lockoutAttr;
                    Attribute samAttr;
                    searchResult = results.next();
                    list.put("fullDn", searchResult.getNameInNamespace());
                    attributes = searchResult.getAttributes();
                    Attribute userAttr = attributes.get("userPrincipalName");
                    if (userAttr != null) {
                        list.put("userPrincipalName", userAttr.get().toString());
                    }
                    if ((samAttr = attributes.get("sAMAccountName")) != null) {
                        list.put("sAMAccountName", samAttr.get().toString());
                    }
                    if ((lockoutAttr = attributes.get("lockoutTime")) != null) {
                        list.put("lockoutTime", lockoutAttr.get().toString());
                    }
                    this.logger.debug("1. LDAP CN encontrado=> {}", (Object)searchResult.getNameInNamespace());
                    for (String itemKey : list.keySet()) {
                        this.logger.debug("return op1: list.key({})=>{}", (Object)itemKey, list.get(itemKey));
                    }
                }
            }
            catch (PartialResultException preExc) {
                this.logger.warn("PartialResultExc", (Throwable)preExc);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (Exception exc) {
                        this.logger.error("Exc", (Throwable)exc);
                    }
                }
            }
            try {
                if (!list.isEmpty()) break block66;
                results = ctx.search(rootDn, "(|(objectClass=person)(objectClass=user))", controls);
                while (results.hasMore()) {
                    Attribute lockoutAttr;
                    searchResult = results.next();
                    attributes = searchResult.getAttributes();
                    Attribute attr = attributes.get("cn");
                    String cn = attr.get().toString();
                    NamingEnumeration<String> idsEnum = attributes.getIDs();
                    while (idsEnum.hasMore()) {
                        Attribute lockoutAttr2;
                        String userId = idsEnum.next();
                        if (!userId.equalsIgnoreCase(searchName)) continue;
                        list.put("fullDn", searchResult.getNameInNamespace());
                        list.put("userPrincipalName", attributes.get("userPrincipalName").get().toString());
                        Attribute samAttr = attributes.get("sAMAccountName");
                        if (samAttr != null) {
                            list.put("sAMAccountName", samAttr.get().toString());
                        }
                        if ((lockoutAttr2 = attributes.get("lockoutTime")) != null) {
                            list.put("lockoutTime", lockoutAttr2.get().toString());
                        }
                        for (String itemKey : list.keySet()) {
                            this.logger.debug("return op2[id]: list.key({})=>{}", (Object)itemKey, list.get(itemKey));
                        }
                        HashMap<String, String> exc = list;
                        return exc;
                    }
                    if (!searchResult.getName().equalsIgnoreCase(searchName) && !cn.equalsIgnoreCase(searchName)) continue;
                    list.put("fullDn", searchResult.getNameInNamespace());
                    list.put("userPrincipalName", attributes.get("userPrincipalName").get().toString());
                    Attribute samAttr = attributes.get("sAMAccountName");
                    if (samAttr != null) {
                        list.put("sAMAccountName", samAttr.get().toString());
                    }
                    if ((lockoutAttr = attributes.get("lockoutTime")) != null) {
                        list.put("lockoutTime", lockoutAttr.get().toString());
                    }
                    for (String itemKey : list.keySet()) {
                        this.logger.debug("return op2: list.key({})=>{}", (Object)itemKey, list.get(itemKey));
                    }
                    HashMap<String, String> hashMap = list;
                    return hashMap;
                }
            }
            catch (NameNotFoundException exc) {
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (Exception exc) {
                        this.logger.error("Exc", (Throwable)exc);
                    }
                }
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception exc) {
                        this.logger.error("Exc", (Throwable)exc);
                    }
                }
            }
        }
        for (String itemKey : list.keySet()) {
            this.logger.debug("return op3: list.key({})=>{}", (Object)itemKey, list.get(itemKey));
        }
        return list;
    }
}

