/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.reports;

import br.gov.antt.sgctt.geral.ColumnInfo;
import br.gov.antt.sgctt.pleitos.Pleito;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatorioProcessosExcel {
    private static final Logger logger = LoggerFactory.getLogger(RelatorioProcessosExcel.class);
    private List<String> prefCampos;
    private final Map<String, CellStyle> cellStyles = new HashMap();

    public byte[] executeXLS(List<Pleito> processos, List<ColumnInfo> prefCampos) {
        logger.debug("Gerando XLS licen\u00e7as");
        Workbook wb = this.internalExecuteXLS(processos, prefCampos);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)baos);
            baos.flush();
            wb.close();
        }
        catch (IOException ioExc) {
            logger.error("IOExc", (Throwable)ioExc);
        }
        return baos.toByteArray();
    }

    private Workbook internalExecuteXLS(List<Pleito> processos, List<ColumnInfo> prefCampos) {
        Cell cell;
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        this.createStyles((Workbook)wb);
        Sheet sheet = wb.createSheet("Licen\u00e7as");
        sheet.setDisplayGridlines(false);
        sheet.setPrintGridlines(false);
        boolean idxRow = false;
        int idxCell = -1;
        Row row = sheet.createRow(0);
        if (this.hasColumn("id").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("ID");
        }
        if (this.hasColumn("empresa").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Concession\u00e1ria");
        }
        if (this.hasColumn("processo").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Processo");
        }
        if (this.hasColumn("fase").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Fase");
        }
        if (this.hasColumn("assunto").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Assunto");
        }
        if (this.hasColumn("tipo").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Tipo");
        }
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 8000);
        sheet.setColumnWidth(2, 4000);
        sheet.setColumnWidth(3, 7500);
        sheet.setColumnWidth(4, 12000);
        sheet.setColumnWidth(5, 4000);
        return wb;
    }

    private void createStyles(Workbook wb) {
        DefaultIndexedColorMap idxColor = new DefaultIndexedColorMap();
        Font fontBase = wb.createFont();
        fontBase.setFontHeightInPoints((short)11);
        fontBase.setFontName("Calibri");
        Font fontHeader = wb.createFont();
        fontHeader.setFontHeightInPoints((short)11);
        fontHeader.setFontName("Calibri");
        fontHeader.setBold(true);
        CellStyle styleBorderCinza = wb.createCellStyle();
        styleBorderCinza.setBorderBottom(BorderStyle.THIN);
        styleBorderCinza.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderLeft(BorderStyle.THIN);
        styleBorderCinza.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderRight(BorderStyle.THIN);
        styleBorderCinza.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderTop(BorderStyle.THIN);
        styleBorderCinza.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        this.cellStyles.put("styleBorderCinza", styleBorderCinza);
        CellStyle styleHead = wb.createCellStyle();
        styleHead.cloneStyleFrom(styleBorderCinza);
        styleHead.setFont(fontHeader);
        styleHead.setAlignment(HorizontalAlignment.CENTER);
        styleHead.setVerticalAlignment(VerticalAlignment.CENTER);
        styleHead.setWrapText(true);
        ((XSSFCellStyle)styleHead).setFillForegroundColor(new XSSFColor(new Color(198, 198, 198), (IndexedColorMap)idxColor));
        styleHead.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.cellStyles.put("styleHead", styleHead);
        CellStyle styleBase = wb.createCellStyle();
        styleBase.setFont(fontBase);
        styleBase.setAlignment(HorizontalAlignment.CENTER);
        styleBase.setWrapText(true);
        styleBase.setVerticalAlignment(VerticalAlignment.CENTER);
        styleBase.setBorderBottom(BorderStyle.THIN);
        styleBase.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderLeft(BorderStyle.THIN);
        styleBase.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderRight(BorderStyle.THIN);
        styleBase.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderTop(BorderStyle.THIN);
        styleBase.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        this.cellStyles.put("styleBase", styleBase);
        DataFormat formatter = wb.createDataFormat();
        CellStyle styleData = wb.createCellStyle();
        styleData.cloneStyleFrom(styleBase);
        styleData.setDataFormat(formatter.getFormat("dd/MM/yyyy"));
        styleData.setAlignment(HorizontalAlignment.CENTER);
        this.cellStyles.put("styleData", styleData);
    }

    public Boolean hasColumn(String coluna) {
        if (coluna == null || coluna.isEmpty()) {
            return false;
        }
        if (this.prefCampos == null || this.prefCampos.isEmpty()) {
            return true;
        }
        return this.prefCampos.contains(coluna);
    }
}

