/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.reports;

import br.gov.antt.sgctt.correspondencias.CorrespondenciaBase;
import br.gov.antt.sgctt.obrigacoes.ObrigacaoContratual;
import br.gov.antt.sgctt.obrigacoes.ObrigacaoLancamento;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatorioObrigacoesXls {
    private static final Logger LOG = LoggerFactory.getLogger(RelatorioObrigacoesXls.class);
    private List<String> preferencias;

    public byte[] execute(List<ObrigacaoLancamento> obrigacoes, List<String> preferencias) {
        LOG.debug("Iniciando exporta\u00e7\u00e3o Excel obriga\u00e7\u00f5es");
        this.preferencias = preferencias;
        Workbook wb = this.internalExecuteXLS(obrigacoes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)baos);
            baos.flush();
            wb.close();
        }
        catch (IOException ioExc) {
            LOG.error("IOExc", (Throwable)ioExc);
        }
        return baos.toByteArray();
    }

    private Workbook internalExecuteXLS(List<ObrigacaoLancamento> obrigacoes) {
        Object object;
        Cell cell;
        String ULTIMO_DIA_UTIL = "UDM";
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        DefaultIndexedColorMap idxColor = new DefaultIndexedColorMap();
        Font fontBase = wb.createFont();
        fontBase.setFontHeightInPoints((short)11);
        fontBase.setFontName("Calibri");
        Font fontRevisao = wb.createFont();
        fontRevisao.setFontHeightInPoints((short)13);
        fontRevisao.setFontName("Calibri");
        Font fontRelatorio = wb.createFont();
        fontRelatorio.setFontHeightInPoints((short)16);
        fontRelatorio.setFontName("Calibri");
        fontRelatorio.setBold(true);
        Font fontHeader = wb.createFont();
        fontHeader.setFontHeightInPoints((short)11);
        fontHeader.setFontName("Calibri");
        fontHeader.setBold(true);
        Font fontTitle = wb.createFont();
        fontTitle.setFontHeightInPoints((short)18);
        fontTitle.setFontName("Calibri");
        Font fontBigHeader = wb.createFont();
        fontBigHeader.setFontHeightInPoints((short)18);
        fontBigHeader.setColor(IndexedColors.GREY_50_PERCENT.getIndex());
        fontBigHeader.setFontName("Calibri");
        Font fontBig = wb.createFont();
        fontBig.setFontHeightInPoints((short)18);
        fontBig.setFontName("Calibri");
        Font fontSub = wb.createFont();
        fontSub.setFontHeightInPoints((short)11);
        fontSub.setFontName("Calibri");
        fontSub.setBold(true);
        Font fontQtde = wb.createFont();
        fontQtde.setFontHeightInPoints((short)11);
        fontQtde.setFontName("Calibri");
        CellStyle styleBorder = wb.createCellStyle();
        styleBorder.setBorderBottom(BorderStyle.THIN);
        styleBorder.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        styleBorder.setBorderLeft(BorderStyle.THIN);
        styleBorder.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        styleBorder.setBorderRight(BorderStyle.THIN);
        styleBorder.setRightBorderColor(IndexedColors.BLACK.getIndex());
        styleBorder.setBorderTop(BorderStyle.THIN);
        styleBorder.setTopBorderColor(IndexedColors.BLACK.getIndex());
        CellStyle styleBorderCinza = wb.createCellStyle();
        styleBorderCinza.setBorderBottom(BorderStyle.THIN);
        styleBorderCinza.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderLeft(BorderStyle.THIN);
        styleBorderCinza.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderRight(BorderStyle.THIN);
        styleBorderCinza.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderTop(BorderStyle.THIN);
        styleBorderCinza.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        CellStyle styleBase = wb.createCellStyle();
        styleBase.setFont(fontBase);
        styleBase.setAlignment(HorizontalAlignment.CENTER);
        styleBase.setWrapText(true);
        styleBase.setVerticalAlignment(VerticalAlignment.CENTER);
        styleBase.setBorderBottom(BorderStyle.THIN);
        styleBase.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderLeft(BorderStyle.THIN);
        styleBase.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderRight(BorderStyle.THIN);
        styleBase.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderTop(BorderStyle.THIN);
        styleBase.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        DataFormat formatter = wb.createDataFormat();
        CellStyle styleNumerico = wb.createCellStyle();
        styleNumerico.setFont(fontBase);
        styleNumerico.setBorderBottom(BorderStyle.THIN);
        styleNumerico.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleNumerico.setBorderLeft(BorderStyle.THIN);
        styleNumerico.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleNumerico.setBorderRight(BorderStyle.THIN);
        styleNumerico.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleNumerico.setBorderTop(BorderStyle.THIN);
        styleNumerico.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleNumerico.setAlignment(HorizontalAlignment.RIGHT);
        styleNumerico.setDataFormat(formatter.getFormat("##,##0.00"));
        CellStyle styleHead = wb.createCellStyle();
        styleHead.cloneStyleFrom(styleBorderCinza);
        styleHead.setFont(fontHeader);
        styleHead.setAlignment(HorizontalAlignment.CENTER);
        styleHead.setVerticalAlignment(VerticalAlignment.CENTER);
        styleHead.setWrapText(true);
        ((XSSFCellStyle)styleHead).setFillForegroundColor(new XSSFColor(new Color(198, 198, 198), (IndexedColorMap)idxColor));
        styleHead.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        CellStyle styleCabecalho = wb.createCellStyle();
        styleCabecalho.setFont(fontBigHeader);
        styleCabecalho.setBorderBottom(BorderStyle.THIN);
        styleCabecalho.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleCabecalho.setBorderLeft(BorderStyle.THIN);
        styleCabecalho.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleCabecalho.setBorderRight(BorderStyle.THIN);
        styleCabecalho.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleCabecalho.setBorderTop(BorderStyle.THIN);
        styleCabecalho.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleCabecalho.setAlignment(HorizontalAlignment.CENTER);
        styleCabecalho.setVerticalAlignment(VerticalAlignment.CENTER);
        styleCabecalho.setWrapText(true);
        CellStyle styleControle = wb.createCellStyle();
        styleControle.setFont(fontBig);
        styleControle.setAlignment(HorizontalAlignment.CENTER);
        styleControle.setVerticalAlignment(VerticalAlignment.CENTER);
        styleControle.setWrapText(true);
        styleControle.setBorderLeft(BorderStyle.THIN);
        styleControle.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleControle.setBorderRight(BorderStyle.THIN);
        styleControle.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleControle.setBorderTop(BorderStyle.THIN);
        styleControle.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        CellStyle styleSubCabecalho = wb.createCellStyle();
        styleSubCabecalho.setFont(fontSub);
        styleSubCabecalho.setAlignment(HorizontalAlignment.CENTER);
        styleSubCabecalho.setVerticalAlignment(VerticalAlignment.CENTER);
        styleSubCabecalho.setWrapText(true);
        CellStyle styleRevisao = wb.createCellStyle();
        styleRevisao.setFont(fontRevisao);
        styleRevisao.setAlignment(HorizontalAlignment.CENTER);
        styleRevisao.setVerticalAlignment(VerticalAlignment.CENTER);
        styleRevisao.setWrapText(true);
        styleRevisao.setBorderLeft(BorderStyle.THIN);
        styleRevisao.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleRevisao.setBorderRight(BorderStyle.THIN);
        styleRevisao.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        CellStyle styleRelatorio = wb.createCellStyle();
        styleRelatorio.setFont(fontRevisao);
        styleRelatorio.setAlignment(HorizontalAlignment.CENTER);
        styleRelatorio.setVerticalAlignment(VerticalAlignment.CENTER);
        styleRelatorio.setWrapText(true);
        styleRelatorio.setBorderLeft(BorderStyle.THIN);
        styleRelatorio.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleRelatorio.setBorderRight(BorderStyle.THIN);
        styleRelatorio.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleRelatorio.setBorderBottom(BorderStyle.THIN);
        styleRelatorio.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        CellStyle styleFooterCentral = wb.createCellStyle();
        styleFooterCentral.setFont(fontBase);
        styleFooterCentral.setAlignment(HorizontalAlignment.CENTER);
        ((XSSFCellStyle)styleFooterCentral).setFillForegroundColor(new XSSFColor(new Color(198, 198, 198), (IndexedColorMap)idxColor));
        styleFooterCentral.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleFooterCentral.setBorderBottom(BorderStyle.THIN);
        styleFooterCentral.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterCentral.setBorderLeft(BorderStyle.THIN);
        styleFooterCentral.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterCentral.setBorderRight(BorderStyle.THIN);
        styleFooterCentral.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterCentral.setBorderTop(BorderStyle.THIN);
        styleFooterCentral.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        CellStyle styleFooterDireita = wb.createCellStyle();
        styleFooterDireita.setFont(fontBase);
        styleFooterDireita.setAlignment(HorizontalAlignment.RIGHT);
        styleFooterDireita.setDataFormat(formatter.getFormat("##,##0.00"));
        ((XSSFCellStyle)styleFooterDireita).setFillForegroundColor(new XSSFColor(new Color(198, 198, 198), (IndexedColorMap)idxColor));
        styleFooterDireita.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleFooterDireita.setBorderBottom(BorderStyle.THIN);
        styleFooterDireita.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterDireita.setBorderLeft(BorderStyle.THIN);
        styleFooterDireita.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterDireita.setBorderRight(BorderStyle.THIN);
        styleFooterDireita.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleFooterDireita.setBorderTop(BorderStyle.THIN);
        styleFooterDireita.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font smallFont = wb.createFont();
        smallFont.setFontHeightInPoints((short)8);
        smallFont.setItalic(true);
        Font small2Font = wb.createFont();
        small2Font.setFontHeightInPoints((short)9);
        CellStyle styleFooterLeft = wb.createCellStyle();
        styleFooterLeft.setFont(smallFont);
        styleFooterLeft.setAlignment(HorizontalAlignment.LEFT);
        ((XSSFCellStyle)styleFooterLeft).setFillForegroundColor(new XSSFColor(new Color(190, 190, 190), (IndexedColorMap)idxColor));
        styleFooterLeft.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleFooterLeft.setBorderBottom(BorderStyle.THIN);
        styleFooterLeft.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        styleFooterLeft.setBorderLeft(BorderStyle.THIN);
        styleFooterLeft.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        styleFooterLeft.setBorderTop(BorderStyle.THIN);
        styleFooterLeft.setTopBorderColor(IndexedColors.BLACK.getIndex());
        CellStyle styleFooterRight = wb.createCellStyle();
        styleFooterRight.setFont(small2Font);
        styleFooterRight.setAlignment(HorizontalAlignment.LEFT);
        ((XSSFCellStyle)styleFooterRight).setFillForegroundColor(new XSSFColor(new Color(190, 190, 190), (IndexedColorMap)idxColor));
        styleFooterRight.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        styleFooterRight.setBorderBottom(BorderStyle.THIN);
        styleFooterRight.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        styleFooterRight.setBorderRight(BorderStyle.THIN);
        styleFooterRight.setRightBorderColor(IndexedColors.BLACK.getIndex());
        styleFooterRight.setBorderTop(BorderStyle.THIN);
        styleFooterRight.setTopBorderColor(IndexedColors.BLACK.getIndex());
        CellStyle styleQtd = wb.createCellStyle();
        styleQtd.setFont(fontQtde);
        styleQtd.setBorderBottom(BorderStyle.THIN);
        styleQtd.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        styleQtd.setBorderLeft(BorderStyle.THIN);
        styleQtd.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        styleQtd.setBorderRight(BorderStyle.THIN);
        styleQtd.setRightBorderColor(IndexedColors.BLACK.getIndex());
        styleQtd.setBorderTop(BorderStyle.THIN);
        styleQtd.setTopBorderColor(IndexedColors.BLACK.getIndex());
        styleQtd.setDataFormat(formatter.getFormat("##,##0.00"));
        CellStyle styleData = wb.createCellStyle();
        styleData.cloneStyleFrom(styleBase);
        styleData.setDataFormat(formatter.getFormat("dd/MM/yyyy"));
        styleData.setAlignment(HorizontalAlignment.CENTER);
        SXSSFSheet sheet = wb.createSheet("Lan\u00e7amentos");
        sheet.setDisplayGridlines(false);
        sheet.setPrintGridlines(false);
        Integer idx = 0;
        Integer idxCell = 0;
        Row row = sheet.createRow(0);
        if (this.hasColumn("nome").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Nome");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("descricao").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Descri\u00e7\u00e3o");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("classificacao").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Classifica\u00e7\u00e3o");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("area").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("\u00c1rea");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("responsavel").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Respons\u00e1vel");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("entidade").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Entidade");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("formato").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Formato");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("itemContrato").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Item Contrato");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("statusObrigacao").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Obriga\u00e7\u00e3o");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("periodicidade").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Periodicidade");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("diaUtil").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Dia \u00datil");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("diaFixo").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Dia Fixo");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("aviso").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Aviso (Dias)");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("inicioObrigacao").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("In\u00edcio Obriga\u00e7\u00e3o");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("finalObrigacao").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Final Obriga\u00e7\u00e3o");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("prazo").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Prazo");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("entrega").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Entrega");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("correspondencia").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Corresp. - ID");
            idxCell = idxCell + 1;
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Corresp. - Carta");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("statusPrazoDesc").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Status - Prazo");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("statusLancamento").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Status - Lcto.");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("datEncerramento").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Data Encerramento");
            idxCell = idxCell + 1;
        }
        if (this.hasColumn("observacaoEncerramento").booleanValue()) {
            cell = row.createCell(idxCell.intValue());
            cell.setCellStyle(styleHead);
            cell.setCellValue("Obs. Encerramento");
            idxCell = idxCell + 1;
        }
        if (obrigacoes != null) {
            for (ObrigacaoLancamento lcto : obrigacoes) {
                idx = idx + 1;
                row = sheet.createRow(idx.intValue());
                idxCell = 0;
                ObrigacaoContratual obriga = lcto.getObrigacao();
                if (this.hasColumn("nome").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    cell.setCellValue(obriga.getNome());
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("descricao").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    String desc = obriga.getDescricao();
                    if (desc != null && desc.length() > 32700) {
                        desc = desc.substring(0, 32700);
                    }
                    cell.setCellValue(desc);
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("classificacao").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getClassificacao() != null) {
                        cell.setCellValue(obriga.getClassificacao().getDescricao());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("area").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getArea() != null) {
                        cell.setCellValue(obriga.getArea().getDescricao());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("responsavel").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getResponsavelArea() != null) {
                        cell.setCellValue(obriga.getResponsavelArea().getNome());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("entidade").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getEntidade() != null) {
                        cell.setCellValue(obriga.getEntidade().getNome());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("formato").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getFormato().equals(Character.valueOf('E'))) {
                        cell.setCellValue("Email");
                    }
                    if (obriga.getFormato().equals(Character.valueOf('C'))) {
                        cell.setCellValue("Carta");
                    }
                    if (obriga.getFormato().equals(Character.valueOf('D'))) {
                        cell.setCellValue("Digital");
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("itemContrato").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getIdItemContrato() != null && obriga.getItemContrato() != null && obriga.getItemContrato().getNroItem() != null) {
                        cell.setCellValue(obriga.getItemContrato().getNroItem());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("statusObrigacao").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getStatus().equals(1)) {
                        cell.setCellValue("Ativa");
                    }
                    if (obriga.getStatus().equals(2)) {
                        cell.setCellValue("Inativa");
                    }
                    if (obriga.getStatus().equals(3)) {
                        cell.setCellValue("Cancelada");
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("periodicidade").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getPeriodicidade() != null) {
                        cell.setCellValue(obriga.getPeriodicidade().getDisplayName());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("diaUtil").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getDiaUtil() != null) {
                        String diaUtil = obriga.getDiaUtil();
                        if (diaUtil.equals("UDM")) {
                            diaUtil = "\u00daltimo dia";
                        }
                        cell.setCellValue(diaUtil);
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("diaFixo").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getDiaFixo() != null) {
                        cell.setCellValue((double)obriga.getDiaFixo().intValue());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("aviso").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (obriga.getDiasAviso() != null) {
                        cell.setCellValue(obriga.getDiasAviso());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("inicioObrigacao").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleData);
                    if (obriga.getDatInicioObrigacao() != null) {
                        cell.setCellValue(obriga.getDatInicioObrigacao());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("finalObrigacao").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleData);
                    if (obriga.getDatFinalObrigacao() != null) {
                        cell.setCellValue(obriga.getDatFinalObrigacao());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("prazo").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleData);
                    if (lcto.getDatObrigacao() != null) {
                        cell.setCellValue(lcto.getDatObrigacao());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("entrega").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleData);
                    if (lcto.getDatExecucao() != null) {
                        cell.setCellValue(lcto.getDatExecucao());
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("correspondencia").booleanValue()) {
                    CorrespondenciaBase corresp;
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (lcto.getCorrespondencia() != null) {
                        cell.setCellValue((double)lcto.getCorrespondencia().getId().getIdCorrespondencia().intValue());
                    }
                    idxCell = idxCell + 1;
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (lcto.getCorrespondencia() != null && (corresp = lcto.getCorrespondencia()) != null && corresp.getNroMinuta() != null) {
                        cell.setCellValue(String.format("%s", corresp.getNroMinuta()));
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("statusPrazoDesc").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    cell.setCellValue(lcto.getStatusPrazoDesc());
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("statusLancamento").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleBase);
                    if (lcto.getStatus().equals(0)) {
                        cell.setCellValue("Pendente");
                    }
                    if (lcto.getStatus().equals(1)) {
                        cell.setCellValue("Correspond\u00eancia: Andamento");
                    }
                    if (lcto.getStatus().equals(2)) {
                        cell.setCellValue("Correspond\u00eancia: Protocolada");
                    }
                    if (lcto.getStatus().equals(3)) {
                        if (lcto.getIdCorrespondencia() != null) {
                            cell.setCellValue("Correspond\u00eancia: Encerrada");
                        } else {
                            cell.setCellValue("Encerrado");
                        }
                    }
                    if (lcto.getStatus().equals(4)) {
                        cell.setCellValue("Cancelado");
                    }
                    idxCell = idxCell + 1;
                }
                if (this.hasColumn("datEncerramento").booleanValue()) {
                    cell = row.createCell(idxCell.intValue());
                    cell.setCellStyle(styleData);
                    cell.setCellValue(lcto.getDatEncerramento());
                    idxCell = idxCell + 1;
                }
                if (!this.hasColumn("observacaoEncerramento").booleanValue()) continue;
                cell = row.createCell(idxCell.intValue());
                cell.setCellStyle(styleBase);
                cell.setCellValue(lcto.getObservacaoEncerramento());
                idxCell = idxCell + 1;
            }
        }
        idxCell = 0;
        if (this.hasColumn("nome").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 13500);
        }
        if (this.hasColumn("descricao").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 20000);
        }
        if (this.hasColumn("classificacao").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 6500);
        }
        if (this.hasColumn("area").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 6500);
        }
        if (this.hasColumn("responsavel").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 6500);
        }
        if (this.hasColumn("entidade").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 6500);
        }
        if (this.hasColumn("formato").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 1800);
        }
        if (this.hasColumn("itemContrato").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 1900);
        }
        if (this.hasColumn("statusObrigacao").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 3000);
        }
        if (this.hasColumn("periodicidade").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 3500);
        }
        if (this.hasColumn("diaUtil").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 2000);
        }
        if (this.hasColumn("diaFixo").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 2000);
        }
        if (this.hasColumn("aviso").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 1500);
        }
        if (this.hasColumn("inicioObrigacao").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 3000);
        }
        if (this.hasColumn("finalObrigacao").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 3000);
        }
        if (this.hasColumn("prazo").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 3000);
        }
        if (this.hasColumn("entrega").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 3000);
        }
        if (this.hasColumn("correspondencia").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 3500);
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 6000);
        }
        if (this.hasColumn("statusPrazoDesc").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 9000);
        }
        if (this.hasColumn("statusLancamento").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 7000);
        }
        if (this.hasColumn("datEncerramento").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 5000);
        }
        if (this.hasColumn("observacaoEncerramento").booleanValue()) {
            object = idxCell;
            idxCell = idxCell + 1;
            sheet.setColumnWidth(((Integer)object).intValue(), 15000);
        }
        return wb;
    }

    public Boolean hasColumn(String coluna) {
        if (coluna == null || coluna.isEmpty()) {
            return false;
        }
        List prefs = this.preferencias;
        if (prefs == null || prefs.isEmpty()) {
            return true;
        }
        if (prefs.contains(coluna)) {
            return true;
        }
        return false;
    }

    public Integer hasColumns(String coluna) {
        if (coluna == null || coluna.isEmpty()) {
            return 0;
        }
        List prefs = this.preferencias;
        if (prefs == null || prefs.isEmpty()) {
            return 0;
        }
        int colspan = 0;
        for (String col : coluna.split(";")) {
            if (!prefs.contains(col)) continue;
            ++colspan;
        }
        return colspan;
    }
}

