/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.reports;

import br.gov.antt.sgctt.geral.ColumnInfo;
import br.gov.antt.sgctt.licencas.Condicionante;
import br.gov.antt.sgctt.licencas.Licenca;
import br.gov.antt.sgctt.licencas.TipoValidade;
import br.gov.antt.sgctt.reports.RelatorioLicencasExcel;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatorioLicencasExcel {
    private static final Logger logger = LoggerFactory.getLogger(RelatorioLicencasExcel.class);
    private List<String> prefCampos;
    private final Map<String, CellStyle> cellStyles = new HashMap();

    public byte[] executeXLS(List<Condicionante> condicionantes, List<ColumnInfo> prefCampos) {
        logger.debug("Gerando XLS licen\u00e7as");
        Workbook wb = this.internalExecuteXLS(condicionantes, prefCampos);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)baos);
            baos.flush();
            wb.close();
        }
        catch (IOException ioExc) {
            logger.error("IOExc", (Throwable)ioExc);
        }
        return baos.toByteArray();
    }

    private Workbook internalExecuteXLS(List<Condicionante> condicionantes, List<ColumnInfo> prefCampos) {
        Cell cell;
        SXSSFWorkbook wb = new SXSSFWorkbook(100);
        this.createStyles((Workbook)wb);
        Sheet sheet = wb.createSheet("Licen\u00e7as");
        sheet.setDisplayGridlines(false);
        sheet.setPrintGridlines(false);
        int idxRow = 0;
        int idxCell = -1;
        Row row = sheet.createRow(0);
        if (this.hasColumn("nroLicenca").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("N\u00ba Licen\u00e7a");
        }
        if (this.hasColumn("empresa").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Empresa");
        }
        if (this.hasColumn("empreendimento").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Empreendimento");
        }
        if (this.hasColumn("tipoLicenca").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Tipo de Licen\u00e7a");
        }
        if (this.hasColumn("orgaoAmbiental").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("\u00d3rg\u00e3o Ambiental");
        }
        if (this.hasColumn("dataEmissao").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Data Emiss\u00e3o");
        }
        if (this.hasColumn("validade").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Validade");
        }
        if (this.hasColumn("status").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Status de licen\u00e7a");
        }
        if (this.hasColumn("nroProcesso").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("N\u00ba Processo");
        }
        if (this.hasColumn("codigoOrgao").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("C\u00f3digo \u00d3rg\u00e3o");
        }
        if (this.hasColumn("observacao").booleanValue()) {
            cell = row.createCell(++idxCell);
            cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
            cell.setCellValue("Observa\u00e7\u00e3o");
        }
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("\u00d3rg\u00e3o expedidor");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("\u00c1rea");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("Respons\u00e1vel");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("N\u00ba Condicionante");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("Descri\u00e7\u00e3o Cond.");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("Tipo Cond.");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("Especifica\u00e7\u00f5es Cond.");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("Status Cond.");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("Data Limite Cond.");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("Data Conclus\u00e3o Cond.");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("Notas Cond.");
        cell = row.createCell(++idxCell);
        cell.setCellStyle((CellStyle)this.cellStyles.get("styleHead"));
        cell.setCellValue("Observa\u00e7\u00f5es Cond.");
        if (condicionantes != null) {
            1 compItem = new /* Unavailable Anonymous Inner Class!! */;
            for (Condicionante condicionante : condicionantes) {
                if (condicionante == null || condicionante.getLicenca() == null) continue;
                Licenca licenca = condicionante.getLicenca();
                row = sheet.createRow(++idxRow);
                idxCell = -1;
                if (this.hasColumn("nroLicenca").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                    cell.setCellValue(licenca.getNroLicenca());
                }
                if (this.hasColumn("empresa").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                    if (licenca.getEmpresa() != null) {
                        cell.setCellValue(licenca.getEmpresa().getNomeFantasia());
                    }
                }
                if (this.hasColumn("empreendimento").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                    if (licenca.getObra() != null) {
                        cell.setCellValue(licenca.getObra().getDescricao());
                    }
                }
                if (this.hasColumn("tipoLicenca").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                    if (licenca.getTipoLicenca() != null) {
                        cell.setCellValue(licenca.getTipoLicenca().getDescricao());
                    }
                }
                if (this.hasColumn("orgaoAmbiental").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                    if (licenca.getOrgaoAmbiental() != null) {
                        cell.setCellValue(licenca.getOrgaoAmbiental().getNome());
                    }
                }
                if (this.hasColumn("dataEmissao").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleData"));
                    cell.setCellValue(licenca.getDataEmissao());
                }
                if (this.hasColumn("validade").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                    String periodo = null;
                    if (licenca.getTipoValidade() != null) {
                        if (licenca.getTipoValidade().equals((Object)TipoValidade.DIAS)) {
                            periodo = " dia(s)";
                        }
                        if (licenca.getTipoValidade().equals((Object)TipoValidade.SEMANAS)) {
                            periodo = " semana(s)";
                        }
                        if (licenca.getTipoValidade().equals((Object)TipoValidade.MESES)) {
                            periodo = " mes(es)";
                        }
                        if (licenca.getTipoValidade().equals((Object)TipoValidade.ANOS)) {
                            periodo = " ano(s)";
                        }
                    }
                    cell.setCellValue(licenca.getValidade() + periodo);
                }
                if (this.hasColumn("status").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                    if (licenca.getStatus() != null) {
                        cell.setCellValue(licenca.getStatus().getDescricao());
                    }
                }
                if (this.hasColumn("nroProcesso").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                    cell.setCellValue(licenca.getNroProcesso());
                }
                if (this.hasColumn("codigoOrgao").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                    cell.setCellValue(licenca.getNroOrgao());
                }
                if (this.hasColumn("observacao").booleanValue()) {
                    cell = row.createCell(++idxCell);
                    cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                    cell.setCellValue(licenca.getObservacao());
                }
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                if (licenca.getStatus() != null) {
                    cell.setCellValue(licenca.getStatus().getDescricao());
                }
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                if (licenca.getArea() != null) {
                    cell.setCellValue(licenca.getArea().getDescricao());
                }
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                if (licenca.getResponsavelArea() != null && licenca.getResponsavelArea().getResponsavel() != null) {
                    cell.setCellValue(licenca.getResponsavelArea().getResponsavel().getNome());
                }
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                cell.setCellValue(condicionante.getNumero());
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                cell.setCellValue(condicionante.getDescricao());
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                String tipo = null;
                if (condicionante.getTipo() != null) {
                    if (condicionante.getTipo().getCode() == 1) {
                        tipo = "Informa\u00e7\u00e3o Complementar";
                    }
                    if (condicionante.getTipo().getCode() == 2) {
                        tipo = "Condicionante";
                    }
                }
                cell.setCellValue(tipo);
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                cell.setCellValue(condicionante.getEspecificacao());
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                if (condicionante.getStatusCondicionante() != null) {
                    cell.setCellValue(condicionante.getStatusCondicionante().getDescricao());
                }
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleData"));
                cell.setCellValue(condicionante.getDataLimite());
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleData"));
                cell.setCellValue(condicionante.getDataConclusao());
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                cell.setCellValue(condicionante.getNotaCondicionante());
                cell = row.createCell(++idxCell);
                cell.setCellStyle((CellStyle)this.cellStyles.get("styleBase"));
                cell.setCellValue(condicionante.getObservacao());
            }
        }
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 4000);
        sheet.setColumnWidth(3, 7500);
        sheet.setColumnWidth(4, 12000);
        sheet.setColumnWidth(5, 4000);
        sheet.setColumnWidth(6, 4000);
        sheet.setColumnWidth(7, 4000);
        sheet.setColumnWidth(8, 5500);
        sheet.setColumnWidth(9, 11000);
        sheet.setColumnWidth(10, 8000);
        sheet.setColumnWidth(11, 4000);
        sheet.setColumnWidth(12, 4000);
        sheet.setColumnWidth(13, 6000);
        sheet.setColumnWidth(14, 11000);
        sheet.setColumnWidth(15, 11000);
        sheet.setColumnWidth(16, 4000);
        sheet.setColumnWidth(17, 4000);
        sheet.setColumnWidth(18, 4000);
        sheet.setColumnWidth(19, 8000);
        sheet.setColumnWidth(20, 6000);
        return wb;
    }

    private void createStyles(Workbook wb) {
        DefaultIndexedColorMap idxColor = new DefaultIndexedColorMap();
        Font fontBase = wb.createFont();
        fontBase.setFontHeightInPoints((short)11);
        fontBase.setFontName("Calibri");
        Font fontHeader = wb.createFont();
        fontHeader.setFontHeightInPoints((short)11);
        fontHeader.setFontName("Calibri");
        fontHeader.setBold(true);
        CellStyle styleBorderCinza = wb.createCellStyle();
        styleBorderCinza.setBorderBottom(BorderStyle.THIN);
        styleBorderCinza.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderLeft(BorderStyle.THIN);
        styleBorderCinza.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderRight(BorderStyle.THIN);
        styleBorderCinza.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBorderCinza.setBorderTop(BorderStyle.THIN);
        styleBorderCinza.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        this.cellStyles.put("styleBorderCinza", styleBorderCinza);
        CellStyle styleHead = wb.createCellStyle();
        styleHead.cloneStyleFrom(styleBorderCinza);
        styleHead.setFont(fontHeader);
        styleHead.setAlignment(HorizontalAlignment.CENTER);
        styleHead.setVerticalAlignment(VerticalAlignment.CENTER);
        styleHead.setWrapText(true);
        ((XSSFCellStyle)styleHead).setFillForegroundColor(new XSSFColor(new Color(198, 198, 198), (IndexedColorMap)idxColor));
        styleHead.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.cellStyles.put("styleHead", styleHead);
        CellStyle styleBase = wb.createCellStyle();
        styleBase.setFont(fontBase);
        styleBase.setAlignment(HorizontalAlignment.CENTER);
        styleBase.setWrapText(true);
        styleBase.setVerticalAlignment(VerticalAlignment.CENTER);
        styleBase.setBorderBottom(BorderStyle.THIN);
        styleBase.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderLeft(BorderStyle.THIN);
        styleBase.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderRight(BorderStyle.THIN);
        styleBase.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        styleBase.setBorderTop(BorderStyle.THIN);
        styleBase.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        this.cellStyles.put("styleBase", styleBase);
        DataFormat formatter = wb.createDataFormat();
        CellStyle styleData = wb.createCellStyle();
        styleData.cloneStyleFrom(styleBase);
        styleData.setDataFormat(formatter.getFormat("dd/MM/yyyy"));
        styleData.setAlignment(HorizontalAlignment.CENTER);
        this.cellStyles.put("styleData", styleData);
    }

    public Boolean hasColumn(String coluna) {
        if (coluna == null || coluna.isEmpty()) {
            return false;
        }
        if (this.prefCampos == null || this.prefCampos.isEmpty()) {
            return true;
        }
        return this.prefCampos.contains(coluna);
    }
}

