/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.core.utils;

import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class RegExpUtil {
    private static String ONLY_DIGITS = "\\D";
    private static String DIGITS_DECIMALS = "-?\\d+(,\\d+)*(\\.\\d+(,\\d+)?)?";
    private static String CEP_PATTERN = "(\\d{2,2})(\\d{3,3})(\\d{2,2})";
    private static String CPF_PATTERN = "(\\d{3,3})(\\d{3,3})(\\d{3,3})(\\d{2,2})";
    private static String CNPJ_PATTERN = "(\\d{2,3})(\\d{3,3})(\\d{3,3})(\\d{4,4})(\\d{2,2})";

    public static String onlyNumbers(String sourceString) {
        return sourceString.replaceAll(ONLY_DIGITS, "");
    }

    public static String onlyNumbersWithDecimals(String sourceString) {
        Pattern pattern = Pattern.compile(DIGITS_DECIMALS, 8);
        Matcher matcher = pattern.matcher(sourceString);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static String formatCEP(String cepNumber) {
        Pattern cpfPattern = Pattern.compile(CEP_PATTERN);
        Matcher matcher = cpfPattern.matcher(cepNumber);
        if (matcher.groupCount() == 3) {
            return matcher.replaceAll("$1.$2-$3");
        }
        return "";
    }

    public static String formatCPF(String cpfNumber) {
        Pattern cpfPattern = Pattern.compile(CPF_PATTERN);
        Matcher matcher = cpfPattern.matcher(cpfNumber);
        if (matcher.groupCount() == 4) {
            return matcher.replaceAll("$1.$2.$3-$4");
        }
        return "";
    }

    public static String formatCNPJ(String cnpjNumber) {
        Pattern cpfPattern = Pattern.compile(CNPJ_PATTERN);
        Matcher matcher = cpfPattern.matcher(cnpjNumber);
        if (matcher.groupCount() == 5) {
            return matcher.replaceAll("$1.$2.$3/$4-$5");
        }
        return "";
    }

    @Deprecated
    private static String removeAccents(String sourceString) {
        String[] fromChars = new String[]{"\u00e1\u00e0\u00e3\u00e2\u00e4", "\u00e9\u00e8\u00ea\u00eb", "\u00ed\u00ec\u00ee\u00ef", "\u00f3\u00f2\u00f5\u00f4\u00f6", "\u00fa\u00f9\u00fb\u00fc", "\u00e7", "\u00c1\u00c0\u00c3\u00c2\u00c4", "\u00c9\u00c8\u00ca\u00cb", "\u00cd\u00cc\u00ce\u00cf", "\u00d3\u00d2\u00d5\u00d4\u00d6", "\u00da\u00d9\u00db\u00dc", "\u00c7", "?!()\u00ba"};
        String[] rawString = new String[]{"a", "e", "i", "o", "u", "c", "A", "E", "I", "O", "U", "C", ""};
        String resultStr = sourceString;
        for (int i = 0; i < rawString.length; ++i) {
            resultStr = resultStr.replaceAll("[" + fromChars[i] + "]", rawString[i]);
        }
        return resultStr;
    }

    public static String removerAcentos(String acentuada) {
        StringBuilder cs = new StringBuilder(acentuada);
        return Normalizer.normalize(cs, Normalizer.Form.NFKD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
    }

    public static String makeRefCode(String label) {
        String output = label;
        output = RegExpUtil.removeAccents((String)output);
        output = output.replaceAll(" d[aeo] ", " ").replaceAll(" com ", " ").replaceAll(" para ", " ");
        output = output.replaceAll(" ", "_").replaceAll("\\W", "");
        return output.toUpperCase();
    }
}

