/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis.geral;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.apis.RodoviasRestServices;
import br.gov.antt.sgctt.core.beans.geral.TrechoHomogeneo;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.dto.geral.trechoHomogeneo.FindTrechosHomogeneosDTO;
import br.gov.antt.sgctt.core.dto.geral.trechoHomogeneo.SaveTrechoHomogeneoDTO;
import br.gov.antt.sgctt.services.CadastroService;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Trechos Homog\u00eaneos", description="Trechos homog\u00eaneos")
@RequestMapping(value={"/api/v1/trechosHomogeneos"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0016H\u0017J\u001a\u0010\u0017\u001a\u00020\u00102\b\b\u0001\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u0010\u0019\u001a\u00020\u00102\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J$\u0010\u001c\u001a\u00020\u00102\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0013\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lbr/gov/antt/sgctt/apis/geral/TrechosHomogeneosRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "cadastroService", "Lbr/gov/antt/sgctt/services/CadastroService;", "<init>", "(Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/CadastroService;)V", "getSegurancaService", "()Lbr/gov/antt/sgctt/services/SegurancaService;", "getCadastroService", "()Lbr/gov/antt/sgctt/services/CadastroService;", "LOG", "Lorg/slf4j/Logger;", "findTrechos", "Lorg/springframework/data/domain/Page;", "Lbr/gov/antt/sgctt/core/beans/geral/TrechoHomogeneo;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "dto", "Lbr/gov/antt/sgctt/core/dto/geral/trechoHomogeneo/FindTrechosHomogeneosDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "createTrechoHomogeneo", "Lbr/gov/antt/sgctt/core/dto/geral/trechoHomogeneo/SaveTrechoHomogeneoDTO;", "findThById", "idTrechoHomogeneo", "", "updateTrechoHomogeneo", "deleteTrechoHomogeneo", "", "server"})
public class TrechosHomogeneosRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final Logger LOG;

    public TrechosHomogeneosRestServices(@NotNull SegurancaService segurancaService, @NotNull CadastroService cadastroService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.cadastroService = cadastroService;
        Logger logger = LoggerFactory.getLogger(RodoviasRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOG = logger;
    }

    @NotNull
    public SegurancaService getSegurancaService() {
        return this.segurancaService;
    }

    @NotNull
    public CadastroService getCadastroService() {
        return this.cadastroService;
    }

    @Operation(summary="Busca trechos homog\u00eaneos (TH)", description="Retorna uma lista de trechos homog\u00eaneos.")
    @ApiResponses(value={@ApiResponse(description="Lista de trechos homog\u00eaneos encontrados.", responseCode="200")})
    @GetMapping
    @NotNull
    public Page<TrechoHomogeneo> findTrechos(@NotNull HttpServletRequest request, @Parameter(description="Dados para filtragem") @Valid @ParameterObject @NotNull FindTrechosHomogeneosDTO dto, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @PageableDefault(sort={"id", "idRodovia"}, direction=Sort.Direction.ASC) @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.getCadastroService().findTrechosHomogeneos(dto, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findTrechosHomogeneos(...)");
        return page;
    }

    @PostMapping
    @Operation(summary="Cria um novo Trecho Homog\u00eaneo", description="Cria um novo trecho homog\u00eaneo.")
    @ApiResponses(value={@ApiResponse(description="Trecho Homog\u00eaneo criado com sucesso", responseCode="201")})
    @NotNull
    public TrechoHomogeneo createTrechoHomogeneo(@Parameter(description="Dados do novo trecho homog\u00eaneo a ser criado") @Valid @RequestBody @NotNull SaveTrechoHomogeneoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - Iniciando createTrechoHomogeneo()...", (Object)usuario.getLogin());
        CadastroService cadastroService = this.getCadastroService();
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        TrechoHomogeneo trechoHomogeneo = cadastroService.createTrechoHomogeneo(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)trechoHomogeneo, (String)"createTrechoHomogeneo(...)");
        return trechoHomogeneo;
    }

    @GetMapping(value={"/{idTrechoHomogeneo}"})
    @Operation(summary="Busca um TH por ID", description="Retorna os detalhes de um Trecho homogeneo pelo seu ID. Requer permiss\u00e3o 'TRECHO_HOMOGENEO' ou 'TRECHO_HOMOGENEO_LISTAGEM'.")
    @ApiResponses(value={@ApiResponse(description="TH encontrado com sucesso", responseCode="200"), @ApiResponse(description="TH n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public TrechoHomogeneo findThById(@PathVariable(name="idTrechoHomogeneo") int idTrechoHomogeneo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - Iniciando getTrechoHomogeneoById(id={})...", (Object)usuario.getLogin(), (Object)idTrechoHomogeneo);
        TrechoHomogeneo trechoHomogeneo = this.getCadastroService().getTrechoHomogeneoById(idTrechoHomogeneo);
        Intrinsics.checkNotNullExpressionValue((Object)trechoHomogeneo, (String)"getTrechoHomogeneoById(...)");
        return trechoHomogeneo;
    }

    @PutMapping(value={"/{idTrechoHomogeneo}"})
    @Operation(summary="Atualiza um Trecho Homog\u00eaneo existente", description="Atualiza os dados de um trecho homog\u00eaneo existente.")
    @ApiResponses(value={@ApiResponse(description="Trecho Homog\u00eaneo atualizado com sucesso", responseCode="200"), @ApiResponse(description="Trecho Homog\u00eaneo n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public TrechoHomogeneo updateTrechoHomogeneo(@Parameter(description="ID do trecho homog\u00eaneo a ser atualizado") @PathVariable(value="idTrechoHomogeneo") int idTrechoHomogeneo, @Parameter(description="Dados do trecho homog\u00eaneo a ser atualizado") @Valid @RequestBody @NotNull SaveTrechoHomogeneoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - Iniciando updateTrechoHomogeneo(id={})...", (Object)usuario.getLogin(), (Object)idTrechoHomogeneo);
        CadastroService cadastroService = this.getCadastroService();
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        TrechoHomogeneo trechoHomogeneo = cadastroService.updateTrechoHomogeneo(idTrechoHomogeneo, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)trechoHomogeneo, (String)"updateTrechoHomogeneo(...)");
        return trechoHomogeneo;
    }

    @DeleteMapping(value={"/{idTrechoHomogeneo}"})
    @Operation(summary="Deleta um Trecho Homog\u00eaneo", description="Deleta um trecho homog\u00eaneo existente pelo ID.")
    @ApiResponses(value={@ApiResponse(description="Trecho Homog\u00eaneo removido com sucesso", responseCode="200"), @ApiResponse(description="Trecho Homog\u00eaneo n\u00e3o encontrado", responseCode="404")})
    public void deleteTrechoHomogeneo(@Parameter(description="ID do trecho homog\u00eaneo a ser removido") @PathVariable(value="idTrechoHomogeneo") int idTrechoHomogeneo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        this.LOG.debug("{} - Iniciando deleteTrechoHomogeneo(id={})...", (Object)usuario.getLogin(), (Object)idTrechoHomogeneo);
        this.getCadastroService().deleteTrechoHomogeneo(idTrechoHomogeneo);
    }
}

