/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis.dashboard;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.core.beans.seguranca.Usuario;
import br.gov.antt.sgctt.core.dto.ativos.DashboardDTO;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.SegurancaService;
import br.gov.antt.sgctt.services.ativos.SigacoService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Dashboard", description="Opera\u00e7\u00f5es do Dashboard da empresa")
@RequestMapping(value={"/api/dashboard"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lbr/gov/antt/sgctt/apis/dashboard/DashboardV1RestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "sigacoService", "Lbr/gov/antt/sgctt/services/ativos/SigacoService;", "<init>", "(Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/ativos/SigacoService;)V", "getDashboardData", "Lbr/gov/antt/sgctt/core/dto/ativos/DashboardDTO;", "empresa", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "server"})
public class DashboardV1RestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final SigacoService sigacoService;

    public DashboardV1RestServices(@NotNull SegurancaService segurancaService, @NotNull SigacoService sigacoService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)sigacoService, (String)"sigacoService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.sigacoService = sigacoService;
    }

    @Operation(summary="Buscar dados do dashboard", description="Retorna os dados completos do dashboard incluindo linha do tempo, PER, processos, ativos e obras")
    @ApiResponses(value={@ApiResponse(description="Dados do dashboard encontrados com sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=DashboardDTO.class))}), @ApiResponse(description="Empresa n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{empresa}"})
    @NotNull
    public DashboardDTO getDashboardData(@Parameter(description="Sigla da empresa") @PathVariable @NotNull String empresa, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        DashboardDTO dashboardDTO = this.sigacoService.getDashboardData(empresa, usuario2);
        Intrinsics.checkNotNullExpressionValue((Object)dashboardDTO, (String)"getDashboardData(...)");
        return dashboardDTO;
    }
}

