/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis.ativos;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.ativos.ImportacaoMonitoracao;
import br.gov.antt.sgctt.ativos.MonitoracaoAnexo;
import br.gov.antt.sgctt.ativos.MonitoracaoHistorico;
import br.gov.antt.sgctt.ativos.MonitoracaoImagem;
import br.gov.antt.sgctt.ativos.ReferenciaAtivo;
import br.gov.antt.sgctt.ativos.TipoElemento;
import br.gov.antt.sgctt.ativos.cadastros.Elemento;
import br.gov.antt.sgctt.ativos.cadastros.Monitorador;
import br.gov.antt.sgctt.ativos.dto.StructuredMonitoracaoDesempenhoDTO;
import br.gov.antt.sgctt.ativos.dto.elementos.ElementoDTO;
import br.gov.antt.sgctt.ativos.enums.TipoAtivo;
import br.gov.antt.sgctt.ativos.mappers.ElementoDTOMapper;
import br.gov.antt.sgctt.ativos.monitoracoes.Monitoracao;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.beans.seguranca.Usuario;
import br.gov.antt.sgctt.core.dto.ativos.FindMonitoracoesDTO;
import br.gov.antt.sgctt.core.dto.ativos.SaveMonitoradorDTO;
import br.gov.antt.sgctt.core.dto.ativos.SaveTipoElementoDTO;
import br.gov.antt.sgctt.core.dto.ativos.importacao.elementos.ImportElementosDTO;
import br.gov.antt.sgctt.core.dto.ativos.importacao.monitoracao.ImportMonitoracoesDTO;
import br.gov.antt.sgctt.exceptions.BusinessException;
import br.gov.antt.sgctt.services.CadastroService;
import br.gov.antt.sgctt.services.CoreService;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.SegurancaService;
import br.gov.antt.sgctt.services.ativos.SigacoService;
import br.gov.antt.sgctt.services.importacao.importers.ativos.elementos.ElementoImporter;
import br.gov.antt.sgctt.services.importacao.importers.ativos.elementos.ElementoImporterRegistry;
import br.gov.antt.sgctt.services.importacao.importers.ativos.monitoracao.MonitoracaoImporter;
import br.gov.antt.sgctt.services.importacao.importers.ativos.monitoracao.MonitoracaoImporterRegistry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Valid;
import jakarta.validation.Validator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="Ativos v1", description="Opera\u00e7\u00f5es relacionadas a monitora\u00e7\u00e3o de ativos v1")
@RequestMapping(value={"/api/v1/ativos"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J<\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017J=\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00172\u0006\u0010!\u001a\u00020\"2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010&2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017\u00a2\u0006\u0002\u0010'J=\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00172\u0006\u0010!\u001a\u00020\"2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010&2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017\u00a2\u0006\u0002\u0010'JU\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010!\u001a\u00020\"2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\b\u0001\u0010+\u001a\u0004\u0018\u00010&2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010&2\b\b\u0001\u0010\u001f\u001a\u00020 H\u0017\u00a2\u0006\u0002\u0010-J=\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00172\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010%\u001a\u0004\u0018\u00010&2\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017\u00a2\u0006\u0002\u00100Ja\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00172\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u00103\u001a\u0004\u0018\u00010&2\n\b\u0001\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u00104\u001a\u0004\u0018\u00010&2\n\b\u0001\u00105\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017\u00a2\u0006\u0002\u00106J\u001c\u00107\u001a\u0002082\b\b\u0001\u00109\u001a\u00020&2\b\b\u0001\u0010!\u001a\u00020\"H\u0017Jg\u0010:\u001a\b\u0012\u0004\u0012\u0002080\u00172\b\b\u0001\u0010\u001f\u001a\u00020 2\n\b\u0001\u0010;\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010<\u001a\u0004\u0018\u00010\u001c2\n\b\u0001\u0010=\u001a\u0004\u0018\u00010>2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010>2\u0010\b\u0001\u0010@\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010A2\u0006\u0010!\u001a\u00020\"H\u0017\u00a2\u0006\u0002\u0010BJ\u0016\u0010:\u001a\b\u0012\u0004\u0012\u0002080A2\u0006\u0010!\u001a\u00020\"H\u0017J\u001a\u0010C\u001a\u0002082\b\b\u0001\u0010\u001d\u001a\u00020D2\u0006\u0010!\u001a\u00020\"H\u0017J$\u0010E\u001a\u0002082\b\b\u0001\u00109\u001a\u00020&2\b\b\u0001\u0010\u001d\u001a\u00020D2\u0006\u0010!\u001a\u00020\"H\u0017J\u001a\u0010F\u001a\u00020G2\b\b\u0001\u00109\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0017J\u00e1\u0002\u0010H\u001a\b\u0012\u0004\u0012\u00020I0\u00172\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010;\u001a\u0004\u0018\u00010\u001a2\u0010\b\u0001\u0010J\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010A2\u0010\b\u0001\u0010@\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010A2\u0010\b\u0001\u0010K\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010A2\n\b\u0001\u0010L\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010M\u001a\u0004\u0018\u00010\u001a2\u0010\b\u0001\u0010N\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010A2\n\b\u0001\u0010O\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010P\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010Q\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010R\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010S\u001a\u0004\u0018\u00010\u001a2\u0010\b\u0001\u0010T\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010A2\n\b\u0001\u0010U\u001a\u0004\u0018\u00010&2\n\b\u0001\u0010V\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010W\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010X\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010Y\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010Z\u001a\u0004\u0018\u00010&2\n\b\u0001\u0010[\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010\\\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010]\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017\u00a2\u0006\u0002\u0010^J*\u0010_\u001a\b\u0012\u0004\u0012\u00020`0A2\b\b\u0001\u0010a\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0017J.\u0010b\u001a\u00020\u001a2\b\b\u0001\u0010c\u001a\u00020\u001a2\b\b\u0001\u0010\u001d\u001a\u00020d2\b\b\u0001\u0010e\u001a\u00020f2\u0006\u0010!\u001a\u00020\"H\u0017J.\u0010g\u001a\u00020\u001a2\b\b\u0001\u0010c\u001a\u00020\u001a2\b\b\u0001\u0010\u001d\u001a\u00020h2\b\b\u0001\u0010e\u001a\u00020f2\u0006\u0010!\u001a\u00020\"H\u0017J,\u0010i\u001a\b\u0012\u0004\u0012\u00020j0\u00172\n\b\u0001\u0010;\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017J\u001a\u0010k\u001a\u00020j2\b\b\u0001\u0010l\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0017J\u001a\u0010m\u001a\u00020j2\b\b\u0001\u0010\u001d\u001a\u00020n2\u0006\u0010!\u001a\u00020\"H\u0017J$\u0010o\u001a\u00020j2\b\b\u0001\u0010l\u001a\u00020&2\b\b\u0001\u0010\u001d\u001a\u00020n2\u0006\u0010!\u001a\u00020\"H\u0017J\u001a\u0010p\u001a\u00020G2\b\b\u0001\u0010l\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0017J8\u0010q\u001a\b\u0012\u0004\u0012\u00020I0r2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010s\u001a\u00020&2\b\b\u0001\u0010\u001b\u001a\u00020\u001a2\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\"H\u0017J@\u0010t\u001a\u0006\u0012\u0002\b\u00030r2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001a2\b\b\u0001\u0010u\u001a\u00020v2\n\b\u0001\u0010w\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010!\u001a\u00020\"H\u0017JJ\u0010x\u001a\u0006\u0012\u0002\b\u00030r2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010+\u001a\u00020&2\b\b\u0001\u0010\u001b\u001a\u00020\u001a2\b\b\u0001\u0010u\u001a\u00020v2\n\b\u0001\u0010w\u001a\u0004\u0018\u00010\u001a2\b\b\u0001\u0010!\u001a\u00020\"H\u0017J0\u0010y\u001a\u00020>2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010+\u001a\u00020&2\b\b\u0001\u0010\u001b\u001a\u00020\u001a2\b\b\u0001\u0010!\u001a\u00020\"H\u0017J.\u0010z\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"H\u0017J6\u0010{\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020|0A0r2\b\b\u0001\u0010\u001b\u001a\u00020\u001a2\n\b\u0001\u0010}\u001a\u0004\u0018\u00010\u001a2\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\"H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006~"}, d2={"Lbr/gov/antt/sgctt/apis/ativos/AtivosV1RestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "coreService", "Lbr/gov/antt/sgctt/services/CoreService;", "cadastroService", "Lbr/gov/antt/sgctt/services/CadastroService;", "sigacoService", "Lbr/gov/antt/sgctt/services/ativos/SigacoService;", "monitoracaoImporterRegistry", "Lbr/gov/antt/sgctt/services/importacao/importers/ativos/monitoracao/MonitoracaoImporterRegistry;", "elementoImporterRegistry", "Lbr/gov/antt/sgctt/services/importacao/importers/ativos/elementos/ElementoImporterRegistry;", "elementoDTOMapper", "Lbr/gov/antt/sgctt/ativos/mappers/ElementoDTOMapper;", "validator", "Ljakarta/validation/Validator;", "<init>", "(Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/CoreService;Lbr/gov/antt/sgctt/services/CadastroService;Lbr/gov/antt/sgctt/services/ativos/SigacoService;Lbr/gov/antt/sgctt/services/importacao/importers/ativos/monitoracao/MonitoracaoImporterRegistry;Lbr/gov/antt/sgctt/services/importacao/importers/ativos/elementos/ElementoImporterRegistry;Lbr/gov/antt/sgctt/ativos/mappers/ElementoDTOMapper;Ljakarta/validation/Validator;)V", "logger", "Lorg/slf4j/Logger;", "findMonitoracoes", "Lorg/springframework/data/domain/Page;", "Lbr/gov/antt/sgctt/ativos/monitoracoes/Monitoracao;", "empresa", "", "tipoAtivo", "Lbr/gov/antt/sgctt/ativos/enums/TipoAtivo;", "dto", "Lbr/gov/antt/sgctt/core/dto/ativos/FindMonitoracoesDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "findAnexos", "Lbr/gov/antt/sgctt/ativos/MonitoracaoAnexo;", "idMonitoracao", "", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "findImagens", "Lbr/gov/antt/sgctt/ativos/MonitoracaoImagem;", "findCiclosAnteriores", "idElemento", "faseMonitoracao", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Lbr/gov/antt/sgctt/ativos/enums/TipoAtivo;Ljava/lang/Integer;Ljava/lang/Integer;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "findHistoricos", "Lbr/gov/antt/sgctt/ativos/MonitoracaoHistorico;", "(Ljava/lang/String;Ljava/lang/Integer;Lorg/springframework/data/domain/Pageable;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/data/domain/Page;", "findImportacoes", "Lbr/gov/antt/sgctt/ativos/ImportacaoMonitoracao;", "anoConcessao", "status", "responsavel", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lorg/springframework/data/domain/Pageable;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/data/domain/Page;", "findTipoElementoById", "Lbr/gov/antt/sgctt/ativos/TipoElemento;", "idCategoria", "findTiposElementos", "search", "subsistema", "isParent", "", "isChild", "idsTipoElementosPai", "", "(Lorg/springframework/data/domain/Pageable;Ljava/lang/String;Lbr/gov/antt/sgctt/ativos/enums/TipoAtivo;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/util/List;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/data/domain/Page;", "saveCategoria", "Lbr/gov/antt/sgctt/core/dto/ativos/SaveTipoElementoDTO;", "updateCategoria", "deleteCategoria", "", "findElementos", "Lbr/gov/antt/sgctt/ativos/cadastros/Elemento;", "idsTipoElementos", "idRodovias", "kmInicial", "kmFinal", "statusValue", "classeSinalizacao", "sentido", "direcao", "uf", "sigla", "tipoEps", "idEspecificacaoEps", "classificacao", "tipo", "tipoAcesso", "tipoProprietario", "idTipoOcupacao", "tipoRelevo", "tipoTerrapleno", "classificacaoAtivo", "(Ljava/lang/String;Lbr/gov/antt/sgctt/ativos/enums/TipoAtivo;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/springframework/data/domain/Pageable;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/data/domain/Page;", "getMonitoracoesDesempenho", "Lbr/gov/antt/sgctt/ativos/dto/StructuredMonitoracaoDesempenhoDTO;", "siglaEmpresa", "importMonitoracoes", "empresaSigla", "Lbr/gov/antt/sgctt/core/dto/ativos/importacao/monitoracao/ImportMonitoracoesDTO;", "file", "Lorg/springframework/web/multipart/MultipartFile;", "importElementos", "Lbr/gov/antt/sgctt/core/dto/ativos/importacao/elementos/ImportElementosDTO;", "findMonitoradores", "Lbr/gov/antt/sgctt/ativos/cadastros/Monitorador;", "getMonitoradorById", "id", "createMonitorador", "Lbr/gov/antt/sgctt/core/dto/ativos/SaveMonitoradorDTO;", "updateMonitorador", "deleteMonitorador", "getElementoById", "Lorg/springframework/http/ResponseEntity;", "idAtivo", "saveElemento", "elementoDto", "Lbr/gov/antt/sgctt/ativos/dto/elementos/ElementoDTO;", "observacao", "editElemento", "deleteElemento", "getMonitoracaoById", "getReferenciasAtivo", "Lbr/gov/antt/sgctt/ativos/ReferenciaAtivo;", "campoReferencia", "server"})
public class AtivosV1RestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final SigacoService sigacoService;
    @NotNull
    private final MonitoracaoImporterRegistry monitoracaoImporterRegistry;
    @NotNull
    private final ElementoImporterRegistry elementoImporterRegistry;
    @NotNull
    private final ElementoDTOMapper elementoDTOMapper;
    @NotNull
    private final Validator validator;
    @NotNull
    private final Logger logger;

    public AtivosV1RestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService, @NotNull SigacoService sigacoService, @NotNull MonitoracaoImporterRegistry monitoracaoImporterRegistry, @NotNull ElementoImporterRegistry elementoImporterRegistry, @NotNull ElementoDTOMapper elementoDTOMapper, @NotNull Validator validator) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        Intrinsics.checkNotNullParameter((Object)sigacoService, (String)"sigacoService");
        Intrinsics.checkNotNullParameter((Object)monitoracaoImporterRegistry, (String)"monitoracaoImporterRegistry");
        Intrinsics.checkNotNullParameter((Object)elementoImporterRegistry, (String)"elementoImporterRegistry");
        Intrinsics.checkNotNullParameter((Object)elementoDTOMapper, (String)"elementoDTOMapper");
        Intrinsics.checkNotNullParameter((Object)validator, (String)"validator");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        this.sigacoService = sigacoService;
        this.monitoracaoImporterRegistry = monitoracaoImporterRegistry;
        this.elementoImporterRegistry = elementoImporterRegistry;
        this.elementoDTOMapper = elementoDTOMapper;
        this.validator = validator;
        Logger logger = LoggerFactory.getLogger(AtivosV1RestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @Operation(summary="Buscar monitora\u00e7\u00f5es", description="Retorna uma lista de monitora\u00e7\u00f5es de Edifica\u00e7\u00f5es filtradas pelos par\u00e2metros informados")
    @ApiResponses(value={@ApiResponse(description="Lista de monitora\u00e7\u00f5es de Edifica\u00e7\u00f5es encontradas", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/{tipoAtivo}"})
    @NotNull
    public Page<Monitoracao> findMonitoracoes(@Parameter(description="Sigla da empresa", required=true) @PathVariable @NotNull String empresa, @Parameter(description="Tipo do Ativo", required=true) @PathVariable @NotNull TipoAtivo tipoAtivo, @ParameterObject @Valid @NotNull FindMonitoracoesDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoracoes(empresa, tipoAtivo, dto, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoracoes(...)");
        return page;
    }

    @Operation(summary="Buscar anexos da monitora\u00e7\u00e3o", description="Retorna lista de anexos associados a uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/{idMonitoracao}/anexos"})
    @NotNull
    public Page<MonitoracaoAnexo> findAnexos(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findAnexosMonitoracao(empresa, idMonitoracao, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexosMonitoracao(...)");
        return page;
    }

    @Operation(summary="Buscar imagens da monitora\u00e7\u00e3o", description="Retorna lista de imagens associadas a uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200"), @ApiResponse(description="Monitora\u00e7\u00e3o n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/monitoracoes/{empresa}/{idMonitoracao}/imagens"})
    @NotNull
    public Page<MonitoracaoImagem> findImagens(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findImagensMonitoracao(empresa, idMonitoracao, null, null, null, null, null, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findImagensMonitoracao(...)");
        return page;
    }

    @Operation(summary="Buscar hist\u00f3rico de monitora\u00e7\u00f5es", description="Retorna os hist\u00f3ricos (ciclos anteriores) de uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3rico encontrado com sucesso", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/{tipoAtivo}/ciclos/{idElemento}"})
    @NotNull
    public Page<Monitoracao> findCiclosAnteriores(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @Nullable TipoAtivo tipoAtivo, @Parameter(description="ID do elemento") @PathVariable(name="idElemento") @Nullable Integer idElemento, @Parameter(description="Fase da monitora\u00e7\u00e3o") @RequestParam(name="fase") @Nullable Integer faseMonitoracao, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findCiclosAnteriores(empresa, tipoAtivo, idElemento, faseMonitoracao, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findCiclosAnteriores(...)");
        return page;
    }

    @Operation(summary="Buscar hist\u00f3ricos da monitora\u00e7\u00e3o", description="Retorna os hist\u00f3ricos de altera\u00e7\u00f5es ou eventos de uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3ricos encontrados com sucesso", responseCode="200")})
    @GetMapping(value={"/monitoracoes/{empresa}/{idMonitoracao}/historicos"})
    @NotNull
    public Page<MonitoracaoHistorico> findHistoricos(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findHistoricos(empresa, idMonitoracao, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findHistoricos(...)");
        return page;
    }

    @Operation(summary="Buscar importa\u00e7\u00f5es de monitora\u00e7\u00f5es", description="Retorna a lista de importa\u00e7\u00f5es de monitora\u00e7\u00f5es baseado em filtros opcionais")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @GetMapping(value={"/monitoracoes/importacoes/{empresa}"})
    @NotNull
    public Page<ImportacaoMonitoracao> findImportacoes(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Ano da Concess\u00e3o", required=false) @RequestParam(name="anoConcessao", required=false) @Nullable Integer anoConcessao, @Parameter(description="Subsistema", required=false) @RequestParam(name="subsistema", required=false) @Nullable String tipoAtivo, @Parameter(description="Status", required=false) @RequestParam(name="status", required=false) @Nullable Integer status, @Parameter(description="Respons\u00e1vel", required=false) @RequestParam(name="responsavel", required=false) @Nullable String responsavel, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findImportacoes(empresa, anoConcessao, tipoAtivo, status, responsavel, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findImportacoes(...)");
        return page;
    }

    @GetMapping(value={"/cadastros/tiposElementos/{idCategoria}"})
    @Operation(summary="Retorna a categoria com base no seu identificador")
    @ApiResponses(value={@ApiResponse(description="Categoria encontrada com sucesso", responseCode="200"), @ApiResponse(description="Categoria n\u00e3o encontrada", responseCode="404")})
    @NotNull
    public TipoElemento findTipoElementoById(@Parameter(description="Identificador da categoria.") @PathVariable(name="idCategoria") int idCategoria, @Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.logger.debug("getCategoriaById({})", (Object)idCategoria);
        TipoElemento tipoElemento = this.sigacoService.getTipoElementoById(idCategoria);
        Intrinsics.checkNotNullExpressionValue((Object)tipoElemento, (String)"getTipoElementoById(...)");
        return tipoElemento;
    }

    @GetMapping(value={"/cadastros/tiposElementos"})
    @Operation(summary="Recupera uma lista de tipos de elementos baseada em filtros (search e subsistema).")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public Page<TipoElemento> findTiposElementos(@Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @Parameter(description="Par\u00e2metro de busca") @RequestParam(value="search", required=false) @Nullable String search, @Parameter(description="Tipo do ativo") @RequestParam(value="subsistema", required=false) @Nullable TipoAtivo subsistema, @Parameter(description="Boolean indicando se o elemento \u00e9 pai") @RequestParam(value="isParent", required=false) @Nullable Boolean isParent, @Parameter(description="Boolean indicando se o elemento \u00e9 filho") @RequestParam(value="isChild", required=false) @Nullable Boolean isChild, @Parameter(description="ID do tipo elememento pai") @RequestParam(value="idTipoElementoPai", required=false) @Nullable List<Integer> idsTipoElementosPai, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findTiposElementos(search, subsistema, idsTipoElementosPai, isParent, isChild, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findTiposElementos(...)");
        return page;
    }

    @GetMapping(value={"/cadastros/tiposElementos/all"})
    @Operation(summary="Recupera uma lista de tipos de elementos.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public List<TipoElemento> findTiposElementos(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getPrivateUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        List list = this.sigacoService.findAllTiposElemento();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllTiposElemento(...)");
        return list;
    }

    @PostMapping(value={"/cadastros/tiposElementos"})
    @Operation(summary="Salva a categoria de ativo.")
    @ApiResponses(value={@ApiResponse(description="Tipo elemento criado com sucesso", responseCode="201")})
    @NotNull
    public TipoElemento saveCategoria(@RequestBody(description="Dados da categoria de ativo a ser salva.") @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull SaveTipoElementoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        TipoElemento tipoElemento = this.sigacoService.createTipoElemento(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)tipoElemento, (String)"createTipoElemento(...)");
        return tipoElemento;
    }

    @PutMapping(value={"/cadastros/tiposElementos/{idCategoria}"})
    @Operation(summary="Atualiza a categoria de ativo conforme seu identificador")
    @ApiResponses(value={@ApiResponse(description="Categoria atualizada com sucesso", responseCode="200")})
    @NotNull
    public TipoElemento updateCategoria(@Parameter(description="Identificador da categoria a ser atualizada.") @PathVariable(name="idCategoria") int idCategoria, @RequestBody(description="Dados da categoria de ativo a ser atualizada.") @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull SaveTipoElementoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        TipoElemento tipoElemento = this.sigacoService.updateTipoElemento(idCategoria, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)tipoElemento, (String)"updateTipoElemento(...)");
        return tipoElemento;
    }

    @DeleteMapping(value={"/cadastros/tiposElementos/{idCategoria}"})
    @Operation(summary="Deleta a categoria de ativo conforme seu identificador")
    @ApiResponses(value={@ApiResponse(description="Categoria deletada com sucesso", responseCode="204")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCategoria(@Parameter(description="Identificador da categoria a ser removida.") @PathVariable(name="idCategoria") int idCategoria, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getPrivateUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.logger.debug("deleteCategoria({})", (Object)idCategoria);
        this.sigacoService.deleteTipoElemento(idCategoria);
    }

    @GetMapping(value={"/cadastros/{empresa}/elementos/{tipoAtivo}/all"})
    @Operation(summary="Busca os itens de ativo.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=Elemento.class))})})
    @NotNull
    public Page<Elemento> findElementos(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(description="Par\u00e2metro de busca") @RequestParam(value="search", required=false) @Nullable String search, @Parameter(description="ID do Tipo do Elemento") @RequestParam(value="idTipoElemento", required=false) @Nullable List<Integer> idsTipoElementos, @Parameter(description="ID do Tipo elememento pai") @RequestParam(value="idTipoElementoPai", required=false) @Nullable List<Integer> idsTipoElementosPai, @Parameter(description="ID da rodovia") @RequestParam(value="rodovia", required=false) @Nullable List<Integer> idRodovias, @Parameter(description="Kil\u00f4metro inicial") @RequestParam(value="kmInicial", required=false) @Nullable String kmInicial, @Parameter(description="Kil\u00f4metro final") @RequestParam(value="kmFinal", required=false) @Nullable String kmFinal, @Parameter(description="Status do elemento") @RequestParam(value="status", required=false) @Nullable List<String> statusValue, @Parameter(description="Classe da sinaliza\u00e7\u00e3o") @RequestParam(value="classeSinalizacao", required=false) @Nullable String classeSinalizacao, @Parameter(description="Sentido do elemento") @RequestParam(value="sentido", required=false) @Nullable String sentido, @Parameter(description="Dire\u00e7\u00e3o do elemento") @RequestParam(value="direcao", required=false) @Nullable String direcao, @Parameter(description="UF do elemento") @RequestParam(value="uf", required=false) @Nullable String uf, @Parameter(description="Sigla do elemento") @RequestParam(value="sigla", required=false) @Nullable String sigla, @Parameter(description="Tipo EPS") @RequestParam(value="tipoEps", required=false) @Nullable List<String> tipoEps, @Parameter(description="ID da especifica\u00e7\u00e3o EPS") @RequestParam(value="idEspecificacaoEps", required=false) @Nullable Integer idEspecificacaoEps, @Parameter(description="Classifica\u00e7\u00e3o do elemento OAC") @RequestParam(value="classificacao", required=false) @Nullable String classificacao, @Parameter(description="Tipo do elemento (nome/descri\u00e7\u00e3o)") @RequestParam(value="tipo", required=false) @Nullable String tipo, @Parameter(description="Tipo de acesso (FDA)") @RequestParam(value="tipoAcesso", required=false) @Nullable String tipoAcesso, @Parameter(description="Tipo de propriet\u00e1rio (FDA)") @RequestParam(value="tipoProprietario", required=false) @Nullable String tipoProprietario, @Parameter(description="ID do tipo de ocupa\u00e7\u00e3o (FDO)") @RequestParam(value="idTipoOcupacao", required=false) @Nullable Integer idTipoOcupacao, @Parameter(description="Tipo de relevo (TEC)") @RequestParam(value="tipoRelevo", required=false) @Nullable String tipoRelevo, @Parameter(description="Tipo de terrapleno (TEC)") @RequestParam(value="tipoTerrapleno", required=false) @Nullable String tipoTerrapleno, @Parameter(description="Classifica\u00e7\u00e3o do ativo (TEC)") @RequestParam(value="classificacaoAtivo", required=false) @Nullable String classificacaoAtivo, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findElementos(empresa, search, tipoAtivo, idsTipoElementos, idsTipoElementosPai, idRodovias, kmInicial, kmFinal, statusValue, classeSinalizacao, sentido, direcao, uf, sigla, tipoEps, idEspecificacaoEps, classificacao, tipo, tipoAcesso, tipoProprietario, idTipoOcupacao, tipoRelevo, tipoTerrapleno, classificacaoAtivo, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findElementos(...)");
        return page;
    }

    @GetMapping(value={"/monitoracoes/{siglaEmpresa}/desempenho/{tipoAtivo}"})
    @Operation(summary="Recupera as m\u00e9tricas de desempenho das monitora\u00e7\u00f5es ")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200")})
    @NotNull
    public List<StructuredMonitoracaoDesempenhoDTO> getMonitoracoesDesempenho(@PathVariable(value="siglaEmpresa") @NotNull String siglaEmpresa, @PathVariable(value="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)siglaEmpresa, (String)"siglaEmpresa");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        List list = this.sigacoService.getMonitoracoesDesempenho(siglaEmpresa, tipoAtivo);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMonitoracoesDesempenho(...)");
        return list;
    }

    @PostMapping(value={"/monitoracoes/{empresa}/import"}, consumes={"multipart/form-data"})
    @Operation(summary="Importar monitora\u00e7\u00f5es", description="Importa uma lista de monitora\u00e7\u00f5es a partir de um arquivo XLSX")
    @ApiResponses(value={@ApiResponse(description="Importa\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @NotNull
    public String importMonitoracoes(@PathVariable(value="empresa") @NotNull String empresaSigla, @RequestPart(value="body") @Valid @NotNull ImportMonitoracoesDTO dto, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        MonitoracaoImporter importer = this.monitoracaoImporterRegistry.getImporter(dto.tipoAtivo());
        String string = importer.importMonitoracoes(file, dto, empresaSigla, usuario2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"importMonitoracoes(...)");
        return string;
    }

    @PostMapping(value={"/cadastros/{empresa}/import"}, consumes={"multipart/form-data"})
    @Operation(summary="Importar elementos", description="Importa uma lista de elementos a partir de um arquivo XLSX")
    @ApiResponses(value={@ApiResponse(description="Importa\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @NotNull
    public String importElementos(@PathVariable(value="empresa") @NotNull String empresaSigla, @RequestPart(value="body") @Valid @NotNull ImportElementosDTO dto, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        ElementoImporter importer = this.elementoImporterRegistry.getImporter(dto.tipoAtivo());
        String string = importer.importElementos(file, dto, empresaSigla, usuario2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"importElementos(...)");
        return string;
    }

    @GetMapping(value={"/cadastros/monitoradores"})
    @Operation(summary="Buscar monitoradores", description="Retorna uma lista paginada de monitoradores filtrada por busca")
    @ApiResponses(value={@ApiResponse(description="Lista de monitoradores encontrada com sucesso", responseCode="200")})
    @NotNull
    public Page<Monitorador> findMonitoradores(@Parameter(description="Termo de busca (nome)") @RequestParam(name="search", required=false) @Nullable String search, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Page page = this.sigacoService.findMonitoradores(search, usuario2, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findMonitoradores(...)");
        return page;
    }

    @GetMapping(value={"/cadastros/monitoradores/{id}"})
    @Operation(summary="Buscar monitorador por ID", description="Retorna um monitorador espec\u00edfico pelo seu identificador")
    @ApiResponses(value={@ApiResponse(description="Monitorador encontrado com sucesso", responseCode="200"), @ApiResponse(description="Monitorador n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public Monitorador getMonitoradorById(@Parameter(description="ID do monitorador") @PathVariable(value="id") int id, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getPrivateUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Monitorador monitorador = this.sigacoService.getMonitoradorById(id);
        Intrinsics.checkNotNullExpressionValue((Object)monitorador, (String)"getMonitoradorById(...)");
        return monitorador;
    }

    @PostMapping(value={"/cadastros/monitoradores"})
    @Operation(summary="Criar monitorador", description="Cria um novo monitorador")
    @ApiResponses(value={@ApiResponse(description="Monitorador criado com sucesso", responseCode="201")})
    @NotNull
    public Monitorador createMonitorador(@RequestBody(description="Dados do monitorador a ser criado") @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull SaveMonitoradorDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Monitorador monitorador = this.sigacoService.createMonitorador(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)monitorador, (String)"createMonitorador(...)");
        return monitorador;
    }

    @PutMapping(value={"/cadastros/monitoradores/{id}"})
    @Operation(summary="Atualizar monitorador", description="Atualiza um monitorador existente")
    @ApiResponses(value={@ApiResponse(description="Monitorador atualizado com sucesso", responseCode="200"), @ApiResponse(description="Monitorador n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public Monitorador updateMonitorador(@Parameter(description="ID do monitorador") @PathVariable int id, @RequestBody(description="Dados do monitorador a ser atualizado") @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull SaveMonitoradorDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        Integer n = usuario2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Monitorador monitorador = this.sigacoService.updateMonitorador(id, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)monitorador, (String)"updateMonitorador(...)");
        return monitorador;
    }

    @DeleteMapping(value={"/cadastros/monitoradores/{id}"})
    @Operation(summary="Deletar monitorador", description="Remove um monitorador do sistema")
    @ApiResponses(value={@ApiResponse(description="Monitorador deletado com sucesso", responseCode="204"), @ApiResponse(description="Monitorador n\u00e3o encontrado", responseCode="404")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteMonitorador(@Parameter(description="ID do monitorador") @PathVariable int id, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getPrivateUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        this.sigacoService.deleteMonitorador(id);
    }

    @GetMapping(value={"/cadastros/{empresa}/{tipoAtivo}/{idAtivo}"})
    @Operation(summary="Busca o elemento por seu identificador e empresa.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=Elemento.class))})})
    @NotNull
    public ResponseEntity<Elemento> getElementoById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do ativo") @PathVariable(name="idAtivo") int idAtivo, @Parameter(description="Tipo do Ativo") @PathVariable(name="tipoAtivo") @NotNull String tipoAtivo, @Parameter(hidden=true) @Nullable HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            if (StringsKt.isBlank((CharSequence)tipoAtivo)) {
                String[] stringArray = new String[]{"%sigla%", tipoAtivo};
                throw new ErrorCodeException(ErrorCode.ATIVO_DOES_NOT_EXISTS, stringArray);
            }
            TipoAtivo tipoAtivo2 = TipoAtivo.fromString((String)tipoAtivo);
            if (tipoAtivo2 == null) {
                String[] stringArray = new String[]{"%sigla%", tipoAtivo};
                throw new ErrorCodeException(ErrorCode.ATIVO_DOES_NOT_EXISTS, stringArray);
            }
            TipoAtivo tipoAtivoEnum = tipoAtivo2;
            this.logger.debug("getAtivoById({})", (Object)idAtivo);
            return new ResponseEntity((Object)this.sigacoService.getElementoById(empresa, Integer.valueOf(idAtivo), tipoAtivoEnum), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getAtivoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/cadastros/{empresa}/{tipoAtivo}"})
    @Operation(summary="Salva o Elemento de ativo.", requestBody=@RequestBody(description="DTO base para elementos de ativo. O campo 'tipoAtivo' no corpo da requisi\u00e7\u00e3o determina qual subtipo \u00e9 esperado e DEVE ser o mesmo que o {tipoAtivo} passado na URL.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ElementoDTO.class))}, required=true))
    @ApiResponses(value={@ApiResponse(description="Criado", responseCode="201", content={@Content(schema=@Schema(implementation=Elemento.class))})})
    @NotNull
    public ResponseEntity<?> saveElemento(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Tipo do Ativo") @PathVariable(name="tipoAtivo") @NotNull String tipoAtivo, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull ElementoDTO elementoDto, @Parameter(description="Observa\u00e7\u00e3o do elemento", required=false) @RequestParam(name="observacao", required=false) @Nullable String observacao, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)elementoDto, (String)"elementoDto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        if (StringsKt.isBlank((CharSequence)tipoAtivo)) {
            String[] stringArray = new String[]{"%sigla%", tipoAtivo};
            throw new ErrorCodeException(ErrorCode.ATIVO_DOES_NOT_EXISTS, stringArray);
        }
        TipoAtivo tipoAtivo2 = TipoAtivo.fromString((String)tipoAtivo);
        if (tipoAtivo2 == null) {
            String[] stringArray = new String[]{"%sigla%", tipoAtivo};
            throw new ErrorCodeException(ErrorCode.ATIVO_DOES_NOT_EXISTS, stringArray);
        }
        TipoAtivo tipoAtivoEnum = tipoAtivo2;
        if (!Intrinsics.areEqual((Object)tipoAtivoEnum.getSigla(), (Object)elementoDto.getTipoAtivo())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "O tipo de ativo na URL n\u00e3o corresponde ao do corpo da requisi\u00e7\u00e3o.");
        }
        try {
            Elemento elementoRequest = this.elementoDTOMapper.toEntity(elementoDto);
            CharSequence charSequence = observacao;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                elementoRequest.setObservacao(observacao);
            }
            Set violations = this.validator.validate((Object)elementoRequest, new Class[0]);
            Intrinsics.checkNotNull((Object)violations);
            if (!((Collection)violations).isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
            Elemento elementoDB = this.sigacoService.saveElemento(empresa, elementoRequest, usuario.getId(), elementoRequest.getObservacao(), elementoRequest.getKmReferencial());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)elementoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveElemento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/cadastros/{empresa}/{tipoAtivo}/{idElemento}"})
    @Operation(summary="Edita o Elemento.", requestBody=@RequestBody(description="DTO base para elementos de ativo. O campo 'tipoAtivo' no corpo da requisi\u00e7\u00e3o determina qual subtipo \u00e9 esperado e DEVE ser o mesmo que o {tipoAtivo} passado na URL.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ElementoDTO.class))}, required=true))
    @ApiResponses(value={@ApiResponse(description="Ok", responseCode="200", content={@Content(schema=@Schema(implementation=Elemento.class))})})
    @NotNull
    public ResponseEntity<?> editElemento(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do Elemento") @PathVariable(name="idElemento") int idElemento, @Parameter(description="Tipo de Ativo") @PathVariable(name="tipoAtivo") @NotNull String tipoAtivo, @org.springframework.web.bind.annotation.RequestBody @Valid @NotNull ElementoDTO elementoDto, @Parameter(description="Observa\u00e7\u00e3o do elemento", required=false) @RequestParam(name="observacao", required=false) @Nullable String observacao, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)elementoDto, (String)"elementoDto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        if (StringsKt.isBlank((CharSequence)tipoAtivo)) {
            String[] stringArray = new String[]{"%sigla%", tipoAtivo};
            throw new ErrorCodeException(ErrorCode.ATIVO_DOES_NOT_EXISTS, stringArray);
        }
        TipoAtivo tipoAtivo2 = TipoAtivo.fromString((String)tipoAtivo);
        if (tipoAtivo2 == null) {
            String[] stringArray = new String[]{"%sigla%", tipoAtivo};
            throw new ErrorCodeException(ErrorCode.ATIVO_DOES_NOT_EXISTS, stringArray);
        }
        TipoAtivo tipoAtivoEnum = tipoAtivo2;
        if (!Intrinsics.areEqual((Object)tipoAtivoEnum.getSigla(), (Object)elementoDto.getTipoAtivo())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "O tipo de ativo na URL n\u00e3o corresponde ao do corpo da requisi\u00e7\u00e3o.");
        }
        try {
            Elemento elementoRequest = this.elementoDTOMapper.toEntity(elementoDto);
            CharSequence charSequence = observacao;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                elementoRequest.setObservacao(observacao);
            }
            Set violations = this.validator.validate((Object)elementoRequest, new Class[0]);
            Intrinsics.checkNotNull((Object)violations);
            if (!((Collection)violations).isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
            Elemento elementoDB = this.sigacoService.editElemento(empresa, elementoRequest, Integer.valueOf(idElemento), usuario.getId(), tipoAtivoEnum, elementoRequest.getObservacao(), elementoRequest.getKmReferencial());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.OK)).body((Object)elementoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.editElemento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/cadastros/{empresa}/{tipoAtivo}/{idElemento}"})
    @Operation(summary="Deleta o Elemento.")
    @ApiResponses(value={@ApiResponse(description="Ok", responseCode="200")})
    public boolean deleteElemento(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Identificador do Elemento") @PathVariable(name="idElemento") int idElemento, @Parameter(description="Tipo de Ativo") @PathVariable(name="tipoAtivo") @NotNull String tipoAtivo, @Parameter(hidden=true) @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        if (StringsKt.isBlank((CharSequence)tipoAtivo)) {
            String[] stringArray = new String[]{"%sigla%", tipoAtivo};
            throw new ErrorCodeException(ErrorCode.ATIVO_DOES_NOT_EXISTS, stringArray);
        }
        TipoAtivo tipoAtivo2 = TipoAtivo.fromString((String)tipoAtivo);
        if (tipoAtivo2 == null) {
            String[] stringArray = new String[]{"%sigla%", tipoAtivo};
            throw new ErrorCodeException(ErrorCode.ATIVO_DOES_NOT_EXISTS, stringArray);
        }
        TipoAtivo tipoAtivoEnum = tipoAtivo2;
        try {
            Boolean bl = this.sigacoService.deleteElemento(empresa, Integer.valueOf(idElemento), tipoAtivoEnum);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"deleteElemento(...)");
            return bl;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveElemento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/monitoracoes/{empresa}/{tipoAtivo}/{idMonitoracao}"})
    @Operation(summary="Busca a monitora\u00e7\u00e3o por seu identificador, empresa e tipo de ativo.")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200"), @ApiResponse(description="Monitora\u00e7\u00e3o n\u00e3o encontrada", responseCode="404")})
    @NotNull
    public Monitoracao getMonitoracaoById(@Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Tipo de Ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(description="Identificador da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") int idMonitoracao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Object[] objectArray = new Object[]{empresa, tipoAtivo, idMonitoracao};
        this.logger.debug("getMonitoracaoById({}, {}, {})", objectArray);
        Monitoracao monitoracao = this.sigacoService.getMonitoracaoById(empresa, idMonitoracao, tipoAtivo);
        Intrinsics.checkNotNullExpressionValue((Object)monitoracao, (String)"getMonitoracaoById(...)");
        return monitoracao;
    }

    @GetMapping(value={"/referenciasAtivos/{tipoAtivo}"})
    @Operation(summary="Busca as refer\u00eancias de um ativo por meio do Tipo de Ativo e nome do campo de refer\u00eancia (opcional).")
    @ApiResponses(value={@ApiResponse(description="Sucesso", responseCode="200", content={@Content(schema=@Schema(implementation=ReferenciaAtivo.class))}), @ApiResponse(description="Refer\u00eancias n\u00e3o encontradas", responseCode="404")})
    @NotNull
    public ResponseEntity<List<ReferenciaAtivo>> getReferenciasAtivo(@Parameter(description="Tipo de Ativo") @PathVariable(name="tipoAtivo") @NotNull String tipoAtivo, @Parameter(description="Nome do campo de refer\u00eancia") @RequestParam(name="campoReferencia", required=false) @Nullable String campoReferencia, @Parameter(hidden=true) @Nullable HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            if (StringsKt.isBlank((CharSequence)tipoAtivo)) {
                String[] stringArray = new String[]{"%sigla%", tipoAtivo};
                throw new ErrorCodeException(ErrorCode.ATIVO_DOES_NOT_EXISTS, stringArray);
            }
            TipoAtivo tipoAtivo2 = TipoAtivo.fromString((String)tipoAtivo);
            if (tipoAtivo2 == null) {
                String[] stringArray = new String[]{"%sigla%", tipoAtivo};
                throw new ErrorCodeException(ErrorCode.ATIVO_DOES_NOT_EXISTS, stringArray);
            }
            TipoAtivo tipoAtivoEnum = tipoAtivo2;
            this.logger.debug("getReferenciasAtivo({}, {})", (Object)campoReferencia, (Object)tipoAtivo);
            List list = this.sigacoService.getReferenciasAtivos(tipoAtivoEnum, campoReferencia);
            if (list == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Refer\u00eancias n\u00e3o encontradas");
            }
            List response = list;
            ResponseEntity responseEntity = ResponseEntity.ok((Object)response);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getReferenciasAtivo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

