/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis.ativos;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.ativos.ImportacaoMonitoracao;
import br.gov.antt.sgctt.ativos.MonitoracaoAnexo;
import br.gov.antt.sgctt.ativos.MonitoracaoHistorico;
import br.gov.antt.sgctt.ativos.MonitoracaoImagem;
import br.gov.antt.sgctt.ativos.MonitoracaoPavimento;
import br.gov.antt.sgctt.ativos.enums.TipoAtivo;
import br.gov.antt.sgctt.ativos.monitoracoes.Monitoracao;
import br.gov.antt.sgctt.ativos.monitoracoes.MonitoracaoDrenagem;
import br.gov.antt.sgctt.ativos.monitoracoes.MonitoracaoEdificacao;
import br.gov.antt.sgctt.ativos.monitoracoes.MonitoracaoFaixaDominioAcesso;
import br.gov.antt.sgctt.ativos.monitoracoes.MonitoracaoOae;
import br.gov.antt.sgctt.ativos.monitoracoes.MonitoracaoSinalizacaoEps;
import br.gov.antt.sgctt.ativos.monitoracoes.MonitoracaoTerrapleno;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.beans.seguranca.Usuario;
import br.gov.antt.sgctt.exceptions.BusinessException;
import br.gov.antt.sgctt.services.CadastroService;
import br.gov.antt.sgctt.services.CoreService;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.SegurancaService;
import br.gov.antt.sgctt.services.ativos.SigacoService;
import br.gov.antt.sgctt.utils.UploadedFileInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="Ativos", description="Opera\u00e7\u00f5es relacionadas a monitora\u00e7\u00e3o de ativos")
@RequestMapping(value={"/api/monitoracoes/sigaco"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010 H\u0017J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010!H\u0017J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\"H\u0017J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010#H\u0017J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010$H\u0017J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010%H\u0017J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010&H\u0017J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u001aH\u0017J=\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\b\u0001\u0010*\u001a\u00020+2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u0010.J3\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u00102J?\u00103\u001a\b\u0012\u0004\u0012\u0002010\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u00104\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u00105J=\u00106\u001a\b\u0012\u0004\u0012\u0002010\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\b\b\u0001\u00107\u001a\u000208H\u0017\u00a2\u0006\u0002\u00109J?\u0010:\u001a\b\u0012\u0004\u0012\u00020)0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010;\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u00105J3\u0010<\u001a\b\u0012\u0004\u0012\u00020=002\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u00102J?\u0010>\u001a\b\u0012\u0004\u0012\u00020=0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u00104\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u00105J=\u0010?\u001a\b\u0012\u0004\u0012\u00020=0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\b\b\u0001\u00107\u001a\u000208H\u0017\u00a2\u0006\u0002\u00109J?\u0010@\u001a\b\u0012\u0004\u0012\u00020)0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010;\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u00105JK\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001a002\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010*\u001a\u0004\u0018\u00010+2\n\b\u0001\u0010B\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010C\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u0010DJ9\u0010E\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020F000\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010,\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u0010GJ\u001f\u0010H\u001a\n\u0012\u0004\u0012\u00020J\u0018\u00010I2\b\u0010K\u001a\u0004\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010LJ]\u0010M\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020N000\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010O\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010P\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010Q\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010R\u001a\u0004\u0018\u00010\u001eH\u0017\u00a2\u0006\u0002\u0010SJ?\u0010T\u001a\b\u0012\u0004\u0012\u00020N0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010U\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010V\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u00105J?\u0010W\u001a\b\u0012\u0004\u0012\u00020)0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0001\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0001\u0010X\u001a\u0004\u0018\u00010-2\n\b\u0001\u0010Y\u001a\u0004\u0018\u00010-H\u0017\u00a2\u0006\u0002\u00105R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006Z"}, d2={"Lbr/gov/antt/sgctt/apis/ativos/AtivosRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "coreService", "Lbr/gov/antt/sgctt/services/CoreService;", "cadastroService", "Lbr/gov/antt/sgctt/services/CadastroService;", "sigacoService", "Lbr/gov/antt/sgctt/services/ativos/SigacoService;", "<init>", "(Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/CoreService;Lbr/gov/antt/sgctt/services/CadastroService;Lbr/gov/antt/sgctt/services/ativos/SigacoService;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "ptBR", "Ljava/util/Locale;", "getPtBR", "()Ljava/util/Locale;", "fmtPtBr", "Ljava/text/NumberFormat;", "getFmtPtBr", "()Ljava/text/NumberFormat;", "saveMonitoracao", "Lorg/springframework/http/ResponseEntity;", "Lbr/gov/antt/sgctt/ativos/monitoracoes/Monitoracao;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "empresa", "", "monitoracao", "Lbr/gov/antt/sgctt/ativos/monitoracoes/MonitoracaoDrenagem;", "Lbr/gov/antt/sgctt/ativos/monitoracoes/MonitoracaoSinalizacaoEps;", "Lbr/gov/antt/sgctt/ativos/MonitoracaoPavimento;", "Lbr/gov/antt/sgctt/ativos/monitoracoes/MonitoracaoTerrapleno;", "Lbr/gov/antt/sgctt/ativos/monitoracoes/MonitoracaoFaixaDominioAcesso;", "Lbr/gov/antt/sgctt/ativos/monitoracoes/MonitoracaoOae;", "Lbr/gov/antt/sgctt/ativos/monitoracoes/MonitoracaoEdificacao;", "updateMonitoracao", "deleteMonitoracao", "", "tipoAtivo", "Lbr/gov/antt/sgctt/ativos/enums/TipoAtivo;", "idMonitoracao", "", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Lbr/gov/antt/sgctt/ativos/enums/TipoAtivo;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "findImagens", "", "Lbr/gov/antt/sgctt/ativos/MonitoracaoImagem;", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;)Ljava/util/List;", "getImagemById", "sequencia", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "saveImagem", "file", "Lorg/springframework/web/multipart/MultipartFile;", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Lorg/springframework/web/multipart/MultipartFile;)Lorg/springframework/http/ResponseEntity;", "deleteImagemMonitoracao", "seqAnexo", "findAnexos", "Lbr/gov/antt/sgctt/ativos/MonitoracaoAnexo;", "getAnexoById", "saveAnexo", "deleteAnexoMonitoracao", "findCiclosAnteriores", "idElemento", "faseMonitoracao", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Lbr/gov/antt/sgctt/ativos/enums/TipoAtivo;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/util/List;", "findHistoricos", "Lbr/gov/antt/sgctt/ativos/MonitoracaoHistorico;", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "stringToKm", "", "", "cellValue", "(Ljava/lang/String;)[Ljava/lang/Double;", "findImportacoes", "Lbr/gov/antt/sgctt/ativos/ImportacaoMonitoracao;", "idFase", "subsistema", "status", "responsavel", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)Lorg/springframework/http/ResponseEntity;", "getImportacaoById", "anoConcessao", "seqImportacao", "deleteImportacoes", "fase", "importacao", "server"})
@SourceDebugExtension(value={"SMAP\nAtivosRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtivosRestServices.kt\nbr/gov/antt/sgctt/apis/ativos/AtivosRestServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,950:1\n739#2,9:951\n739#2,9:964\n739#2,9:977\n37#3:960\n36#3,3:961\n37#3:973\n36#3,3:974\n37#3:986\n36#3,3:987\n*S KotlinDebug\n*F\n+ 1 AtivosRestServices.kt\nbr/gov/antt/sgctt/apis/ativos/AtivosRestServices\n*L\n808#1:951,9\n816#1:964,9\n823#1:977,9\n808#1:960\n808#1:961,3\n816#1:973\n816#1:974,3\n823#1:986\n823#1:987,3\n*E\n"})
public class AtivosRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final SigacoService sigacoService;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Locale ptBR;
    @NotNull
    private final NumberFormat fmtPtBr;

    public AtivosRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService, @NotNull SigacoService sigacoService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        Intrinsics.checkNotNullParameter((Object)sigacoService, (String)"sigacoService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        this.sigacoService = sigacoService;
        Logger logger = LoggerFactory.getLogger(AtivosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        Locale locale = new Locale.Builder().setLanguage("pt").setRegion("BR").build();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"build(...)");
        this.ptBR = locale;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance(this.getPtBR());
        Intrinsics.checkNotNullExpressionValue((Object)numberFormat, (String)"getNumberInstance(...)");
        this.fmtPtBr = numberFormat;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public Locale getPtBR() {
        return this.ptBR;
    }

    @NotNull
    public NumberFormat getFmtPtBr() {
        return this.fmtPtBr;
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de drenagem", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo drenagem")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/drenagens"})
    @NotNull
    public ResponseEntity<Monitoracao> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de drenagem") @RequestBody @Nullable MonitoracaoDrenagem monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            Monitoracao monitoracaoDB = sigacoService.saveMonitoracao(empresa, (Monitoracao)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[DRE]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de sinaliza\u00e7\u00e3o", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo sinaliza\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/sinalizacoesEps"})
    @NotNull
    public ResponseEntity<Monitoracao> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de sinaliza\u00e7\u00e3o") @RequestBody @Nullable MonitoracaoSinalizacaoEps monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            Monitoracao monitoracaoDB = sigacoService.saveMonitoracao(empresa, (Monitoracao)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[SNH]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de pavimentos", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo pavimentos")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/pavimentos"})
    @NotNull
    public ResponseEntity<Monitoracao> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de pavimentos") @RequestBody @Nullable MonitoracaoPavimento monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            Monitoracao monitoracaoDB = sigacoService.saveMonitoracao(empresa, (Monitoracao)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[SNV]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de terraplenos", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo terraplenos")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/terraplenos"})
    @NotNull
    public ResponseEntity<Monitoracao> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de terraplenos") @RequestBody @Nullable MonitoracaoTerrapleno monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            Monitoracao monitoracaoDB = sigacoService.saveMonitoracao(empresa, (Monitoracao)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[SNV]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de faixa de dom\u00ednio", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo faixa de dom\u00ednio")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/faixasDominio"})
    @NotNull
    public ResponseEntity<Monitoracao> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de faixa de dom\u00ednio") @RequestBody @Nullable MonitoracaoFaixaDominioAcesso monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            Monitoracao monitoracaoDB = sigacoService.saveMonitoracao(empresa, (Monitoracao)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[Faixa de dom\u00ednio]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de obra de arte especial", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo obra de arte especial")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/obrasArteEspeciais"})
    @NotNull
    public ResponseEntity<Monitoracao> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de obra de arte especial") @RequestBody @Nullable MonitoracaoOae monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            Monitoracao monitoracaoDB = sigacoService.saveMonitoracao(empresa, (Monitoracao)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[Obra de Arte Especial]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar monitora\u00e7\u00e3o de edifica\u00e7\u00f5es", description="Cria ou atualiza uma monitora\u00e7\u00e3o do tipo edifica\u00e7\u00f5es")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o criada com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/edificacoes"})
    @NotNull
    public ResponseEntity<Monitoracao> saveMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o de edifica\u00e7\u00f5es") @RequestBody @Nullable MonitoracaoEdificacao monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            Monitoracao monitoracaoDB = sigacoService.saveMonitoracao(empresa, (Monitoracao)monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveMonitoracao[Edifica\u00e7\u00f5es]", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Atualizar monitora\u00e7\u00e3o", description="Atualiza uma monitora\u00e7\u00e3o existente")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o atualizada com sucesso", responseCode="201")})
    @PutMapping(value={"/{empresa}"})
    @NotNull
    public ResponseEntity<Monitoracao> updateMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Dados da monitora\u00e7\u00e3o a ser atualizada") @RequestBody @Nullable Monitoracao monitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            SigacoService sigacoService = this.sigacoService;
            Intrinsics.checkNotNull((Object)sigacoService);
            Monitoracao monitoracaoDB = sigacoService.saveMonitoracao(empresa, monitoracao, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)monitoracaoDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.updateMonitoracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Excluir monitora\u00e7\u00e3o", description="Remove uma monitora\u00e7\u00e3o espec\u00edfica")
    @ApiResponses(value={@ApiResponse(description="Monitora\u00e7\u00e3o exclu\u00edda com sucesso", responseCode="200"), @ApiResponse(description="Monitora\u00e7\u00e3o n\u00e3o encontrada", responseCode="404")})
    @DeleteMapping(value={"/{empresa}/{tipoAtivo}/{idMonitoracao}"})
    @NotNull
    public ResponseEntity<Boolean> deleteMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @NotNull TipoAtivo tipoAtivo, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)tipoAtivo, (String)"tipoAtivo");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            return new ResponseEntity((Object)this.sigacoService.deleteMonitoracao(empresa, idMonitoracao, tipoAtivo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.deleteMonitoracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Buscar imagens da monitora\u00e7\u00e3o", description="Retorna lista de imagens associadas a uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200"), @ApiResponse(description="Monitora\u00e7\u00e3o n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{empresa}/{idMonitoracao}/imagens"})
    @NotNull
    public List<MonitoracaoImagem> findImagens(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        List list = this.sigacoService.findImagensMonitoracao(empresa, idMonitoracao, null, null, null, null, null, usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    @Operation(summary="Buscar imagem por ID", description="Retorna a imagem da monitora\u00e7\u00e3o a partir do seu identificador")
    @ApiResponses(value={@ApiResponse(description="Imagem encontrada", responseCode="200"), @ApiResponse(description="Imagem n\u00e3o encontrada", responseCode="404")})
    @GetMapping(value={"/{empresa}/{idMonitoracao}/imagens/{sequencia}"})
    @NotNull
    public ResponseEntity<MonitoracaoImagem> getImagemById(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Sequ\u00eancia da imagem") @PathVariable(name="sequencia") @Nullable Integer sequencia) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.getLogger().debug("getImagemById({}, {})", (Object)empresa, (Object)idMonitoracao);
            return new ResponseEntity((Object)this.sigacoService.getImagemMonitoracaoById(empresa, idMonitoracao, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.getImagemById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar imagem da monitora\u00e7\u00e3o", description="Realiza o upload de uma imagem para uma monitora\u00e7\u00e3o, recebendo multipart/form-data com os par\u00e2metros de arquivo")
    @ApiResponses(value={@ApiResponse(description="Imagem salva com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/{idMonitoracao}/imagens"}, consumes={"multipart/form-data"})
    @ResponseBody
    @NotNull
    public ResponseEntity<MonitoracaoImagem> saveImagem(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Arquivo de imagem enviado") @RequestParam(name="file", required=false) @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.getLogger().debug("Executando saveImagem(emp={},idMonitoracao={})...", (Object)empresa, (Object)idMonitoracao);
        try {
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            String tipoMovto = null;
            String tipoImagem = null;
            if (formData.containsKey("tipoAtivo")) {
                Object v = formData.get("tipoAtivo");
                Intrinsics.checkNotNull(v);
                tipoAtivo = ((String[])v)[0];
            }
            if (formData.containsKey("tipoMovimento")) {
                Object v = formData.get("tipoMovimento");
                Intrinsics.checkNotNull(v);
                tipoMovto = ((String[])v)[0];
            }
            if (formData.containsKey("tipoImagem")) {
                Object v = formData.get("tipoImagem");
                Intrinsics.checkNotNull(v);
                tipoImagem = ((String[])v)[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            MonitoracaoImagem imagemDB = this.sigacoService.saveImagemMonitoracao(empresa, idMonitoracao, tipoAtivo, tipoImagem, tipoMovto, fileInfo, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)imagemDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveImagem", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            this.getLogger().error("BizExc.saveImagem", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @Operation(summary="Excluir imagem da monitora\u00e7\u00e3o", description="Exclui a imagem da monitora\u00e7\u00e3o a partir de seu identificador")
    @ApiResponses(value={@ApiResponse(description="Imagem exclu\u00edda com sucesso", responseCode="200"), @ApiResponse(description="Imagem n\u00e3o encontrada", responseCode="404")})
    @DeleteMapping(value={"/{empresa}/{idMonitoracao}/imagens/{seqAnexo}"})
    @NotNull
    public ResponseEntity<Boolean> deleteImagemMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Sequ\u00eancia do anexo") @PathVariable(name="seqAnexo") @Nullable Integer seqAnexo) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{empresa, idMonitoracao, seqAnexo};
        this.getLogger().debug("deleteImagemMonitoracao({},{},{})", objectArray);
        try {
            return new ResponseEntity((Object)this.sigacoService.deleteImagemMonitoracao(empresa, idMonitoracao, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.deleteImagemMonitoracao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Buscar anexos da monitora\u00e7\u00e3o", description="Retorna lista de anexos associados a uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/{idMonitoracao}/anexos"})
    @NotNull
    public List<MonitoracaoAnexo> findAnexos(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        List list = this.sigacoService.findAnexosMonitoracao(empresa, idMonitoracao, usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    @Operation(summary="Buscar anexo por ID", description="Retorna o anexo da monitora\u00e7\u00e3o a partir do seu identificador")
    @ApiResponses(value={@ApiResponse(description="Anexo encontrado", responseCode="200"), @ApiResponse(description="Anexo n\u00e3o encontrado", responseCode="404")})
    @GetMapping(value={"/{empresa}/{idMonitoracao}/anexos/{sequencia}"})
    @NotNull
    public ResponseEntity<MonitoracaoAnexo> getAnexoById(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Sequ\u00eancia do anexo") @PathVariable(name="sequencia") @Nullable Integer sequencia) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.getLogger().debug("getAnexoById({}, {})", (Object)empresa, (Object)idMonitoracao);
            return new ResponseEntity((Object)this.sigacoService.getAnexoMonitoracaoById(empresa, idMonitoracao, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.getAnexoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Salvar anexo da monitora\u00e7\u00e3o", description="Realiza o upload de um anexo para uma monitora\u00e7\u00e3o, recebendo multipart/form-data com os par\u00e2metros de arquivo")
    @ApiResponses(value={@ApiResponse(description="Anexo salvo com sucesso", responseCode="201")})
    @PostMapping(value={"/{empresa}/{idMonitoracao}/anexos"}, consumes={"multipart/form-data"})
    @ResponseBody
    @NotNull
    public ResponseEntity<MonitoracaoAnexo> saveAnexo(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Arquivo a ser enviado") @RequestParam(name="file", required=false) @NotNull MultipartFile file) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.getLogger().debug("Executando saveAnexo(emp={},idMonitoracao={})...", (Object)empresa, (Object)idMonitoracao);
        try {
            Map formData = request.getParameterMap();
            String tipoAtivo = null;
            String tipoAnexo = null;
            if (formData.containsKey("tipoAtivo")) {
                Object v = formData.get("tipoAtivo");
                Intrinsics.checkNotNull(v);
                tipoAtivo = ((String[])v)[0];
            }
            if (formData.containsKey("tipoAnexo")) {
                Object v = formData.get("tipoAnexo");
                Intrinsics.checkNotNull(v);
                tipoAnexo = ((String[])v)[0];
            }
            UploadedFileInfo fileInfo = new UploadedFileInfo(file.getOriginalFilename(), file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            MonitoracaoAnexo imagemDB = this.sigacoService.saveAnexoMonitoracao(empresa, idMonitoracao, tipoAtivo, tipoAnexo, fileInfo, usuario.getLogin());
            ResponseEntity responseEntity = ResponseEntity.status((HttpStatusCode)((HttpStatusCode)HttpStatus.CREATED)).body((Object)imagemDB);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.saveAnexo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (IOException ioExc) {
            this.getLogger().error("BizExc.saveAnexo", (Throwable)ioExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, ioExc.getMessage());
        }
    }

    @Operation(summary="Excluir anexo da monitora\u00e7\u00e3o", description="Exclui o anexo da monitora\u00e7\u00e3o a partir de seu identificador")
    @ApiResponses(value={@ApiResponse(description="Anexo exclu\u00eddo com sucesso", responseCode="200")})
    @DeleteMapping(value={"/{empresa}/{idMonitoracao}/anexos/{seqAnexo}"})
    @NotNull
    public ResponseEntity<Boolean> deleteAnexoMonitoracao(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao, @Parameter(description="Sequ\u00eancia do anexo") @PathVariable(name="seqAnexo") @Nullable Integer seqAnexo) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{empresa, idMonitoracao, seqAnexo};
        this.getLogger().debug("deleteAnexoMonitoracao({},{},{})", objectArray);
        try {
            return new ResponseEntity((Object)this.sigacoService.deleteAnexoMonitoracao(empresa, idMonitoracao, seqAnexo), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.deleteAnexoInspecao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Buscar hist\u00f3rico de monitora\u00e7\u00f5es", description="Retorna os hist\u00f3ricos (ciclos anteriores) de uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3rico encontrado com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/{tipoAtivo}/ciclos/{idElemento}"})
    @NotNull
    public List<Monitoracao> findCiclosAnteriores(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="C\u00f3digo do tipo de ativo") @PathVariable(name="tipoAtivo") @Nullable TipoAtivo tipoAtivo, @Parameter(description="ID do elemento") @PathVariable(name="idElemento") @Nullable Integer idElemento, @Parameter(description="Fase da monitora\u00e7\u00e3o") @RequestParam(name="fase") @Nullable Integer faseMonitoracao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        Usuario usuario2 = usuario;
        List list = this.sigacoService.findCiclosAnteriores(empresa, tipoAtivo, idElemento, faseMonitoracao, usuario2, Pageable.unpaged()).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    @Operation(summary="Buscar hist\u00f3ricos da monitora\u00e7\u00e3o", description="Retorna os hist\u00f3ricos de altera\u00e7\u00f5es ou eventos de uma monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3ricos encontrados com sucesso", responseCode="200")})
    @GetMapping(value={"/{empresa}/{idMonitoracao}/historicos"})
    @NotNull
    public ResponseEntity<List<MonitoracaoHistorico>> findHistoricos(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da monitora\u00e7\u00e3o") @PathVariable(name="idMonitoracao") @Nullable Integer idMonitoracao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.sigacoService.findHistoricos(empresa, idMonitoracao, usuario2, Pageable.unpaged()).getContent());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Nullable
    public Double[] stringToKm(@Nullable String cellValue) {
        String cellValue2 = cellValue;
        if (cellValue2 == null || ((CharSequence)cellValue2).length() == 0) {
            return null;
        }
        try {
            String[] kmMetros;
            String[] kmMetros2;
            Double[] $this$toTypedArray$iv;
            Collection $this$dropLastWhile$iv;
            String string;
            Object object;
            Double[] doubleArray;
            if (StringsKt.indexOf$default((CharSequence)cellValue2, (String)" ", (int)0, (boolean)false, (int)6, null) != -1) {
                doubleArray = (Double[])cellValue2;
                object = new Regex(" ");
                string = "+";
                cellValue2 = object.replace((CharSequence)doubleArray, string);
            }
            if (StringsKt.indexOf$default((CharSequence)cellValue2, (String)".", (int)0, (boolean)false, (int)6, null) != -1) {
                List list;
                object = cellValue2;
                string = new Regex("\\.");
                int n = 0;
                object = string.split((CharSequence)object, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                CharSequence thisCollection$iv = $this$toTypedArray$iv;
                kmMetros2 = thisCollection$iv.toArray(new String[0]);
                if (kmMetros2 != null && kmMetros2.length > 0) {
                    $this$toTypedArray$iv = new Double[]{Double.parseDouble(kmMetros2[0]), Double.parseDouble(kmMetros2[1])};
                    return $this$toTypedArray$iv;
                }
                return null;
            }
            if (StringsKt.indexOf$default((CharSequence)cellValue2, (String)",", (int)0, (boolean)false, (int)6, null) != -1) {
                Double[] $this$toTypedArray$iv2;
                List list;
                Collection $this$dropLastWhile$iv2;
                double kilometro = this.getFmtPtBr().parse(cellValue2).doubleValue();
                Object thisCollection$iv = String.valueOf(kilometro);
                Regex it = new Regex("\\.");
                int bl = 0;
                thisCollection$iv = it.split((CharSequence)thisCollection$iv, bl);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv2.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                    while (iterator$iv.hasPrevious()) {
                        String it2 = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        if (((CharSequence)it2).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv2, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv2 = list;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv2 = $this$toTypedArray$iv2;
                kmMetros = thisCollection$iv2.toArray(new String[0]);
                if (kmMetros != null && kmMetros.length > 0) {
                    $this$toTypedArray$iv2 = new Double[]{Double.parseDouble(kmMetros[0]), Double.parseDouble(kmMetros[1])};
                    return $this$toTypedArray$iv2;
                }
                return null;
            }
            if (StringsKt.indexOf$default((CharSequence)cellValue2, (String)"+", (int)0, (boolean)false, (int)6, null) != -1) {
                List list;
                $this$toTypedArray$iv = cellValue2;
                kmMetros = new Regex("\\+");
                int $this$toTypedArray$iv2 = 0;
                $this$toTypedArray$iv = kmMetros.split((CharSequence)$this$toTypedArray$iv, $this$toTypedArray$iv2);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list;
                boolean $i$f$toTypedArray = false;
                Double[] thisCollection$iv = $this$toTypedArray$iv;
                kmMetros2 = thisCollection$iv.toArray(new String[0]);
                if (kmMetros2 != null && kmMetros2.length > 0) {
                    $this$toTypedArray$iv = new Double[]{Double.parseDouble(kmMetros2[0]), Double.parseDouble(kmMetros2[1]) / (double)1000};
                    return $this$toTypedArray$iv;
                }
                return null;
            }
            doubleArray = new Double[]{Double.parseDouble(cellValue2), 0.0};
            return doubleArray;
        }
        catch (NumberFormatException nmfExc) {
            return null;
        }
        catch (ParseException psExc) {
            return null;
        }
    }

    @Operation(summary="Buscar importa\u00e7\u00f5es de monitora\u00e7\u00f5es", description="Retorna a lista de importa\u00e7\u00f5es de monitora\u00e7\u00f5es baseado em filtros opcionais")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @GetMapping(value={"/importacoes/{empresa}"})
    @NotNull
    public ResponseEntity<List<ImportacaoMonitoracao>> findImportacoes(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="ID da fase", required=false) @RequestParam(name="idFase", required=false) @Nullable Integer idFase, @Parameter(description="Subsistema", required=false) @RequestParam(name="subsistema", required=false) @Nullable String subsistema, @Parameter(description="Status", required=false) @RequestParam(name="status", required=false) @Nullable Integer status, @Parameter(description="Respons\u00e1vel", required=false) @RequestParam(name="responsavel", required=false) @Nullable String responsavel) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        if (usuario == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        Usuario usuario2 = usuario;
        ResponseEntity responseEntity = ResponseEntity.ok((Object)this.sigacoService.findImportacoes(empresa, idFase, subsistema, status, responsavel, usuario2, Pageable.unpaged()).getContent());
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"ok(...)");
        return responseEntity;
    }

    @Operation(summary="Buscar importa\u00e7\u00e3o por ID", description="Retorna a importa\u00e7\u00e3o de monitora\u00e7\u00e3o a partir de seu identificador")
    @ApiResponses(value={@ApiResponse(description="Importa\u00e7\u00e3o encontrada", responseCode="200")})
    @GetMapping(value={"/importacoes/{empresa}/{anoConcessao}/{seqImportacao}"})
    @NotNull
    public ResponseEntity<ImportacaoMonitoracao> getImportacaoById(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Ano concess\u00e3o") @PathVariable(name="anoConcessao") @Nullable Integer anoConcessao, @Parameter(description="Sequ\u00eancia da importa\u00e7\u00e3o") @PathVariable(name="seqImportacao") @Nullable Integer seqImportacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{empresa, anoConcessao, seqImportacao};
            this.getLogger().debug("getImportacaoById({}, {}, {})", objectArray);
            ResponseEntity responseEntity = ResponseEntity.ok().body((Object)this.sigacoService.getImportacaoById(empresa, anoConcessao, seqImportacao));
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.getImportacaoById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @Operation(summary="Excluir importa\u00e7\u00f5es", description="Exclui uma importa\u00e7\u00e3o de monitora\u00e7\u00e3o")
    @ApiResponses(value={@ApiResponse(description="Importa\u00e7\u00e3o exclu\u00edda com sucesso", responseCode="200")})
    @DeleteMapping(value={"/importacoes/{empresa}/{fase}/{importacao}/excluir"})
    @NotNull
    public ResponseEntity<Boolean> deleteImportacoes(@NotNull HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @Nullable String empresa, @Parameter(description="Fase da importa\u00e7\u00e3o") @PathVariable(name="fase") @Nullable Integer fase, @Parameter(description="ID da importa\u00e7\u00e3o") @PathVariable(name="importacao") @Nullable Integer importacao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            Object[] objectArray = new Object[]{empresa, fase, importacao};
            this.getLogger().debug("excluirImportacoes({}, {}, {})", objectArray);
            return new ResponseEntity((Object)this.sigacoService.deleteImportacoes(empresa, fase, importacao, usuario.getLogin()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.getLogger().error("BizExc.excluirImportacoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

