/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.core.beans.geral.Empresa;
import br.gov.antt.sgctt.core.beans.geral.Rodovia;
import br.gov.antt.sgctt.core.beans.geral.TipoModulo;
import br.gov.antt.sgctt.core.beans.seguranca.GrupoAcessoUsuario;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.beans.seguranca.Usuario;
import br.gov.antt.sgctt.core.beans.seguranca.UsuarioEmpresa;
import br.gov.antt.sgctt.core.beans.seguranca.UsuarioEmpresaAreaVO;
import br.gov.antt.sgctt.core.beans.seguranca.UsuarioGrupo;
import br.gov.antt.sgctt.core.beans.seguranca.UsuarioPerfil;
import br.gov.antt.sgctt.core.beans.seguranca.UsuarioSave;
import br.gov.antt.sgctt.core.beans.seguranca.VOs.UsuarioChangePasswordRequestVO;
import br.gov.antt.sgctt.core.dto.geral.empresa.area.EmpresaAreaResponsavelDTO;
import br.gov.antt.sgctt.core.dto.keycloak.RoleDTO;
import br.gov.antt.sgctt.core.dto.usuario.FindUsuariosEmpresaDTO;
import br.gov.antt.sgctt.core.utils.MD5Utils;
import br.gov.antt.sgctt.exceptions.BusinessException;
import br.gov.antt.sgctt.seguranca.ModuloAcesso;
import br.gov.antt.sgctt.seguranca.PermissaoAcessoGrupo;
import br.gov.antt.sgctt.seguranca.UsuarioAuditoria;
import br.gov.antt.sgctt.services.CadastroService;
import br.gov.antt.sgctt.services.CoreService;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.SegurancaService;
import br.gov.antt.sgctt.services.empresa.EmpresaService;
import br.gov.antt.sgctt.spring.security.keycloak.KeycloakCoreService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="Usu\u00e1rios", description="Servi\u00e7os REST para gerenciamento de usu\u00e1rios do sistema")
@RequestMapping(value={"/api/usuarios"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010 \u001a\u00020!H\u0017J0\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190#2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010 \u001a\u00020!2\u000e\b\u0001\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001fH\u0017J$\u0010%\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0006\u0012\u0004\u0018\u00010(0'0&2\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u001e\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0#0&2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0017J\u001e\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0#0&2\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0017J/\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0#0&2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0001\u0010/\u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u00100J\u001e\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020#0&2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0017J\u001e\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020#0&2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0017JQ\u00104\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010.0#0&2\n\b\u0001\u0010/\u001a\u0004\u0018\u00010!2\n\b\u0001\u00105\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0012\b\u0001\u00106\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010.\u0018\u00010#H\u0017\u00a2\u0006\u0002\u00107J}\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0001\u0010:\u001a\u00020\u001d2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0001\u0010;\u001a\u0004\u0018\u00010<2\n\b\u0001\u0010=\u001a\u0004\u0018\u00010<2\u0010\b\u0001\u0010>\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010#2\n\b\u0001\u0010?\u001a\u0004\u0018\u00010!2\n\b\u0001\u00105\u001a\u0004\u0018\u00010@2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017\u00a2\u0006\u0002\u0010AJ$\u0010B\u001a\b\u0012\u0004\u0012\u0002090&2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0001\u0010C\u001a\u0004\u0018\u000109H\u0017J\u001f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0&2\n\b\u0001\u0010 \u001a\u0004\u0018\u00010!H\u0017\u00a2\u0006\u0002\u0010FJ\u001c\u0010G\u001a\u00020H2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\b\u0001\u0010I\u001a\u00020JH\u0017J \u0010K\u001a\b\u0012\u0004\u0012\u00020E0&2\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010L\u001a\u00020EH\u0017J\u0012\u0010M\u001a\u00020H2\b\b\u0001\u0010 \u001a\u00020!H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lbr/gov/antt/sgctt/apis/UsuariosRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "coreService", "Lbr/gov/antt/sgctt/services/CoreService;", "cadastroService", "Lbr/gov/antt/sgctt/services/CadastroService;", "keycloakCoreService", "Lbr/gov/antt/sgctt/spring/security/keycloak/KeycloakCoreService;", "empresaService", "Lbr/gov/antt/sgctt/services/empresa/EmpresaService;", "<init>", "(Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/CoreService;Lbr/gov/antt/sgctt/services/CadastroService;Lbr/gov/antt/sgctt/spring/security/keycloak/KeycloakCoreService;Lbr/gov/antt/sgctt/services/empresa/EmpresaService;)V", "logger", "Lorg/slf4j/Logger;", "findUsuariosEmpresa", "Lorg/springframework/data/domain/Page;", "Lbr/gov/antt/sgctt/core/beans/seguranca/UsuarioEmpresaAreaVO;", "dto", "Lbr/gov/antt/sgctt/core/dto/usuario/FindUsuariosEmpresaDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findUsuariosKeycloak", "findPermissoes", "Lbr/gov/antt/sgctt/core/dto/keycloak/RoleDTO;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "search", "", "findPermissoesUsuario", "", "idUsuario", "", "setUserRoles", "", "roles", "getUserInfo", "Lorg/springframework/http/ResponseEntity;", "", "", "findGruposAcessoByUsuario", "Lbr/gov/antt/sgctt/core/beans/seguranca/UsuarioGrupo;", "findGruposAcesso", "Lbr/gov/antt/sgctt/core/beans/seguranca/GrupoAcessoUsuario;", "getPermissoes", "Lbr/gov/antt/sgctt/seguranca/PermissaoAcessoGrupo;", "idGrupoUsuario", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "findPermissoesByUsuario", "Lbr/gov/antt/sgctt/seguranca/ModuloAcesso;", "findPermissoesAcesso", "postPermissoesAcesso", "modulo", "permissoes", "(Ljava/lang/Integer;Ljava/lang/String;Ljakarta/servlet/http/HttpServletRequest;Ljava/util/List;)Lorg/springframework/http/ResponseEntity;", "findAuditoria", "Lbr/gov/antt/sgctt/seguranca/UsuarioAuditoria;", "empresa", "dataInicial", "Ljava/time/LocalDate;", "dataFinal", "tipo", "usuario", "Lbr/gov/antt/sgctt/core/beans/geral/TipoModulo;", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/String;Ljava/time/LocalDate;Ljava/time/LocalDate;Ljava/util/List;Ljava/lang/Integer;Lbr/gov/antt/sgctt/core/beans/geral/TipoModulo;Lorg/springframework/data/domain/Pageable;)Lorg/springframework/data/domain/Page;", "postAuditoria", "auditoria", "getUsuarioSavedById", "Lbr/gov/antt/sgctt/core/beans/seguranca/UsuarioSave;", "(Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "alterarSenha", "", "vo", "Lbr/gov/antt/sgctt/core/beans/seguranca/VOs/UsuarioChangePasswordRequestVO;", "saveUsuario", "save", "deleteUsuario", "server"})
@SourceDebugExtension(value={"SMAP\nUsuariosRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UsuariosRestServices.kt\nbr/gov/antt/sgctt/apis/UsuariosRestServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,781:1\n1557#2:782\n1628#2,3:783\n1557#2:786\n1628#2,3:787\n*S KotlinDebug\n*F\n+ 1 UsuariosRestServices.kt\nbr/gov/antt/sgctt/apis/UsuariosRestServices\n*L\n77#1:782\n77#1:783,3\n99#1:786\n99#1:787,3\n*E\n"})
public class UsuariosRestServices
extends BaseRestService {
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final CadastroService cadastroService;
    @NotNull
    private final KeycloakCoreService keycloakCoreService;
    @NotNull
    private final EmpresaService empresaService;
    @NotNull
    private final Logger logger;

    public UsuariosRestServices(@NotNull SegurancaService segurancaService, @NotNull CoreService coreService, @NotNull CadastroService cadastroService, @NotNull KeycloakCoreService keycloakCoreService, @NotNull EmpresaService empresaService) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)cadastroService, (String)"cadastroService");
        Intrinsics.checkNotNullParameter((Object)keycloakCoreService, (String)"keycloakCoreService");
        Intrinsics.checkNotNullParameter((Object)empresaService, (String)"empresaService");
        super(segurancaService);
        this.segurancaService = segurancaService;
        this.coreService = coreService;
        this.cadastroService = cadastroService;
        this.keycloakCoreService = keycloakCoreService;
        this.empresaService = empresaService;
        Logger logger = LoggerFactory.getLogger(UsuariosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping
    @Operation(summary="Listagem de usu\u00e1rios por empresa", description="Retorna os usu\u00e1rios associados com a empresa, atrav\u00e9s de filtro. Pode ser informado o termo de busca, para buscar por partes do nome do usu\u00e1rio. Ainda, pode ser informado o nome do perfil de usu\u00e1rio ou perfil interno.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rios encontrados com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public Page<UsuarioEmpresaAreaVO> findUsuariosEmpresa(@ParameterObject @NotNull FindUsuariosEmpresaDTO dto, @NotNull Pageable pageable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        this.logger.debug("Executando UsuarioRestServices GET usuariosByEmpresa...");
        Page usuariosPage = this.segurancaService.findUsuariosByEmpresasAndGrupos(dto, pageable);
        List list = usuariosPage.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Usuario usuario = (Usuario)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UsuarioEmpresaAreaVO.fromUsuario((Usuario)it));
        }
        List distinctUsuariosVO = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        return (Page)new PageImpl(distinctUsuariosVO, pageable, usuariosPage.getTotalElements());
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping(value={"/keycloak"})
    @Operation(summary="Listagem de usu\u00e1rios que j\u00e1 realizaram acesso e s\u00e3o do Keycloak")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rios encontrados com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public Page<UsuarioEmpresaAreaVO> findUsuariosKeycloak(@ParameterObject @NotNull FindUsuariosEmpresaDTO dto, @NotNull Pageable pageable) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        this.logger.debug("Executando UsuarioRestServices GET usuariosByEmpresa...");
        Page usuariosPage = this.segurancaService.findUsuariosKeycloak(dto, pageable);
        List list = usuariosPage.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Usuario usuario = (Usuario)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UsuarioEmpresaAreaVO.fromUsuario((Usuario)it));
        }
        List distinctUsuariosVO = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        return (Page)new PageImpl(distinctUsuariosVO, pageable, usuariosPage.getTotalElements());
    }

    @GetMapping(value={"/keycloak/permissoes"})
    @Operation(summary="Listagem de permiss\u00f5es Keycloak", description="Lista todas roles nos Grupos e Roles do Keycloak para utilizar em permiss\u00f5es no sistema")
    @ApiResponses(value={@ApiResponse(description="Permiss\u00f5es encontradas com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public Page<RoleDTO> findPermissoes(@NotNull HttpServletRequest request, @RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        this.logger.debug("Executando UsuarioRestServices GET findPermissoes...");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        Page page = this.keycloakCoreService.getPaginatedClientRoles(search, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"getPaginatedClientRoles(...)");
        return page;
    }

    @GetMapping(value={"/keycloak/permissoes/{idUsuario}"})
    @Operation(summary="Listagem de permiss\u00f5es Keycloak do usu\u00e1rio", description="Lista todas roles nos Grupos e Roles de um usu\u00e1rio do Keycloak para utilizar em permiss\u00f5es no sistema")
    @ApiResponses(value={@ApiResponse(description="Permiss\u00f5es encontradas com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public Set<RoleDTO> findPermissoesUsuario(@NotNull HttpServletRequest request, @PathVariable(value="idUsuario") int idUsuario) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.debug("Executando UsuarioRestServices GET findPermissoes...");
        Usuario usuario = this.getPrivateUsuarioByJWT(request);
        Set set = this.keycloakCoreService.getRolesByUserId(Integer.valueOf(idUsuario));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRolesByUserId(...)");
        return set;
    }

    @PostMapping(value={"/keycloak/permissoes/{idUsuario}"})
    @Operation(summary="Endpoint para adi\u00e7\u00e3o de role para usu\u00e1rio", description="Endpoint para adi\u00e7\u00e3o de role do Keycloak para usu\u00e1rio")
    @NotNull
    public List<RoleDTO> setUserRoles(@NotNull HttpServletRequest request, @PathVariable(value="idUsuario") int idUsuario, @org.springframework.web.bind.annotation.RequestBody @NotNull Set<String> roles) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Usuario user = this.getPrivateUsuarioByJWT(request);
        List list = this.keycloakCoreService.setUserRoles(roles, Integer.valueOf(idUsuario));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"setUserRoles(...)");
        return list;
    }

    @GetMapping(value={"/info"})
    @Operation(summary="Informa\u00e7\u00f5es detalhadas do usu\u00e1rio", description="Retorna informa\u00e7\u00f5es detalhadas do usu\u00e1rio autenticado, incluindo perfis, permiss\u00f5es, empresas associadas e dados pessoais.")
    @ApiResponses(value={@ApiResponse(description="Informa\u00e7\u00f5es obtidas com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<Map<String, Object>> getUserInfo(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.debug("Executando UsuarioRestServices GET UserInfo...");
        try {
            Map result = new LinkedHashMap();
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Usu\u00e1rio n\u00e3o est\u00e1 conectado.");
            }
            PublicUser pbUser = publicUser;
            Usuario user = this.segurancaService.getUsuarioByLoginOrMail(pbUser.getLogin());
            Set permissoes = this.keycloakCoreService.getRolesByUserKeycloakId(user.getKeycloakId());
            List grupos = null;
            List areas = null;
            List perfis = new ArrayList();
            List empresas = null;
            UsuarioPerfil perfil = null;
            boolean usuarioTerceiro = false;
            boolean usuarioAdminAmb = false;
            if (user != null) {
                pbUser = new PublicUser(user);
                List gruposUsuario = this.segurancaService.findGrupoUsuariosByUsuario(user.getId());
                List empresasUsuario = this.segurancaService.findEmpresasByUsuario(user.getId());
                List areasUsuario = this.empresaService.findAgenciaAreasByResponsavel(user.getId());
                perfil = this.segurancaService.getExtensaoPerfilByUsuario(user.getId());
                grupos = new ArrayList();
                if (gruposUsuario != null && !gruposUsuario.isEmpty()) {
                    for (UsuarioGrupo grupo : gruposUsuario) {
                        GrupoAcessoUsuario grp = grupo.getGrupoAcesso();
                        grp.setId(null);
                        grp.setDatHorCadastro(null);
                        grp.setIdUsuarioIns(null);
                        ((ArrayList)grupos).add(grp);
                    }
                }
                areas = new ArrayList();
                if (areasUsuario != null && !areasUsuario.isEmpty()) {
                    Iterator iterator = areasUsuario.iterator();
                    while (iterator.hasNext()) {
                        EmpresaAreaResponsavelDTO area;
                        EmpresaAreaResponsavelDTO ar = area = (EmpresaAreaResponsavelDTO)iterator.next();
                        ((ArrayList)areas).add(ar);
                    }
                }
                empresas = new ArrayList();
                if (empresasUsuario != null && !empresasUsuario.isEmpty()) {
                    for (UsuarioEmpresa empUsr : empresasUsuario) {
                        Empresa emp = new Empresa();
                        emp.setNomeFantasia(empUsr.getEmpresa().getNomeFantasia());
                        emp.setSigla(empUsr.getEmpresa().getSigla());
                        ((ArrayList)empresas).add(emp);
                        Integer n = empUsr.getId().getIdEmpresa();
                    }
                }
            } else {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            result.put("nomeUsuario", user.getNome());
            result.put("login", user.getLogin());
            result.put("email", user.getEmail());
            if (perfil.isAdministradorFlag().booleanValue()) {
                result.put("isAdmin", perfil.isAdministradorFlag());
            }
            result.put("isExterno", user.isExterno());
            Boolean bl = usuarioTerceiro;
            result.put("terceiro", bl);
            result.put("ultimoAcesso", user.getDatHorUltimoLogin());
            result.put("refId", user.getId());
            result.put("cargo", user.getCargo());
            result.put("cpfCnpj", perfil.getCpfCnpj());
            result.put("matricula", perfil.getNroMatricula());
            result.put("endereco", perfil.getEndereco());
            result.put("cidade", perfil.getCidade());
            result.put("uf", perfil.getUf());
            result.put("localTrabalho", perfil.getLocalTrabalho());
            result.put("formacao", perfil.getFormacao());
            result.put("utilizacaoRodovia", perfil.getUtilizacaoRodovia());
            result.put("tipoVeiculo", perfil.getTipoVeiculo());
            result.put("idUsuario", perfil.getIdUsuario());
            result.put("permissoes", permissoes);
            Rodovia rodovia = null;
            if (perfil.getIdRodovia() != null) {
                Integer n = perfil.getIdRodovia();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getIdRodovia(...)");
                rodovia = this.cadastroService.getRodoviaById(((Number)n).intValue());
                if (rodovia != null) {
                    rodovia.setEmpresa(null);
                    rodovia.setDatHorCadastro(null);
                    rodovia.setIdUsuarioIns(null);
                    rodovia.setDatHorAlteracao(null);
                    rodovia.setIdUsuarioUpd(null);
                }
            }
            List list = this.cadastroService.findRodovias(null, null, null, Pageable.unpaged()).getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
            List rodovias = list;
            for (Rodovia rdv : rodovias) {
                rdv.setEmpresa(null);
                rdv.setDatHorCadastro(null);
                rdv.setIdUsuarioIns(null);
                rdv.setDatHorAlteracao(null);
                rdv.setIdUsuarioUpd(null);
            }
            result.put("rodovias", rodovias);
            result.put("rodovia", rodovia);
            result.put("grupos", grupos);
            result.put("empresas", empresas);
            result.put("areas", areas);
            result.put("perfis", perfis);
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getUserInfo", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exc.getUserInfo", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/grupos"})
    @Operation(summary="Lista os grupos de acesso do usu\u00e1rio", description="Retorna a lista de grupos de acesso associados ao usu\u00e1rio autenticado.")
    @ApiResponses(value={@ApiResponse(description="Grupos obtidos com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<UsuarioGrupo>> findGruposAcessoByUsuario(@Nullable HttpServletRequest request) {
        this.logger.debug("Executando UsuarioRestServices GET gruposUsuario...");
        try {
            PublicUser pbUser;
            HttpServletRequest httpServletRequest = request;
            Intrinsics.checkNotNull((Object)httpServletRequest);
            PublicUser publicUser = pbUser = this.getUsuarioByJWT(httpServletRequest);
            Intrinsics.checkNotNull((Object)publicUser);
            PublicUser user = this.segurancaService.getUsuarioByLogin(publicUser.getLogin());
            List result = this.segurancaService.findGrupoUsuariosByUsuario(user.getId());
            for (UsuarioGrupo grp : result) {
                grp.setUsuario(null);
                grp.getId().setIdUsuario(null);
                grp.setDatHorCadastro(null);
                grp.setIdUsuarioIns(null);
                GrupoAcessoUsuario gpu = grp.getGrupoAcesso();
                if (gpu == null) continue;
                gpu.setId(null);
                gpu.setDatHorCadastro(null);
                gpu.setIdUsuarioIns(null);
                gpu.setDatHorAlteracao(null);
                gpu.setIdUsuarioUpd(null);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getGruposUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exc.getGruposUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/grupos/all"})
    @Operation(summary="Lista todos os grupos de acesso", description="Retorna todos os grupos de acesso dispon\u00edveis no sistema, podendo ser filtrados por m\u00f3dulo.")
    @ApiResponses(value={@ApiResponse(description="Grupos obtidos com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<GrupoAcessoUsuario>> findGruposAcesso(@Parameter(description="Filtro pelo m\u00f3dulo (opcional)") @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.logger.debug("Executando UsuarioRestServices GET gruposUsuario...");
        try {
            String modulo = request.getParameter("modulo");
            List result = this.segurancaService.findGruposAcessoUsuarios(null, modulo);
            for (GrupoAcessoUsuario grp : result) {
                grp.setDatHorCadastro(null);
                grp.setIdUsuarioIns(null);
                grp.setDatHorAlteracao(null);
                grp.setIdUsuarioUpd(null);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getGruposUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exc.getGruposUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idGrupoUsuario}/permissoes"})
    @Operation(summary="Permiss\u00f5es por grupo de usu\u00e1rio", description="Lista todas as permiss\u00f5es associadas a um grupo de usu\u00e1rio espec\u00edfico.")
    @ApiResponses(value={@ApiResponse(description="Permiss\u00f5es obtidas com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<PermissaoAcessoGrupo>> getPermissoes(@Nullable HttpServletRequest request, @Parameter(description="ID do grupo de usu\u00e1rio") @PathVariable(name="idGrupoUsuario") @Nullable Integer idGrupoUsuario) {
        this.logger.debug("Executando UsuarioRestServices GET permissoes...");
        try {
            HttpServletRequest httpServletRequest = request;
            Intrinsics.checkNotNull((Object)httpServletRequest);
            PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser pbUser = publicUser;
            List result = this.segurancaService.findPermissoesByGrupo(idGrupoUsuario);
            for (PermissaoAcessoGrupo prm : result) {
                prm.setDatHorCadastro(null);
                prm.setIdUsuarioIns(null);
                prm.getGrupoAcessoUsuario().setDatHorAlteracao(null);
                prm.getGrupoAcessoUsuario().setDatHorCadastro(null);
                prm.getGrupoAcessoUsuario().setIdUsuarioIns(null);
                prm.getGrupoAcessoUsuario().setIdUsuarioUpd(null);
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(pbUser.getLogin());
            UsuarioPerfil perfil = this.segurancaService.getExtensaoPerfilByUsuario(user.getId());
            if (perfil.isAdministradorFlag().booleanValue()) {
                PermissaoAcessoGrupo permSeg = new PermissaoAcessoGrupo(idGrupoUsuario, Integer.valueOf(9999));
                permSeg.setModulo(new ModuloAcesso(Integer.valueOf(9999), "M\u00f3dulo seguran\u00e7a", "Acesso Seguran\u00e7a", TipoModulo.SEGURANCA.getSigla(), null, null));
                result.add(permSeg);
            }
            return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getPermissoes", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exc.getPermissoes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/permissoes"})
    @Operation(summary="Permiss\u00f5es do usu\u00e1rio atual", description="Retorna a lista de permiss\u00f5es associadas ao usu\u00e1rio autenticado.")
    @ApiResponses(value={@ApiResponse(description="Permiss\u00f5es obtidas com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<ModuloAcesso>> findPermissoesByUsuario(@Nullable HttpServletRequest request) {
        this.logger.debug("GET permissoesByUsuario...");
        try {
            HttpServletRequest httpServletRequest = request;
            Intrinsics.checkNotNull((Object)httpServletRequest);
            PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser pbUser = publicUser;
            PublicUser user = this.segurancaService.getUsuarioByLogin(pbUser.getLogin());
            Set permissoesUser = this.segurancaService.findPermissoesByUsuario(user.getId());
            ArrayList<ModuloAcesso> permissoes = new ArrayList<ModuloAcesso>();
            for (ModuloAcesso permUsr : permissoesUser) {
                permUsr.setId(null);
                permUsr.setIdModuloPai(null);
                if (permUsr.getModuloPai() != null) {
                    permUsr.getModuloPai().setId(null);
                }
                permissoes.add(permUsr);
            }
            return new ResponseEntity(permissoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findPermissoesByUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exc.findPermissoesByUsuario", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/permissoes/all"})
    @Operation(summary="Todas as permiss\u00f5es de acesso", description="Retorna todas as permiss\u00f5es de acesso dispon\u00edveis na empresa.")
    @ApiResponses(value={@ApiResponse(description="Permiss\u00f5es obtidas com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<ModuloAcesso>> findPermissoesAcesso(@Nullable HttpServletRequest request) {
        try {
            HttpServletRequest httpServletRequest = request;
            Intrinsics.checkNotNull((Object)httpServletRequest);
            PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser pbUser = publicUser;
            this.logger.debug("GET findPermissoesAcesso({})...", (Object)pbUser.getLogin());
            List permissoes = this.segurancaService.findModulos();
            return new ResponseEntity((Object)permissoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.findPermissoesAcesso", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.logger.error("Exc.findPermissoesAcesso", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/permissoesAcesso/{idGrupoUsuario}/{modulo}"})
    @Operation(summary="Salvar permiss\u00f5es de acesso", description="Grava as permiss\u00f5es espec\u00edficas de um grupo de usu\u00e1rio para um determinado m\u00f3dulo.")
    @ApiResponses(value={@ApiResponse(description="Permiss\u00f5es salvas com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<List<PermissaoAcessoGrupo>> postPermissoesAcesso(@Parameter(description="ID do grupo de usu\u00e1rio") @PathVariable(name="idGrupoUsuario") @Nullable Integer idGrupoUsuario, @Parameter(description="M\u00f3dulo do sistema") @PathVariable(name="modulo") @Nullable String modulo, @Nullable HttpServletRequest request, @RequestBody(description="Lista de permiss\u00f5es a serem configuradas", content={@Content(schema=@Schema(implementation=PermissaoAcessoGrupo.class))}, required=true) @org.springframework.web.bind.annotation.RequestBody @Nullable List<? extends PermissaoAcessoGrupo> permissoes) {
        this.logger.debug("API postPermissoesAcesso...");
        try {
            HttpServletRequest httpServletRequest = request;
            Intrinsics.checkNotNull((Object)httpServletRequest);
            PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser usr = publicUser;
            if (permissoes == null || permissoes.isEmpty()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Permiss\u00f5es de usu\u00e1rio n\u00e3o encontradas.");
            }
            PublicUser user = this.segurancaService.getUsuarioByLogin(usr.getLogin());
            this.segurancaService.savePermissoes(idGrupoUsuario, permissoes, modulo, user.getId());
            return new ResponseEntity(permissoes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveGrupoUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{empresa}/auditorias"})
    @Operation(summary="Auditoria de usu\u00e1rios", description="Retorna informa\u00e7\u00f5es de auditoria dos usu\u00e1rios de uma empresa, podendo ser filtradas por data e tipo.")
    @ApiResponses(value={@ApiResponse(description="Registros de auditoria obtidos com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public Page<UsuarioAuditoria> findAuditoria(@Nullable HttpServletRequest request, @Parameter(description="Sigla da empresa") @PathVariable(name="empresa") @NotNull String empresa, @Parameter(description="Filtro de busca") @RequestParam(name="search", required=false) @Nullable String search, @Parameter(description="Data inicial para filtro") @RequestParam(name="dataInicial", required=false) @Nullable LocalDate dataInicial, @Parameter(description="Data final para filtro") @RequestParam(name="dataFinal", required=false) @Nullable LocalDate dataFinal, @Parameter(description="Tipo de auditoria") @RequestParam(name="tipo", required=false) @Nullable List<Integer> tipo, @Parameter(description="ID do Usu\u00e1rio") @RequestParam(name="usuario", required=false) @Nullable Integer usuario, @Parameter(description="M\u00f3dulo") @RequestParam(name="modulo", required=false) @Nullable TipoModulo modulo, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        this.logger.debug("Executando UsuarioRestServices GET getAuditoria...");
        Page page = this.segurancaService.findAuditoria(empresa, search, dataInicial, dataFinal, usuario, tipo, modulo, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAuditoria(...)");
        return page;
    }

    @PostMapping(value={"/auditoria"})
    @Operation(summary="Registrar auditoria", description="Grava um registro de auditoria de a\u00e7\u00e3o do usu\u00e1rio.")
    @ApiResponses(value={@ApiResponse(description="Registro de auditoria salvo com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<UsuarioAuditoria> postAuditoria(@Nullable HttpServletRequest request, @RequestBody(description="Dados de auditoria a serem registrados", content={@Content(schema=@Schema(implementation=UsuarioAuditoria.class))}, required=true) @org.springframework.web.bind.annotation.RequestBody @Nullable UsuarioAuditoria auditoria) {
        this.logger.debug("API postAuditoria...");
        try {
            HttpServletRequest httpServletRequest = request;
            Intrinsics.checkNotNull((Object)httpServletRequest);
            PublicUser publicUser = this.getUsuarioByJWT(httpServletRequest);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Usu\u00e1rio n\u00e3o encontrado.");
            }
            PublicUser usr = publicUser;
            if (auditoria == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Auditoria de usu\u00e1rio n\u00e3o encontrada.");
            }
            this.segurancaService.registraAuditoria(auditoria.getIdEmpresa(), auditoria.getDescricao(), auditoria.getIdUsuario(), auditoria.getTipo(), auditoria.getIpAcesso());
            return new ResponseEntity((Object)auditoria, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveGrupoUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idUsuario}/usuario/saved"})
    @Operation(summary="Obter usu\u00e1rio completo", description="Carrega o usu\u00e1rio pelo seu identificador, retornando em uma \u00fanica chamada seus grupos, empresas e perfil.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rio obtido com sucesso", responseCode="200")})
    @NotNull
    public ResponseEntity<UsuarioSave> getUsuarioSavedById(@Parameter(description="ID do usu\u00e1rio") @PathVariable @Nullable Integer idUsuario) {
        try {
            this.logger.debug("getUsuarioSavedById({})", (Object)idUsuario);
            return new ResponseEntity((Object)this.segurancaService.getUsuarioSavedById(idUsuario), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.getUsuarioSavedById", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/alterarSenha"})
    @Operation(summary="Alterar senha do usu\u00e1rio", description="Endpoint para permitir que o usu\u00e1rio altere sua pr\u00f3pria senha.")
    @ApiResponses(value={@ApiResponse(description="Senha alterada com sucesso", responseCode="200")})
    @ResponseBody
    public void alterarSenha(@Nullable HttpServletRequest request, @RequestBody(description="Dados para altera\u00e7\u00e3o de senha", content={@Content(schema=@Schema(implementation=UsuarioChangePasswordRequestVO.class))}, required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull UsuarioChangePasswordRequestVO vo) {
        Intrinsics.checkNotNullParameter((Object)vo, (String)"vo");
        HttpServletRequest httpServletRequest = request;
        Intrinsics.checkNotNull((Object)httpServletRequest);
        String token = this.getToken(httpServletRequest);
        if (vo.idUsuario() == null) {
            this.keycloakCoreService.alterarSenhaUsuario(token, vo.novaSenha());
            return;
        }
        this.keycloakCoreService.alterarSenhaAdmin(token, vo);
    }

    @PostMapping(value={"/usuario"})
    @Operation(summary="Salvar usu\u00e1rio", description="Cria ou atualiza um usu\u00e1rio no sistema, incluindo seus dados de perfil, grupos e empresas associadas.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rio salvo com sucesso", responseCode="200")})
    @ResponseBody
    @NotNull
    public ResponseEntity<UsuarioSave> saveUsuario(@NotNull HttpServletRequest request, @RequestBody(description="Dados completos do usu\u00e1rio a ser salvo", required=true) @org.springframework.web.bind.annotation.RequestBody @NotNull UsuarioSave save) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)save, (String)"save");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            this.logger.debug("API saveUsuario({}) ...", (Object)usuario.getLogin());
            UsuarioPerfil perfilUser = this.segurancaService.getExtensaoPerfilByUsuario(usuario.getId());
            UsuarioPerfil perfil = save.getPerfil();
            if (StringUtils.hasText((String)perfil.getSenha())) {
                String rawSenha = perfil.getSenha();
                Intrinsics.checkNotNull((Object)rawSenha);
                CharSequence charSequence = rawSenha;
                if (!new Regex("^[a-fA-F0-9]{32}$").matches(charSequence) && !new Regex("^[a-fA-F0-9]{40}$").matches(charSequence = (CharSequence)rawSenha)) {
                    perfil.setSenha(MD5Utils.transformToMD5((String)rawSenha));
                }
            }
            if (!perfilUser.getAdministradorBoolean().booleanValue()) {
                throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
            }
            UsuarioSave userSaved = this.segurancaService.saveUsuario(save.getUsuario(), save.getPerfil(), save.getGrupos(), save.getEmpresas(), usuario.getId(), this.getIpExterno(request));
            return new ResponseEntity((Object)userSaved, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.logger.error("BizExc.saveUsuario", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idUsuario}"})
    @Operation(summary="Excluir usu\u00e1rio", description="Remove um usu\u00e1rio do sistema a partir do seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Usu\u00e1rio exclu\u00eddo com sucesso", responseCode="200")})
    public void deleteUsuario(@Parameter(description="ID do usu\u00e1rio a ser exclu\u00eddo") @PathVariable(name="idUsuario") int idUsuario) {
        this.logger.debug("deleteUsuario({})", (Object)idUsuario);
        this.segurancaService.deleteUsuario(idUsuario);
    }
}

