/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.apis.SchedulersRestServices;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.exceptions.BusinessException;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.LicencaService;
import br.gov.antt.sgctt.services.SegurancaService;
import br.gov.antt.sgctt.services.email.EmailQueueProcessor;
import br.gov.antt.sgctt.services.empresa.SirDataSynchronizer;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/schedulers"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lbr/gov/antt/sgctt/apis/SchedulersRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "licencaService", "Lbr/gov/antt/sgctt/services/LicencaService;", "emailQueueProcessor", "Lbr/gov/antt/sgctt/services/email/EmailQueueProcessor;", "sirDataSynchronizer", "Lbr/gov/antt/sgctt/services/empresa/SirDataSynchronizer;", "<init>", "(Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/LicencaService;Lbr/gov/antt/sgctt/services/email/EmailQueueProcessor;Lbr/gov/antt/sgctt/services/empresa/SirDataSynchronizer;)V", "sendMails", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "updateLicencasPrazos", "", "syncEmpresas", "Companion", "server"})
public class SchedulersRestServices
extends BaseRestService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LicencaService licencaService;
    @NotNull
    private final EmailQueueProcessor emailQueueProcessor;
    @NotNull
    private final SirDataSynchronizer sirDataSynchronizer;
    private static final Logger log = LoggerFactory.getLogger(SchedulersRestServices.class);

    public SchedulersRestServices(@NotNull SegurancaService segurancaService, @NotNull LicencaService licencaService, @NotNull EmailQueueProcessor emailQueueProcessor, @NotNull SirDataSynchronizer sirDataSynchronizer) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)licencaService, (String)"licencaService");
        Intrinsics.checkNotNullParameter((Object)emailQueueProcessor, (String)"emailQueueProcessor");
        Intrinsics.checkNotNullParameter((Object)sirDataSynchronizer, (String)"sirDataSynchronizer");
        super(segurancaService);
        this.licencaService = licencaService;
        this.emailQueueProcessor = emailQueueProcessor;
        this.sirDataSynchronizer = sirDataSynchronizer;
    }

    @PostMapping(value={"/emails/process"})
    @Operation(summary="Envia os emails pendentes ou em cache.")
    public void sendMails(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        log.info("Iniciando processamento da fila de emails...");
        this.emailQueueProcessor.processEmailQueue(usuario.getId());
    }

    @PostMapping(value={"/licencas/prazos"})
    @Operation(summary="Calcula e informa quando uma licen\u00e7a ambiental tiver expirada ou quase expirada")
    public boolean updateLicencasPrazos(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        try {
            log.info("Iniciando atualiza\u00e7\u00e3o de prazos das licen\u00e7as...");
            Boolean bl = this.licencaService.updatePrazoLicencas();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"updatePrazoLicencas(...)");
            return bl;
        }
        catch (BusinessException bizExc) {
            log.error("BizExc.updatePrazoRacs", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/sir/sync"})
    @Operation(summary="Sincroniza as empresas com os dados do SIR")
    public void syncEmpresas(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        log.info("Iniciando sincroniza\u00e7\u00e3o de dados com o SIR...");
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.sirDataSynchronizer.sync(((Number)n).intValue());
    }
}

