/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.apis.pleitos.FindPleitosDTOFactory;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.dto.pleitos.FindPleitosDTO;
import br.gov.antt.sgctt.core.dto.pleitos.PleitoPrimeiraFaseDTO;
import br.gov.antt.sgctt.core.dto.pleitos.PleitoSegundaFaseDTO;
import br.gov.antt.sgctt.core.dto.pleitos.UpdatePleitoDTO;
import br.gov.antt.sgctt.core.dto.pleitos.anexo.FindPleitoAnexosDTO;
import br.gov.antt.sgctt.core.dto.pleitos.dashboard.GetPleitoDashboardDTO;
import br.gov.antt.sgctt.core.dto.pleitos.dashboard.PleitoDashboardDTO;
import br.gov.antt.sgctt.core.dto.pleitos.demandante.SaveDemandanteDTO;
import br.gov.antt.sgctt.core.dto.pleitos.historico.CreateHistoricoDTO;
import br.gov.antt.sgctt.core.dto.pleitos.historico.UpdateHistoricoDTO;
import br.gov.antt.sgctt.core.dto.pleitos.itemContratual.CreatePleitoItemContratualDTO;
import br.gov.antt.sgctt.core.dto.pleitos.logs.CreatePleitoLogDTO;
import br.gov.antt.sgctt.core.dto.pleitos.rodovia.CreatePleitoRodoviaDTO;
import br.gov.antt.sgctt.core.dto.pleitos.rodovia.UpdatePleitoRodoviaDTO;
import br.gov.antt.sgctt.exceptions.BusinessException;
import br.gov.antt.sgctt.geral.importacao.ProcessoImportacao;
import br.gov.antt.sgctt.pleitos.HistoricoPleito;
import br.gov.antt.sgctt.pleitos.Pleito;
import br.gov.antt.sgctt.pleitos.PleitoAnexo;
import br.gov.antt.sgctt.pleitos.PleitoDemandante;
import br.gov.antt.sgctt.pleitos.PleitoEstruturaContrato;
import br.gov.antt.sgctt.pleitos.PleitoLog;
import br.gov.antt.sgctt.pleitos.PleitoRodovia;
import br.gov.antt.sgctt.pleitos.PleitoStatus;
import br.gov.antt.sgctt.reports.RelatorioProcessosExcel;
import br.gov.antt.sgctt.services.CadastrosPleitoService;
import br.gov.antt.sgctt.services.CoreService;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.PleitoService;
import br.gov.antt.sgctt.services.SegurancaService;
import br.gov.antt.sgctt.services.helpers.ImportacaoPleitoHelper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Tag(name="pleitos", description="REST Services para Pleitos")
@RequestMapping(value={"/api/v1/pleitos"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00fe\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0017\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J4\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0012\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J$\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J.\u0010!\u001a\u00020\u00112\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u0012\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J$\u0010#\u001a\u00020$2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J*\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J4\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110'2\b\b\u0001\u0010\u0012\u001a\u00020(2\n\b\u0001\u0010)\u001a\u0004\u0018\u00010\u00192\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J.\u0010,\u001a\u00020-2\b\b\u0001\u0010.\u001a\u00020\u001b2\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J*\u00100\u001a\b\u0012\u0004\u0012\u00020-0'2\b\b\u0001\u0010.\u001a\u00020\u001b2\b\b\u0001\u0010/\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0017J \u00100\u001a\b\u0012\u0004\u0012\u00020-0'2\b\b\u0001\u0010\u0012\u001a\u0002012\u0006\u0010*\u001a\u00020+H\u0017J.\u00102\u001a\u00020$2\b\b\u0001\u0010.\u001a\u00020\u001b2\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u00103\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J:\u00104\u001a\u0002052\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010\u0012\u001a\u0002072\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J2\u00108\u001a\b\u0012\u0004\u0012\u0002050'2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017JD\u00109\u001a\u0002052\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010:\u001a\u00020\u001b2\b\b\u0001\u0010\u0012\u001a\u00020;2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J.\u0010<\u001a\u00020$2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010:\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J.\u0010=\u001a\u00020$2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010:\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J*\u0010>\u001a\b\u0012\u0004\u0012\u00020?0'2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0017J4\u0010@\u001a\b\u0012\u0004\u0012\u00020?0A2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010\u0012\u001a\u00020B2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J.\u0010C\u001a\u00020$2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010D\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J*\u0010E\u001a\b\u0012\u0004\u0012\u00020F0'2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0017J.\u0010G\u001a\u00020F2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010\u0012\u001a\u00020H2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J8\u0010I\u001a\u00020F2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010J\u001a\u00020\u001b2\b\b\u0001\u0010\u0012\u001a\u00020K2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J.\u0010L\u001a\u00020$2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010J\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J$\u0010M\u001a\u00020$2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J*\u0010N\u001a\b\u0012\u0004\u0012\u00020O0'2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0017J.\u0010P\u001a\u00020O2\b\b\u0001\u00106\u001a\u00020\u00192\b\b\u0001\u0010/\u001a\u00020\u001b2\b\b\u0001\u0010\u0012\u001a\u00020Q2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0012\u0010R\u001a\u00020S2\b\b\u0001\u0010T\u001a\u00020\u001bH\u0017J\"\u0010U\u001a\b\u0012\u0004\u0012\u00020S0'2\n\b\u0001\u0010V\u001a\u0004\u0018\u00010\u00192\u0006\u0010*\u001a\u00020+H\u0017J\u001a\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00190A2\n\b\u0001\u0010V\u001a\u0004\u0018\u00010\u0019H\u0017J\u001a\u0010X\u001a\u00020S2\b\b\u0001\u0010\u0012\u001a\u00020Y2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J$\u0010Z\u001a\u00020S2\b\b\u0001\u0010T\u001a\u00020\u001b2\b\b\u0001\u0010\u0012\u001a\u00020Y2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0012\u0010[\u001a\u00020$2\b\b\u0001\u0010T\u001a\u00020\u001bH\u0017J\u0018\u0010\\\u001a\u00020]2\u0006\u0010\u0012\u001a\u00020^2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J(\u0010_\u001a\b\u0012\u0004\u0012\u00020`0\u00172\b\b\u0001\u0010\u0012\u001a\u00020(2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lbr/gov/antt/sgctt/apis/PleitosRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "coreService", "Lbr/gov/antt/sgctt/services/CoreService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "pleitoService", "Lbr/gov/antt/sgctt/services/PleitoService;", "importacaoPleitoHelper", "Lbr/gov/antt/sgctt/services/helpers/ImportacaoPleitoHelper;", "cadastrosPleitoService", "Lbr/gov/antt/sgctt/services/CadastrosPleitoService;", "<init>", "(Lbr/gov/antt/sgctt/services/CoreService;Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/PleitoService;Lbr/gov/antt/sgctt/services/helpers/ImportacaoPleitoHelper;Lbr/gov/antt/sgctt/services/CadastrosPleitoService;)V", "LOGGER", "Lorg/slf4j/Logger;", "savePleitoPrimeiraFase", "Lbr/gov/antt/sgctt/pleitos/Pleito;", "dto", "Lbr/gov/antt/sgctt/core/dto/pleitos/PleitoPrimeiraFaseDTO;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "savePleitoSegundaFase", "Lorg/springframework/http/ResponseEntity;", "empresa", "", "idPleito", "", "Lbr/gov/antt/sgctt/core/dto/pleitos/PleitoSegundaFaseDTO;", "importPleitos", "Lbr/gov/antt/sgctt/geral/importacao/ProcessoImportacao;", "file", "Lorg/springframework/web/multipart/MultipartFile;", "updatePleito", "Lbr/gov/antt/sgctt/core/dto/pleitos/UpdatePleitoDTO;", "deletePleito", "", "getPleito", "findPleitos", "Lorg/springframework/data/domain/Page;", "Lbr/gov/antt/sgctt/core/dto/pleitos/FindPleitosDTO;", "status", "pageable", "Lorg/springframework/data/domain/Pageable;", "createAnexo", "Lbr/gov/antt/sgctt/pleitos/PleitoAnexo;", "empresaId", "pleitoId", "findAnexos", "Lbr/gov/antt/sgctt/core/dto/pleitos/anexo/FindPleitoAnexosDTO;", "deleteAnexo", "anexoId", "createHistorico", "Lbr/gov/antt/sgctt/pleitos/HistoricoPleito;", "empresaSigla", "Lbr/gov/antt/sgctt/core/dto/pleitos/historico/CreateHistoricoDTO;", "findHistoricosByPleitoId", "updateHistorico", "historicoId", "Lbr/gov/antt/sgctt/core/dto/pleitos/historico/UpdateHistoricoDTO;", "deleteHistorico", "deleteHistoricoAnexo", "findPleitoItensContratuais", "Lbr/gov/antt/sgctt/pleitos/PleitoEstruturaContrato;", "createItemContratual", "", "Lbr/gov/antt/sgctt/core/dto/pleitos/itemContratual/CreatePleitoItemContratualDTO;", "deleteItemContratual", "idItemContratual", "findPleitoRodovias", "Lbr/gov/antt/sgctt/pleitos/PleitoRodovia;", "createPleitoRodovia", "Lbr/gov/antt/sgctt/core/dto/pleitos/rodovia/CreatePleitoRodoviaDTO;", "updatePleitoRodovia", "idPleitoRodovia", "Lbr/gov/antt/sgctt/core/dto/pleitos/rodovia/UpdatePleitoRodoviaDTO;", "deletePleitoRodovia", "iniciarAprovacao", "findPleitoLogs", "Lbr/gov/antt/sgctt/pleitos/PleitoLog;", "createLog", "Lbr/gov/antt/sgctt/core/dto/pleitos/logs/CreatePleitoLogDTO;", "findDemandanteById", "Lbr/gov/antt/sgctt/pleitos/PleitoDemandante;", "id", "findDemandantes", "nome", "demandanteAutocomplete", "createDemandante", "Lbr/gov/antt/sgctt/core/dto/pleitos/demandante/SaveDemandanteDTO;", "updateDemandante", "deleteDemandante", "getDashboard", "Lbr/gov/antt/sgctt/core/dto/pleitos/dashboard/PleitoDashboardDTO;", "Lbr/gov/antt/sgctt/core/dto/pleitos/dashboard/GetPleitoDashboardDTO;", "downloadRelatorioDashboard", "", "server"})
@SourceDebugExtension(value={"SMAP\nPleitosRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PleitosRestServices.kt\nbr/gov/antt/sgctt/apis/PleitosRestServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,915:1\n295#2,2:916\n*S KotlinDebug\n*F\n+ 1 PleitosRestServices.kt\nbr/gov/antt/sgctt/apis/PleitosRestServices\n*L\n281#1:916,2\n*E\n"})
public class PleitosRestServices
extends BaseRestService {
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final PleitoService pleitoService;
    @NotNull
    private final ImportacaoPleitoHelper importacaoPleitoHelper;
    @NotNull
    private final CadastrosPleitoService cadastrosPleitoService;
    @NotNull
    private final Logger LOGGER;

    public PleitosRestServices(@NotNull CoreService coreService, @NotNull SegurancaService segurancaService, @NotNull PleitoService pleitoService, @NotNull ImportacaoPleitoHelper importacaoPleitoHelper, @NotNull CadastrosPleitoService cadastrosPleitoService) {
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)pleitoService, (String)"pleitoService");
        Intrinsics.checkNotNullParameter((Object)importacaoPleitoHelper, (String)"importacaoPleitoHelper");
        Intrinsics.checkNotNullParameter((Object)cadastrosPleitoService, (String)"cadastrosPleitoService");
        super(segurancaService);
        this.coreService = coreService;
        this.segurancaService = segurancaService;
        this.pleitoService = pleitoService;
        this.importacaoPleitoHelper = importacaoPleitoHelper;
        this.cadastrosPleitoService = cadastrosPleitoService;
        Logger logger = LoggerFactory.getLogger(PleitosRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOGGER = logger;
    }

    @Operation(summary="Salva um novo pleito", description="Cria ou atualiza um pleito com suas informa\u00e7\u00f5es relacionadas")
    @ApiResponses(value={@ApiResponse(description="Pleito criado com sucesso", responseCode="201")})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @NotNull
    public Pleito savePleitoPrimeiraFase(@Parameter(description="Dados do pleito a ser salvo", required=true) @RequestBody @Valid @NotNull PleitoPrimeiraFaseDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - savePleitoPrimeiraFase({})", (Object)usuario.getLogin(), (Object)dto);
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Pleito pleito = this.pleitoService.savePleitoPrimeiraFase(dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pleito, (String)"savePleitoPrimeiraFase(...)");
        return pleito;
    }

    @Operation(summary="Salva um novo pleito em sua segunda fase.", description="Salva um novo pleito em sua segunda fase.")
    @ApiResponses(value={@ApiResponse(description="Pleito criado com sucesso", responseCode="201", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pleito.class))})})
    @PutMapping(value={"/{empresa}/{idPleito}"})
    @NotNull
    public ResponseEntity<Pleito> savePleitoSegundaFase(@Parameter(description="Sigla da empresa", required=true) @PathVariable @NotNull String empresa, @Parameter(description="Identificador do pleito", required=true) @PathVariable int idPleito, @Parameter(description="Dados do pleito a ser salvo", required=true) @RequestBody @Valid @NotNull PleitoSegundaFaseDTO dto, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            this.LOGGER.debug("{} - savePleito({})", (Object)usuario.getLogin(), (Object)dto);
            Integer n = usuario.getId();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
            return new ResponseEntity((Object)this.pleitoService.savePleitoSegundaFase(dto, ((Number)n).intValue(), idPleito, empresa), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.savePleito", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{empresa}/import"}, consumes={"multipart/form-data"})
    @Operation(summary="Importa pleitos a partir de um arquivo XLSX", description="Processa o XLSX e persiste os pleitos na base")
    @NotNull
    public ProcessoImportacao importPleitos(@PathVariable(value="empresa") @NotNull String empresa, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            ProcessoImportacao processoImportacao = this.importacaoPleitoHelper.importarPleitos(empresa, file.getInputStream(), usuario.getId());
            Intrinsics.checkNotNullExpressionValue((Object)processoImportacao, (String)"importarPleitos(...)");
            return processoImportacao;
        }
        catch (BusinessException ex) {
            String[] stringArray = new String[]{"%error%", ex.getMessage()};
            throw new ErrorCodeException(ErrorCode.VALIDATION_ERROR, stringArray);
        }
    }

    @Operation(summary="Edita pleito por meio de seu identificador", description="Atualiza um pleito por meio de seu identificador e campos informados.")
    @ApiResponses(value={@ApiResponse(description="Pleito atualizado com sucesso", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pleito.class))})})
    @PutMapping(value={"/{empresa}/{idPleito}/deprecated"})
    @NotNull
    public Pleito updatePleito(@Parameter(description="ID da empresa") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="ID do pleito") @PathVariable(value="idPleito") @NotNull int idPleito, @Parameter(description="Dados atualizados do pleito") @Valid @RequestBody @NotNull UpdatePleitoDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        String ipExterno = this.getIpExterno(request);
        Pleito pleito = this.pleitoService.updatePleito(Integer.valueOf(idPleito), empresa, dto, usuario.getId(), ipExterno);
        Intrinsics.checkNotNullExpressionValue((Object)pleito, (String)"updatePleito(...)");
        return pleito;
    }

    @Operation(summary="Delete pleito por meio de seu identificador", description="ADelete um pleito por meio de seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Pleito deletado com sucesso", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pleito.class))})})
    @DeleteMapping(value={"/{empresa}/{idPleito}"})
    public void deletePleito(@Parameter(description="ID da empresa") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="ID do pleito") @PathVariable(value="idPleito") int idPleito, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.pleitoService.removePleito(Integer.valueOf(idPleito), empresa, usuario.getId());
    }

    @Operation(summary="Recupera um pleito espec\u00edfico", description="Busca e retorna um pleito com base no c\u00f3digo da empresa e ID do pleito")
    @ApiResponses(value={@ApiResponse(description="Pleito encontrado com sucesso", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Pleito.class))})})
    @GetMapping(value={"/{empresa}/{idPleito}"})
    @NotNull
    public ResponseEntity<Pleito> getPleito(@PathVariable @NotNull String empresa, @PathVariable int idPleito, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = idPleito;
        Integer n2 = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getId(...)");
        return new ResponseEntity((Object)this.pleitoService.getPleitoById(empresa, n, ((Number)n2).intValue()), (HttpStatusCode)HttpStatus.OK);
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping
    @Operation(summary="Listagem paginada de pleitos", description="Retorna os Pleitos filtrados conforme os par\u00e2metros informados no payload")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada de pleitos", responseCode="200")})
    @NotNull
    public Page<Pleito> findPleitos(@ParameterObject @NotNull FindPleitosDTO dto, @Parameter(description="Nome do status do pleito") @RequestParam(name="status", required=false) @Nullable String status, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        FindPleitosDTO findPleitosDTO;
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        CharSequence charSequence = status;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && (dto.getIdsStatusPleito() == null || dto.getIdsStatusPleito().isEmpty())) {
            Integer idStatus;
            PleitoStatus status2;
            Object v3;
            block4: {
                void $this$firstOrNull$iv;
                List list = dto.getIdsEmpresa();
                Integer idEmpresa = list != null ? (Integer)CollectionsKt.firstOrNull((List)list) : null;
                List list2 = this.cadastrosPleitoService.findStatusPleito(idEmpresa, status);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"findStatusPleito(...)");
                Iterable iterable = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PleitoStatus it = (PleitoStatus)element$iv;
                    boolean bl = false;
                    if (!StringsKt.equals((String)it.getDescricao(), (String)status, (boolean)true)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            PleitoStatus pleitoStatus = status2 = (PleitoStatus)v3;
            Integer n = idStatus = pleitoStatus != null ? pleitoStatus.getId() : null;
            findPleitosDTO = n != null ? FindPleitosDTOFactory.copyWithStatus((FindPleitosDTO)dto, (Integer)n) : dto;
        } else {
            findPleitosDTO = dto;
        }
        FindPleitosDTO efetivoDto = findPleitosDTO;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Page page = this.pleitoService.findPleitos(efetivoDto, ((Number)n).intValue(), pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findPleitos(...)");
        return page;
    }

    @PostMapping(value={"/{empresaId}/{pleitoId}/anexo"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria\u00e7\u00e3o de anexo de pleito", description="Cria um anexo para o pleito e o arquivo informado")
    @ApiResponses(value={@ApiResponse(description="Retorna o anexo criado", responseCode="201")})
    @NotNull
    public PleitoAnexo createAnexo(@PathVariable(value="empresaId") int empresaId, @PathVariable(value="pleitoId") int pleitoId, @RequestPart @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PleitoAnexo pleitoAnexo = this.pleitoService.createAnexo(empresaId, pleitoId, ((Number)n).intValue(), file);
        Intrinsics.checkNotNullExpressionValue((Object)pleitoAnexo, (String)"createAnexo(...)");
        return pleitoAnexo;
    }

    @GetMapping(value={"/{empresaId}/{pleitoId}/anexo"})
    @Operation(summary="Listagem paginada de anexos de pleito", description="Retorna os Anexos de Pleito do pleito especificado")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada dos anexos de pleito", responseCode="200")})
    @NotNull
    public Page<PleitoAnexo> findAnexos(@PathVariable(value="empresaId") int empresaId, @PathVariable(value="pleitoId") int pleitoId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findAnexos(Integer.valueOf(empresaId), Integer.valueOf(pleitoId), pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexos(...)");
        return page;
    }

    @GetMapping(value={"/anexo"})
    @Operation(summary="Listagem paginada de anexos de pleito baseado no filtro do payload", description="Retorna os Anexos de Pleito filtrados conforme os par\u00e2metros informados no payload")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada dos anexos de pleito", responseCode="200")})
    @NotNull
    public Page<PleitoAnexo> findAnexos(@Valid @ModelAttribute @NotNull FindPleitoAnexosDTO dto, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findAnexos(dto, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findAnexos(...)");
        return page;
    }

    @DeleteMapping(value={"/{empresaId}/{pleitoId}/anexo/{anexoId}"})
    @Operation(summary="Deleta um anexo de pleito", description="Deleta um anexo de pleito existente com base no ID do pleito e ID do anexo")
    @ApiResponses(value={@ApiResponse(description="Anexo deletado com sucesso", responseCode="200")})
    public void deleteAnexo(@PathVariable(value="empresaId") int empresaId, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="anexoId") int anexoId, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = empresaId;
        Integer n2 = pleitoId;
        Integer n3 = anexoId;
        Integer n4 = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"getId(...)");
        this.pleitoService.deleteAnexo(n, n2, n3, ((Number)n4).intValue());
    }

    @PostMapping(value={"/{empresa}/{pleitoId}/historico"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria\u00e7\u00e3o de hist\u00f3rico de pleito", description="Cria um novo hist\u00f3rico para o pleito informado")
    @ApiResponses(value={@ApiResponse(description="Retorna o hist\u00f3rico criado", responseCode="201")})
    @NotNull
    public HistoricoPleito createHistorico(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @Valid @RequestPart(value="historico") @NotNull CreateHistoricoDTO dto, @RequestPart(required=false) @Nullable MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        HistoricoPleito historicoPleito = this.pleitoService.createHistorico(empresaSigla, pleitoId, dto, ((Number)n).intValue(), file);
        Intrinsics.checkNotNullExpressionValue((Object)historicoPleito, (String)"createHistorico(...)");
        return historicoPleito;
    }

    @GetMapping(value={"/{empresa}/{pleitoId}/historico"})
    @Operation(summary="Listagem paginada de hist\u00f3ricos de pleito", description="Retorna os hist\u00f3ricos atrav\u00e9s do id do pleito.")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada de historicos", responseCode="200")})
    @NotNull
    public Page<HistoricoPleito> findHistoricosByPleitoId(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        Page page = this.pleitoService.findHistoricosByPleitoId(empresaSigla, pleitoId, ((Number)n).intValue(), pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findHistoricosByPleitoId(...)");
        return page;
    }

    @PutMapping(value={"/{empresa}/{pleitoId}/historico/{historicoId}"}, consumes={"multipart/form-data"})
    @Operation(summary="Atualiza um hist\u00f3rico de pleito", description="Atualiza um hist\u00f3rico de pleito existente com base no ID do pleito e ID do hist\u00f3rico")
    @ApiResponses(value={@ApiResponse(description="Retorna o hist\u00f3rico atualizado", responseCode="200")})
    @NotNull
    public HistoricoPleito updateHistorico(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="historicoId") int historicoId, @Valid @RequestPart(value="historico") @NotNull UpdateHistoricoDTO dto, @RequestPart(required=false) @Nullable MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        HistoricoPleito historicoPleito = this.pleitoService.updateHistorico(empresaSigla, pleitoId, historicoId, dto, ((Number)n).intValue(), file);
        Intrinsics.checkNotNullExpressionValue((Object)historicoPleito, (String)"updateHistorico(...)");
        return historicoPleito;
    }

    @DeleteMapping(value={"/{empresa}/{pleitoId}/historico/{historicoId}"})
    @Operation(summary="Deleta um hist\u00f3rico de pleito", description="Deleta um hist\u00f3rico de pleito existente com base no ID do pleito e ID do hist\u00f3rico")
    @ApiResponses(value={@ApiResponse(description="Hist\u00f3rico deletado com sucesso", responseCode="200")})
    public void deleteHistorico(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="historicoId") int historicoId, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.pleitoService.deleteHistorico(empresaSigla, pleitoId, historicoId, ((Number)n).intValue());
    }

    @DeleteMapping(value={"/{empresa}/{pleitoId}/historico/{historicoId}/anexo"})
    @Operation(summary="Deleta o anexo de um hist\u00f3rico de pleito", description="Deleta o anexo de um hist\u00f3rico de pleito existente com base no ID do pleito e ID do hist\u00f3rico")
    @ApiResponses(value={@ApiResponse(description="Anexo deletado com sucesso", responseCode="200")})
    public void deleteHistoricoAnexo(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="historicoId") int historicoId, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.pleitoService.deleteHistoricoAnexo(empresaSigla, pleitoId, historicoId, ((Number)n).intValue());
    }

    @GetMapping(value={"/{empresa}/{pleitoId}/itens-contratuais"})
    @Operation(summary="Listagem paginada de itens contratuais associados a um pleito", description="Retorna os itens contratuais associados a um pleito espec\u00edfico")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada de itens contratuais associados ao pleito", responseCode="200")})
    @NotNull
    public Page<PleitoEstruturaContrato> findPleitoItensContratuais(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findPleitoItemContratos(empresaSigla, pleitoId, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findPleitoItemContratos(...)");
        return page;
    }

    @PostMapping(value={"/{empresa}/{pleitoId}/itens-contratuais"})
    @Operation(summary="Cria\u00e7\u00e3o de itens contratuais de pleito", description="Cria um novo item contratual para o pleito informado")
    @ApiResponses(value={@ApiResponse(description="Retorna o item contratual criado", responseCode="201")})
    @NotNull
    public List<PleitoEstruturaContrato> createItemContratual(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @Valid @RequestBody @NotNull CreatePleitoItemContratualDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        List list = this.pleitoService.createPleitoItemContratos(empresaSigla, pleitoId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createPleitoItemContratos(...)");
        return list;
    }

    @DeleteMapping(value={"/{empresa}/{pleitoId}/itens-contratuais/{itemContratualId}"})
    @Operation(summary="Deleta um item contratual de pleito", description="Deleta um item contratual de pleito existente com base no ID do pleito e ID do item contratual")
    @ApiResponses(value={@ApiResponse(description="Item contratual deletado com sucesso", responseCode="200")})
    public void deleteItemContratual(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="itemContratualId") int idItemContratual, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.pleitoService.deletePleitoItemContrato(empresaSigla, pleitoId, idItemContratual, ((Number)n).intValue());
    }

    @GetMapping(value={"/{empresa}/{pleitoId}/rodovias"})
    @Operation(summary="Listagem paginada de rodovias associadas a um pleito", description="Retorna as rodovias associadas a um pleito espec\u00edfico")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada de rodovias associadas ao pleito", responseCode="200")})
    @NotNull
    public Page<PleitoRodovia> findPleitoRodovias(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findPleitoRodovias(empresaSigla, pleitoId, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findPleitoRodovias(...)");
        return page;
    }

    @PostMapping(value={"/{empresa}/{pleitoId}/rodovias"})
    @Operation(summary="Associa uma rodovia a um pleito", description="Associa uma rodovia a um pleito")
    @ApiResponses(value={@ApiResponse(description="Retorna a associa\u00e7\u00e3o criada", responseCode="201")})
    @NotNull
    public PleitoRodovia createPleitoRodovia(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @Valid @RequestBody @NotNull CreatePleitoRodoviaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PleitoRodovia pleitoRodovia = this.pleitoService.createPleitoRodovia(empresaSigla, pleitoId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pleitoRodovia, (String)"createPleitoRodovia(...)");
        return pleitoRodovia;
    }

    @PutMapping(value={"/{empresa}/{pleitoId}/rodovias/{idPleitoRodovia}"})
    @Operation(summary="Atualiza uma associa\u00e7\u00e3o de rodovia a um pleito", description="Atualiza uma associa\u00e7\u00e3o de rodovia a um pleito")
    @ApiResponses(value={@ApiResponse(description="Associa\u00e7\u00e3o de rodovia atualizada com sucesso", responseCode="200")})
    @NotNull
    public PleitoRodovia updatePleitoRodovia(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="idPleitoRodovia") int idPleitoRodovia, @Valid @RequestBody @NotNull UpdatePleitoRodoviaDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PleitoRodovia pleitoRodovia = this.pleitoService.updatePleitoRodovia(empresaSigla, pleitoId, idPleitoRodovia, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pleitoRodovia, (String)"updatePleitoRodovia(...)");
        return pleitoRodovia;
    }

    @DeleteMapping(value={"/{empresa}/{pleitoId}/rodovias/{idPleitoRodovia}"})
    @Operation(summary="Desassocia uma rodovia de um pleito", description="Desassocia uma rodovia de um pleito")
    @ApiResponses(value={@ApiResponse(description="Rodovia desassociada com sucesso", responseCode="200")})
    public void deletePleitoRodovia(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @PathVariable(value="idPleitoRodovia") int idPleitoRodovia, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.pleitoService.deletePleitoRodovia(empresaSigla, pleitoId, idPleitoRodovia, ((Number)n).intValue());
    }

    @PostMapping(value={"/{empresa}/{pleitoId}/iniciar"})
    @Operation(summary="Iniciar fluxo de aprova\u00e7\u00e3o de Pleitos", description="Iniciar fluxo de aprova\u00e7\u00e3o de Pleitos")
    @ApiResponses(value={@ApiResponse(description="Fluxo iniciado com sucesso", responseCode="200")})
    public void iniciarAprovacao(@PathVariable(value="empresa") @NotNull String empresa, @PathVariable(value="pleitoId") int pleitoId, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        this.pleitoService.iniciarAprovacao(empresa, pleitoId, ((Number)n).intValue());
    }

    @GetMapping(value={"/{empresa}/{pleitoId}/logs"})
    @Operation(summary="Listagem paginada de logs de pleito", description="Retorna os logs associados a um pleito espec\u00edfico")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista paginada de logs associados ao pleito", responseCode="200")})
    @NotNull
    public Page<PleitoLog> findPleitoLogs(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findLogsByPleito(empresaSigla, pleitoId, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findLogsByPleito(...)");
        return page;
    }

    @PostMapping(value={"/{empresa}/{pleitoId}/logs"})
    @Operation(summary="Cria\u00e7\u00e3o de logs de pleito", description="Cria um novo log para o pleito informado")
    @ApiResponses(value={@ApiResponse(description="Retorna o log criado", responseCode="201")})
    @NotNull
    public PleitoLog createLog(@PathVariable(value="empresa") @NotNull String empresaSigla, @PathVariable(value="pleitoId") int pleitoId, @Valid @RequestBody @NotNull CreatePleitoLogDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresaSigla, (String)"empresaSigla");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PleitoLog pleitoLog = this.pleitoService.createLog(empresaSigla, pleitoId, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pleitoLog, (String)"createLog(...)");
        return pleitoLog;
    }

    @GetMapping(value={"/demandantes/{id}"})
    @Operation(summary="Busca um demandante por ID", description="Retorna um demandante espec\u00edfico com base no ID informado")
    @ApiResponses(value={@ApiResponse(description="Retorna o demandante encontrado", responseCode="200"), @ApiResponse(description="Demandante n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public PleitoDemandante findDemandanteById(@PathVariable(value="id") int id) {
        PleitoDemandante pleitoDemandante = this.pleitoService.findDemandanteById(id);
        Intrinsics.checkNotNullExpressionValue((Object)pleitoDemandante, (String)"findDemandanteById(...)");
        return pleitoDemandante;
    }

    @GetMapping(value={"/demandantes"})
    @Operation(summary="Listagem de todos os demandantes", description="Retorna todos os demandantes cadastrados no sistema")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista de demandantes", responseCode="200")})
    @NotNull
    public Page<PleitoDemandante> findDemandantes(@RequestParam(value="search", required=false) @Nullable String nome, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.pleitoService.findDemandantes(nome, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findDemandantes(...)");
        return page;
    }

    @GetMapping(value={"/demandantes/autocomplete"})
    @Operation(summary="Autocomplete de demandantes", description="Retorna uma lista de demandantes filtrados pelo nome informado")
    @ApiResponses(value={@ApiResponse(description="Retorna a lista de demandantes filtrados", responseCode="200")})
    @NotNull
    public List<String> demandanteAutocomplete(@RequestParam(value="nome", required=false) @Nullable String nome) {
        List list = this.pleitoService.demandanteAutocomplete(nome);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"demandanteAutocomplete(...)");
        return list;
    }

    @PostMapping(value={"/demandantes"})
    @Operation(summary="Cria\u00e7\u00e3o de um novo demandante", description="Cria um novo demandante no sistema")
    @ApiResponses(value={@ApiResponse(description="Demandante criado com sucesso", responseCode="201")})
    @NotNull
    public PleitoDemandante createDemandante(@Valid @RequestBody @NotNull SaveDemandanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        PleitoDemandante pleitoDemandante = this.pleitoService.createDemandante(dto, usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)pleitoDemandante, (String)"createDemandante(...)");
        return pleitoDemandante;
    }

    @PutMapping(value={"/demandantes/{id}"})
    @Operation(summary="Atualiza\u00e7\u00e3o de um demandante", description="Atualiza um demandante existente no sistema")
    @ApiResponses(value={@ApiResponse(description="Demandante atualizado com sucesso", responseCode="200"), @ApiResponse(description="Demandante n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public PleitoDemandante updateDemandante(@PathVariable(value="id") int id, @Valid @RequestBody @NotNull SaveDemandanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        Integer n = usuario.getId();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
        PleitoDemandante pleitoDemandante = this.pleitoService.updateDemandante(id, dto, ((Number)n).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)pleitoDemandante, (String)"updateDemandante(...)");
        return pleitoDemandante;
    }

    @DeleteMapping(value={"/demandantes/{id}"})
    @Operation(summary="Dele\u00e7\u00e3o de um demandante", description="Deleta um demandante existente no sistema")
    @ApiResponses(value={@ApiResponse(description="Demandante deletado com sucesso", responseCode="200"), @ApiResponse(description="Demandante n\u00e3o encontrado", responseCode="404")})
    public void deleteDemandante(@PathVariable(value="id") int id) {
        this.pleitoService.deleteDemandante(id);
    }

    @GetMapping(value={"/dashboard"})
    @Operation(summary="Dashboard de Pleitos", description="Retorna informa\u00e7\u00f5es resumidas sobre os pleitos")
    @ApiResponses(value={@ApiResponse(description="Retorna o dashboard de pleitos", responseCode="200")})
    @NotNull
    public PleitoDashboardDTO getDashboard(@NotNull GetPleitoDashboardDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PleitoDashboardDTO pleitoDashboardDTO = this.pleitoService.getDashboardData(dto);
        Intrinsics.checkNotNullExpressionValue((Object)pleitoDashboardDTO, (String)"getDashboardData(...)");
        return pleitoDashboardDTO;
    }

    @GetMapping(value={"/relatorios/dashboard"})
    @Operation(summary="Efetua o download do relat\u00f3rio do dashboard com dados dos processos", description="Realiza o download de uma planilha em formato XLS com dados agregados dos processos. ")
    @ApiResponses(value={@ApiResponse(description="Relat\u00f3rio do dashboard gerado com sucesso", responseCode="200")})
    @ResponseBody
    @Transactional(readOnly=true)
    @NotNull
    public ResponseEntity<byte[]> downloadRelatorioDashboard(@ParameterObject @NotNull FindPleitosDTO dto, @NotNull Pageable pageable, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.LOGGER.debug("Gerando relat\u00f3rio dashboard");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            RelatorioProcessosExcel relatorio = new RelatorioProcessosExcel();
            Integer n = usuario.getId();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getId(...)");
            Page processosPages = this.pleitoService.findPleitos(dto, ((Number)n).intValue(), pageable);
            List processos = processosPages.get().toList();
            byte[] reportBytes = relatorio.executeXLS(processos, null);
            if (reportBytes == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Arquivo f\u00edsico n\u00e3o foi encontrado, imposs\u00edvel prosseguir.");
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            headers.add("Content-Disposition", "attachment; filename=\"relatorio_dashboard_processos.xlsx\"");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            int reportLen = reportBytes.length;
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)reportLen).body((Object)reportBytes);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }
}

