/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.core.beans.geral.Empresa;
import br.gov.antt.sgctt.core.beans.geral.TipoEmpresa;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.dto.licencas.CondicionanteDocumentoPaginationDTO;
import br.gov.antt.sgctt.core.dto.licencas.CondicionanteNotaDTO;
import br.gov.antt.sgctt.core.dto.licencas.CondicionantePaginationDTO;
import br.gov.antt.sgctt.core.dto.licencas.CreateCondicionanteDTO;
import br.gov.antt.sgctt.core.dto.licencas.CreatePlanoAcaoCondicionanteDTO;
import br.gov.antt.sgctt.core.dto.licencas.DashboardLicencasDTO;
import br.gov.antt.sgctt.core.dto.licencas.EditLicencaDTO;
import br.gov.antt.sgctt.core.dto.licencas.EditPlanoAcaoCondicionanteDTO;
import br.gov.antt.sgctt.core.dto.licencas.FiltroLicencaDashboardDTO;
import br.gov.antt.sgctt.core.dto.licencas.FindLicencasDTO;
import br.gov.antt.sgctt.exceptions.BusinessException;
import br.gov.antt.sgctt.licencas.Condicionante;
import br.gov.antt.sgctt.licencas.CondicionanteDocumento;
import br.gov.antt.sgctt.licencas.CondicionanteNota;
import br.gov.antt.sgctt.licencas.Licenca;
import br.gov.antt.sgctt.licencas.LicencaDocumento;
import br.gov.antt.sgctt.licencas.LicencaNota;
import br.gov.antt.sgctt.licencas.LicencaObra;
import br.gov.antt.sgctt.licencas.LicencaObraVO;
import br.gov.antt.sgctt.licencas.PlanoAcaoCondicionante;
import br.gov.antt.sgctt.licencas.PlanoAcaoCondicionanteDocumento;
import br.gov.antt.sgctt.licencas.StatusLicenca;
import br.gov.antt.sgctt.reports.RelatorioLicencasExcel;
import br.gov.antt.sgctt.services.CoreService;
import br.gov.antt.sgctt.services.DashboardLicencasService;
import br.gov.antt.sgctt.services.Exceptions.ErrorCode;
import br.gov.antt.sgctt.services.Exceptions.ErrorCodeException;
import br.gov.antt.sgctt.services.LicencaService;
import br.gov.antt.sgctt.services.SegurancaService;
import br.gov.antt.sgctt.services.importacao.ImportacaoLicencaService;
import br.gov.antt.sgctt.services.importacao.importers.condicionantes.ImportacaoCondicionanteService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.beans.PropertyEditor;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Tag(name="licencas v1", description="REST Services para Licen\u00e7as Ambientais v1")
@Validated
@RestController
@RequestMapping(value={"/api/v1/licencas"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J(\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\n\b\u0001\u0010\u001c\u001a\u0004\u0018\u00010\u0017H\u0017J\u0012\u0010\u001d\u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\u0017H\u0017J\u0012\u0010 \u001a\u00020\u001e2\b\b\u0001\u0010\u001f\u001a\u00020\u0017H\u0017J4\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\b\u0001\u0010$\u001a\u00020%2\n\b\u0001\u0010&\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0017J \u0010)\u001a\b\u0012\u0004\u0012\u00020#0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,H\u0017J \u0010-\u001a\b\u0012\u0004\u0012\u00020#0*2\b\b\u0001\u0010.\u001a\u00020#2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J*\u0010/\u001a\b\u0012\u0004\u0012\u00020#0*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010$\u001a\u0002002\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J'\u00101\u001a\b\u0012\u0004\u0012\u0002020*2\n\b\u0001\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017\u00a2\u0006\u0002\u00103J*\u00104\u001a\b\u0012\u0004\u0012\u0002050*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u00106\u001a\u000205H\u0017J4\u00107\u001a\b\u0012\u0004\u0012\u0002050*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u00108\u001a\u00020,2\b\b\u0001\u00106\u001a\u000205H\u0017J:\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002050\"0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\n\b\u0001\u0010:\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020(H\u0017J*\u0010;\u001a\b\u0012\u0004\u0012\u0002050*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u00108\u001a\u00020,H\u0017J*\u0010<\u001a\b\u0012\u0004\u0012\u0002020*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u00108\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J.\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0\"0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(H\u0017J*\u0010?\u001a\b\u0012\u0004\u0012\u00020>0*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J-\u0010@\u001a\u00020\u00132\n\b\u0001\u0010+\u001a\u0004\u0018\u00010,2\n\b\u0001\u0010A\u001a\u0004\u0018\u00010,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017\u00a2\u0006\u0002\u0010BJ:\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0\"0*2\b\b\u0001\u0010+\u001a\u00020,2\n\b\u0001\u0010:\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0017J$\u0010E\u001a\u00020D2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,H\u0017J*\u0010G\u001a\b\u0012\u0004\u0012\u00020H0*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010$\u001a\u00020I2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J4\u0010J\u001a\b\u0012\u0004\u0012\u00020H0*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010$\u001a\u00020I2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J*\u0010K\u001a\b\u0012\u0004\u0012\u0002020*2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010+\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017JD\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020M0\"0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\n\b\u0001\u0010:\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020(H\u0017J4\u0010N\u001a\b\u0012\u0004\u0012\u00020M0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u00108\u001a\u00020,H\u0017J6\u0010O\u001a\b\u0012\u0004\u0012\u00020M0*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\n\b\u0001\u0010P\u001a\u0004\u0018\u00010M2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J4\u0010Q\u001a\b\u0012\u0004\u0012\u0002020*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u00108\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J>\u0010R\u001a\b\u0012\u0004\u0012\u00020M0*2\b\b\u0001\u0010$\u001a\u00020S2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u00108\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017JD\u0010T\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020U0\"0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\n\b\u0001\u0010:\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020(H\u0017J4\u0010V\u001a\b\u0012\u0004\u0012\u00020U0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010W\u001a\u00020,H\u0017J*\u0010X\u001a\b\u0012\u0004\u0012\u00020U0*2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010$\u001a\u00020Y2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J4\u0010Z\u001a\b\u0012\u0004\u0012\u00020U0*2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010W\u001a\u00020,2\b\b\u0001\u0010$\u001a\u00020[2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J4\u0010\\\u001a\b\u0012\u0004\u0012\u0002020*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010W\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J>\u0010]\u001a\b\u0012\u0004\u0012\u00020^0*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010W\u001a\u00020,2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J<\u0010_\u001a\b\u0012\u0004\u0012\u00020^0\"2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010W\u001a\u00020,2\u0006\u0010'\u001a\u00020(H\u0017J>\u0010`\u001a\b\u0012\u0004\u0012\u0002020*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010W\u001a\u00020,2\b\b\u0001\u0010a\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J8\u0010b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020c0\"0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\u0006\u0010'\u001a\u00020(H\u0017J4\u0010d\u001a\b\u0012\u0004\u0012\u00020e0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010A\u001a\u00020,H\u0017J4\u0010f\u001a\b\u0012\u0004\u0012\u00020e0*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J4\u0010g\u001a\b\u0012\u0004\u0012\u0002020*2\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010F\u001a\u00020,2\b\b\u0001\u0010A\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J.\u0010h\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020i0\"0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(H\u0017J*\u0010j\u001a\b\u0012\u0004\u0012\u00020i0*2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010+\u001a\u00020,2\b\b\u0001\u0010k\u001a\u00020,H\u0017J\"\u0010l\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001020*2\b\b\u0001\u0010m\u001a\u00020n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J3\u0010o\u001a\b\u0012\u0004\u0012\u0002020*2\n\b\u0001\u0010+\u001a\u0004\u0018\u00010,2\n\b\u0001\u0010p\u001a\u0004\u0018\u00010,2\u0006\u0010\u0018\u001a\u00020\u0019H\u0017\u00a2\u0006\u0002\u0010qJB\u0010r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0\"0*2\n\b\u0001\u0010&\u001a\u0004\u0018\u00010\u00172\u0010\b\u0001\u0010s\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(H\u0017J4\u0010u\u001a\b\u0012\u0004\u0012\u00020v0*2\u0010\b\u0001\u0010w\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010t2\n\b\u0001\u0010x\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0018\u0010y\u001a\b\u0012\u0004\u0012\u00020z0*2\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0017JY\u0010{\u001a\b\u0012\u0004\u0012\u00020z0*2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\n\b\u0001\u0010:\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010|\u001a\u0004\u0018\u00010,2\n\b\u0001\u0010}\u001a\u0004\u0018\u00010\u00172\n\b\u0001\u0010~\u001a\u0004\u0018\u00010,2\n\b\u0001\u0010&\u001a\u0004\u0018\u00010,H\u0017\u00a2\u0006\u0002\u0010\u007fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0080\u0001"}, d2={"Lbr/gov/antt/sgctt/apis/LicencasRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "coreService", "Lbr/gov/antt/sgctt/services/CoreService;", "licencaService", "Lbr/gov/antt/sgctt/services/LicencaService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "importacaoLicencaService", "Lbr/gov/antt/sgctt/services/importacao/ImportacaoLicencaService;", "importacaoCondicionanteService", "Lbr/gov/antt/sgctt/services/importacao/importers/condicionantes/ImportacaoCondicionanteService;", "dashboardLicencasService", "Lbr/gov/antt/sgctt/services/DashboardLicencasService;", "<init>", "(Lbr/gov/antt/sgctt/services/CoreService;Lbr/gov/antt/sgctt/services/LicencaService;Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/importacao/ImportacaoLicencaService;Lbr/gov/antt/sgctt/services/importacao/importers/condicionantes/ImportacaoCondicionanteService;Lbr/gov/antt/sgctt/services/DashboardLicencasService;)V", "LOGGER", "Lorg/slf4j/Logger;", "initBinder", "", "binder", "Lorg/springframework/web/bind/WebDataBinder;", "importItensPER", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "file", "Lorg/springframework/web/multipart/MultipartFile;", "planilha", "getImportacaoProgress", "Lorg/springframework/web/servlet/mvc/method/annotation/SseEmitter;", "jobId", "getCondicionanteImportacaoProgress", "findLicencas", "Lorg/springframework/data/domain/Page;", "Lbr/gov/antt/sgctt/licencas/Licenca;", "dto", "Lbr/gov/antt/sgctt/core/dto/licencas/FindLicencasDTO;", "status", "pageable", "Lorg/springframework/data/domain/Pageable;", "getLicenca", "Lorg/springframework/http/ResponseEntity;", "idLicenca", "", "saveLicenca", "licenca", "editLicenca", "Lbr/gov/antt/sgctt/core/dto/licencas/EditLicencaDTO;", "deleteLicenca", "", "(Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "createNotasLicenca", "Lbr/gov/antt/sgctt/licencas/LicencaNota;", "nota", "editNotasLicenca", "idNota", "getNotasLicenca", "search", "getLicencaNota", "deleteLicencaNota", "findDocumentosByLicenca", "Lbr/gov/antt/sgctt/licencas/LicencaDocumento;", "saveDocumentoByLicenca", "removeDocumentoLicenca", "seqArquivo", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)V", "findCondicionantesByLicenca", "Lbr/gov/antt/sgctt/core/dto/licencas/CondicionantePaginationDTO;", "getCondicionanteById", "idCondicionante", "saveCondicionanteByLicenca", "Lbr/gov/antt/sgctt/licencas/Condicionante;", "Lbr/gov/antt/sgctt/core/dto/licencas/CreateCondicionanteDTO;", "editCondicionanteByLicenca", "deleteCondicionanteByLicenca", "findCondicionanteNota", "Lbr/gov/antt/sgctt/licencas/CondicionanteNota;", "getCondicionanteNota", "saveCondicionanteNota", "condicionanteNota", "deleteCondicionanteNota", "editCondicionanteNota", "Lbr/gov/antt/sgctt/core/dto/licencas/CondicionanteNotaDTO;", "findPlanosAcao", "Lbr/gov/antt/sgctt/licencas/PlanoAcaoCondicionante;", "getPlanoAcaoById", "idPlanoAcao", "savePlanoAcao", "Lbr/gov/antt/sgctt/core/dto/licencas/CreatePlanoAcaoCondicionanteDTO;", "editPlanoAcao", "Lbr/gov/antt/sgctt/core/dto/licencas/EditPlanoAcaoCondicionanteDTO;", "deletePlanoAcao", "savePlanoAcaoCondicionanteDocumento", "Lbr/gov/antt/sgctt/licencas/PlanoAcaoCondicionanteDocumento;", "findDocumentosByPlanoAcao", "removeDocumentoPlanoAcao", "seqAnexo", "findDocumentosByCondicionante", "Lbr/gov/antt/sgctt/core/dto/licencas/CondicionanteDocumentoPaginationDTO;", "getDocumentoBySeq", "Lbr/gov/antt/sgctt/licencas/CondicionanteDocumento;", "saveCondicionanteDocumento", "removeDocumento", "findObrasByLicenca", "Lbr/gov/antt/sgctt/licencas/LicencaObra;", "getLicencaObraById", "idObra", "saveLicencaObra", "licencaObra", "Lbr/gov/antt/sgctt/licencas/LicencaObraVO;", "deleteLicencaObra", "sequencia", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljakarta/servlet/http/HttpServletRequest;)Lorg/springframework/http/ResponseEntity;", "findCondicionantesWithFilters", "idsEmpresas", "", "dashboardLicencasCondicionantes", "Lbr/gov/antt/sgctt/core/dto/licencas/DashboardLicencasDTO;", "idsEmpresa", "tipo", "downloadRelatorioDashboard", "", "downloadRelatorioConsulta", "idEntidade", "nroProcesso", "tipoLicenca", "(Ljakarta/servlet/http/HttpServletRequest;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/springframework/http/ResponseEntity;", "server"})
@SourceDebugExtension(value={"SMAP\nLicencasRestServices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicencasRestServices.kt\nbr/gov/antt/sgctt/apis/LicencasRestServices\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1757:1\n774#2:1758\n865#2,2:1759\n1557#2:1761\n1628#2,3:1762\n*S KotlinDebug\n*F\n+ 1 LicencasRestServices.kt\nbr/gov/antt/sgctt/apis/LicencasRestServices\n*L\n196#1:1758\n196#1:1759,2\n197#1:1761\n197#1:1762,3\n*E\n"})
public class LicencasRestServices
extends BaseRestService {
    @Nullable
    private final CoreService coreService;
    @NotNull
    private final LicencaService licencaService;
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final ImportacaoLicencaService importacaoLicencaService;
    @NotNull
    private final ImportacaoCondicionanteService importacaoCondicionanteService;
    @NotNull
    private final DashboardLicencasService dashboardLicencasService;
    @NotNull
    private final Logger LOGGER;

    public LicencasRestServices(@Nullable CoreService coreService, @NotNull LicencaService licencaService, @NotNull SegurancaService segurancaService, @NotNull ImportacaoLicencaService importacaoLicencaService, @NotNull ImportacaoCondicionanteService importacaoCondicionanteService, @NotNull DashboardLicencasService dashboardLicencasService) {
        Intrinsics.checkNotNullParameter((Object)licencaService, (String)"licencaService");
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)importacaoLicencaService, (String)"importacaoLicencaService");
        Intrinsics.checkNotNullParameter((Object)importacaoCondicionanteService, (String)"importacaoCondicionanteService");
        Intrinsics.checkNotNullParameter((Object)dashboardLicencasService, (String)"dashboardLicencasService");
        super(segurancaService);
        this.coreService = coreService;
        this.licencaService = licencaService;
        this.segurancaService = segurancaService;
        this.importacaoLicencaService = importacaoLicencaService;
        this.importacaoCondicionanteService = importacaoCondicionanteService;
        this.dashboardLicencasService = dashboardLicencasService;
        Logger logger = LoggerFactory.getLogger(LicencasRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOGGER = logger;
    }

    @InitBinder
    public void initBinder(@NotNull WebDataBinder binder) {
        Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
        binder.registerCustomEditor(Integer.class, "status", (PropertyEditor)new /* Unavailable Anonymous Inner Class!! */);
    }

    @PostMapping(value={"/importacao"}, consumes={"multipart/form-data"})
    @Operation(summary="Realizar importa\u00e7\u00e3o de planilha com Licen\u00e7as.", description="Realizar importa\u00e7\u00e3o de planilha com com Licen\u00e7as.")
    @ApiResponses(value={@ApiResponse(description="Opera\u00e7\u00e3o realizada com sucesso", responseCode="200")})
    @NotNull
    public String importItensPER(@Parameter(hidden=true) @NotNull HttpServletRequest request, @RequestPart(value="file") @NotNull MultipartFile file, @RequestPart(value="planilha", required=false) @Nullable String planilha) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        String string = this.licencaService.callImportacao(file.getInputStream(), usuario.getId(), planilha);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"callImportacao(...)");
        return string;
    }

    @GetMapping(value={"/import/progress/{jobId}"}, produces={"text/event-stream"})
    @Operation(summary="Verificar progresso da importa\u00e7\u00e3o de Licen\u00e7as", description="Retorna o progresso da importa\u00e7\u00e3o de Licen\u00e7as em tempo real")
    @ApiResponses(value={@ApiResponse(description="Progresso da importa\u00e7\u00e3o retornado com sucesso", responseCode="200"), @ApiResponse(description="Job de importa\u00e7\u00e3o n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public SseEmitter getImportacaoProgress(@PathVariable(value="jobId") @NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        SseEmitter sseEmitter = this.importacaoLicencaService.registerProgressListener(jobId);
        Intrinsics.checkNotNullExpressionValue((Object)sseEmitter, (String)"registerProgressListener(...)");
        return sseEmitter;
    }

    @GetMapping(value={"/condicionantes/import/progress/{jobId}"}, produces={"text/event-stream"})
    @Operation(summary="Verificar progresso da importa\u00e7\u00e3o de Licen\u00e7as", description="Retorna o progresso da importa\u00e7\u00e3o de Licen\u00e7as em tempo real")
    @ApiResponses(value={@ApiResponse(description="Progresso da importa\u00e7\u00e3o retornado com sucesso", responseCode="200"), @ApiResponse(description="Job de importa\u00e7\u00e3o n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public SseEmitter getCondicionanteImportacaoProgress(@PathVariable(value="jobId") @NotNull String jobId) {
        Intrinsics.checkNotNullParameter((Object)jobId, (String)"jobId");
        SseEmitter sseEmitter = this.importacaoCondicionanteService.registerProgressListener(jobId);
        Intrinsics.checkNotNullExpressionValue((Object)sseEmitter, (String)"registerProgressListener(...)");
        return sseEmitter;
    }

    /*
     * WARNING - void declaration
     */
    @GetMapping
    @Operation(summary="Consulta paginada de Licencas")
    @NotNull
    public Page<Licenca> findLicencas(@ParameterObject @Valid @NotNull FindLicencasDTO dto, @Parameter(description="Nome do status ou per\u00edodo de renova\u00e7\u00e3o (ex: Vigente, Vencidas, At\u00e9 30 dias, 60 dias, 120 dias, >120 dias)") @RequestParam(name="status", required=false) @Nullable String status, @NotNull HttpServletRequest request, @NotNull Pageable pageable) {
        FindLicencasDTO findLicencasDTO;
        block25: {
            block23: {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
                this.LOGGER.debug("API getLicencasPaginated...");
                PublicUser publicUser = this.getUsuarioByJWT(request);
                if (publicUser == null) {
                    throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
                }
                PublicUser usuario = publicUser;
                this.LOGGER.debug("{} - getLicenca()", (Object)usuario);
                CharSequence charSequence = status;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || dto.status() != null) break block23;
                LocalDate hoje = LocalDate.now();
                switch (((Object)StringsKt.trim((CharSequence)status)).toString()) {
                    case "Vencidas": {
                        findLicencasDTO = new FindLicencasDTO(dto.empresas(), dto.search(), dto.idEntidade(), dto.nroProcesso(), dto.tipoLicenca(), hoje.minusYears(10L), hoje.minusDays(1L), Integer.valueOf(2), null, dto.tipoLicencaId());
                        break;
                    }
                    case "At\u00e9 30 dias": {
                        findLicencasDTO = new FindLicencasDTO(dto.empresas(), dto.search(), dto.idEntidade(), dto.nroProcesso(), dto.tipoLicenca(), hoje, hoje.plusDays(30L), Integer.valueOf(2), null, dto.tipoLicencaId());
                        break;
                    }
                    case "60 dias": {
                        findLicencasDTO = new FindLicencasDTO(dto.empresas(), dto.search(), dto.idEntidade(), dto.nroProcesso(), dto.tipoLicenca(), hoje.plusDays(30L), hoje.plusDays(60L), Integer.valueOf(2), null, dto.tipoLicencaId());
                        break;
                    }
                    case "120 dias": {
                        findLicencasDTO = new FindLicencasDTO(dto.empresas(), dto.search(), dto.idEntidade(), dto.nroProcesso(), dto.tipoLicenca(), hoje.plusDays(60L), hoje.plusDays(120L), Integer.valueOf(2), null, dto.tipoLicencaId());
                        break;
                    }
                    case ">120 dias": {
                        findLicencasDTO = new FindLicencasDTO(dto.empresas(), dto.search(), dto.idEntidade(), dto.nroProcesso(), dto.tipoLicenca(), hoje.plusDays(120L), hoje.plusYears(100L), Integer.valueOf(2), null, dto.tipoLicencaId());
                        break;
                    }
                    default: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        StatusLicenca it;
                        void $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        List list = this.licencaService.findStatus(status);
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findStatus(...)");
                        Iterable iterable = list;
                        boolean $i$f$filter = false;
                        void var12_10 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            it = (StatusLicenca)element$iv$iv;
                            boolean bl = false;
                            if (!StringsKt.equals((String)it.getDescricao(), (String)status, (boolean)true)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (StatusLicenca)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getId());
                        }
                        List ids = (List)destination$iv$iv;
                        Integer idStatus = (Integer)CollectionsKt.firstOrNull((List)ids);
                        if (idStatus != null) {
                            findLicencasDTO = new FindLicencasDTO(dto.empresas(), dto.search(), dto.idEntidade(), dto.nroProcesso(), dto.tipoLicenca(), dto.datInicial(), dto.datFinal(), dto.tipoIntervalo(), idStatus, dto.tipoLicencaId());
                            break;
                        }
                        findLicencasDTO = dto;
                        break;
                    }
                }
                break block25;
            }
            findLicencasDTO = dto;
        }
        FindLicencasDTO efetivoDto = findLicencasDTO;
        Page resultado = this.licencaService.findLicencas(efetivoDto, pageable);
        Intrinsics.checkNotNull((Object)resultado);
        return resultado;
    }

    @GetMapping(value={"/{idLicenca}"})
    @Operation(summary="Carrega dados da licen\u00e7a de acordo com o ID da licen\u00e7a")
    @NotNull
    public ResponseEntity<Licenca> getLicenca(@NotNull HttpServletRequest request, @PathVariable int idLicenca) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.LOGGER.debug("API getLicenca...");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - getLicenca()", (Object)usuario);
        Licenca licenca = this.licencaService.getLicencaById(Integer.valueOf(idLicenca));
        if (licenca == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Licen\u00e7a n\u00e3o encontrada.");
        }
        Licenca lic = licenca;
        lic.setEmpresa(null);
        return new ResponseEntity((Object)lic, (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping
    @Operation(summary="Salva a Licen\u00e7a")
    @NotNull
    public ResponseEntity<Licenca> saveLicenca(@RequestBody @NotNull Licenca licenca, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)licenca, (String)"licenca");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        CoreService coreService = this.coreService;
        Intrinsics.checkNotNull((Object)coreService);
        Empresa empresa = coreService.getEmpresaById(licenca.getIdEmpresa());
        if (empresa == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        Empresa emp = empresa;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        return new ResponseEntity((Object)this.licencaService.saveLicenca(licenca, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{idLicenca}"})
    @Operation(summary="Edita a Licen\u00e7a")
    @NotNull
    public ResponseEntity<Licenca> editLicenca(@PathVariable(value="idLicenca") int idLicenca, @Valid @RequestBody @NotNull EditLicencaDTO dto, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        CoreService coreService = this.coreService;
        Intrinsics.checkNotNull((Object)coreService);
        Empresa empresa = coreService.getEmpresaById(dto.idEmpresa());
        if (empresa == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Empresa n\u00e3o foi encontrada.");
        }
        Empresa emp = empresa;
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        PublicUser publicUser2 = segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            Object[] objectArray = new Object[]{usuario, emp.getSigla(), dto};
            this.LOGGER.debug("{} - saveLicenca ({}, {}))", objectArray);
            return new ResponseEntity((Object)this.licencaService.editLicenca(dto, usr.getId(), Integer.valueOf(idLicenca)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}"})
    @Operation(summary="Exclui a Licen\u00e7a atrav\u00e9s de seu identificador")
    @NotNull
    public ResponseEntity<Boolean> deleteLicenca(@PathVariable(name="idLicenca") @Nullable Integer idLicenca, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - deleteLicenca({})", (Object)usuario, (Object)idLicenca);
        try {
            return new ResponseEntity((Object)this.licencaService.deleteLicenca(idLicenca, this.getIpExterno(request)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/notas"})
    @Operation(summary="Cria uma nota de acordo com o identificador da Licen\u00e7a")
    @NotNull
    public ResponseEntity<LicencaNota> createNotasLicenca(@NotNull HttpServletRequest request, @PathVariable int idLicenca, @RequestBody @NotNull LicencaNota nota) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)nota, (String)"nota");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - createNotasLicenca({})", (Object)usuario, (Object)idLicenca);
        try {
            return new ResponseEntity((Object)this.licencaService.saveNotaLicenca(Integer.valueOf(idLicenca), usuario.getId(), nota), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findfindLicencaNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PutMapping(value={"/{idLicenca}/notas/{idNota}"})
    @Operation(summary="Cria uma nota de acordo com o identificador da Licen\u00e7a")
    @NotNull
    public ResponseEntity<LicencaNota> editNotasLicenca(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idNota") int idNota, @RequestBody @NotNull LicencaNota nota) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)nota, (String)"nota");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - createNotasLicenca({})", (Object)usuario, (Object)idLicenca);
        try {
            return new ResponseEntity((Object)this.licencaService.editNotaLicenca(Integer.valueOf(idLicenca), Integer.valueOf(idNota), usuario.getId(), nota), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findfindLicencaNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/notas"})
    @Operation(summary="Consulta as notas de acordo com o identificador da Licen\u00e7a")
    @NotNull
    public ResponseEntity<Page<LicencaNota>> getNotasLicenca(@NotNull HttpServletRequest request, @PathVariable int idLicenca, @RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findLicencaNota({})", (Object)usuario, (Object)idLicenca);
        try {
            Page page = this.licencaService.getNotasLicenca(Integer.valueOf(idLicenca), search, pageable);
            if (page == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Notas n\u00e3o encontrado.");
            }
            Page notas = page;
            return new ResponseEntity((Object)notas, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findfindLicencaNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/notas/{idNota}"})
    @Operation(summary="Carrega os dados da nota de acordo com o ID da Licen\u00e7a e da Nota.")
    @NotNull
    public ResponseEntity<LicencaNota> getLicencaNota(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idNota") int idNota) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.LOGGER.debug("API getLicencaNota...");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            LicencaNota licencaNota = this.licencaService.getLicencaNota(Integer.valueOf(idLicenca), Integer.valueOf(idNota));
            if (licencaNota == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Nota da Condicionante n\u00e3o encontrada.");
            }
            LicencaNota not = licencaNota;
            this.LOGGER.debug("{} - getLicencaNota()", (Object)usuario);
            return new ResponseEntity((Object)not, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.getLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.getLicencaNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/notas/{idNota}"})
    @Operation(summary="Exclui a Nota de uma Licen\u00e7a por meio de seu identificador.")
    @NotNull
    public ResponseEntity<Boolean> deleteLicencaNota(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idNota") int idNota, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - deleteLicencaNota({})", (Object)usuario, (Object)idNota);
            this.licencaService.deleteLicencaNota(Integer.valueOf(idLicenca), Integer.valueOf(idNota));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteLicencaNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/documentos"})
    @Operation(summary="Consulta paginada de anexos pertencentes \u00e0 Licen\u00e7a.", description="Consulta os anexos pertencentes \u00e0 Licen\u00e7a de acordo com o identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Retorna os anexos da Licen\u00e7a cujo identificador foi enviado.", responseCode="200")})
    @NotNull
    public ResponseEntity<Page<LicencaDocumento>> findDocumentosByLicenca(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findDocumentosByLicenca()", (Object)usuario);
        return new ResponseEntity((Object)this.licencaService.findDocumentosByLicenca(Integer.valueOf(idLicenca), pageable), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(path={"/{idLicenca}/documentos"}, consumes={"multipart/form-data"})
    @Operation(summary="Cria\u00e7\u00e3o de anexo em Licen\u00e7a.", description="Cria um anexo para a Licen\u00e7a, utilizando o arquivo enviado.")
    @ApiResponses(value={@ApiResponse(description="Retorna o anexo criado.", responseCode="201")})
    @NotNull
    public ResponseEntity<LicencaDocumento> saveDocumentoByLicenca(@PathVariable(value="idLicenca") int idLicenca, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - saveDocumentoByLicenca())", (Object)usuario);
            return new ResponseEntity((Object)this.licencaService.registraUploadAnexoLicenca(file, Integer.valueOf(idLicenca), usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/documentos/{seqArquivo}"})
    @Operation(summary="Exclui o Documento atrav\u00e9s de seu identificador")
    public void removeDocumentoLicenca(@PathVariable @Nullable Integer idLicenca, @PathVariable @Nullable Integer seqArquivo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - deleteDocumento({})", (Object)usuario, (Object)seqArquivo);
        this.licencaService.removeDocumentoLicenca(idLicenca, seqArquivo, usuario.getId(), null);
    }

    @GetMapping(value={"/{idLicenca}/condicionantes"})
    @Operation(summary="Consulta paginada de Condicionantes de acordo com a Licen\u00e7a.", description="Realiza consulta paginada de Condicionantes, de acordo com o identificador de Licen\u00e7a enviado.")
    @ApiResponses(value={@ApiResponse(description="Retorna as condicionantes da Licen\u00e7a.", responseCode="200"), @ApiResponse(description="Licen\u00e7a n\u00e3o encontrada de acordo com identificador informado.", responseCode="404")})
    @NotNull
    public ResponseEntity<Page<CondicionantePaginationDTO>> findCondicionantesByLicenca(@PathVariable(value="idLicenca") int idLicenca, @RequestParam(value="search", required=false) @Nullable String search, @NotNull HttpServletRequest request, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findCondicionantesByLicenca()", (Object)usuario);
        try {
            return new ResponseEntity((Object)this.licencaService.findCondicionantesByLicenca(Integer.valueOf(idLicenca), search, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findCondicionantesByLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findCondicionantesByLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}"})
    @Operation(summary="Consulta Condicionante de acordo com o identificador de Licen\u00e7a e seu pr\u00f3prio identificador.", description="Realiza consulta de Condicionante por meio do identificador de Licen\u00e7a e seu pr\u00f3prio identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna a condicionante.", responseCode="200"), @ApiResponse(description="Condicionante n\u00e3o encontrada de acordo com identificador informado.", responseCode="404")})
    @NotNull
    public CondicionantePaginationDTO getCondicionanteById(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - getCondicionanteById()", (Object)usuario);
        CondicionantePaginationDTO condicionantePaginationDTO = this.licencaService.getCondicionanteById(Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca));
        Intrinsics.checkNotNullExpressionValue((Object)condicionantePaginationDTO, (String)"getCondicionanteById(...)");
        return condicionantePaginationDTO;
    }

    @PostMapping(value={"/{idLicenca}/condicionantes"})
    @Operation(summary="Cria uma Condicionante de acordo com os atributos enviados.", description="Realiza a cria\u00e7\u00e3o de uma Condicionante por meio dos atributos enviados em payload.")
    @ApiResponses(value={@ApiResponse(description="Retorna a condicionante.", responseCode="201"), @ApiResponse(description="Houve um erro ao criar uma Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<Condicionante> saveCondicionanteByLicenca(@PathVariable(value="idLicenca") int idLicenca, @Valid @RequestBody @NotNull CreateCondicionanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - saveCondicionanteByLicenca ({}))", (Object)usuario, (Object)dto);
            return new ResponseEntity((Object)this.licencaService.saveCondicionante(dto, Integer.valueOf(idLicenca), usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}"})
    @Operation(summary="Edita uma Condicionante de acordo com os atributos enviados.", description="Realiza a edi\u00e7\u00e3o de uma Condicionante por meio dos atributos enviados em payload.")
    @ApiResponses(value={@ApiResponse(description="Retorna a condicionante editada.", responseCode="201"), @ApiResponse(description="Houve um erro ao editar uma Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<Condicionante> editCondicionanteByLicenca(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @Valid @RequestBody @NotNull CreateCondicionanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ErrorCodeException(ErrorCode.USER_UNAUTHORIZED, new String[0]);
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - saveCondicionanteByLicenca ({}))", (Object)usuario, (Object)dto);
            return new ResponseEntity((Object)this.licencaService.editCondicionante(dto, Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), usuario.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}"})
    @Operation(summary="Deleta uma condicionante de acordo com seu identificador.", description="Deleta uma condicionante de acordo com o identificador informado na URL.")
    @ApiResponses(value={@ApiResponse(description="Deleta a condicionante.", responseCode="200"), @ApiResponse(description="Houve um erro ao deletar uma Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> deleteCondicionanteByLicenca(@PathVariable(name="idCondicionante") int idCondicionante, @PathVariable(name="idLicenca") int idLicenca, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - deleteCondicionanteByLicenca({}, {})", (Object)usuario, (Object)idCondicionante);
        try {
            return new ResponseEntity((Object)this.licencaService.deleteCondicionante(Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/notas"})
    @Operation(summary="Consulta paginada de notas de uma Condicionante.", description="Realiza consulta paginada de notas de uma Condicionante de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna pagina\u00e7\u00e3o de notas de Condicionante", responseCode="200"), @ApiResponse(description="Houve um erro ao buscar as notas da Condicionante informada.", responseCode="400")})
    @NotNull
    public ResponseEntity<Page<CondicionanteNota>> findCondicionanteNota(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findCondicionanteNota()", (Object)usuario);
        try {
            return new ResponseEntity((Object)this.licencaService.findCondicionanteNota(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), search, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findCondicionanteNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/notas/{idNota}"})
    @Operation(summary="Consulta de nota de uma Condicionante de acordo com seu identificador.", description="Realiza consulta de nota de uma Condicionante de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Retorna uma nota espec\u00edfica de Condicionante", responseCode="200"), @ApiResponse(description="Houve um erro ao buscar a notas de Condicionante com o identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<CondicionanteNota> getCondicionanteNota(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idNota") int idNota) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.LOGGER.debug("API getCondicionanteNota...");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            this.LOGGER.debug("{} - getCondicionanteNota()", (Object)usuario);
            return new ResponseEntity((Object)this.licencaService.getCondicionanteNota(Integer.valueOf(idCondicionante), Integer.valueOf(idNota), Integer.valueOf(idLicenca)), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.getCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.getCondicionanteNota", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/notas"})
    @Operation(summary="Cria nota de uma Condicionante.", description="Realiza o cadastro de nota de uma Condicionante.")
    @ApiResponses(value={@ApiResponse(description="Retorna uma nota de Condicionante", responseCode="200"), @ApiResponse(description="Houve um erro ao criar nota de Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<CondicionanteNota> saveCondicionanteNota(@PathVariable(name="idLicenca") int idLicenca, @PathVariable(name="idCondicionante") int idCondicionante, @RequestBody @Nullable CondicionanteNota condicionanteNota, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - saveCondicionanteNota ({}, {}))", (Object)usuario, (Object)condicionanteNota);
            return new ResponseEntity((Object)this.licencaService.saveCondicionanteNota(condicionanteNota, Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/notas/{idNota}"})
    @Operation(summary="Exclui nota de Condicionante.", description="Deleta nota de uma Condicionante de acordo com seu identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Nota de Condicionante deletada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao deletar Nota de Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> deleteCondicionanteNota(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idNota") int idNota, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - deleteCondicionanteNota({}, {})", (Object)usuario, (Object)idNota);
            this.licencaService.deleteCondicionanteNota(Integer.valueOf(idCondicionante), Integer.valueOf(idNota), Integer.valueOf(idLicenca));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/notas/{idNota}"})
    @Operation(summary="Edi\u00e7\u00e3o de nota de Condicionante.", description="Edi\u00e7\u00e3o de nota de Condicionante.")
    @ApiResponses(value={@ApiResponse(description="Nota de Condicionante editada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao editar Nota de Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<CondicionanteNota> editCondicionanteNota(@RequestBody @NotNull CondicionanteNotaDTO dto, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idNota") int idNota, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - deleteCondicionanteNota({}, {})", (Object)usuario, (Object)idNota);
            return new ResponseEntity((Object)this.licencaService.editCondicionanteNota(dto, Integer.valueOf(idCondicionante), Integer.valueOf(idNota), Integer.valueOf(idLicenca), usuario.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteCondicionanteNota", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao"})
    @Operation(summary="Consulta paginada de Planos de A\u00e7\u00e3o de uma Condicionante.", description="Realiza consulta paginada de Planos de A\u00e7\u00e3o de uma Condicionante de acordo com seu identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Consulta de Planos de A\u00e7\u00e3o realizada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao consultar os Planos de A\u00e7\u00e3o de uma Condicionante.", responseCode="400")})
    @NotNull
    public ResponseEntity<Page<PlanoAcaoCondicionante>> findPlanosAcao(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @RequestParam(value="search", required=false) @Nullable String search, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        if (this.getUsuarioByJWT(request) == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        this.LOGGER.debug("findPlanosAcao ({})", (Object)idCondicionante);
        try {
            return new ResponseEntity((Object)this.licencaService.findPlanosAcao(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), search, pageable), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findPlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findPlanoAcaoCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}"})
    @Operation(summary="Consulta de Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza consulta de Plano de A\u00e7\u00e3o de uma Condicionante de acordo com seu identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Plano de A\u00e7\u00e3o encontrado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao consultar o Plano de A\u00e7\u00e3o com o identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<PlanoAcaoCondicionante> getPlanoAcaoById(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            if (this.getUsuarioByJWT(request) == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PlanoAcaoCondicionante planoAcaoCondicionante = this.licencaService.getPlanoAcaoById(Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca));
            if (planoAcaoCondicionante == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Plano de A\u00e7\u00e3o n\u00e3o encontrada.");
            }
            PlanoAcaoCondicionante plano = planoAcaoCondicionante;
            return new ResponseEntity((Object)plano, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.getPlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.getPlanoAcaoCondicionante", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao"})
    @Operation(summary="Salva Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza cadastro de Plano de A\u00e7\u00e3o de uma Condicionante de acordo com payload informado.")
    @ApiResponses(value={@ApiResponse(description="Plano de A\u00e7\u00e3o criado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao criar o Plano de A\u00e7\u00e3o com o payload informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<PlanoAcaoCondicionante> savePlanoAcao(@PathVariable(value="idCondicionante") int idCondicionante, @RequestBody @NotNull CreatePlanoAcaoCondicionanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        PublicUser publicUser2 = segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.LOGGER.debug("{} - savePlanoAcaoCondicionante ({}))", (Object)usuario, (Object)dto);
            return new ResponseEntity((Object)this.licencaService.savePlanoAcao(dto, Integer.valueOf(idCondicionante), usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.savePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PutMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}"})
    @Operation(summary="Edita Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza edi\u00e7\u00e3o de Plano de A\u00e7\u00e3o de uma Condicionante de acordo com payload informado.")
    @ApiResponses(value={@ApiResponse(description="Plano de A\u00e7\u00e3o editado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao editar o Plano de A\u00e7\u00e3o com o payload informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<PlanoAcaoCondicionante> editPlanoAcao(@PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao, @RequestBody @NotNull EditPlanoAcaoCondicionanteDTO dto, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        PublicUser publicUser2 = segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.LOGGER.debug("{} - editPlanoAcaoCondicionante ({}))", (Object)usuario, (Object)dto);
            return new ResponseEntity((Object)this.licencaService.editPlanoAcao(dto, Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), usr.getId()), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.savePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}"})
    @Operation(summary="Exclui Plano de A\u00e7\u00e3o de uma Condicionante.", description="Exclui Plano de A\u00e7\u00e3o de uma Condicionante de acordo com identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Plano de A\u00e7\u00e3o deletado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao deletar o Plano de A\u00e7\u00e3o com o identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> deletePlanoAcao(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - deletePlanoAcao({})", (Object)usuario, (Object)idPlanoAcao);
            this.licencaService.deletePlanoAcao(Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deletePlanoAcaoCondicionante", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}/documentos"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva o documento de um Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza cadastro de documento pertencente \u00e0 um Plano de A\u00e7\u00e3o de uma Condicionante de acordo com identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Documento do Plano de A\u00e7\u00e3o criado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao criar o Documento do Plano de A\u00e7\u00e3o com o identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<PlanoAcaoCondicionanteDocumento> savePlanoAcaoCondicionanteDocumento(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser usuario = this.getUsuarioByJWT(request);
        if (usuario == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        SegurancaService segurancaService = this.segurancaService;
        Intrinsics.checkNotNull((Object)segurancaService);
        PublicUser publicUser = segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser;
        try {
            this.LOGGER.debug("{} - savePlanoAcaoCondicionanteDocumento ())", (Object)usuario);
            return new ResponseEntity((Object)this.licencaService.registraUploadAnexoPlanoAcao(file, Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca), usuario.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}/documentos"})
    @Operation(summary="Consulta os documentos de um Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza consulta de documentos pertencentes a um Plano de A\u00e7\u00e3o de uma Condicionante de acordo com identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Consulta de Documentos do Plano de A\u00e7\u00e3o criado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao consultar os Documentos do Plano de A\u00e7\u00e3o com o identificador informado.", responseCode="400")})
    @NotNull
    public Page<PlanoAcaoCondicionanteDocumento> findDocumentosByPlanoAcao(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findDocumentosByPlanoAcao()", (Object)usuario);
        try {
            Page page = this.licencaService.findDocumentosByPlanoAcao(Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca), pageable);
            Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findDocumentosByPlanoAcao(...)");
            return page;
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findDocumentosByPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findDocumentosByPlanoAcao", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/planosAcao/{idPlanoAcao}/documentos/{seqAnexo}"})
    @Operation(summary="Deleta o documento de um Plano de A\u00e7\u00e3o de uma Condicionante.", description="Realiza dele\u00e7\u00e3o de documento pertencente a um Plano de A\u00e7\u00e3o de uma Condicionante de acordo com identificador informado.")
    @ApiResponses(value={@ApiResponse(description="Dele\u00e7\u00e3o de Documento do Plano de A\u00e7\u00e3o realizado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao deletar o Documento do Plano de A\u00e7\u00e3o com o identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> removeDocumentoPlanoAcao(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="idPlanoAcao") int idPlanoAcao, @PathVariable(value="seqAnexo") int seqAnexo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.licencaService.removeDocumentoPlanoAcao(Integer.valueOf(idPlanoAcao), Integer.valueOf(idCondicionante), Integer.valueOf(idLicenca), Integer.valueOf(seqAnexo), usuario.getId(), this.getIpExterno(request));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.removeDocumentoPlanoAcao", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/documentos"})
    @Operation(summary="Consulta os documentos de uma Condicionante.", description="Consulta os documentos de uma Condicionante de acordo com seu identificador.")
    @ApiResponses(value={@ApiResponse(description="Consulta de documentos de Condicionante realizada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao realizar consulta de documentos de Condicionante com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Page<CondicionanteDocumentoPaginationDTO>> findDocumentosByCondicionante(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findDocumentosByCondicionante()", (Object)usuario);
        try {
            Page page = this.licencaService.findDocumentosByCondicionante(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), pageable);
            if (page == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Condicionante n\u00e3o encontrado.");
            }
            Page documentos = page;
            return new ResponseEntity((Object)documentos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findCondicionanteDocumento", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/documentos/{seqArquivo}"})
    @Operation(summary="Consulta o documento de uma Condicionante de acordo com seu identificador.", description="Consulta o documento de uma Condicionante de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Consulta de documento de Condicionante realizado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao realizar consulta de documento de Condicionante com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<CondicionanteDocumento> getDocumentoBySeq(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="seqArquivo") int seqArquivo) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            CondicionanteDocumento doc = this.licencaService.getCondicionanteDocumentoBySeq(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), Integer.valueOf(seqArquivo));
            this.LOGGER.debug("{} - getDocumentoBySeq()", (Object)usuario);
            return new ResponseEntity((Object)doc, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.getCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.getCondicionanteDocumento", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/documentos"}, consumes={"multipart/form-data"})
    @Operation(summary="Salva o documento de uma Condicionante de acordo com seu identificador.", description="Salva o documento de uma Condicionante de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Documento de Condicionante criado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao criar documento de Condicionante com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<CondicionanteDocumento> saveCondicionanteDocumento(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @RequestPart(value="file") @NotNull MultipartFile file, @NotNull HttpServletRequest request) {
        PublicUser usuario;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = usuario = this.getUsuarioByJWT(request);
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(publicUser != null ? publicUser.getLogin() : null);
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            return new ResponseEntity((Object)this.licencaService.registraUploadAnexoCondicionante(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), file, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/condicionantes/{idCondicionante}/documentos/{seqArquivo}"})
    @Operation(summary="Exclui o documento de uma Condicionante de acordo com seu identificador.", description="Exclui o documento de uma Condicionante de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Documento de Condicionante deletado com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao deletar documento de Condicionante com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> removeDocumento(@PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idCondicionante") int idCondicionante, @PathVariable(value="seqArquivo") int seqArquivo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            this.LOGGER.debug("{} - deleteDocumento({})", (Object)usuario, (Object)seqArquivo);
            this.licencaService.removeDocumento(Integer.valueOf(idLicenca), Integer.valueOf(idCondicionante), Integer.valueOf(seqArquivo), usuario.getId(), this.getIpExterno(request));
            return new ResponseEntity((Object)true, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteCondicionanteDocumento", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/obras"})
    @Operation(summary="Consulta obras de uma Licen\u00e7a de acordo com seu identificador.", description="Consulta obras de uma Licen\u00e7a de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Obras da Licen\u00e7a consultadas com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao consultar Obras de Licen\u00e7a com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Page<LicencaObra>> findObrasByLicenca(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - findObrasByLicenca()", (Object)usuario);
        try {
            Page obras = this.licencaService.findObrasByLicenca(Integer.valueOf(idLicenca), pageable);
            return new ResponseEntity((Object)obras, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.findObrasByLicenca", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.findObrasByLicenca", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/{idLicenca}/obras/{idObra}"})
    @Operation(summary="Consulta obra de uma Licen\u00e7a de acordo com seu identificador.", description="Consulta obra de uma Licen\u00e7a de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Obra da Licen\u00e7a consultada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao consultar Obra de Licen\u00e7a com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<LicencaObra> getLicencaObraById(@NotNull HttpServletRequest request, @PathVariable(value="idLicenca") int idLicenca, @PathVariable(value="idObra") int idObra) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            PublicUser publicUser = this.getUsuarioByJWT(request);
            if (publicUser == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
            }
            PublicUser usuario = publicUser;
            LicencaObra licencaObra = this.licencaService.getLicencaObraById(Integer.valueOf(idLicenca), Integer.valueOf(idObra));
            if (licencaObra == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Obra n\u00e3o encontrada.");
            }
            LicencaObra doc = licencaObra;
            this.LOGGER.debug("{} - getLicencaObraById()", (Object)usuario);
            return new ResponseEntity((Object)doc, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.getObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOGGER.error("Exception.getObra", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @PostMapping(value={"/{idLicenca}/obras"})
    @Operation(summary="Cria Obra de uma Licen\u00e7a de acordo com seu identificador.", description="Cria Obra de uma Licen\u00e7a de acordo com seu identificador espec\u00edficado na URL.")
    @ApiResponses(value={@ApiResponse(description="Obra de Licen\u00e7a criada com sucesso.", responseCode="200"), @ApiResponse(description="Houve um erro ao criar Obra de Licen\u00e7a com identificador informado.", responseCode="400")})
    @NotNull
    public ResponseEntity<Boolean> saveLicencaObra(@RequestBody @NotNull LicencaObraVO licencaObra, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)licencaObra, (String)"licencaObra");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        PublicUser publicUser2 = this.segurancaService.getUsuarioByLogin(usuario.getLogin());
        if (publicUser2 == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio n\u00e3o encontrado para o Login informado.");
        }
        PublicUser usr = publicUser2;
        try {
            this.LOGGER.debug("{} - saveLicencaObra ({}))", (Object)usuario, (Object)licencaObra);
            return new ResponseEntity((Object)this.licencaService.saveLicencaObra(licencaObra, usr.getId()), (HttpStatusCode)HttpStatus.CREATED);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.saveObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @DeleteMapping(value={"/{idLicenca}/obras/{seqObra}"})
    @Operation(summary="Exclui a obra atrav\u00e9s de seu identificador")
    @NotNull
    public ResponseEntity<Boolean> deleteLicencaObra(@PathVariable(name="idLicenca") @Nullable Integer idLicenca, @PathVariable(name="seqObra") @Nullable Integer sequencia, @NotNull HttpServletRequest request) throws BusinessException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.LOGGER.debug("{} - deleteLicencaObra({})", (Object)usuario, (Object)idLicenca);
        try {
            return new ResponseEntity((Object)this.licencaService.deleteLicencaObra(idLicenca, sequencia), (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("BizExc.deleteLicencaObra", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/condicionantes"})
    @Operation(summary="Consulta paginada de condicionantes com filtros", description="Retorna condicionantes filtradas por status e empresa")
    @ApiResponses(value={@ApiResponse(description="Condicionantes consultadas com sucesso", responseCode="200"), @ApiResponse(description="Erro ao processar consulta", responseCode="400")})
    @NotNull
    public ResponseEntity<Page<CondicionantePaginationDTO>> findCondicionantesWithFilters(@RequestParam(value="status", required=false) @Nullable String status, @RequestParam(value="idEmpresa", required=false) @Nullable List<Integer> idsEmpresas, @NotNull HttpServletRequest request, @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{usuario, status, idsEmpresas};
        this.LOGGER.debug("{} - findCondicionantesWithFilters(status={}, idEmpresa={})", objectArray);
        try {
            Page condicionantes = this.licencaService.findCondicionantesWithFilters(status, idsEmpresas, pageable);
            return new ResponseEntity((Object)condicionantes, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception exc) {
            this.LOGGER.error("Erro ao buscar condicionantes", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/dashboard"})
    @Operation(summary="Consulta dashboard de licen\u00e7as e condicionantes", description="Retorna dashboard totais e por status de licen\u00e7as e condicionantes filtradas por empresa e tipo")
    @ApiResponses(value={@ApiResponse(description="Dashboard consultada com sucesso", responseCode="200"), @ApiResponse(description="Erro ao processar consulta", responseCode="400")})
    @NotNull
    public ResponseEntity<DashboardLicencasDTO> dashboardLicencasCondicionantes(@RequestParam(value="idsEmpresa", required=false) @Nullable List<Integer> idsEmpresa, @RequestParam(value="tipo", required=false) @Nullable String tipo, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Object[] objectArray = new Object[]{usuario, idsEmpresa, tipo};
        this.LOGGER.debug("{} - dashboardLicencasCondicionantes(empresas={}, tipo={})", objectArray);
        try {
            FiltroLicencaDashboardDTO filtro = new FiltroLicencaDashboardDTO(idsEmpresa, tipo);
            DashboardLicencasDTO quantidades = this.dashboardLicencasService.obterQuantidades(filtro);
            return new ResponseEntity((Object)quantidades, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception exc) {
            this.LOGGER.error("Erro ao obter dashboard", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }

    @GetMapping(value={"/relatoriosDashboard"})
    @Operation(summary="Efetua o download do relat\u00f3rio do dashboard com dados por status e condicionantes", description="Realiza o download de uma planilha em formato XLS com dados agregados por status e condicionantes. ")
    @ApiResponses(value={@ApiResponse(description="Relat\u00f3rio do dashboard gerado com sucesso", responseCode="200")})
    @ResponseBody
    @Transactional(readOnly=true)
    @NotNull
    public ResponseEntity<byte[]> downloadRelatorioDashboard(@Parameter(hidden=true) @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.LOGGER.debug("Gerando relat\u00f3rio dashboard");
        try {
            CoreService coreService = this.coreService;
            Intrinsics.checkNotNull((Object)coreService);
            List empresasDB = coreService.findEmpresas(null, TipoEmpresa.CONCESSIONARIA);
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            for (Empresa emp : empresasDB) {
                empresasInt.add(emp.getId());
            }
            RelatorioLicencasExcel relatorio = new RelatorioLicencasExcel();
            List condicionantes = this.licencaService.findCondicionantes((List)empresasInt, null, null, null, null, null, null, null);
            byte[] reportBytes = relatorio.executeXLS(condicionantes, null);
            if (reportBytes == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Arquivo f\u00edsico n\u00e3o foi encontrado, imposs\u00edvel prosseguir.");
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            headers.add("Content-Disposition", "attachment; filename=\"relatorio_dashboard_licencas.xlsx\"");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            int reportLen = reportBytes.length;
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)reportLen).body((Object)reportBytes);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    @GetMapping(value={"/relatoriosConsulta"})
    @Operation(summary="Efetua o download do relat\u00f3rio de consulta com dados detalhados das licen\u00e7as", description="Realiza o download de uma planilha em formato XLS com dados detalhados das licen\u00e7as (n\u00famero, empresa, descri\u00e7\u00e3o, etc). ")
    @ApiResponses(value={@ApiResponse(description="Relat\u00f3rio de consulta gerado com sucesso", responseCode="200")})
    @ResponseBody
    @Transactional(readOnly=true)
    @NotNull
    public ResponseEntity<byte[]> downloadRelatorioConsulta(@Parameter(hidden=true) @NotNull HttpServletRequest request, @Parameter(description="Filtro de busca") @RequestParam(name="search", required=false) @Nullable String search, @Parameter(description="ID da entidade") @RequestParam(name="idEntidade", required=false) @Nullable Integer idEntidade, @Parameter(description="N\u00famero do processo") @RequestParam(name="nroProcesso", required=false) @Nullable String nroProcesso, @Parameter(description="Tipo de licen\u00e7a") @RequestParam(name="tipoLicenca", required=false) @Nullable Integer tipoLicenca, @Parameter(description="Status da licen\u00e7a") @RequestParam(name="status", required=false) @Nullable Integer status) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.LOGGER.debug("Gerando relat\u00f3rio consulta");
        try {
            CoreService coreService = this.coreService;
            Intrinsics.checkNotNull((Object)coreService);
            List empresasDB = coreService.findEmpresas(null, TipoEmpresa.CONCESSIONARIA);
            ArrayList<Integer> empresasInt = new ArrayList<Integer>();
            for (Empresa emp : empresasDB) {
                empresasInt.add(emp.getId());
            }
            RelatorioLicencasExcel relatorio = new RelatorioLicencasExcel();
            List condicionantes = this.licencaService.findCondicionantes((List)empresasInt, search, idEntidade, nroProcesso, tipoLicenca, null, null, status);
            byte[] reportBytes = relatorio.executeXLS(condicionantes, null);
            if (reportBytes == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Arquivo f\u00edsico n\u00e3o foi encontrado, imposs\u00edvel prosseguir.");
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
            headers.add("Content-Type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            headers.add("Content-Disposition", "attachment; filename=\"relatorio_consulta_licencas.xlsx\"");
            headers.add("Pragma", "no-cache");
            headers.add("Expires", "0");
            int reportLen = reportBytes.length;
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)reportLen).body((Object)reportBytes);
            Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
            return responseEntity;
        }
        catch (BusinessException bizExc) {
            this.LOGGER.error("bizExc", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
    }

    public static final /* synthetic */ LicencaService access$getLicencaService$p(LicencasRestServices $this) {
        return $this.licencaService;
    }
}

