/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.beans.Anexo;
import br.gov.antt.sgctt.core.beans.geral.Empresa;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.exceptions.BusinessException;
import br.gov.antt.sgctt.services.CoreService;
import br.gov.antt.sgctt.services.GedService;
import br.gov.antt.sgctt.services.SegurancaService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJF\u0010\f\u001a\u0014\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000e\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u00132\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lbr/gov/antt/sgctt/apis/GedRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "coreService", "Lbr/gov/antt/sgctt/services/CoreService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "gedService", "Lbr/gov/antt/sgctt/services/GedService;", "<init>", "(Lbr/gov/antt/sgctt/services/CoreService;Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/GedService;)V", "LOG", "Lorg/slf4j/Logger;", "findArquivos", "Lorg/springframework/http/ResponseEntity;", "", "Lbr/gov/antt/sgctt/beans/Anexo;", "request", "Ljakarta/servlet/http/HttpServletRequest;", "empresa", "", "search", "modulo", "server"})
public class GedRestServices
extends BaseRestService {
    @NotNull
    private final CoreService coreService;
    @NotNull
    private final SegurancaService segurancaService;
    @NotNull
    private final GedService gedService;
    @NotNull
    private final Logger LOG;

    public GedRestServices(@NotNull CoreService coreService, @NotNull SegurancaService segurancaService, @NotNull GedService gedService) {
        Intrinsics.checkNotNullParameter((Object)coreService, (String)"coreService");
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)gedService, (String)"gedService");
        super(segurancaService);
        this.coreService = coreService;
        this.segurancaService = segurancaService;
        this.gedService = gedService;
        Logger logger = LoggerFactory.getLogger(GedRestServices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.LOG = logger;
    }

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta os anexos, de acordo com os filtros informados")
    @ResponseBody
    @Nullable
    public final ResponseEntity<List<Anexo>> findArquivos(@NotNull HttpServletRequest request, @PathVariable(name="empresa") @Nullable String empresa, @RequestParam(name="search", required=false) @Nullable String search, @RequestParam(name="modulo", required=false) @Nullable String modulo) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        try {
            LocalDate dataInicial = null;
            LocalDate dataFinal = null;
            DateTimeFormatter dateFmt = DateTimeFormatter.ISO_LOCAL_DATE;
            String parmVal = request.getParameter("dataInicial");
            if (parmVal != null && !(((CharSequence)parmVal).length() == 0)) {
                dataInicial = LocalDate.parse(parmVal, dateFmt);
            }
            if ((parmVal = request.getParameter("dataFinal")) != null && !(((CharSequence)parmVal).length() == 0)) {
                dataFinal = LocalDate.parse(parmVal, dateFmt);
            }
            Object[] objectArray = new Object[]{empresa, search, dataInicial, dataFinal};
            this.LOG.debug("API search (empresa={},search={},datIni={},datFim={})...", objectArray);
            if ((search == null || ((CharSequence)search).length() == 0) && dataInicial == null && dataFinal == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Informe o crit\u00e9rio de busca (Palavra-chave, intervalo busca, ...).");
            }
            Empresa emp = this.coreService.getEmpresaBySigla(empresa);
            LocalDate dataIni = null;
            LocalDate dataFim = null;
            List areas = null;
            List docs = this.gedService.fullSearch(emp.getId(), search, dataIni, dataFim, modulo, Integer.valueOf(100), areas);
            ArrayList<Anexo> anexos = new ArrayList<Anexo>();
            for (Anexo anexo : docs) {
                anexo.setId(null);
                anexo.setErroGed(null);
                anexo.setNroErrosGed(null);
                anexo.setRepoPath(null);
                anexos.add(anexo);
            }
            return new ResponseEntity(anexos, (HttpStatusCode)HttpStatus.OK);
        }
        catch (BusinessException bizExc) {
            this.LOG.error("BizExc.search", (Throwable)bizExc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, bizExc.getMessage());
        }
        catch (Exception exc) {
            this.LOG.error("Exception.search", (Throwable)exc);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, exc.getMessage());
        }
    }
}

