/*
 * Decompiled with CFR 0.152.
 */
package br.gov.antt.sgctt.apis;

import br.gov.antt.sgctt.apis.BaseRestService;
import br.gov.antt.sgctt.core.beans.mail.Email;
import br.gov.antt.sgctt.core.beans.seguranca.PublicUser;
import br.gov.antt.sgctt.core.dto.geral.email.EmailDTO;
import br.gov.antt.sgctt.core.dto.geral.email.FindEmailsDTO;
import br.gov.antt.sgctt.core.dto.geral.email.UpdateEmailDTO;
import br.gov.antt.sgctt.services.SegurancaService;
import br.gov.antt.sgctt.services.email.EmailQueueProcessor;
import br.gov.antt.sgctt.services.email.EmailSenderService;
import br.gov.antt.sgctt.services.email.EmailService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/v1/emails"})
@Validated
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0017J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00192\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\u001dH\u0017J&\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u001a\u001a\u00020!H\u0017J$\u0010\"\u001a\u00020#2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0017J\u0010\u0010&\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0017J$\u0010'\u001a\u00020 2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lbr/gov/antt/sgctt/apis/EmailRestServices;", "Lbr/gov/antt/sgctt/apis/BaseRestService;", "segurancaService", "Lbr/gov/antt/sgctt/services/SegurancaService;", "emailService", "Lbr/gov/antt/sgctt/services/email/EmailService;", "emailSenderService", "Lbr/gov/antt/sgctt/services/email/EmailSenderService;", "emailQueueProcessor", "Lbr/gov/antt/sgctt/services/email/EmailQueueProcessor;", "<init>", "(Lbr/gov/antt/sgctt/services/SegurancaService;Lbr/gov/antt/sgctt/services/email/EmailService;Lbr/gov/antt/sgctt/services/email/EmailSenderService;Lbr/gov/antt/sgctt/services/email/EmailQueueProcessor;)V", "getEmailService", "()Lbr/gov/antt/sgctt/services/email/EmailService;", "getEmailSenderService", "()Lbr/gov/antt/sgctt/services/email/EmailSenderService;", "getEmailQueueProcessor", "()Lbr/gov/antt/sgctt/services/email/EmailQueueProcessor;", "findEmailById", "Lbr/gov/antt/sgctt/core/dto/geral/email/EmailDTO;", "empresa", "", "idEmail", "", "findAllEmails", "Lorg/springframework/data/domain/Page;", "dto", "Lbr/gov/antt/sgctt/core/dto/geral/email/FindEmailsDTO;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findEmails", "updateEmail", "Lbr/gov/antt/sgctt/core/beans/mail/Email;", "Lbr/gov/antt/sgctt/core/dto/geral/email/UpdateEmailDTO;", "sendEmail", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "processEmailQueue", "cancelEmail", "server"})
public class EmailRestServices
extends BaseRestService {
    @NotNull
    private final EmailService emailService;
    @NotNull
    private final EmailSenderService emailSenderService;
    @NotNull
    private final EmailQueueProcessor emailQueueProcessor;

    public EmailRestServices(@NotNull SegurancaService segurancaService, @NotNull EmailService emailService, @NotNull EmailSenderService emailSenderService, @NotNull EmailQueueProcessor emailQueueProcessor) {
        Intrinsics.checkNotNullParameter((Object)segurancaService, (String)"segurancaService");
        Intrinsics.checkNotNullParameter((Object)emailService, (String)"emailService");
        Intrinsics.checkNotNullParameter((Object)emailSenderService, (String)"emailSenderService");
        Intrinsics.checkNotNullParameter((Object)emailQueueProcessor, (String)"emailQueueProcessor");
        super(segurancaService);
        this.emailService = emailService;
        this.emailSenderService = emailSenderService;
        this.emailQueueProcessor = emailQueueProcessor;
    }

    @NotNull
    public EmailService getEmailService() {
        return this.emailService;
    }

    @NotNull
    public EmailSenderService getEmailSenderService() {
        return this.emailSenderService;
    }

    @NotNull
    public EmailQueueProcessor getEmailQueueProcessor() {
        return this.emailQueueProcessor;
    }

    @GetMapping(value={"/{empresa}/{id}"})
    @Operation(summary="Consulta de email por ID", description="Retorna os detalhes de um email espec\u00edfico com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Email encontrado com sucesso", responseCode="200"), @ApiResponse(description="Email n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public EmailDTO findEmailById(@Parameter(description="Sigla da empresa") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="ID do email a ser consultado") @PathVariable(value="id") int idEmail) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        EmailDTO emailDTO = this.getEmailService().findEmailById(empresa, idEmail);
        Intrinsics.checkNotNullExpressionValue((Object)emailDTO, (String)"findEmailById(...)");
        return emailDTO;
    }

    @GetMapping
    @Operation(summary="Consulta de emails", description="Retorna uma lista de emails com base nos crit\u00e9rios de pesquisa fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Lista de emails retornada com sucesso", responseCode="200")})
    @NotNull
    public Page<EmailDTO> findAllEmails(@Parameter(description="Consulta de emails") @ParameterObject @Valid @NotNull FindEmailsDTO dto, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.getEmailService().findEmails(null, dto, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findEmails(...)");
        return page;
    }

    @GetMapping(value={"/{empresa}"})
    @Operation(summary="Consulta de emails por empresa", description="Retorna uma lista de emails com base na empresa especificada e nos crit\u00e9rios de pesquisa fornecidos.")
    @ApiResponses(value={@ApiResponse(description="Lista de emails retornada com sucesso", responseCode="200")})
    @NotNull
    public Page<EmailDTO> findEmails(@Parameter(description="Sigla da empresa") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="Consulta de emails") @ParameterObject @Valid @NotNull FindEmailsDTO dto, @Parameter(description="Par\u00e2metros de pagina\u00e7\u00e3o") @NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Page page = this.getEmailService().findEmails(empresa, dto, pageable);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"findEmails(...)");
        return page;
    }

    @PutMapping(value={"/{empresa}/{id}"})
    @Operation(summary="Atualiza os dados de um email", description="Atualiza os dados de um email espec\u00edfico com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Email atualizado com sucesso", responseCode="200"), @ApiResponse(description="Email n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public Email updateEmail(@Parameter(description="Sigla da empresa") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="ID do email a ser atualizado") @PathVariable(value="id") int idEmail, @Parameter(description="Dados do email a serem atualizados") @Valid @RequestBody @NotNull UpdateEmailDTO dto) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        Email email = this.getEmailService().updateEmail(empresa, idEmail, dto);
        Intrinsics.checkNotNullExpressionValue((Object)email, (String)"updateEmail(...)");
        return email;
    }

    @PostMapping(value={"/{empresa}/{id}/send"})
    @Operation(summary="Envia um email", description="Envia um email espec\u00edfico com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Email enviado com sucesso", responseCode="200"), @ApiResponse(description="Email n\u00e3o encontrado", responseCode="404")})
    public void sendEmail(@Parameter(description="Sigla da empresa") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="ID do email a ser enviado") @PathVariable(value="id") int idEmail, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.getEmailSenderService().sendEmail(empresa, idEmail, usuario.getId());
    }

    @PostMapping(value={"/queue/process"})
    @Operation(summary="Processa a fila de emails", description="Inicia o processamento da fila de emails pendentes.")
    @ApiResponses(value={@ApiResponse(description="Fila de emails processada com sucesso", responseCode="200")})
    public void processEmailQueue(@NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        this.getEmailQueueProcessor().processEmailQueue(usuario.getId());
    }

    @PutMapping(value={"/{empresa}/{id}/cancel"})
    @Operation(summary="Cancela o envio de um email", description="Cancela o envio de um email espec\u00edfico com base no ID fornecido.")
    @ApiResponses(value={@ApiResponse(description="Email cancelado com sucesso", responseCode="200"), @ApiResponse(description="Email n\u00e3o encontrado", responseCode="404")})
    @NotNull
    public Email cancelEmail(@Parameter(description="Sigla da empresa") @PathVariable(value="empresa") @NotNull String empresa, @Parameter(description="ID do email a ser cancelado") @PathVariable(value="id") int idEmail, @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter((Object)empresa, (String)"empresa");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        PublicUser publicUser = this.getUsuarioByJWT(request);
        if (publicUser == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Usu\u00e1rio/Token n\u00e3o encontrado.");
        }
        PublicUser usuario = publicUser;
        Email email = this.getEmailService().cancelEmail(empresa, idEmail, usuario.getId());
        Intrinsics.checkNotNullExpressionValue((Object)email, (String)"cancelEmail(...)");
        return email;
    }
}

